/**
 * @addtogroup <AppHmi_System>
 * @{
 * @file        DiagnosisSrvClient.h
 * @brief       DiagnosisSrvClient is to handle ServiceClient impl of Diagnosis Services.
 *              (-> Control1, ...)
 * @author      Sathiya Jayanth - ECG
 * @copyright   (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 * @}
 */

#ifndef DIAGNOSIS_SRV_CLIENT_H
#define DIAGNOSIS_SRV_CLIENT_H
#include <AppHmi_SystemMessages.h>
#include "AppHmi_SystemStateMachine.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_SystemStateMachineData.h"


//#include "ClientServicesIFProxy.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/Control1Proxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "CgiExtensions/CourierMessageMapper.h"

#define DIAGNOSIS_CONTROL1 ::org::bosch::cm::diagnosis::dbus::Diagnosis1::Control1

namespace App {
namespace Core {


/**
 * DiagnosisSrvClient is used to
 *  - Handle the Diagnosis Control1 Service.
 *  - It is supporting the client implementation for StartSystemSetting method
 */
class DiagnosisSrvClient : public ::StartupSync::PropertyRegistrationIF, public hmibase::ServiceAvailableIF,
   public DIAGNOSIS_CONTROL1::StartSystemSettingCallbackIF
{
   public:

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)

      //   ON_COURIER_MESSAGE(ResetSystemSettings)

      ON_COURIER_MESSAGE(FactoryResetSM)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
      /**
       *  Member Function Declaration
       */

      static DiagnosisSrvClient* poGetInstance()
      {
         if (NULL == _diaglient)
         {
            _diaglient = new DiagnosisSrvClient();
         }
         return _diaglient;
      }

      DiagnosisSrvClient();
      virtual~DiagnosisSrvClient();
      //  virtual bool onCourierMessage(const ResetSystemSettings& oMsg);

      virtual bool onCourierMessage(const	 FactoryResetSM& oMsg);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void onStartSystemSettingError(const ::boost::shared_ptr< DIAGNOSIS_CONTROL1::Control1Proxy >& proxy, const ::boost::shared_ptr< DIAGNOSIS_CONTROL1::StartSystemSettingError >& error);
      void onStartSystemSettingResponse(const ::boost::shared_ptr< DIAGNOSIS_CONTROL1::Control1Proxy >& proxy, const ::boost::shared_ptr< DIAGNOSIS_CONTROL1::StartSystemSettingResponse >& response);
      void FactoryReset();
      void privacyResetValue();
      static void destroy();

      //void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);
      //void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      //void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      //void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

   private:
      /**
       *  Member Variables Declaration
       */
      ::boost::shared_ptr< DIAGNOSIS_CONTROL1::Control1Proxy > _controlProxy;
      bool privacyResetRequest;
      static DiagnosisSrvClient*  _diaglient;
};


}
}


#undef DIAGNOSIS_CONTROL1 //Undefined DIAGNOSIS_CONTROL1
#endif //DIAGNOSISSRV_CLIENT_HEADER
