/**************************************************************************************
* @file         : DiagnosisServiceClientHandler.h
* @author       : CMC HMI Team
* @addtogroup   : apphmi_sytem
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef DIAGNOSIS_SERVICECLIENTHANDLER_H
#define DIAGNOSIS_SERVICECLIENTHANDLER_H
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "Common/DefSetServiceBase/DefSetServiceBase.h"
#endif
#include "IResetFactorySettings.h"


namespace App {
namespace Core {
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
class DiagnosisServiceClientHandler  : public iDefSetServiceBase

{
   public:
      virtual ~DiagnosisServiceClientHandler();
      static DiagnosisServiceClientHandler* GetInstance()
      {
         if (_DiagnosisServiceClientHandler == NULL)
         {
            _DiagnosisServiceClientHandler = new DiagnosisServiceClientHandler();
         }
         return _DiagnosisServiceClientHandler;
      }
      void registerRestoreFactorySettingInfoChange(IResetFactorySettings* pIResetFactorySettings);
      void deRegisterRestoreFactorySettingInfoChange(IResetFactorySettings* pIResetFactorySettings);

      virtual void reqPrepareResponse(const PrepareResDiagMsgData&);
      virtual void reqExecuteResponse(const ExecuteResDiagMsgData&);
      virtual void reqFinalizeResponse(const FinalizeResDiagMsgData&);

      static void destroy();
   private:
      DiagnosisServiceClientHandler();

      DefSetServiceBase* _defSetServiceBase;
      std::vector<IResetFactorySettings*> _registeredUpdateList;

      void sendRestoreFactorySettingInfoChange();

      static DiagnosisServiceClientHandler* _DiagnosisServiceClientHandler;
};


#endif
}


}


/*#include "asf/core/BaseComponent.h"
#include "asf/core/ComponentFactory.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1Stub.h"

using namespace ::asf::core;
using namespace ::org::bosch::cm::diagnosis::dbus::Diagnosis1::SystemSettings1;

namespace App {
   namespace Core {

      struct PrepareResDiagMsgData
      {
         std::string sysSetType;
      };

      struct ExecuteResDiagMsgData
      {
         std::string sysSetType;
      };

      struct FinalizeResDiagMsgData
      {
         std::string sysSetType;
      };
	  class DiagnosisServiceClientHandler : public SystemSettings1Stub
      {
	  public:

         DiagnosisServiceClientHandler();
		 virtual ~DiagnosisServiceClientHandler();

		 virtual void onPrepareSystemSettingRequest(const ::boost::shared_ptr< PrepareSystemSettingRequest >& request);
         virtual void onExecuteSystemSettingRequest(const ::boost::shared_ptr< ExecuteSystemSettingRequest >& request);
         virtual void onFinalizeSystemSettingRequest(const ::boost::shared_ptr< FinalizeSystemSettingRequest >& request);

		 void sendPrepareResponse();
         void sendExecuteResponse();
         void sendFinalizeResponse();

		 static DiagnosisServiceClientHandler* GetInstance();

	 private:

	    private:
         static DiagnosisServiceClientHandler* _diagnosisServiceClientHandler;

         PrepareSystemSettingRequest& rObjPrepareSystemSettingRequest;
         ExecuteSystemSettingRequest& rObjExecuteSystemSettingRequest;
         FinalizeSystemSettingRequest& rObjFinalizeSystemSettingRequest;
		 };
 }
}*/
#endif //
