/**************************************************************************************
* @file         : <ClockSrvClient.cpp>
* @author       :  <INF4CV>
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/


#ifndef CLOCK_SERVICE_H
#define CLOCK_SERVICE_H


#include "AppHmi_SystemStateMachine.h"

#include "clock_main_fiProxy.h"
#include "clock_main_fi_types.h"

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_SystemStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_SystemMessages.h"
#include "GpsClockListHandler.h"

#include <map>

#include "AppBase/ServiceAvailableIF.h"
using namespace std;

namespace App {
namespace Core {

class ClockSrvClient : public StartupSync::PropertyRegistrationIF,
   public clock_main_fi::NewDateFormatCallbackIF,
   public hmibase::ServiceAvailableIF,
   public ::clock_main_fi::TimeFormatCallbackIF,
   public ::clock_main_fi::LocalTimeDateCallbackIF,
//Removed the DaylightSavingTime based on Bug 963829
//public clock_main_fi::DaylightSavingTimeCallbackIF,
   public clock_main_fi::GPS_AutoSyncCallbackIF,
   public clock_main_fi::Region_TimeZoneCallbackIF,
   public clock_main_fi::GetAvailableTimeZonesCallbackIF,
   public clock_main_fi::Auto_TimeZoneOffsetCallbackIF
//Removed the DaylightSavingTime based on Bug 963829
//public clock_main_fi::TimeZone_DSTAvailabilityCallbackIF

{
   public :
      //Removed the DaylightSavingTime based on Bug 963829
      //int DayLightSavingTimeStatus;
      static ClockSrvClient* poGetInstance()
      {
         if (NULL == _ClockSrvClient)
         {
            _ClockSrvClient = new ClockSrvClient();
         }

         return _ClockSrvClient;
      }

      virtual ~ClockSrvClient();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                              const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void onTimeFormatError(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& proxy,
                             const ::boost::shared_ptr< clock_main_fi::TimeFormatError >& error);
      void onTimeFormatStatus(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& proxy,
                              const ::boost::shared_ptr< clock_main_fi::TimeFormatStatus >& status);
      //Removed the DaylightSavingTime based on Bug 963829
      //void onDaylightSavingTimeError(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& /*proxy*/,
      // const ::boost::shared_ptr< clock_main_fi::DaylightSavingTimeError >& /*error*/);
      //void onDaylightSavingTimeStatus(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& /*proxy*/,
      // const ::boost::shared_ptr< clock_main_fi::DaylightSavingTimeStatus >& status);

      void covsetTimeFormatProperty(const int& timeFormat);
      void onNewDateFormatError(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& /*proxy*/,
                                const ::boost::shared_ptr< clock_main_fi::NewDateFormatError >& /*error*/);
      void onNewDateFormatStatus(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& proxy,
                                 const ::boost::shared_ptr< clock_main_fi::NewDateFormatStatus >& status);
      void covLocalTimesetMode(const uint8& mhour, const uint8& mminute);
      void onLocalTimeDateError(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& proxy,
                                const ::boost::shared_ptr< clock_main_fi::LocalTimeDateError >& error);
      void onLocalTimeDateStatus(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& proxy,
                                 const ::boost::shared_ptr< clock_main_fi::LocalTimeDateStatus >& status);
      //TIME Zone
      void onRegion_TimeZoneError(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& /*proxy*/,
                                  const ::boost::shared_ptr< clock_main_fi::Region_TimeZoneError >& /*error*/);
      void onRegion_TimeZoneStatus(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& /*proxy*/,
                                   const ::boost::shared_ptr< clock_main_fi::Region_TimeZoneStatus >& status);
      void onGetAvailableTimeZonesError(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& /*proxy*/,
                                        const ::boost::shared_ptr< clock_main_fi::GetAvailableTimeZonesError >& /*error*/);
      void onGetAvailableTimeZonesResult(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& proxy,
                                         const ::boost::shared_ptr< clock_main_fi::GetAvailableTimeZonesResult >& result);
      void onAuto_TimeZoneOffsetError(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& /*proxy*/,
                                      const ::boost::shared_ptr< clock_main_fi::Auto_TimeZoneOffsetError >& /*error*/);
      void onAuto_TimeZoneOffsetStatus(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& /*proxy*/,
                                       const ::boost::shared_ptr< clock_main_fi::Auto_TimeZoneOffsetStatus >& /*status*/);
      void onTimeZone_DSTAvailabilityError(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& /*proxy*/,
                                           const ::boost::shared_ptr< clock_main_fi::TimeZone_DSTAvailabilityError >& /*error*/);
      void onTimeZone_DSTAvailabilityStatus(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& /*proxy*/,
                                            const ::boost::shared_ptr< clock_main_fi::TimeZone_DSTAvailabilityStatus >& /*status*/);

      void onGPS_AutoSyncError(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& /*proxy*/,
                               const ::boost::shared_ptr< clock_main_fi::GPS_AutoSyncError >& /*error*/);
      void onGPS_AutoSyncStatus(const ::boost::shared_ptr< clock_main_fi::Clock_main_fiProxy >& /*proxy*/,
                                const ::boost::shared_ptr< clock_main_fi::GPS_AutoSyncStatus >& status);
      DataBindingItem<MasterGadgetSystemDataBindingSource> oMasterGadgetSystem;

      bool setDateFormatPropertyToService(uint8 dateFormat);
      void covSetAutoSyncPropertyToService(const int& gpsEnableStatus, const int& positionstatus);
      void setDSTPropertyToService(uint8 dstMode);
      void setRegion_TimeZoneToService(uint16 timeZoneIndex);
      void getAvailableTimzoneList();
      //Removed the DaylightSavingTime based on Bug 963829
      //int getDayLightSavingTimeStatus();
      static void destroy();

   private:
      ClockSrvClient();
      static ClockSrvClient* _ClockSrvClient;
      uint8 _timeFormat;
      uint8 _dateFormat;
      uint8 _day;
      uint8 _month;
      int16 _Year;
      map<int, int>mymap;
      //map<int, int>::const_iterator it;

      ::boost::shared_ptr< ::clock_main_fi::Clock_main_fiProxy > _clockproxy;
};


}
}


#endif
