/**************************************************************************************
* @file         : <CabinInfoSrvClient.cpp>
* @author       : Sheena Mathew
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (C) 2018 Robert Bosch GmbH
*                 (C) 2018 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/


#include "hall_std_if.h"
#include "CabinInfoSrvClient.h"
#include "midw_fi_if.h"
#include "CabinASettingListhandler.h"
#include "CabinAVideoMixSourceListHandler.h"
#include "CabinAGlassSettingListhandler.h"
#include "ProjectBaseTypes.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS         TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL             TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX          "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX               App::Core::CabinInfoSrvClient::
#include "trcGenProj/Header/CabinInfoSrvClient.cpp.trc.h"
#endif

#define NOCMGA2GLASSINSTALLED 0
#define CMGA2GLASSINSTALLED 1

using namespace ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService;
using namespace ::asf::core;

namespace App {
namespace Core {

CabinInfoSrvClient* CabinInfoSrvClient::_CabinInfoSrvClient = NULL;
CabinInfoSrvClient::CabinInfoSrvClient()

{
   ETG_TRACE_USR4(("CabinInfoSrvClient Constructor "));
   init();
   sourceinfo.clear();
   glassAvailablityInfoCA = false;
   cmgA2AvailablityInfoCA = false;
   cmgA1AvailablityInfoCA = false;
   b_IsCAcmgA2GlassInstalled = false;
   userOffStateStatus = DISABLED;
   cmgA1GlassCount = 0 ;
   cmgA2GlassCount = 0 ;
   grosscmgGlassCount = 0;
   cmgA2GlassInstalledCount = 0;
   sourceinfo[CABIN_VIDEO_MIX_INDEX_NONE].insert(make_pair(1, 2573835516));
   CabinAVideoMixSourceListHandler::poGetInstance()->UpdateVideoMixSource(sourceinfo);
   sourceinfo[CABIN_VIDEO_MIX_INDEX_MAP_OUT].insert(make_pair(2, 2879570286));
   sourceinfo[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_1].insert(make_pair(2, 0));
   sourceinfo[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_2].insert(make_pair(2, 0));
   sourceinfo[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_3].insert(make_pair(2, 0));
   userData = 0;
   _regionsMapOutStatusInfo_RegId = 0;
   _cabinsSystemsInfo_RegId = 0;
   _cabinInfoSrvClientObj.clear();
}


CabinInfoSrvClient::~CabinInfoSrvClient()
{
   ETG_TRACE_USR4(("CabinInfoSrvClient Destructor \n"));
   delete _CabinInfoSrvClient;
   _CabinInfoSrvClient = NULL;
}


void CabinInfoSrvClient::init()
{
   ETG_TRACE_USR4(("CabinInfoSrvClient init \n"));
   _hmiInfoServiceProxyClient = (::HmiInfoServiceProxy::createProxy("hmiinfoservicePort", *this));
   if (_hmiInfoServiceProxyClient.get())
   {
      ETG_TRACE_USR4(("CabinInfoSrvClient::CabinInfoSrvClient StartupSync _hmiInfoProxyClient"));
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _hmiInfoServiceProxyClient->getPortName());
   }
}


void CabinInfoSrvClient::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_COMP(("CabinSystemStateHandler::onAvailable"));

   if (_hmiInfoServiceProxyClient && _hmiInfoServiceProxyClient == proxy)
   {
      _hmiInfoServiceProxyClient->sendCabinsSystemsInfoRegister(*this);
      _hmiInfoServiceProxyClient->sendCabinSourcesConnectionStatusRegister(*this);
      _hmiInfoServiceProxyClient->sendCabinSourcesConnectionStatusGet(*this);
      _hmiInfoServiceProxyClient->sendCabinsVideoMixInfoRegister(*this);
   }
}


void CabinInfoSrvClient::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_COMP(("CabinInfoSrvClient::onUnavailable"));

   if (_hmiInfoServiceProxyClient && _hmiInfoServiceProxyClient == proxy)
   {
      _hmiInfoServiceProxyClient->sendCabinsSystemsInfoDeregisterAll();
      _hmiInfoServiceProxyClient->sendCabinSourcesConnectionStatusDeregisterAll();
      _hmiInfoServiceProxyClient->sendCabinsVideoMixInfoDeregisterAll();
   }
}


void CabinInfoSrvClient::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("CabinInfoSrvClient::registerProperties"));
}


void CabinInfoSrvClient::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("CabinInfoSrvClient::deregisterProperties"));
}


void CabinInfoSrvClient::onSetCabinVideoMixIndexError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy,
      const ::boost::shared_ptr< SetCabinVideoMixIndexError >& error)
{
   ETG_TRACE_COMP(("CabinInfoSrvClient::onSetCabinVideoMixIndexError"));
}


void CabinInfoSrvClient::onSetCabinVideoMixIndexResponse(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy,
      const ::boost::shared_ptr< SetCabinVideoMixIndexResponse >& response)
{
   ETG_TRACE_COMP(("CabinInfoSrvClient::onSetCabinVideoMixIndexResponse"));
}


/************************************************************************
*FUNCTION		: onCabinsSystemsInfoError
*DESCRIPTION	: To update cabins systems information
*PARAMETER		: NA
*PARAMETER		: NA
*RETURNVALUE	: void
*SWFL			: [Task 1145740]
************************************************************************/


void CabinInfoSrvClient::onCabinsSystemsInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
      const ::boost::shared_ptr< CabinsSystemsInfoError >& error)
{
   ETG_TRACE_COMP(("CabinInfoSrvClient::onCabinsSystemsInfoError"));
}


/************************************************************************
*FUNCTION		: onCabinsSystemsInfoUpdate
*DESCRIPTION	: To update cabins systems information
*PARAMETER		: NA
*PARAMETER		: NA
*RETURNVALUE	: void
************************************************************************/


void CabinInfoSrvClient::onCabinsSystemsInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy,
      const ::boost::shared_ptr< CabinsSystemsInfoUpdate >& update)
{
   ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsSystemsInfoUpdate ........"));

   if (update != NULL)
   {
      ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsSystemsInfoUpdate update is not NULL........"));
      ::std::vector< SystemInfo > cabinSystemCategoryArrayData = update->getCabinsSystemsInfo();

      if (!cabinSystemCategoryArrayData.empty())
      {
         ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsSystemsInfoUpdate cabinSystemCategoryArrayData is not EMPTY........"));
         ::std::vector<SystemInfo>::const_iterator cabinSystemCategoryArrayData_iter = cabinSystemCategoryArrayData.begin();

         if (proxy == _hmiInfoServiceProxyClient)
         {
            cmgA1GlassCount = 0;
            cmgA2GlassCount = 0;
            cmgA2GlassInstalledCount = 0;
            grosscmgGlassCount = 0;
            ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsSystemsInfoUpdate _hmiInfoServiceProxyClient proxy is VERIFIED........"));
            while (cabinSystemCategoryArrayData_iter != cabinSystemCategoryArrayData.end())
            {
               uint8  systemCategory = cabinSystemCategoryArrayData_iter->getSystemCategory();
               uint32 entityid = cabinSystemCategoryArrayData_iter->getEntityId();
               uint8  systemStatus = cabinSystemCategoryArrayData_iter->getSystemStatus();
               uint8  systemPosition = cabinSystemCategoryArrayData_iter->getSystemPosition();
               uint8  systemGroup = cabinSystemCategoryArrayData_iter->getSystemGroup();
               uint32 systemId = cabinSystemCategoryArrayData_iter->getSystemId();
               ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsSystemsInfoUpdate EXTERNAL DEVICE ==> || systemCategory systemGroup systemStatus systemPosition  entityid systemId =%d \t%d \t%d \t%d \t%d \t %d \t", systemCategory, systemGroup, systemStatus, systemPosition,  entityid, systemId));
               ::std::vector< uint32> cabinInfoArrayData = cabinSystemCategoryArrayData_iter->getCabinsInfo();
               ::std::vector<uint32>::const_iterator cabinInfoArrayData_iter = cabinInfoArrayData.begin();

               switch (systemCategory)
               {
                     ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsSystemsInfoUpdate Category Check ==> || systemCategory =%d", systemCategory));
                  case SYSTEM_CATEGORY_CMG:
                     vEvaluateCMG(systemGroup, systemStatus);
                     break;
                  default:
                     break;
               }

               while (cabinInfoArrayData_iter != cabinInfoArrayData.end())
               {
                  cabinInfoArrayData_iter++;
               }
               cabinSystemCategoryArrayData_iter++;
            }//end of main while loop

            if (cmgA1GlassCount == SYSTEM_DISCONNECTED)
            {
               cmgA1AvailablityInfoCA = false;
               ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsSystemsInfoUpdate CABIN_A_MEDIAGLASS1_SINK_ID is DeActivated"));
               //When all the Camera is disconnected, the stop activity timer was tirgerred and which in turn causing swivel was not up
               //·  1336997: Sporadically swivel does not open on source restoration even though glasses are streaming
               //1509210: Media glass doesn't swivel up when mapout is streamed and User OFF is performed
               //App::Core::CabinAGlassSettingListhandler::poGetInstance()->stopInactivityTimer(CABIN_A_MEDIAGLASS1_SINK_ID);
            }

            else if (cmgA1GlassCount >= SYSTEM_CONNECTED)
            {
               cmgA1AvailablityInfoCA = true;
               ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsSystemsInfoUpdate CABIN_A_MEDIAGLASS1_SINK_ID is Activated"));
               App::Core::CabinAGlassSettingListhandler::poGetInstance()->startInactivityTimerONStartup(CABIN_A_MEDIAGLASS1_SINK_ID);
            }
            bool rxduserOffStateStatus = getUserOffStatus();
            ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsSystemsInfoUpdate rxduserOffStateStatus==>%d", rxduserOffStateStatus));
            if (cmgA2GlassCount == SYSTEM_DISCONNECTED)
            {
               sourceinfo.erase(CABIN_VIDEO_MIX_INDEX_MAP_OUT);
               sourceinfo[CABIN_VIDEO_MIX_INDEX_MAP_OUT].insert(make_pair(SYSTEM_DISCONNECTED, 2879570286));

               //Bug 2138719 and 2163076 - A2 DisConnected and UserON
               if (rxduserOffStateStatus == DISABLED)
               {
                  cmgA2AvailablityInfoCA = false;
                  ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsSystemsInfoUpdate CABIN_A_MEDIAGLASS2_SINK_ID is DeActivated AND UserON"));
               }
               //When all the Camera is disconnected, the stop activity timer was tirgerred and which in turn causing swivel was not up
               //1336997: Sporadically swivel does not open on source restoration even though glasses are streaming
               //1509210: Media glass doesn't swivel up when mapout is streamed and User OFF is performed
               // App::Core::CabinAGlassSettingListhandler::poGetInstance()->stopInactivityTimer(CABIN_A_MEDIAGLASS2_SINK_ID);
            }
            else if (cmgA2GlassCount >= SYSTEM_CONNECTED)
            {
               sourceinfo.erase(CABIN_VIDEO_MIX_INDEX_MAP_OUT);
               sourceinfo[CABIN_VIDEO_MIX_INDEX_MAP_OUT].insert(make_pair(SYSTEM_CONNECTED, 2879570286));

               //Bug 2138719 and 2163076 - A2 Connected and UserON
               if (rxduserOffStateStatus == DISABLED)
               {
                  cmgA2AvailablityInfoCA = true;
                  ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsSystemsInfoUpdate CABIN_A_MEDIAGLASS2_SINK_ID is Activated rxduserOffStateStatus==DISABLED"));
                  App::Core::CabinAGlassSettingListhandler::poGetInstance()->startInactivityTimerONStartup(CABIN_A_MEDIAGLASS2_SINK_ID);
               }
               //Bug 2138719 and 2163076 - A2 Connected and UserOFF
               if (rxduserOffStateStatus == ENABLED)
               {
                  cmgA2AvailablityInfoCA = false;
                  ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsSystemsInfoUpdate CABIN_A_MEDIAGLASS2_SINK_ID is Activated rxduserOffStateStatus==ENABLED"));
               }
            }
            /**Bug 1455486- Condition to check if atleast one A2 glass is configured*/
            if (cmgA2GlassInstalledCount == NOCMGA2GLASSINSTALLED)
            {
               ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsSystemsInfoUpdate, No A2 Glass configured"));
               b_IsCAcmgA2GlassInstalled = false;
            }
            else if (cmgA2GlassInstalledCount >= CMGA2GLASSINSTALLED)
            {
               b_IsCAcmgA2GlassInstalled = true;
            }

            grosscmgGlassCount = cmgA1GlassCount + cmgA2GlassCount;

            if (grosscmgGlassCount == SYSTEM_DISCONNECTED)
            {
               glassAvailablityInfoCA = false;
            }
            else if (grosscmgGlassCount >= SYSTEM_CONNECTED)
            {
               glassAvailablityInfoCA = true;
            }

            ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsSystemsInfoUpdate cmgA1GlassCount cmgA2GlassCount grosscmgGlassCount ==>%d \t,%d \t,%d \t ", cmgA1GlassCount, cmgA2GlassCount, grosscmgGlassCount));
            ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsSystemsInfoUpdate cmgA1AvailablityInfoCA cmgA2AvailablityInfoCA  cmgA2GlassConfiguredInfoCA glassAvailablityInfoCA==>%d \t,%d \t,%d \t,%d \t ", cmgA1AvailablityInfoCA, cmgA2AvailablityInfoCA, b_IsCAcmgA2GlassInstalled, glassAvailablityInfoCA));
#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
            CabinASettingListhandler::poGetInstance()->UpdateCabinASettingListOnCmgChange();
            CabinAVideoMixSourceListHandler::poGetInstance()->UpdateVideoMixSource(sourceinfo);
#endif
         }
      }
   }
}


/************************************************************************
*FUNCTION		: vEvaluateCMG
*DESCRIPTION	: To update cabins systems information
*PARAMETER		: uint8 systemGroup, uint32 systemStatus
*PARAMETER		: uint8 systemGroup, uint32 systemStatus
*RETURNVALUE	: void
*SWFL			: [Task 1145740]
************************************************************************/
void CabinInfoSrvClient::vEvaluateCMG(uint8 systemGroup, uint32 systemStatus)
{
   bool userOffState = DISABLED;
   ETG_TRACE_USR4(("CabinInfoSrvClient::vEvaluateCMG systemGroup systemStatus %d %d", systemGroup, systemStatus));
   /*Bug 1455486 - Condition to find the number of A2 Glasses Installed count*/
   if (systemGroup == SYSTEM_GROUP_CMG_A2)
   {
      ++cmgA2GlassInstalledCount;
   }
   else
   {
      //Nothing to do
   }

   if ((SYSTEM_STATUS_UNAVAILABLE  == systemStatus)
         || (SYSTEM_STATUS_DISCONNECTED == systemStatus)
         || (SYSTEM_STATUS_HMI_OFF_DISCONNECTED  == systemStatus)
         || (SYSTEM_STATUS_INACTIVE_DISCONNECTED  == systemStatus)
         || (SYSTEM_STATUS_USER_OFF_DISCONNECTED == systemStatus)
         || (SYSTEM_STATUS_COCKPIT_DISCONNECTED  == systemStatus)
         || (SYSTEM_STATUS_PNM_DISCONNECTED == systemStatus)
         || (SYSTEM_STATUS_HOURLOGIC_DISCONNECTED  == systemStatus))
   {
      //Bug 2138719 and 2163076 - In User Off , A2 Won't be Disconnected and Allow swivel to up and does not allow VMS to Reset.
      if ((SYSTEM_STATUS_USER_OFF_DISCONNECTED == systemStatus) && (systemGroup == SYSTEM_GROUP_CMG_A2))
      {
         ++cmgA2GlassCount;
         userOffState = ENABLED;
      }
      ETG_TRACE_USR4(("CabinInfoSrvClient::vEvaluateCMG systemGroup cmgA2GlassCount==%d userOffState==>%d", cmgA2GlassCount, userOffState));
   }
   else
   {
      if (systemGroup == SYSTEM_GROUP_CMG_A)
      {
         ++cmgA1GlassCount;
      }
      else if (systemGroup == SYSTEM_GROUP_CMG_A2)
      {
         ++cmgA2GlassCount;
      }
      else
      {
      }
      ETG_TRACE_USR4(("CabinInfoSrvClient::vEvaluateCMG cmgA1GlassCount==>%d cmgA2GlassCount==>%d userOffState==>%d", cmgA1GlassCount, cmgA2GlassCount, userOffState));
   }
   updateUserOffStatus(userOffState);
   ETG_TRACE_USR4(("CabinInfoSrvClient::vEvaluateCMG cmgA1GlassCount==>%d cmgA2GlassCount==>%d cmgA2GlassCountConfigured= %d userOffState==>%d", cmgA1GlassCount, cmgA2GlassCount, cmgA2GlassInstalledCount, userOffState))
}


void CabinInfoSrvClient::updateUserOffStatus(bool RxuserOffState)
{
   userOffStateStatus = RxuserOffState;
}


bool CabinInfoSrvClient::getUserOffStatus()
{
   ETG_TRACE_USR4(("CabinInfoSrvClient::getUserOffStatus() userOffStateStatus==>%d", userOffStateStatus));
   return userOffStateStatus;
}


bool CabinInfoSrvClient::getglassAvailablityInfoStatusCA()
{
   ETG_TRACE_USR4(("CabinInfoSrvClient::getglassAvailablityInfoStatusCA glassAvailablityInfoCA %d", glassAvailablityInfoCA));
   return glassAvailablityInfoCA;
}


bool CabinInfoSrvClient::getcmgA1AvailablityInfoStatusCA()
{
   ETG_TRACE_USR4(("CabinInfoSrvClient::getcmgA1AvailablityInfoStatusCA cmgA1AvailablityInfoCA %d", cmgA1AvailablityInfoCA));
   return cmgA1AvailablityInfoCA;
}


bool CabinInfoSrvClient::getcmgA2AvailablityInfoStatusCA()
{
   ETG_TRACE_USR4(("CabinInfoSrvClient::getcmgA2AvailablityInfoStatusCA cmgA2AvailablityInfoCA %d", cmgA2AvailablityInfoCA));
   return cmgA2AvailablityInfoCA;
}


/*Bug-1455486-Function to return the If A2 Glass are configured during Installion or not*/
bool CabinInfoSrvClient::getcmgA2GlassConfiguredInfoStatusCA()
{
   ETG_TRACE_USR4(("CabinInfoSrvClient::getcmgA2GlassConfiguredInfoStatusCA b_IsCAcmgA2GlassInstalled= %d", b_IsCAcmgA2GlassInstalled));
   return b_IsCAcmgA2GlassInstalled;
}


void CabinInfoSrvClient::onCabinSourcesConnectionStatusError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinSourcesConnectionStatusError >& error)
{
   ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinSourcesConnectionStatusError ."));
}


void CabinInfoSrvClient::onCabinSourcesConnectionStatusUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< CabinSourcesConnectionStatusUpdate >& update)
{
   ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinSourcesConnectionStatusUpdate ."));

   if (update != NULL)
   {
      ::std::vector< CabinSourceConnectionStatusInfo > cabinconnectionstatusinfovector = update->getCabinSourcesConnectionStatus();

      if (!cabinconnectionstatusinfovector.empty())
      {
         ::std::vector< CabinSourceConnectionStatusInfo >::const_iterator cabinInfo_iter = cabinconnectionstatusinfovector.begin();

         if (proxy == _hmiInfoServiceProxyClient)
         {
            while (cabinInfo_iter != cabinconnectionstatusinfovector.end())
            {
               uint16 sourceId = cabinInfo_iter->getSourceId();    // source id of type int -- either True or False
               int sourceStatus = cabinInfo_iter->getStatus();  // source status of type int -- either True or False //ip1=417 ip2=425 ip3=433 ip4=441
               userData = cabinInfo_iter->getUserData2();
               ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinSourcesConnectionStatusUpdate EXTERNAL DEVICE sourceId %d, sourceStatus %d,userData=%d",  sourceId, sourceStatus, userData));
               if (sourceId == SRC_CAMERAPORT1_IPCAM)
               {
                  sourceinfo.erase(CABIN_VIDEO_MIX_INDEX_IP_CAMERA_1);
                  sourceinfo[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_1].insert(make_pair(sourceStatus, userData));
               }
               else if (sourceId == SRC_CAMERAPORT2_IPCAM)
               {
                  sourceinfo.erase(CABIN_VIDEO_MIX_INDEX_IP_CAMERA_2);
                  sourceinfo[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_2].insert(make_pair(sourceStatus, userData));
               }
               else if (sourceId == SRC_CAMERAPORT3_IPCAM)
               {
                  sourceinfo.erase(CABIN_VIDEO_MIX_INDEX_IP_CAMERA_3);
                  sourceinfo[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_3].insert(make_pair(sourceStatus, userData));
               }
               else
               {
               }

               cabinInfo_iter++;
            }
#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
            CabinAVideoMixSourceListHandler::poGetInstance()->UpdateVideoMixSource(sourceinfo);
#endif
         }
      }
   }
}


void CabinInfoSrvClient::onCabinsVideoMixInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy,
      const ::boost::shared_ptr< CabinsVideoMixInfoError >& error)
{
   ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsVideoMixInfoError"));
}


void CabinInfoSrvClient::userSelectedindex(int index, int reason)
{
   ETG_TRACE_USR4(("CabinInfoSrvClient::userSelectedindex REGION_CABIN_A==>%d reason==>%d index==>%d", REGION_CABIN_A, reason, index));
   CabinVideoMixInfo cabinvideomix(REGION_CABIN_A, reason, index);
   _hmiInfoServiceProxyClient->sendSetCabinVideoMixIndexRequest(*this, cabinvideomix);
}


void CabinInfoSrvClient::onCabinsVideoMixInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy,
      const ::boost::shared_ptr< CabinsVideoMixInfoUpdate >& update)
{
   ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsVideoMixInfoUpdate"));
   if (update != NULL)
   {
      ::std::vector< CabinVideoMixInfo > cabinvideomixinfovector = update->getCabinsVideoMixInfo();

      if (!cabinvideomixinfovector.empty())
      {
         ::std::vector< CabinVideoMixInfo >::const_iterator cabinvideoInfo_iter = cabinvideomixinfovector.begin();

         if (proxy == _hmiInfoServiceProxyClient)
         {
            while (cabinvideoInfo_iter != cabinvideomixinfovector.end())
            {
               uint32 cabinId = cabinvideoInfo_iter->getCabinId();
               uint8 reason = cabinvideoInfo_iter->getReason();
               uint8 videoMixIndex = cabinvideoInfo_iter->getVideoMixIndex();
               ETG_TRACE_USR4(("CabinInfoSrvClient::onCabinsVideoMixInfoUpdate 4 cabinId %d, reason %d,videoMixIndex %d",  cabinId, reason, videoMixIndex));
               if ((cabinId == REGION_CABIN_A) && ((reason == CABIN_VIDEO_MIX_CHANGE_REASON_USER) || (reason == CABIN_VIDEO_MIX_CHANGE_REASON_CMA_ERROR) || (reason == CABIN_VIDEO_MIX_CHANGE_REASON_CMP_ERROR) || (reason == CABIN_VIDEO_MIX_CHANGE_REASON_CMG_ERROR) || (reason == CABIN_VIDEO_MIX_CHANGE_REASON_RESTORE))) //   reason = CABIN_VIDEO_MIX_CHANGE_REASON_USER  1 //cabinId = REGION_CABIN_A =0
               {
                  CabinAVideoMixSourceListHandler::poGetInstance()->UpdateVmsGuiOnUserSelection(videoMixIndex);
               }

               cabinvideoInfo_iter++;
            }
         }
      }
   }
}


}
}
