/**************************************************************************************
* @file         : SystemSettingListHandler.h
* @author       : Sheena Mathew
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef SYSTEM_SETTINGS_LIST_HANDLER_H
#define SYSTEM_SETTINGS_LIST_HANDLER_H


#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
//#include "AppHmi_SystemTypes.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"

#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "App/Core/ClientHandler/SpeedLock/HmiDataServiceClientHandler.h"
#include "System_Types.h"
#include <vector>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea
#include<map>
#include <boost/tuple/tuple.hpp>
using namespace std;
namespace App {
namespace Core {

class SystemSettingsListHandler :  public ListImplementation
{
   public:
      //static SystemSettingsListHandler* _theListhandlerInstance;
      //SystemSettingsListHandler();
      virtual ~SystemSettingsListHandler();
      SystemSettingsListHandler(const SystemSettingsListHandler&);
      SystemSettingsListHandler& operator =(const SystemSettingsListHandler&);
      bool _speedlockStatus;
      bool _bluetoothStatus;
      void onUpdateMenu(enMenu menu1);
      bool listcreated;

      // Incomming events ...
      bool onCourierMessage(const Courier::StartupMsg& oMsg);
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      bool onCourierMessage(const ApplicationStateUpdMsg& oMsg);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(ApplicationStateUpdMsg)

      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
      void  AddCombo1ListItem(ListDataProviderBuilder& listBuilder, enMenu value, enMenu currentValue);
      void SetspeedlockVisibilityStatus(bool status);
      void showHidePrivacyPopUp(uint8 PrivacyResetRequestUnit);

      static SystemSettingsListHandler* poGetInstance()
      {
         if (NULL == m_posystemSettingsListHandler)
         {
            m_posystemSettingsListHandler = new SystemSettingsListHandler();
         }
         return m_posystemSettingsListHandler;
      }
      void sendDistanceUnitUpdateToGUI(uint32 DistanceUnitCode);
      void intializalanguagedata();
      string vUpdateLanguageStatusString(uint32 Languageindex);
      void SetLanguageStatus(uint32 languagecode);
      void SetBluetoothStatus(bool status);
      void vDataversion(std::string dataversion);
      void vCreateTemplateList();
      bool VariantType();
      bool getSettingsAppState();
      void isSWUpdateviaDiagTool(bool status);

   private:
      void vGetSerialNumber();
      unsigned int rowIdx;
      static SystemSettingsListHandler* m_posystemSettingsListHandler;
      map< int, string > mpLanguageStringStatus;
      typedef ::boost::tuple<int, std::string, int, Candera::String, std::string, bool>tp_syslangstatus;
      vector<tp_syslangstatus>vec_systemlanguagestatus;
      tSharedPtrDataProvider getMainViewListDataProvider();
      SystemSettingsListHandler();
      map<int, Candera::String> m_ListtypetoSysSettingMainUpd;
      map<int, Candera::String> ::iterator itr1;
      enMenu _currentMeasurementOption;
      Candera::String m_Sysupdate;
      Candera::String _currentMeasurementOptionStr;
      Candera::String _dataversion;
      Candera::String _serialnumber;
      //std::string _currentMeasurementOptionStr;
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      typedef ::boost::tuple<string, string, Candera::String>mytp;
      vector<mytp>my_vec;
      std::vector<std::string> SMDI; //SettingsMainDataItem
      Candera::String SYSTEMMAINTEXT;
      HmiDataServiceClientHandler* _hmidatasrvhandler;

      void changeMeasurementSettings(Candera::UInt32 selectedRowId);
      //DataBindingItem<DropdownmenuComboDataBindingSource> _DropdownCombo1InfoData;
      DataBindingItem<speedlockUpdatesVisibilityDataBindingSource> _speedlockUpdatesVisibility;
      DataBindingItem<bluetoothVisibilityDataBindingSource> _bluetoothVisibility;
      DataBindingItem<SWUpdateListItemEnableDataBindingSource> _SWUpdateListItemEnable;
      // For updating software version in list
      std::string _currentSoftwareVersion;
      uint32 _RxdCurrentLanguageStatus4mVehData;
      std::string _CurrentLanguageStatusStringData2Home;
      bool _isSettingAppInForeground;
};


}
}


#endif // SYSTEM_SETTINGS_LIST_HANDLER_H
