/**************************************************************************************
* @file         : <SWUpdate.h>
* @author       : <Ramesh Kesavan> <ECH> <INF4CV>
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/


#ifndef SW_UPDATE_HEADER
#define SW_UPDATE_HEADER
#include "App/Core/Utils/SWUpdateUtility.h"
#include <string>
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#define SMART 2
#include "App/Core/ClientHandler/DownloadSrvClient/SWUpdateClient.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/DataModel/ListRegistry.h"
#include "App/Core/HmiTranslation_TextIds.h"
#include "tinystr.h"
#include "tinyxml.h"
#include "App/Core/Utils/XMLParser/XMLParser.h"
#include <boost/lexical_cast.hpp> // for lexical_cast()
#include <boost/assign/std/vector.hpp>
using namespace boost::assign;
using namespace std;
#ifdef VARIANT_S_FTR_ENABLE_NAVIGATION
#include "asf/core/Timer.h"
#endif
#else
#if !defined LIST_ID_SW_DOWNLOAD_HISTORY
#define LIST_ID_SW_DOWNLOAD_HISTORY 114
#endif
#if !defined LIST_ID_SW_UPDATE_DETAILS_LIST
#define LIST_ID_SW_UPDATE_DETAILS_LIST 113
#endif
extern bool EXT_bIs_USB_Connected;
#endif


namespace App {
namespace Core {


#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
class SWUpdate :
   public ListImplementation
#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
   , public ::asf::core::TimerCallbackIF
#endif
{
   public:
      //Singleton class implementation
      static SWUpdate* m_swupdateSetting;
      static SWUpdate* GetInstance();
      virtual~SWUpdate();
      void setSystemGUIInitialized();
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      /** Courier Message Handling */
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(UpdatePopupTextReqMsg)
      ON_COURIER_MESSAGE(StartUSBStickBinaryValidationReqMsg)
      ON_COURIER_MESSAGE(SetSoftwareUpdateTypeMsg)
      ON_COURIER_MESSAGE(EnableButtonsonNopopMsg)
      ON_COURIER_MESSAGE(StartDownloadReqMsg)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(SetReleaseFilterReqMsg)
      ON_COURIER_MESSAGE(RebootOnSWDLCompleteMsg)
      ON_COURIER_MESSAGE(StartMISStageOneUpdateMsg)
      ON_COURIER_MESSAGE(HandleRebootOnUSBRemovalMsg)
      ON_COURIER_MESSAGE(TimerWidgetExpiryMsg)
      ON_COURIER_MESSAGE(HandlePendingSWDLMsg)
      ON_COURIER_MESSAGE(SWUpdateAbortRebootMsg)
      ON_COURIER_MESSAGE(ListRefreshMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS();

      /** Member Functions */
      bool onCourierMessage(const UpdatePopupTextReqMsg& oMsg);
      bool onCourierMessage(const StartUSBStickBinaryValidationReqMsg& oMsg);
      bool onCourierMessage(const SetSoftwareUpdateTypeMsg& oMsg);
      bool onCourierMessage(const EnableButtonsonNopopMsg& oMsg);
      bool onCourierMessage(const StartDownloadReqMsg& oMsg);
      bool onCourierMessage(const RebootOnSWDLCompleteMsg& oMsg);
      bool onCourierMessage(const StartMISStageOneUpdateMsg& oMsg);
      bool onCourierMessage(const TimerWidgetExpiryMsg& oMsg);
      bool onCourierMessage(const HandleRebootOnUSBRemovalMsg& oMsg);
      bool onCourierMessage(const HandlePendingSWDLMsg& oMsg);
      bool onCourierMessage(const SWUpdateAbortRebootMsg& oMsg);
      bool onCourierMessage(const SetReleaseFilterReqMsg& /*oMsg*/);
      bool onCourierMessage(const ListRefreshMsg&  oMsg);
      virtual bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);

      /** fcswupdate fucntions */
      void updateState(const std::string muVersion, const uint8 updatestate, const uint8 updateSource);
      void errorTypeUpdate(const uint8 errorType);
      void updateReleaseDoc(const ReleaseDocInfo& stReleaseDocInfo);
      void updateReleaseFilter(const uint8 releaseFilter);
      void updateSWUpdateVersionDetailsText();
      tSharedPtrDataProvider getSoftwareUpdateResults();
      void readSWUpdateDetails();
      void readSWUpdateHistory();
      void updateSWUpdateHistoryDetailsText();
      void handleSWDLRebootScenarios();
      bool RetrieveInformationFromXML();
      bool RetrieveInformationFromDTCXML();
      void handlePopupTextUpdate(unsigned int popupSource);
      void CreateMapAttrbValuetoTextId();
      bool loadingxmldata();
      bool checkxmlavailable();
      std::map<std::string, Candera::String> MappedValue;
      tSharedPtrDataProvider ExtractInfo();
      tSharedPtrDataProvider getSerialandMACAddress();
      void sendMCPVersionUpdatetoGUI(uint32 swVervalue);
#endif
      void ValdiateSWUpdateHMIStatus();
      void PoolForXMLFile();
      bool getStageOneUpdateOnGoingStatus();
      void SWUpdateviaDiagTool(bool status);
      void CurrentActiveRegion(uint8 u8activeRegion);
      bool getWaitAllowRecoveryModeStatus();

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
      void  RequestXMLScriptWhileAnimationRun();
      void UpdateSWVersionScriptStatus(int RxdSoftwareNdSubSystermSWVerScriptStatus);
#endif
#endif

#ifndef VARIANT_S_FTR_ENABLE_NAVIGATION
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      unsigned int getKDSVehicleType();
#endif
#endif
   private:
      // Singleton
      SWUpdate();

      /** Member function */
      void init();
      void updateVersionInfo(const ReleaseDocInfo& stReleaseDocInfo);
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);

      /** Data binding Member variable */
      Courier::DataItemContainer<SWUpdateMainDataBindingSource> _swMainVersionInfo;
      Courier::DataItemContainer<SWUpdateDetailsDataBindingSource> _swUpdateDetails;
      Courier::DataItemContainer<SWUpdateHistoryDetailsDataBindingSource> _swUpdateHistoryDetails;
      Courier::DataItemContainer<SWUpdateStickInfoDataBindingSource> _swUpdateUsbStickInfo;
      Courier::DataItemContainer<DownlaodTypeInfoDataBindingSource> _downlaodTypeInfoInfo;
      Courier::DataItemContainer<SWUpdateNameSmartDataBindingSource> _SWNameSmart;
      Courier::DataItemContainer<SWQuickUpdateEnableDataBindingSource> _swQuickUpdateInfo;
      Courier::DataItemContainer<SWFullUpdateEnableDataBindingSource> _swFullUpdateInfo;
      Courier::DataItemContainer<SWUpdateDetailsEnableDataBindingSource> _swDetailsInfo;
      Courier::DataItemContainer<SWUpdatebackbuttonEnableDataBindingSource> _swBackButtonInfo;
      DataBindingItem<PopupTextDataBindingSource> _PopupText;
      DataBindingItem<PopUpButtonVisibilityDataBindingSource> _PopupButton;
      DataBindingItem<SWHistoryDetailsTextDataBindingSource> _SWHistoryDetailsText;

      DataBindingItem<SwVersionNodeSwitchItemDataBindingSource> _oSwVersionNodeSwitchItem;
      DataBindingItem<MISStage1ResultsDataBindingSource> _MISStage1Results;
      std::vector<App::Core::UpdReport> _CISstatusReportVec;
      std::vector<App::Core::DTCInfo> _GetDTCInfoVec;
      std::vector<App::Core::SWUpdateReport> _SerialandMACAddressReportVec;
#endif
   public:
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      uint64 _progressIndex;
      uint32 _totalEstTime;
      uint32 _totalEstTimefromXML;
      uint8 _updatestate;
      uint8 _updateOption;
      uint8 _releaseFilter;
      uint8 _errorValue;
      uint8 _sourceType;
      bool _speedLockStatus;
      enSoftwareDownloadMode _downloadMode;
      bool _isSameVersion;
      uint8 _brakeStatus;
      uint32 _listId;
      bool _listStatus;
      enSoftwareUpdateType _userRequestedUpdateType;
      std::vector<std::string> _swHistoryDetailsVector;
      bool _isCustPopupIncompDisplayed;
      uint32 _currentRowId;
      bool _isEstimatedTimeSet;
#endif
      // used for MIS update
      bool listcreated;
      uint32 _SWversionValue;
      bool _isUpdateSuccessful;
      bool _isCMCUpdateNeeded;
      bool _isQuickUpdate;
      bool _isXMLfileAvailable;
      bool _inMISUpdateMode;
      bool _isDownloadInterrupted;
      bool _isUpdateStateCalled;
      bool _isReleaseDocCalled;
      bool _isUpdateErrorsCalled;
      vector<Candera::String>_SoftwareversionText;
      vector<Candera::String>_SoftwareversionTextValue;
      bool _onBootFlag;
      bool _isSoftwareDownloadPending;
      bool _isContextSwitchRequestPlacedForMIS;
      pthread_t observerThread;
      bool _isSWupdateviaDiagTool;
      bool _isSWUpdateTriggered;
      bool _isContextSwitchRequestPlacedForSWUpdateviaDiag;
      uint8 _currentActiveRegion;
      bool _isWaitAllowRecoveryModeReceived;

   private:


#ifdef VARIANT_S_FTR_ENABLE_NAVIGATION
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      asf::core::Timer _swvertimer;
      bool isTimerRunning4swver;
      void stopTimer4softwareversion(void);
      void startTimer4softwareversion(void);
      virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);
#endif
#endif
};


#endif
}


}
#endif
