/**************************************************************************************
* @file         : <SWUpdate.cpp>
* @author       : <Ramesh Kesavan> <ECH> <INF4CV>
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "hall_std_if.h"
//#include "AppHmi_SystemTypes.h"
#endif
#include "SWUpdate.h"
#ifndef VARIANT_S_FTR_ENABLE_NAVIGATION
#define DP_S_IMPORT_INTERFACE_FI
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "dp_generic_if.h"


#endif
#endif

#include "System_Types.h"
#include <pthread.h>
#include <unistd.h>
#include "App/datapool/SystemDataPoolConfig.h"

#define EnableLIST_DisableBUSYWAIT 0
#define DisableLIST_EnableBUSYWAIT 1
#define SCRIPT_RUN_SUCCESS 0

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "App/Core/ClientHandler/DownloadSrvClient/SWUpdateClient.h"
#include "App/Core/ClientHandler/SPM/SpmSrvClient.h"
#include "AppHmi_SystemStateMachineData.h"
#include "App/Core/ClientHandler/VehicleSrvClient/VehicleSrvClient.h"
#include "App/Core/ClientHandler/Diagnosis/MIDWDiagnosis.h"
#define EN_ACTIVITY_IDS bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"


#else
// Gtest bind
#include <iostream>
#include "stdio.h"

// Fake Textid - ID itself is used as string to validate in unittest
#define TextId_0x1311 "1311"
#define TextId_0x1312 "1312"
#define TextId_0x1313 "1313"
#define TextId_0x1314 "1314"
#define TextId_0x1315 "1315"
#define TextId_0x1316 "1316"
#define TextId_0x1317 "1317"
#define TextId_0x1318 "1318"
#define TextId_0x1319 "1319"
#define TextId_0x131A "131A"
#define TextId_0x131B "131B"
#define TextId_0x131C "131C"
#define TextId_0x131D "131D"
#define TextId_0x131E "131E"
#define TextId_0x131F "131F"

#define TextId_0x1374 "1374"
#define TextId_0x1375 "1375"
#define TextId_0x1376 "1376"
#define TextId_0x1377 "1377"
#define TextId_0x1378 "1378"
#define TextId_0x1379 "1379"
#define TextId_0x137A "137A"
#define TextId_0x137B "137B"
#define TextId_0x137C "137C"
#define TextId_0x137D "137D"
#define TextId_0x137E "137E"
#define TextId_0x137F "137F"

bool EXT_bIs_USB_Connected = false;

using namespace std;
using namespace ::App::Core;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
SWUpdateClient* SWUpdateClient::_swUpdateClient = NULL;
ListRegistry* ListRegistry::_mlistRegistry = NULL;
#endif
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::SWUpdate::
#include "trcGenProj/Header/SWUpdate.cpp.trc.h"
#endif

#define MARKER_FILE "/var/opt/bosch/persistent/fcswupdate/misUpdatePending"
#define INVALID_SOFTWAREVERSIONVALUE  0xFFFFFFFF
const char* DATA_CONTEXT_SW_UPDATE_DETAILS              = "UpdateDetailsVersion";
const char* DATA_CONTEXT_SW_UPDATE_DETAILS_2LINE        = "UpdateDetailsVersion_2Line";
const char* DATA_CONTEXT_SW_UPDATE_ODD_LIST             = "SwUpdate_Odd";
const char* DATA_CONTEXT_SW_UPDATE_EVEN_LIST            = "SwUpdate_Even";
const char* DATA_CONTEXT_SW_UPDATE_DETAILS_ODD_LIST     = "SwUpdate_Details_Odd";
const char* DATA_CONTEXT_SW_UPDATE_DETAILS_EVEN_LIST    = "SwUpdate_Details_Even";
const char* DATA_CONTEXT_TEXT_LIST_ITEM                 = "Layer_DetailsText";
const char* DATA_CONTEXT_TEXT_SW_VERSIN_LIST_ITEM = "Text_Customer_SWVersion";
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
const uint8 MAX_HISTORY_ENTRIES                         = 10;
const uint32 MAX_STEPCOUNT = 100;
const uint64 MAX_WAIT_TIME_FOR_XML = 10; // in secs

using namespace ::App::Core;

SWUpdate* SWUpdate::m_swupdateSetting = NULL;
#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
void* SoftwareNdSubSWUpdate_Trigger(void* ptr);
#endif
#endif
void* TestForXMLAvailability(void* ptr);

/**
* @Constructor
*/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
SWUpdate::SWUpdate() :
   _progressIndex(0)
   , _totalEstTime(0)
   , _totalEstTimefromXML(0)
   , _updatestate(0)
   , _updateOption(0)
   , _releaseFilter(UpdOptions_NewOnly)
   , _errorValue(error_unavailable_stick)
   , _sourceType(0/*SourceType_Usb*/)
   , _speedLockStatus(false)
   , _downloadMode(SWDL_DEFAULT_MODE)
   , _isSameVersion(false)
   , _brakeStatus(false)
   , _listId(0)
   , _listStatus(false/*LIST_INACTIVE*/)
   , _isCustPopupIncompDisplayed(false)
   , _currentRowId(0)
   , _isEstimatedTimeSet(false)
   , _isUpdateSuccessful(true) // All update failure shall be handled by Middleware & MIS, HMI should just display info
   , _isCMCUpdateNeeded(false)
   , _isXMLfileAvailable(false)
   , _inMISUpdateMode(false)
   , _isDownloadInterrupted(false)
   , _isUpdateStateCalled(false)
   , _isReleaseDocCalled(false)
   , _isUpdateErrorsCalled(false)
   , _onBootFlag(false)
   , _isSoftwareDownloadPending(false)
   , _isContextSwitchRequestPlacedForMIS(false)
   , listcreated(false)
   , _SWversionValue(INVALID_SOFTWAREVERSIONVALUE)
   , observerThread(0)
   , _isSWupdateviaDiagTool(false)
   , _isSWUpdateTriggered(false)
   , _isContextSwitchRequestPlacedForSWUpdateviaDiag(false)
   , _currentActiveRegion(0)
   , _isWaitAllowRecoveryModeReceived(0)
#ifdef VARIANT_S_FTR_ENABLE_NAVIGATION
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   , isTimerRunning4swver(false)
#endif
#endif
{
   ETG_TRACE_COMP(("SWUpdate Constructor is called"));
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SW_UPDATE_DETAILS_LIST, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SW_DOWNLOAD_HISTORY, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SW_UPDATE_RESULT_LIST, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SYSTEM_SWVERSION_CIS_LIST, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SETTINGS_SWUPDATE_UPDATE_INFO, this);
#ifndef VARIANT_S_FTR_ENABLE_NAVIGATION
   SM_VehicleType = static_cast<uint8>(getKDSVehicleType());
   ETG_TRACE_USR1(("SWUpdate constructor: Vehicle Type =%d", SM_VehicleType))
#endif
   init();
   CreateMapAttrbValuetoTextId();
   _CISstatusReportVec.clear();
   _GetDTCInfoVec.clear();
   _SoftwareversionText.clear();
   _SoftwareversionTextValue.clear();
   _userRequestedUpdateType = static_cast<enSoftwareUpdateType>(SystemDataPoolConfig::getInstance()-> getSWUpdateTypeValue());
   _isQuickUpdate = static_cast<enSoftwareUpdateType>(SystemDataPoolConfig::getInstance()-> getSWUpdateTypeValue());
   ETG_TRACE_USR1(("SWUpdate constructor: _userRequestedUpdateType =%d", ETG_CENUM(enSoftwareUpdateType, _userRequestedUpdateType)))
}


/****************------------------------- LOGIC OF Implementation --------------------------------***************************/


#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
void SWUpdate::RequestXMLScriptWhileAnimationRun()
{
   ETG_TRACE_USR1(("SWUpdate::RequestXMLScriptWhileAnimationRun()"));
   pthread_t softwareVersionThreadId;
   pthread_attr_t detachable_thread;
   int retValAttr = -1;
   retValAttr = pthread_attr_init(&detachable_thread);
   retValAttr = pthread_attr_setdetachstate(&detachable_thread, PTHREAD_CREATE_DETACHED);
   int retVal = -1;
   if (retValAttr == 0)
   {
      // Create detached child thread to pool for XML file availablity - dont neet to join
      retVal = pthread_create(&softwareVersionThreadId, &detachable_thread, SoftwareNdSubSWUpdate_Trigger, NULL);
   }
   if (retVal == 0)
   {
      ETG_TRACE_USR1(("SWUpdate::RequestXMLScriptWhileAnimationRun: CREATED THREAD_ID = %d", softwareVersionThreadId));
   }
   else
   {
      ETG_TRACE_ERR(("SWUpdate RequestXMLScriptWhileAnimationRun: creation FAILED: ERROR_ID = %d", retVal));
   }
}


#endif


#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
void* SoftwareNdSubSWUpdate_Trigger(void*)//msgptr
{
   int SoftwareNdSubSystermSWVerScriptStatus = -1;
   sleep(1);
   ::std::string subSystemScript = "/var/opt/bosch/persistent/avdecc/cisinstallation/doipcmcerrmem.py";
   ::std::string cmd = "python ";
   cmd.append(subSystemScript);
   SoftwareNdSubSystermSWVerScriptStatus = system(cmd.c_str());
   ETG_TRACE_USR1(("SWUpdate::SoftwareNdSubSWUpdate_Trigger(void*) SoftwareNdSubSystermSWVerScriptStatus return value ==>%d", SoftwareNdSubSystermSWVerScriptStatus));
   SWUpdate::GetInstance()->UpdateSWVersionScriptStatus(SoftwareNdSubSystermSWVerScriptStatus);// Received script status is forwarded to the UpdateSWVersionScriptStatus
   return NULL;
}


void SWUpdate::UpdateSWVersionScriptStatus(int RxdSoftwareNdSubSystermSWVerScriptStatus)
{
   ETG_TRACE_COMP(("SWUpdate::UpdateSWVersionScriptStatus: RxdSoftwareNdSubSystermSWVerScriptStatus==>%d ", RxdSoftwareNdSubSystermSWVerScriptStatus));
   if (RxdSoftwareNdSubSystermSWVerScriptStatus != 0)
   {
      (*_oSwVersionNodeSwitchItem).mToggleNodeIndex = EnableLIST_DisableBUSYWAIT;
      _oSwVersionNodeSwitchItem.MarkAllItemsModified();
      _oSwVersionNodeSwitchItem.SendUpdate(true);

      ETG_TRACE_COMP(("void SWUpdate::UpdateSWVersionScriptStatus(int RxdSoftwareNdSubSystermSWVerScriptStatus) TimerNDAnim-Dis - List-En"));
      stopTimer4softwareversion();
      POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Show, Courier::ViewId("AppHmi_System#SoftwareDownload#Pfo_SoftwareVersionFetchingError"))));
   }
   else if (RxdSoftwareNdSubSystermSWVerScriptStatus == 0)
   {
      bool isFileAvailable = false;
      for (int iteration = 0; iteration < 3; iteration++)
      {
         isFileAvailable =  loadingxmldata();
         ETG_TRACE_USR2_THR(("SWUpdate::TestForXMLAvailability: iteration : %d, isFileAvailable = %d", iteration, isFileAvailable));
         if (isFileAvailable)
         {
            break;
         }
         sleep(2);
      }
   }
}


#endif
#endif


/**
*  @Singleton Instance
*/
/********************************************
 NAME    : SWUpdate
 SYSFL    : null,
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
SWUpdate* SWUpdate::GetInstance()
{
   if (NULL == m_swupdateSetting)
   {
      m_swupdateSetting = new SWUpdate();
   }
   return m_swupdateSetting;
}


#endif


/**
* @Destructor
*/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
SWUpdate::~SWUpdate()
{
   ETG_TRACE_COMP(("SWUpdate Destructor is called"));
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SYSTEM_SWVERSION_CIS_LIST);
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SETTINGS_SWUPDATE_UPDATE_INFO);
}


#endif


/**
* init - To call the methods in Startup.
* @param[in] 	: None
* @param[out] 	: None
* @return 		: void
*/
/********************************************
* NAME    : SWUpdate
* SYSFL    : null,
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void SWUpdate::init()
{
   _swHistoryDetailsVector.clear();
}


#endif


#ifndef VARIANT_S_FTR_ENABLE_NAVIGATION
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
unsigned int SWUpdate::getKDSVehicleType()
{
   uint8 u8VehicleType[2] = { 0 };
   uint16 u16VehicleType = 0;
   if (DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation", "VehicleType", &u8VehicleType[0], 2))
   {
      ETG_TRACE_USR2(("SWUpdate::getKDSVehicleType: First byte : %x, Second byte : %x", u8VehicleType[0], u8VehicleType[1]));
      u16VehicleType = static_cast<uint16>((u8VehicleType[0] << 8) | u8VehicleType[1]);
   }
   ETG_TRACE_USR1(("SWUpdate::getKDSVehicleType:Vehicle type : %d", u16VehicleType));
   return u16VehicleType;
}


#endif
#endif


/**
* setSystemGUIInitialized - To set/send system CGI app initialized status
* @param[in] 	: None
* @param[out] 	: None
* @return 		: void
*/
/********************************************
* NAME    : SWUpdate
* SYSFL    : SWFL-2156
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void SWUpdate::setSystemGUIInitialized()
{
   ETG_TRACE_COMP(("SWUpdate::setSystemGUIInitialized"));
   (*_swUpdateUsbStickInfo).mValidDownloadStickStatus = false;
   EXT_bIs_USB_Connected = false;
   _swUpdateUsbStickInfo.MarkAllItemsModified();
   _swUpdateUsbStickInfo.SendUpdate(true);
}


#endif


/**
* updateState - Update handling for version flashed in Target
* @param[in] muVersion
* @parm[out] None
* @return void
*/ /********************************************
* NAME    : SWUpdate
* SYSFL    : SWFL-2164
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void SWUpdate::updateState(const std::string muVersion, const uint8 updatestate, const uint8 updateSource)
{
   ETG_TRACE_COMP(("SWUpdate::updateState: update state = %d,  update source = %d, Multimedia version = %s", ETG_CENUM(enUpdState, updatestate), updateSource, muVersion.c_str()));
#ifndef VARIANT_S_FTR_ENABLE_NAVIGATION
   if (SM_VehicleType == SMART)
   {
      (*_SWNameSmart).misVisble = false;
      ETG_TRACE_USR1(("SWUpdate::updateState: SMART Text visible status = %d", (*_SWNameSmart).misVisble));
      _SWNameSmart.MarkAllItemsModified();
      _SWNameSmart.SendUpdate(true);
   }
#endif
   _isUpdateStateCalled = true;
   _updatestate = updatestate;
   if (!muVersion.empty())
   {
      _updatestate = updatestate;
      _sourceType = updateSource;
      (*_swMainVersionInfo).mCurrentVersion = muVersion.c_str();
      _swMainVersionInfo.MarkItemModified(ItemKey::SWUpdateMain::CurrentVersionItem);
      _swMainVersionInfo.SendUpdate(true);
   }
   if (UpdState_WaitAllowRecoveryMode == _updatestate)
   {
      ETG_TRACE_USR1(("SWUpdate::updateState: _inMISUpdateMode = %d", _inMISUpdateMode));
      _isWaitAllowRecoveryModeReceived = true;
      ETG_TRACE_USR1(("SWUpdate::updateState: _isWaitAllowRecoveryModeReceived = %d", _isWaitAllowRecoveryModeReceived));

      // -------------------------------------Test for ERROR Mode scenario -------------------------------------------------------
      // In Error mode scenario : SWDL Hmi will not in foreground and USB connected information will not be available

      // these are the initial condition for this use case
      // On reboot because of the internal reset in HeadUnit after completion of Stage 1, the middleware
      // will not send any info regd plugged in USB stick, if the Stick contain valid software
      // middleware will start update automatically in Background.
      // Use case (Bug 906356): if the middleware has already sent the UpdateState as WaitALlowRecoveryMode, and reset happend when we were displaying the results
      // its evident that USBstick with valid software is pulgged in. we will not receive ReleaseDoc or UpdateErrorState here

      // _inMISUpdateMode if flase means we are not into MIS Stage 1 mode,
      // EXT_bIs_USB_Connected if false means we have not received updateProgress before
      if (false == _inMISUpdateMode)
      {
         // It was confirmed with Middleware that _updatestate will come as UpdState_WaitAllowRecoveryMode, only during SWDL update progress,
         // if we receive this in middle, it means SWDL is pending at middleware. and middleware is waiting for HMI input to perform reboot.
         if (true == _isSWUpdateTriggered)
         {
            ETG_TRACE_USR2(("SWUpdate::updateState: _isSWUpdateTriggered is true"));
            //do nothing
            //When Quick update is triggered via HMI, the time for Quick update is very less.
            //As a result even before the XML is fetched and progress bar scene is displayed update would be completed and reboot happens.
            //To prevent this, if SWUpdate is triggered via HMI and if UpdState_WaitAllowRecoveryMode comes before display of progressbar scene, setAllowRecoveryModeRequest should not be sent as true.
         }
         else
         {
            ETG_TRACE_USR2(("SWUpdate::updateState: _isSWUpdateTriggered is false"));
            SWUpdateClient::GetInstance()->setAllowRecoveryModeRequest(true);
         }
      }
      //-------------------------- End of Error mode scenario -------------------------------------------
      //--------------------------- Below code get executed for Normal mode -----------------------------
      _isCMCUpdateNeeded = true;
      // This condition is encounter after MIS Update to send the AllowRecoveryMode
      // ToDO
      // isUpdateSuccessful -  To be set based on Return code from Middleware. No return code will be from MIS, Use UpdateState resp and UpdateProgress state message
      // Below code update the pop text for scenarios where CMC update is not needed
      if (_isUpdateSuccessful)
      {
         if (_isCMCUpdateNeeded)
         {
            // can occure for quick update scenario, but middleware provides info
            POST_MSG((COURIER_MESSAGE_NEW(SWupdateResultNotificationMsg)(POPUP_MIS_UPDATE_SUCCESS_AND_CMC_UPDATE)));
         }
         else
         {
            // All the components are successfully update
            POST_MSG((COURIER_MESSAGE_NEW(SWupdateResultNotificationMsg)(POPUP_MIS_UPDATE_SUCCESS_AND_REBOOT)));
         }
      }
      else
      {
         // All the components have failed to update
         POST_MSG((COURIER_MESSAGE_NEW(SWupdateResultNotificationMsg)(POPUP_MIS_UPDATE_FAILED)));
      }
   }
}


#endif


/**
* errorTypeUpdate - Handle error update type
* @param[in] errorStatus
* @parm[out] None
* @return void
*/
/********************************************
* NAME    : SWUpdate
* SYSFL    : SWFL-2173, SWFL-2175, SWFL-2177, SWFL-2179, SWFL-2181
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void SWUpdate::errorTypeUpdate(const uint8 errorStatus)
{
   ETG_TRACE_COMP(("SWUpdate::errorTypeUpdate: errorStatus =%d", ETG_CENUM(ErrorType, errorStatus)));
   _isUpdateErrorsCalled = true;
   _errorValue = errorStatus;
   // Update USB Connected State
   if (_errorValue == error_default_SWL_OK)        // Sent on start up even when USB is not available
   {
      // default value from midw, So No change to the EXT_bIs_USB_Connected value.
   }
   else if ((_errorValue == error_unavailable_stick) || (_errorValue == error_removed_stick))
   {
      EXT_bIs_USB_Connected = false;
   }
   else
   {
      // update the USB connected status irrespective of the updatestate values.
      EXT_bIs_USB_Connected = true;
   }// end of Sent on start up even when USB is not available
   // error types are valid only in Config State (valid usb stick) and in SelectRelease state (Invalid/incompatible download)
   ETG_TRACE_USR1(("SWUpdate::errorTypeUpdate: EXT_bIs_USB_Connected = %d.", EXT_bIs_USB_Connected));
   if ((_updatestate == UpdState_Config) || (_updatestate == UpdState_SelectRelease))
   {
      ETG_TRACE_USR2(("SWUpdate:errorTypeUpdate  updatestate 3 or 4"));
      (*_swUpdateUsbStickInfo).mUsbStickAvailableStatus = true; //To check whether USB is available or not
      if (errorStatus == error_incompatible_stick)
      {
         _isCustPopupIncompDisplayed = true;
         EXT_bIs_USB_Connected = true;
      }
      else if (_errorValue == error_removed_stick)
      {
         (*_swUpdateUsbStickInfo).mValidDownloadStickStatus = false;
         (*_swUpdateUsbStickInfo).mUsbStickAvailableStatus = false;
         EXT_bIs_USB_Connected = false;
         _isEstimatedTimeSet = false;
         POST_MSG((COURIER_MESSAGE_NEW(USBStickRemovedUpdMsg)()));
         _isCustPopupIncompDisplayed = false;
         if (_inMISUpdateMode)
         {
            // If the USB is removed, while MIS Stage one in progress. prepare the Swupdate for reboot scenario
            handleSWDLRebootScenarios();
         }
         // on USB removal resetting the bool flags
         _isUpdateStateCalled = false;
         _isReleaseDocCalled = false;
         _isUpdateErrorsCalled = false;
      }
      else if (_errorValue == error_incompatible_usb_format)
      {
         EXT_bIs_USB_Connected = true;
      }
      else if (_errorValue == error_downgrade_stick)
      {
         _isCustPopupIncompDisplayed = true;
         EXT_bIs_USB_Connected = true;
      }
      else if (_errorValue == error_samegrade_stick)
      {
         _isCustPopupIncompDisplayed = true;
         EXT_bIs_USB_Connected = true;
      }

      _swUpdateUsbStickInfo.MarkAllItemsModified();
      _swUpdateUsbStickInfo.SendUpdate(true);
      // perform Quick update, when misUpdatePending file is found bootup in the following path
      // -- /var/opt/bosch/persistent/fcswupdate/
      // This scenario represents, CIS update (Quick update) has to be done as a part of Software update
      if (false == _onBootFlag) // start of _onbootflag
      {
         bool bisMarkerFileFound = false;
         _onBootFlag = true;
         ETG_TRACE_USR3(("SWUpdate::errorTypeUpdate: MARKER_FILE = %s", MARKER_FILE));
         FILE* fileptr = fopen(MARKER_FILE, "r");
         if (NULL != fileptr)
         {
            bisMarkerFileFound = true;
            // Relocating file close call before logic. so In case, the program takes any branch file handle shall be closed properly
            fclose(fileptr);
         }//end of file pointer
         ETG_TRACE_USR3(("SWUpdate::errorTypeUpdate: MarkerFile found status = %d", bisMarkerFileFound));
         if (true == bisMarkerFileFound)//start for bisMarkerFileFound
         {
            ETG_TRACE_USR3(("SWUpdate::errorTypeUpdate:bisMarkerFileFound"));
            if (EXT_bIs_USB_Connected)// check for EXT_bIs_USB_Connected
            {
               ETG_TRACE_USR3(("SWUpdate::errorTypeUpdate:EXT_bIs_USB_Connected"));

               if (_isUpdateStateCalled && _isReleaseDocCalled  && _isUpdateErrorsCalled)
               {
                  //below code is commented to prevent quick update from happening in the first boot cycle
                  ETG_TRACE_USR4(("SWUpdate::errorTypeUpdate: _isUpdateStateCalled = %d, _isReleaseDocCalled = %d, _isUpdateErrorsCalled = %d", _isUpdateStateCalled, _isReleaseDocCalled, _isUpdateErrorsCalled));
                  //Set update is in middle of software update. Need to invoke the reboot logic
                  _isSoftwareDownloadPending = true;
                  ETG_TRACE_USR4(("SWUpdate::errorTypeUpdate: MarkerFile - Setting Quick Update Mode"));
                  //SWUpdateClient::GetInstance()->SetSoftwareUpdateType(UpdateType_Quick);
                  // Update Popup text to be displayed to user
                  // handlePopupTextUpdate(POPUP_MIS_UPDATE_PENDING);
                  // Post courier msg to display Popup
                  // POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Show, Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_three_line_single_button"))));
               }
               else
               {
                  ETG_TRACE_USR4(("SWUpdate::errorTypeUpdate: MarkerFile - MIS quick update deferred, as one of the following calls were not made - _isUpdateStateCalled = %d, _isReleaseDocCalled = %d, _isUpdateErrorsCalled = %d", _isUpdateStateCalled, _isReleaseDocCalled, _isUpdateErrorsCalled));
               }
            }
            else
            {
               ETG_TRACE_USR4(("SWUpdate::errorTypeUpdate:MarkerFile - USB is Not Connected but misUpdatePending is found. CIS update pending"));
            }
         }
      }
   }
}


#endif


/********************************************
 NAME    : ValdiateSWUpdateHMIStatus
 SYSFL    : null
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void SWUpdate::ValdiateSWUpdateHMIStatus()
{
   ETG_TRACE_COMP(("SWUpdate::ValdiateSWUpdateHMIStatus"));
   // these are the initial condition for this use case
   // On reboot because of the internal reset in HeadUnit during Stage 1, the middleware only
   // will not send any info plugged in USB stick, if the Stick contain valid software
   // middleware will start update automatically in Background.
   // the HMI is notified of this only by receiving updataeprogess. so only when we get updateprogess
   // and USB connected information is not updated perform this below seqence, if the condition are
   // not maintained, this will lead to redundancy and creates MULTIPLE THREADS
   // if we receive, this property in the boot-up. (Headunit restarted during cis update,with usb plugged in)
   // its evident that USBstick with valid software is pulgged in. we will not receive ReleaseDoc or UpdateErrorState here
   _errorValue = error_default_SWL_OK;
   if (false == EXT_bIs_USB_Connected)
   {
      // this is one of the entry conditions in state machine, Hence update the variable to TRUE.
      EXT_bIs_USB_Connected = true;
   }
   // _inMISUpdateMode if flase means we are not into MIS Stage 1 mode
   // EXT_bIs_USB_Connected if false means we have not received updateProgress before
   if (false == _inMISUpdateMode)
   {
      // Added to avoid redundant ContextSwitch request and thread creation.
      if (false == _isContextSwitchRequestPlacedForMIS)
      {
         // HMI is not in SWUpdate mode, as well have received UpdateState as running from middleware with submodule==MIS.
         // Usecase : MIS stage 1 was terminated (simulated reset - power off). On reboot, based fcswupdrunning.xml. MIS was started in BG without HMI transition
         // Trigger HMI scene transition to MIS stage1 Progress bar scene
         ETG_TRACE_USR3(("SWUpdate::ValdiateSWUpdateHMIStatus: _inMISUpdateMode = %d, _isContextSwitchRequestPlacedForMIS = %d", _inMISUpdateMode, _isContextSwitchRequestPlacedForMIS));
         POST_MSG((COURIER_MESSAGE_NEW(RequestMISupdateContextSwitchMsg)()));
         _isContextSwitchRequestPlacedForMIS = true;
         if (_isSWupdateviaDiagTool == false)
         {
            //send acknowledgment to LCM indicating SW Update is for MIS and progressbar context switch is placed.
            //acknowledgement should be sent only for SWUpdate via HMI trigger and avoid during Diagnosis update
            ETG_TRACE_USR2(("SWUpdate::ValdiateSWUpdateHMIStatus - Send SWUpdate started to LCM"));
            SpmSrvClient::GetInstance()->sendSWUpdateStatus(true);
         }
         // Reset the progress index to Zero. Start the internal timer
         _isXMLfileAvailable = false;
         _totalEstTime = 0;
         _totalEstTimefromXML = 0;
         _progressIndex = 0;
         // Step 1 - Write function pointer to be run by thread
         PoolForXMLFile();
         // Step 2 - Start the child thread - check TestForXMLAvailability method
         // Step 3 - trigger closure of timer and exit the thread
      }
      else
      {
         ETG_TRACE_USR3(("SWUpdate::ValdiateSWUpdateHMIStatuss: Context switch to Master placed, and XML monitoring thread started."));
      }
   }
}


#endif


/********************************************
* NAME    : SWUpdate
* SYSFL    : SWFL-2173, SWFL-2175, SWFL-2177, SWFL-2179, SWFL-2181,
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
bool SWUpdate::onCourierMessage(const StartUSBStickBinaryValidationReqMsg& /* oMsg */)
{
   ETG_TRACE_COMP(("SWUpdate::StartUSBStickBinaryValidationReqMsg: _errorValue = %d", ETG_CENUM(ErrorType, _errorValue)));
   if (_errorValue == error_incompatible_stick)
   {
      POST_MSG((COURIER_MESSAGE_NEW(IncompatibleUSBUpdMsg)())); // SERVICE__ICPOP_SW_DOWNLOAD_NO_MEDIA
   }
   else if (_errorValue == error_incompatible_usb_format)
   {
      POST_MSG((COURIER_MESSAGE_NEW(IncompatibleUsbFormatMsg)())); //InCompitable USB Format- Support only NTFS and FAT32
   }
   else if (_errorValue == error_removed_stick)
   {
      POST_MSG((COURIER_MESSAGE_NEW(USBStickRemovedUpdMsg)()));
   }

   else if (_errorValue == error_downgrade_stick)
   {
      POST_MSG((COURIER_MESSAGE_NEW(SWCompactibilityUpdMsg)(2)));
   }

   else
   {
      if ((true == (*_swUpdateUsbStickInfo).mValidDownloadStickStatus) || (_errorValue == error_samegrade_stick) || (_downloadMode == SWDL_CUSTOMER_MODE && _isSameVersion == true))
      {
         ETG_TRACE_COMP(("SWUpdate::StartUSBStickBinaryValidationReqMsg:USBValidationCompleteMsg"))
         // The USB Stick contains valid binaries
         POST_MSG((COURIER_MESSAGE_NEW(USBValidationCompleteMsg)()));
      }
   }

   return true;
}


#endif


/********************************************
* NAME    : SWUpdate
* SYSFL    : SWFL-2156
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
bool SWUpdate::onCourierMessage(const SetReleaseFilterReqMsg& oMsg)
{
   _downloadMode = oMsg.GetDownloadMode();
   ETG_TRACE_COMP(("SWUpdate::SetReleaseFilterReqMsg: Download mode = %d", ETG_CENUM(enSoftwareDownloadMode, _downloadMode)));
   if (_downloadMode == SWDL_CUSTOMER_MODE)
   {
      SWUpdateClient::GetInstance()->SetReleaseFilter(UpdOptions_NewAndSameOnly);
      _releaseFilter = UpdOptions_NewAndSameOnly;
   }
   else if (_downloadMode == SWDL_ENGG_MODE)
   {
      SWUpdateClient::GetInstance()->SetReleaseFilter(UpdOptions_Any);
      _releaseFilter = UpdOptions_Any;
   }
   else
   {
      SWUpdateClient::GetInstance()->SetReleaseFilter(UpdOptions_NewOnly);
      _releaseFilter = UpdOptions_NewOnly;
   }
   return true;
}


#endif


/********************************************
* NAME    : SWUpdate
* SYSFL    : SWFL-2156
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void SWUpdate::updateReleaseFilter(const uint8 releaseFilter)
{
   ETG_TRACE_COMP(("SWUpdate::updateReleaseFilter: release filter = %d", ETG_CENUM(UpdOptions, releaseFilter)));
   if (releaseFilter == UpdOptions_NewAndSameOnly)
   {
      POST_MSG((COURIER_MESSAGE_NEW(CustomerModeFilterUpdMsg)()));
   }
   else if (releaseFilter == UpdOptions_Any)
   {
      POST_MSG((COURIER_MESSAGE_NEW(EnggModeFilterUpdMsg)()));
   }
}


#endif


/**
* onCourierMessage - Request message to update the nature of update request by user
* @param[in] SetSoftwareUpdateTypeMsg  oMsg
* @parm[out] none
* @return bool
*********************************************
* NAME    : SWUpdate
* SYSFL    : SWFL-2164
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
bool SWUpdate::onCourierMessage(const SetSoftwareUpdateTypeMsg& oMsg)
{
   _userRequestedUpdateType = oMsg.GetUpdateType();
   ETG_TRACE_COMP(("SWUpdate::SetSoftwareUpdateTypeMsg: Update type sent = %d", ETG_CENUM(enSoftwareUpdateType, _userRequestedUpdateType)));
   SystemDataPoolConfig::getInstance()->setSWUpdateTypeValue(_userRequestedUpdateType);
   ETG_TRACE_USR1(("SWUpdate::SetSoftwareUpdateTypeMsg datapool write complete"));
   SWUpdateClient::GetInstance()->SetSoftwareUpdateType(_userRequestedUpdateType);
   if (UpdateType_Full == _userRequestedUpdateType)
   {
      // in case of Full update need to Perform CMC update as well
      _isCMCUpdateNeeded = true;
      (*_swQuickUpdateInfo).mButtonenable = false;
      (*_swDetailsInfo).mButtonenable = false;
      (*_swBackButtonInfo).mButtonenable = false;
   }
   else
   {
      _isQuickUpdate = true;
      (*_swFullUpdateInfo).mButtonenable = false;
      (*_swDetailsInfo).mButtonenable = false;
      (*_swBackButtonInfo).mButtonenable = false;
   }
   (*_PopupText).mProgressValue = 0;
   (*_PopupText).mProgressValueStr = "0 %";
   _swFullUpdateInfo.MarkAllItemsModified();
   _swFullUpdateInfo.SendUpdate(true);
   _swQuickUpdateInfo.MarkAllItemsModified();
   _swQuickUpdateInfo.SendUpdate(true);
   _swDetailsInfo.MarkAllItemsModified();
   _swDetailsInfo.SendUpdate(true);
   _swBackButtonInfo.MarkAllItemsModified();
   _swBackButtonInfo.SendUpdate(true);

   _PopupText.MarkAllItemsModified();
   _PopupText.SendUpdate(true);
#ifndef VARIANT_S_FTR_ENABLE_NAVIGATION
   if (SM_VehicleType == SMART)
   {
      POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Show, Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_five_line_double_button"))));
   }
#endif
   POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Show, Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_six_line_two_button"))));
   return true;
}


bool SWUpdate::onCourierMessage(const EnableButtonsonNopopMsg& oMsg)
{
   ETG_TRACE_COMP(("SWUpdate::EnableButtonsonNopopMsg:"));
   (*_swQuickUpdateInfo).mButtonenable = true;
   (*_swDetailsInfo).mButtonenable = true;
   (*_swBackButtonInfo).mButtonenable = true;
   (*_swFullUpdateInfo).mButtonenable = true;
   _swFullUpdateInfo.MarkAllItemsModified();
   _swFullUpdateInfo.SendUpdate(true);
   _swQuickUpdateInfo.MarkAllItemsModified();
   _swQuickUpdateInfo.SendUpdate(true);
   _swDetailsInfo.MarkAllItemsModified();
   _swDetailsInfo.SendUpdate(true);
   _swBackButtonInfo.MarkAllItemsModified();
   _swBackButtonInfo.SendUpdate(true);
   return true;
}


#endif


/**
 * onCourierMessage - Request to call 'ApplyDoc' property and SetUpdateOptions
 * @param[in] StartDownloadReqMsg  oMsg
 * @parm[out] none
 * @return bool
 */
/********************************************
* NAME    : SWUpdate
* SYSFL    : SWFL-2164
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
bool SWUpdate::onCourierMessage(const StartDownloadReqMsg& /* oMsg */)
{
   ETG_TRACE_COMP(("SWUpdate::StartDownloadReqMsg is called"));
   // Sending ApplyDoc request to middleware via client
   SWUpdateClient::GetInstance()->handleStartDownloadRequest();
   _isSWUpdateTriggered = true;
   // Reset the progress index to Zero. Start the internal timer
   _isXMLfileAvailable = false;
   _totalEstTime = 0;
   _totalEstTimefromXML = 0;
   _progressIndex = 0;
   // Step 1 - Write function pointer to be run by thread
   PoolForXMLFile();
   // Step 2 - Start the child thread - check TestForXMLAvailability method
   // Step 3 - trigger closure of timer and exit the thread
   return true;
}


#endif


/**
* updateReleaseDoc - To handle update system software when new version is found.
* @param[in] ReleaseDocInfo& stReleaseDocInfo
* @param[in] muVersion
* @parm[out] None
* @return void
*/
/********************************************
* NAME    : SWUpdate
* SYSFL    : null,
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void SWUpdate::updateReleaseDoc(const ReleaseDocInfo& stReleaseDocInfo)
{
   _isReleaseDocCalled = true;
   SWUpdateUtility swUpdateUtility;
   uint8 updateDirection = stReleaseDocInfo.UpdateDirection;
   _isSameVersion = swUpdateUtility.isSameVersion(updateDirection);
   //(*_swUpdateUsbStickInfo).mIsNotSameVersion = !(_isSameVersion);
   ETG_TRACE_USR1(("SWUpdate::updateReleaseDoc: updateDirection = %d, _isSameVersion =%d, _releaseFilter = %d, is release doc name empty = %d", updateDirection, _isSameVersion, _releaseFilter, stReleaseDocInfo.releaseName.empty()));
   if ((!stReleaseDocInfo.releaseName.empty()) && (_releaseFilter == UpdOptions_NewOnly))
   {
      (*_swUpdateUsbStickInfo).mValidDownloadStickStatus = true;
      if (stReleaseDocInfo.sourceType == 0/*SourceType_Usb*/)
      {
         updateVersionInfo(stReleaseDocInfo);
         // Msg will be posted when USB with New release version is found 'Automatic Update'or'Customer Update'.
         //       POST_MSG((COURIER_MESSAGE_NEW(NewSystemSoftwareFound)()));
         EXT_bIs_USB_Connected = true;
      }
   }
   else if ((!stReleaseDocInfo.releaseName.empty()) && (_releaseFilter != UpdOptions_NewOnly))
   {
      (*_swUpdateUsbStickInfo).mValidDownloadStickStatus = true;
      EXT_bIs_USB_Connected = true;
      // Msg will be posted when Dynamic update of invalid  stick to valid USB stick is found.
      updateVersionInfo(stReleaseDocInfo);
      //     POST_MSG((COURIER_MESSAGE_NEW(ReleaseDocPropertyUpdMsg)(0)));
   }
   else if ((stReleaseDocInfo.UpdateDirection == UpdateDirection__Downgrade) && (_releaseFilter == UpdOptions_NewAndSameOnly))
   {
      //    POST_MSG((COURIER_MESSAGE_NEW(ReleaseDocPropertyUpdMsg)(3)));
      EXT_bIs_USB_Connected = true;
   }
   else
   {
      (*_swUpdateUsbStickInfo).mValidDownloadStickStatus = false;
      // encountered for Nav Map Data Stick
      //  POST_MSG((COURIER_MESSAGE_NEW(IncompatibleUSBUpdMsg)()));
      //  ETG_TRACE_USR4(("SWUpdate: Invalid case"));
   }
   _swUpdateUsbStickInfo.MarkAllItemsModified();
   _swUpdateUsbStickInfo.SendUpdate(true);
}


#endif


/**
* updateVersionInfo - Handle to update the Media, Current and Quick update and estimated time.
* @param[in] stReleaseDocInfo
* @parm[out] None
* @return void
*/
/********************************************
* NAME    : SWUpdate
* SYSFL    : null,
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void SWUpdate::updateVersionInfo(const ReleaseDocInfo& stReleaseDocInfo)
{
   ETG_TRACE_COMP(("SWUpdate::updateVersionInfo"));
   ETG_TRACE_COMP(("SWUpdate::updateVersionInfo  _errorValue =%d,_downloadMode =%d,_isSameVersion=%d", _errorValue, _downloadMode, _isSameVersion));
   SWUpdateUtility swUpdateUtility;
   if ((stReleaseDocInfo.needFlashing) != ((*_swMainVersionInfo).mIsNeedFlashing))
   {
      (*_swMainVersionInfo).mIsNeedFlashing = stReleaseDocInfo.needFlashing;
   }
   _totalEstTime = stReleaseDocInfo.estimatedTime;
   std::string estTime = swUpdateUtility.getEstimatedTime(stReleaseDocInfo.estimatedTime, ESTIMATED_TOTAL_TIME);
   (*_swMainVersionInfo).mMediaVersion = stReleaseDocInfo.releaseName.c_str();
   if (_isEstimatedTimeSet == false)
   {
      (*_swMainVersionInfo).mEstimatedTime = estTime.c_str();
      _isEstimatedTimeSet = true;
   }

   if ((_errorValue == error_samegrade_stick) || (_isSameVersion == true))
   {
      ETG_TRACE_COMP(("SWUpdate updateVersionInfo::inside the if condition"));
      std::string sameVersionFirstLine = Candera::String(TextId_0x1A43).GetCString();
      //std::string sameVersionSecondLine = Candera::String(TextId_0x137D).GetCString();
      //sameVersionFirstLine.append(sameVersionSecondLine);
      //(*_swMainVersionInfo).mSameversionText = sameVersionFirstLine.c_str();
      (*_swMainVersionInfo).mIsSameversionTextvisible = true;
   }
   else
   {
      ETG_TRACE_COMP(("SWUpdateupdateVersionInfo::inside the else condition"));
      //(*_swMainVersionInfo).mSameversionText = " ";
      (*_swMainVersionInfo).mIsSameversionTextvisible = false;
   }

   ETG_TRACE_USR1(("SWUpdate::updateVersionInfo: _totalEstTime = %d, ReleaseDoc Name = %s", _totalEstTime, stReleaseDocInfo.releaseName.c_str()));
   ETG_TRACE_USR1(("SWUpdate:estTime = %s ", estTime.c_str()));
   _swMainVersionInfo.MarkItemModified(ItemKey::SWUpdateMain::IsNeedFlashingItem);
   _swMainVersionInfo.MarkItemModified(ItemKey::SWUpdateMain::MediaVersionItem);
   _swMainVersionInfo.MarkItemModified(ItemKey::SWUpdateMain::EstimatedTimeItem);
   // _swMainVersionInfo.MarkItemModified(ItemKey::SWUpdateMain::SameversionTextItem);
   _swMainVersionInfo.MarkItemModified(ItemKey::SWUpdateMain::IsSameversionTextvisibleItem);
   _swMainVersionInfo.SendUpdate(true);
}


#endif


/********************************************
* NAME    : SWUpdate
* SYSFL    : SWFL-2173, SWFL-2175, SWFL-2177, SWFL-2179, SWFL-2181
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
bool SWUpdate::onCourierMessage(const UpdatePopupTextReqMsg& oMsg)
{
   unsigned int popupSource = oMsg.GetPopupTextID();
   ETG_TRACE_COMP(("SWUpdate::UpdatePopupTextReqMsg called"));
   // by de-coupling we can trigger popupvia model as well without couirer msgs
   handlePopupTextUpdate(popupSource);

   return true;
}


#endif


/********************************************
* NAME    : SWUpdate
* SYSFL    : SWFL-2173, SWFL-2175, SWFL-2177, SWFL-2179, SWFL-2181
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void SWUpdate::handlePopupTextUpdate(unsigned int popupSource)
{
   ETG_TRACE_COMP(("SWUpdate::handlePopupTextUpdate: popupType= %d", ETG_CENUM(enPopUpType, popupSource)));
   const Candera::String DATA_CONTEXT_USB_UNAVAILABLE_FIRSTLINE = Candera::String(TextId_0x1313);
   const Candera::String DATA_CONTEXT_USB_UNAVAILABLE_SECONDLINE = Candera::String(TextId_0x1311);
   const Candera::String DATA_CONTEXT_USB_UNAVAILABLE_THIRDLINE = Candera::String(TextId_0x1312);
   const Candera::String DATA_CONTEXT_USB_UNAVAILABLE_FOURTHLINE = Candera::String(TextId_0x1313);
#ifdef VARIANT_S_FTR_ENABLE_NAVIGATION
   const Candera::String DATA_CONTEXT_INSTALLATION_UNAVAILABLE_FIRSTLINE = Candera::String(TextId_0x174E);
   const Candera::String DATA_CONTEXT_INSTALLATION_UNAVAILABLE_SECONDLINE = Candera::String(TextId_0x174F);
   const Candera::String DATA_CONTEXT_INSTALLATION_UNAVAILABLE_THIRDLINE = Candera::String(TextId_0x1750);

   const Candera::String DATA_CONTEXT_INSTALLATION_AVAILABLE_FIRSTLINE = Candera::String(TextId_0x174B);
   const Candera::String DATA_CONTEXT_INSTALLATION_AVAILABLE_SECONDLINE = Candera::String(TextId_0x174C);
   const Candera::String DATA_CONTEXT_INSTALLATION_AVAILABLE_THIRDLINE = Candera::String(TextId_0x174D);

   const Candera::String DATA_CONTEXT_INSTALLATION_INPROGRESS_FIRSTLINE = Candera::String(TextId_0x1748);
   const Candera::String DATA_CONTEXT_INSTALLATION_INPROGRESS_SECONDLINE = Candera::String(TextId_0x1749);
   const Candera::String DATA_CONTEXT_INSTALLATION_INPROGRESS_THIRDLINE = Candera::String(TextId_0x174A);
#endif
   const Candera::String DATA_CONTEXT_SWDOWNGRADE_FIRSTLINE = Candera::String(TextId_0x1314);
   const Candera::String DATA_CONTEXT_SWDOWNGRADE_SECONDLINE = Candera::String(TextId_0x1315);
   const Candera::String DATA_CONTEXT_SWDOWNGRADE_THIRDLINE = Candera::String(TextId_0x1316);
   const Candera::String DATA_CONTEXT_SWDOWNGRADE_FOURTHLINE = Candera::String(TextId_0x1317);
   const Candera::String DATA_CONTEXT_QUICKUPDATE_FIRSTLINE = Candera::String(TextId_0x14DC);
   const Candera::String DATA_CONTEXT_QUICKUPDATE_SECONDLINE = Candera::String(TextId_0x14DD);
   const Candera::String DATA_CONTEXT_QUICKUPDATE_THIRDLINE = Candera::String(TextId_0x14DE);
   const Candera::String DATA_CONTEXT_QUICKUPDATE_FOURTHLINE = Candera::String(TextId_0x14DF);
   const Candera::String DATA_CONTEXT_QUICKUPDATE_FIFTHLINE = Candera::String(TextId_0x14E0);
   const Candera::String DATA_CONTEXT_QUICKUPDATE_SIXTHLINE = Candera::String(TextId_0x14E1);

   const Candera::String DATA_CONTEXT_FULLUPDATE_FIRSTLINE = Candera::String(TextId_0x14D6);
   const Candera::String DATA_CONTEXT_FULLUPDATE_SECONDLINE = Candera::String(TextId_0x14D7);
   const Candera::String DATA_CONTEXT_FULLUPDATE_THIRDLINE = Candera::String(TextId_0x14D8);
   const Candera::String DATA_CONTEXT_FULLUPDATE_FOURTHLINE = Candera::String(TextId_0x14D9);
   const Candera::String DATA_CONTEXT_FULLUPDATE_FIFTHLINE = Candera::String(TextId_0x14DA);
   const Candera::String DATA_CONTEXT_FULLUPDATE_SIXTHLINE = Candera::String(TextId_0x14DB);

   const Candera::String DATA_CONTEXT_USB_REMOVED_FIRSTLINE = Candera::String(TextId_0x1374);
   const Candera::String DATA_CONTEXT_USB_REMOVED_SECONDLINE = Candera::String(TextId_0x1375);
   const Candera::String DATA_CONTEXT_USB_REMOVED_THIRDLINE = Candera::String(TextId_0x1376);
   const Candera::String DATA_CONTEXT_USB_REMOVED_FOURTHLINE = Candera::String(TextId_0x1377);

   const Candera::String DATA_CONTEXT_USB_INCOMPATIBLE_FIRSTLINE = Candera::String(TextId_0x1378);
   const Candera::String DATA_CONTEXT_USB_INCOMPATIBLE_SECONDLINE = Candera::String(TextId_0x1379);
   const Candera::String DATA_CONTEXT_USB_INCOMPATIBLE_THIRDLINE = Candera::String(TextId_0x137A);
   const Candera::String DATA_CONTEXT_USB_INCOMPATIBLE_FOURTHLINE = Candera::String(TextId_0x137B);

   const Candera::String DATA_CONTEXT_SWUPDATE_UNSUPPROTED_FILE_FORMAT_FIRSTLINE = " ";
   const Candera::String DATA_CONTEXT_SWUPDATE_UNSUPPROTED_FILE_FORMAT_SECONDLINE = "USB Format is not supported,";
   const Candera::String DATA_CONTEXT_SWUPDATE_UNSUPPROTED_FILE_FORMAT_THIRDLINE = "Please connect the FAT32 (or) NTFS formatted USB Stick";
   const Candera::String DATA_CONTEXT_SWUPDATE_UNSUPPROTED_FILE_FORMAT_FOURTHLINE = " ";

   const Candera::String DATA_CONTEXT_SWSAMEVERSION_FIRSTLINE = Candera::String(TextId_0x137C);
   const Candera::String DATA_CONTEXT_SWSAMEVERSION_SECONDLINE = Candera::String(TextId_0x137D);
   const Candera::String DATA_CONTEXT_SWSAMEVERSION_THIRDLINE = Candera::String(TextId_0x137E);
   const Candera::String DATA_CONTEXT_SWSAMEVERSION_FOURTHLINE = Candera::String(TextId_0x137F);
#ifndef VARIANT_S_FTR_ENABLE_NAVIGATION
   const Candera::String DATA_CONTEXT_FULLUPDATE_SMART_FIRSTLINE = Candera::String(TextId_0x131C);
   const Candera::String DATA_CONTEXT_FULLUPDATE_SMART_SECONDLINE = Candera::String(TextId_0x131D);
   const Candera::String DATA_CONTEXT_FULLUPDATE_SMART_THIRDLINE = Candera::String(TextId_0x131E);
   const Candera::String DATA_CONTEXT_FULLUPDATE_SMART_FOURTHLINE = Candera::String(TextId_0x131F);
   const Candera::String DATA_CONTEXT_QUICKUPDATE_SMART_FIRSTLINE = Candera::String(TextId_0x1318);
   const Candera::String DATA_CONTEXT_QUICKUPDATE_SMART_SECONDLINE = Candera::String(TextId_0x1319);
   const Candera::String DATA_CONTEXT_QUICKUPDATE_SMART_THIRDLINE = Candera::String(TextId_0x131A);
   const Candera::String DATA_CONTEXT_QUICKUPDATE_SMART_FOURTHLINE = Candera::String(TextId_0x131B);


#endif
   (*_PopupText).mLine1 = "";
   (*_PopupText).mLine2 = "";
   (*_PopupText).mLine3 = "";
   (*_PopupText).mLine4 = "";
   (*_PopupText).mLine5 = "";
   (*_PopupText).mLine6 = "";
   (*_PopupButton).mButtonVisibility = true;
   switch (popupSource)
   {
      case POPUP_USB_REMOVED:
      {
         (*_PopupText).mLine1 = DATA_CONTEXT_USB_REMOVED_FIRSTLINE;
         (*_PopupText).mLine2 = DATA_CONTEXT_USB_REMOVED_SECONDLINE;
         (*_PopupText).mLine3 = DATA_CONTEXT_USB_REMOVED_THIRDLINE;
         (*_PopupText).mLine4 = DATA_CONTEXT_USB_REMOVED_FOURTHLINE;
         break;
      }
      case POPUP_USB_INCOMPATIBLE:
      {
         (*_PopupText).mLine1 = DATA_CONTEXT_USB_INCOMPATIBLE_FIRSTLINE;
         (*_PopupText).mLine2 = DATA_CONTEXT_USB_INCOMPATIBLE_SECONDLINE;
         (*_PopupText).mLine3 = DATA_CONTEXT_USB_INCOMPATIBLE_THIRDLINE;
         (*_PopupText).mLine4 = DATA_CONTEXT_USB_INCOMPATIBLE_FOURTHLINE;
         break;
      }
      case POPUP_USB_UNSUPPORT_FORMAT:
      {
         (*_PopupText).mLine1 = DATA_CONTEXT_SWUPDATE_UNSUPPROTED_FILE_FORMAT_FIRSTLINE;
         (*_PopupText).mLine2 = DATA_CONTEXT_SWUPDATE_UNSUPPROTED_FILE_FORMAT_SECONDLINE;
         (*_PopupText).mLine3 = DATA_CONTEXT_SWUPDATE_UNSUPPROTED_FILE_FORMAT_THIRDLINE;
         (*_PopupText).mLine4 = DATA_CONTEXT_SWUPDATE_UNSUPPROTED_FILE_FORMAT_FOURTHLINE;
         break;
      }
      case POPUP_USB_UNAVAILABLE:
      {
         (*_PopupText).mLine1 = DATA_CONTEXT_USB_UNAVAILABLE_FIRSTLINE;
         (*_PopupText).mLine2 = DATA_CONTEXT_USB_UNAVAILABLE_SECONDLINE;
         (*_PopupText).mLine3 = DATA_CONTEXT_USB_UNAVAILABLE_THIRDLINE;
         break;
      }
      case POPUP_SWDOWNGRADE:
      {
         (*_PopupText).mLine1 = DATA_CONTEXT_SWDOWNGRADE_FIRSTLINE;
         (*_PopupText).mLine2 = DATA_CONTEXT_SWDOWNGRADE_SECONDLINE;
         (*_PopupText).mLine3 = DATA_CONTEXT_SWDOWNGRADE_THIRDLINE;
         (*_PopupText).mLine4 = DATA_CONTEXT_SWDOWNGRADE_FOURTHLINE;
         break;
      }
      case POPUP_SWSAMEVERSION:
      {
         (*_PopupText).mLine1 = DATA_CONTEXT_SWSAMEVERSION_FIRSTLINE;
         (*_PopupText).mLine2 = DATA_CONTEXT_SWSAMEVERSION_SECONDLINE;
         (*_PopupText).mLine3 = DATA_CONTEXT_SWSAMEVERSION_THIRDLINE;
         (*_PopupText).mLine4 = DATA_CONTEXT_SWSAMEVERSION_FOURTHLINE;
         break;
      }
      case POPUP_FULLUPDATE:
      {
         (*_PopupText).mLine1 = DATA_CONTEXT_FULLUPDATE_FIRSTLINE;
         (*_PopupText).mLine2 = DATA_CONTEXT_FULLUPDATE_SECONDLINE;
         (*_PopupText).mLine3 = DATA_CONTEXT_FULLUPDATE_THIRDLINE;
         (*_PopupText).mLine4 = DATA_CONTEXT_FULLUPDATE_FOURTHLINE;
         (*_PopupText).mLine5 = DATA_CONTEXT_FULLUPDATE_FIFTHLINE;
         (*_PopupText).mLine6 = DATA_CONTEXT_FULLUPDATE_SIXTHLINE;
         break;
      }
      case POPUP_QUICKUPDATE:
      {
         (*_PopupText).mLine1 = DATA_CONTEXT_QUICKUPDATE_FIRSTLINE;
         (*_PopupText).mLine2 = DATA_CONTEXT_QUICKUPDATE_SECONDLINE;
         (*_PopupText).mLine3 = DATA_CONTEXT_QUICKUPDATE_THIRDLINE;
         (*_PopupText).mLine4 = DATA_CONTEXT_QUICKUPDATE_FOURTHLINE;
         (*_PopupText).mLine5 = DATA_CONTEXT_QUICKUPDATE_FIFTHLINE;
         (*_PopupText).mLine6 = DATA_CONTEXT_QUICKUPDATE_SIXTHLINE;
         break;
      }
#ifndef VARIANT_S_FTR_ENABLE_NAVIGATION
      case POPUP_FULLUPDATE_SMART:
      {
         (*_PopupText).mLine1 = DATA_CONTEXT_FULLUPDATE_SMART_FIRSTLINE;
         (*_PopupText).mLine2 = DATA_CONTEXT_FULLUPDATE_SMART_SECONDLINE;
         (*_PopupText).mLine3 = DATA_CONTEXT_FULLUPDATE_SMART_THIRDLINE;
         (*_PopupText).mLine4 = DATA_CONTEXT_FULLUPDATE_SMART_FOURTHLINE;
         break;
      }
      case POPUP_QUICKUPDATE_SMART:
      {
         (*_PopupText).mLine1 = DATA_CONTEXT_QUICKUPDATE_SMART_FIRSTLINE;
         (*_PopupText).mLine2 = DATA_CONTEXT_QUICKUPDATE_SMART_SECONDLINE;
         (*_PopupText).mLine3 = DATA_CONTEXT_QUICKUPDATE_SMART_THIRDLINE;
         (*_PopupText).mLine4 = DATA_CONTEXT_QUICKUPDATE_SMART_FOURTHLINE;
         break;
      }
#endif
      case POPUP_MIS_UPDATE_SUCCESS_AND_CMC_UPDATE:
      {
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
         (*_PopupText).mLine1 = Candera::String(TextId_0x14E2);
         (*_PopupText).mLine2 = Candera::String(TextId_0x14E3);
         (*_PopupText).mLine3 = Candera::String(TextId_0x14E4);
#endif
         break;
      }
      case POPUP_MIS_UPDATE_SUCCESS_AND_REBOOT:
      {
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
         //SWUpdateUtility swUpdateUtility;
         //(*_PopupText).mLine1 = Candera::String(TextId_0x14E6);
         //(*_PopupText).mLine2 = Candera::String(TextId_0x14E7);
         //std::string line3str = Candera::String(TextId_0x14E8).GetCString();
         //(*_PopupText).mLine3 = (swUpdateUtility.replaceInTranslationTextID(line3str, "10", "%1")).c_str();
         std::string Line1 = "CIs systems software update is successful.";
         std::string Line2 = "Stage2 update will be skipped.";
         std::string Line3 = "System reboots in 10 seconds.";
         (*_PopupText).mLine1 = Candera::String(Line1.c_str());
         (*_PopupText).mLine2 = Candera::String(Line2.c_str());
         (*_PopupText).mLine3 = Candera::String(Line3.c_str());
#endif
         break;
      }
      case POPUP_MIS_UPDATE_FAILED:
      {
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
         (*_PopupText).mLine1 = Candera::String(TextId_0x14EA);
         (*_PopupText).mLine2 = Candera::String(TextId_0x14EB);
#endif
         break;
      }
      case POPUP_MIS_UPDATE_FAILED_INVALID_XML:
      {
         //"Stage 1: Update has failed due to Time Out. ";
         // "The System will abort the software Update.";
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
         (*_PopupText).mLine1 = Candera::String(TextId_0x14EA);
         (*_PopupText).mLine2 = Candera::String(TextId_0x14EB);
#endif
         break;
      }
      case POPUP_MIS_UPDATE_PENDING:
      {
         (*_PopupText).mLine1 = "Stage 1: CIs subsystems update was not successful.";
         (*_PopupText).mLine2 = "System will restarts update again and reboots. ";
         break;
      }

#ifdef VARIANT_S_FTR_ENABLE_NAVIGATION
      case  POPUP_SYS_INSTALLATION_INPROGRESS:
      {
         (*_PopupText).mLine1 = DATA_CONTEXT_INSTALLATION_INPROGRESS_FIRSTLINE;
         (*_PopupText).mLine2 = DATA_CONTEXT_INSTALLATION_INPROGRESS_SECONDLINE;
         (*_PopupText).mLine3 = DATA_CONTEXT_INSTALLATION_INPROGRESS_THIRDLINE;
         (*_PopupButton).mButtonVisibility = false;
         break;
      }
      case  POPUP_SYS_INSTALLATION_SUCCESS:
      {
         (*_PopupText).mLine1 = DATA_CONTEXT_INSTALLATION_AVAILABLE_FIRSTLINE;
         (*_PopupText).mLine2 = DATA_CONTEXT_INSTALLATION_AVAILABLE_SECONDLINE;
         (*_PopupText).mLine3 = DATA_CONTEXT_INSTALLATION_AVAILABLE_THIRDLINE;
         (*_PopupButton).mButtonVisibility = true;
         break;
      }
      case  POPUP_SYS_INSTALLATION_FAILURE:
      {
         (*_PopupText).mLine1 = DATA_CONTEXT_INSTALLATION_UNAVAILABLE_FIRSTLINE;
         (*_PopupText).mLine2 = DATA_CONTEXT_INSTALLATION_UNAVAILABLE_SECONDLINE;
         (*_PopupText).mLine3 = DATA_CONTEXT_INSTALLATION_UNAVAILABLE_THIRDLINE;
         (*_PopupButton).mButtonVisibility = true;
         break;
      }
      case  POPUP_SYS_RESETSUPPLIERMODE_SUCCESS:
      {
         (*_PopupText).mLine1 = Candera::String(TextId_0x1A28);
         (*_PopupText).mLine2 = Candera::String(TextId_0x1A29);

         break;
      }
      case  POPUP_SYS_RESETSUPPLIERMODE_FAILURE:
      {
         (*_PopupText).mLine1 = Candera::String(TextId_0x1A2A);
         (*_PopupText).mLine2 = Candera::String(TextId_0x1A2B);

         break;
      }
#endif
      default:
      {
         break;
      }
   }
   _PopupText.MarkAllItemsModified();
   _PopupText.SendUpdate(true);
   _PopupButton.MarkAllItemsModified();
   _PopupButton.SendUpdate(true);
}


#endif


/**
* readSWDeatilsReleaseDoc - To Handle Software Details list screen update from 'ReleaseDoc'
* @param[in] releaseDocName
* @parm[out] None
* @return void
*/
/********************************************
* NAME    : SWUpdate
* SYSFL    : SWFL-2166
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void SWUpdate::readSWUpdateDetails()
{
   std::vector<swDetailsInfo> _swDetailsVector = SWUpdateClient::GetInstance()->getSWDetailsVector();
   uint32 detailsSize = _swDetailsVector.size();
   ETG_TRACE_USR1(("SWUpdate::readSWUpdateDetails: detailsSize = %d", detailsSize));
   tSharedPtrDataProvider dataProvider;
   ListDataProviderBuilder listBuilder(LIST_ID_SW_UPDATE_DETAILS_LIST);
   for (uint8 detailsval = 0; detailsval < detailsSize; ++detailsval)
   {
      SWDetailsTextData item;
      item.mSubModuleName  = _swDetailsVector[detailsval].subModuleName.c_str();
      item.mCurrentVersion = _swDetailsVector[detailsval].currentVersion.c_str();
      item.mMediaVersion   = _swDetailsVector[detailsval].mediaVersion.c_str();
      listBuilder.AddItem(
         detailsval, // - identifies the row
         0UL, // - unused
         DATA_CONTEXT_TEXT_LIST_ITEM)
      .AddDataBindingUpdater<SWDetailsTextDataBindingSource>(item);
      ETG_TRACE_USR2(("SWUpdate::readSWUpdateDetails: detailsval= %d, SubModuleName  = %s", detailsval, item.mSubModuleName.GetCString()))
      ETG_TRACE_USR2(("SWUpdate::readSWUpdateDetails: CurrentVersion = %s", item.mCurrentVersion.GetCString()));
      ETG_TRACE_USR2(("SWUpdate::readSWUpdateDetails: MediaVersion   = %s", item.mMediaVersion.GetCString()));
   }
   dataProvider = listBuilder.CreateDataProvider();
   POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
}


#endif


/**
* updateSWUpdateDetailsText - Utility Function to Update the SW Update Version Details Data Binding Variable during Speed Lock
* @param[in] None
* @parm[out] None
* @return void
*/
/********************************************
* NAME    : SWUpdate
* SYSFL    : null,
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void SWUpdate::updateSWUpdateVersionDetailsText()
{
   ETG_TRACE_COMP(("SWUpdate::updateSWUpdateVersionDetailsText"));
   std::vector < swDetailsInfo > swDetailsVector = SWUpdateClient::GetInstance()->getSWDetailsVector();
   std::string detailsInfo = "";
   for (std::vector < swDetailsInfo >::const_iterator iter_id = swDetailsVector.begin(); iter_id != swDetailsVector.end(); ++iter_id)
   {
      detailsInfo = detailsInfo + ((*iter_id).currentVersion) + "\n";
   }
   (*_swUpdateDetails).mMainCurrentVersion = detailsInfo.c_str();
   _swUpdateDetails.MarkItemModified(ItemKey::SWUpdateDetails::MainCurrentVersionItem);
   _swUpdateDetails.SendUpdate(true);
}


#endif


/**
* getListDataProvider - Add the items required for Software details List and
*                       sends the ListDataProvider to the FlexList Widget
* @param[in] none
* @parm[out] none
* @return tSharedPtrDataProvider
*/
/********************************************
* NAME    : SWUpdate
* SYSFL    : SWFL-2166, SWFL-2168
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
tSharedPtrDataProvider SWUpdate::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   tSharedPtrDataProvider dataProvider;
   _listId = oMsg.GetListId();
   ETG_TRACE_COMP(("SWUpdate::getListDataProvider is called with list Id = %u, EXT_bIs_USB_Connected = %d", _listId, EXT_bIs_USB_Connected));
   switch (_listId)
   {
      case LIST_ID_SYSTEM_SWVERSION_CIS_LIST:
      {
         ETG_TRACE_COMP(("SWUpdate::getListDataProvider is called ExtractInfo()"));
         dataProvider = ExtractInfo();
         break;
      }
      case LIST_ID_SW_UPDATE_DETAILS_LIST:
      {
         SWUpdateClient::GetInstance()->getDeviceDataReleaseDoc();
         break;
      }
      case LIST_ID_SW_DOWNLOAD_HISTORY:
      {
         SWUpdateClient::GetInstance()->getUpdateHistory();
         break;
      }
      case LIST_ID_SW_UPDATE_RESULT_LIST:
      {
         if (EXT_bIs_USB_Connected)
         {
            dataProvider = getSoftwareUpdateResults();
            POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
         }
         break;
      }
      case LIST_ID_SETTINGS_SWUPDATE_UPDATE_INFO:
      {
         ETG_TRACE_COMP(("SWUpdate::getListDataProvider LIST_ID_SETTINGS_SWUPDATE_UPDATE_INFO"));
         dataProvider = getSerialandMACAddress();
         break;
      }
      default:
      {
         break;
      }
   }
   return dataProvider;
}


#endif


/********************************************
* NAME    : SWUpdate
* SYSFL    : SWFL-2168
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void SWUpdate::readSWUpdateHistory()
{
   ETG_TRACE_COMP(("SWUpdate::readSWUpdateHistory is called"));
   if (NULL != SWUpdateClient::GetInstance())
   {
      std::vector< UpdateHistoryInfo > _swHistoryVector =  SWUpdateClient::GetInstance()->getSWUpdateHistoryVector();
      uint32 logHistorySize = _swHistoryVector.size();
      ETG_TRACE_USR1(("SWUpdate::readSWUpdateHistory: History vector size = %d",  logHistorySize));
      if (logHistorySize != 0)
      {
         ListDataProviderBuilder listBuilder(LIST_ID_SW_DOWNLOAD_HISTORY);
         uint8 FirstEntry = 0;
         Candera::String versionName = _swHistoryVector[FirstEntry].versionName.c_str();
         ETG_TRACE_USR2(("SWUpdate::readSWUpdateHistory: version name = %s",  versionName.GetCString()));
         Candera::String date        = _swHistoryVector[FirstEntry].date.c_str();
         bool status                 = _swHistoryVector[FirstEntry].status;
         Candera::String Status      = (status == true) ? "Successful" : "Failure";
         ETG_TRACE_USR2(("SWUpdate::readSWUpdateHistory: status = %s",  Status.GetCString()));
         listBuilder.AddItem(FirstEntry, 0UL, "First_SWUpdateHistory").AddData(versionName).AddData(Status);//.AddData(date);
         for (uint8 logval = 1; logval < logHistorySize; ++logval)
         {
            Candera::String versionName = _swHistoryVector[logval].versionName.c_str();
            ETG_TRACE_USR2(("SWUpdate::readSWUpdateHistory: version name = %s",  versionName.GetCString()));
            Candera::String date        = _swHistoryVector[logval].date.c_str();
            bool status                 = _swHistoryVector[logval].status;
            Candera::String Status      = (status == true) ? "Successful" : "Failure";
            ETG_TRACE_USR2(("SWUpdate::readSWUpdateHistory: status = %s",  Status.GetCString()));
            listBuilder.AddItem(logval, 0UL, "SWUpdateHistory").AddData(versionName).AddData(Status);//.AddData(date);
         }
         tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();
         POST_MSG((COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)));
      }
   }
}


#endif


/********************************************
* NAME    : SWUpdate MIS Stage 1 Update
* SYSFL    : SWFL-
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
tSharedPtrDataProvider SWUpdate::getSoftwareUpdateResults()
{
   _isSWUpdateTriggered = false; // Flag set to false after SWUpdate is completed and results screen is shown
   std::vector<App::Core::UpdReport> _statusReportVec;
   // Read infrom from XML.
   _isXMLfileAvailable = RetrieveInformationFromXML();
   if (_isXMLfileAvailable)
   {
      _statusReportVec = XMLDocParser::GetInstance()->GetResultUpdates();
   }
   uint32 updateResultSize = _statusReportVec.size();
   ETG_TRACE_USR1(("SWUpdate::getSoftwareUpdateStatus: _isXMLfileAvailable = %d, updateResultSize = %d", _isXMLfileAvailable, updateResultSize));
   uint32 numOfUpdatedComponents = 0;
   Candera::String updateResultData;
   bool isComponentUpdateFailed = false;
   ListDataProviderBuilder listBuilder(LIST_ID_SW_UPDATE_RESULT_LIST);
   if (0U == updateResultSize)
   {
      ETG_TRACE_USR2(("SWUpdate::getSoftwareUpdateStatus - Empty vector"));
      isComponentUpdateFailed = true;
      listBuilder.AddItem(
         0U, // - identifies the row
         0UL, // - unused
         "UpdateResults")
      .AddData("Empty")
      .AddData("Empty");
   }
   else
   {
      for (uint8 logval = 0; logval < updateResultSize; logval++)
      {
         SWUpdateUtility testobj;
         ETG_TRACE_USR3(("SWUpdate::getSoftwareUpdateStatus inside Loop %d", logval));
         std::string Name = "Sub Systems";//Should be replaced with Text-ids
         std::string Status = "Not connected";
         std::string Center = "Center";
         if (_statusReportVec[logval].nameStr == Center)
         {
            ETG_TRACE_USR2(("SWUpdate::getSoftwareUpdateStatus submodule name is Center"));
            listBuilder.AddItem(
               logval, // - identifies the row
               0UL, // - unused
               "UpdateResults")
            .AddData(Name.c_str())
            .AddData(Status.c_str());
         }
         else
         {
            ETG_TRACE_USR2(("SWUpdate::getSoftwareUpdateStatus submodule name is not Center"));
            listBuilder.AddItem(
               logval, // - identifies the row
               0UL, // - unused
               "UpdateResults")
            .AddData(_statusReportVec[logval].nameStr.c_str())
            .AddData(_statusReportVec[logval].resultStr.c_str());
         }
         if (_statusReportVec[logval].isUpdateSuccess)
         {
            numOfUpdatedComponents++;
         }
         else
         {
            ETG_TRACE_USR4(("SWUpdate::getSoftwareUpdateStatus - inside Loop Update has failed"));
            isComponentUpdateFailed = true;
         }
         ETG_TRACE_USR3(("SWUpdate::getSoftwareUpdateStatus Component Name %s", _statusReportVec[logval].nameStr.c_str()));
         ETG_TRACE_USR3(("SWUpdate::getSoftwareUpdateStatus Update Result %s", _statusReportVec[logval].resultStr.c_str()));
      }
   }
   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();
   ETG_TRACE_USR1(("SWUpdate:getSoftwareUpdateStatus numOfUpdatedComponents = %d, _userRequestedUpdateType = %d", numOfUpdatedComponents, _userRequestedUpdateType));

   if (_isSWupdateviaDiagTool)
   {
      if (isComponentUpdateFailed) //if any of the MIS component update has failed then send false to diagnosis
      {
         ETG_TRACE_USR4(("SWUpdate::getSoftwareUpdateStatus - sending false"));
         MIDWDiagnosis::poGetInstance()->SendCISswUpdateComplete(false);
      }
      else //if all MIS component update has finished successfully then send true to diagnosis
      {
         ETG_TRACE_USR4(("SWUpdate::getSoftwareUpdateStatus - sending true"));
         MIDWDiagnosis::poGetInstance()->SendCISswUpdateComplete(true);
      }
   }

   // Result shown in HMI is for information, Any update related failure shall be handled by
   // middleware in next boot cycle. Hence, CMC head unit shall not be blocked bcoz of error
   // in submodule update.
   _isUpdateSuccessful = true;
   if (UpdateType_Full == _userRequestedUpdateType)
   {
      // in case of Full update, we need to Perform CMC update as well
      _isCMCUpdateNeeded = true;
   }
   // Below code update the pop text for scenarios where CMC update is not needed
   if (_isUpdateSuccessful)
   {
      if (_isCMCUpdateNeeded)
      {
         // can occure for quick update scenario, but middleware provides info
         POST_MSG((COURIER_MESSAGE_NEW(SWupdateResultNotificationMsg)(POPUP_MIS_UPDATE_SUCCESS_AND_CMC_UPDATE)));
      }
      else
      {
         // All the components are successfully update
         POST_MSG((COURIER_MESSAGE_NEW(SWupdateResultNotificationMsg)(POPUP_MIS_UPDATE_SUCCESS_AND_REBOOT)));
      }
   }
   else
   {
      // All the components have failed to update
      POST_MSG((COURIER_MESSAGE_NEW(SWupdateResultNotificationMsg)(POPUP_MIS_UPDATE_FAILED)));
   }
   (*_PopupText).mProgressValue = 0;
   (*_PopupText).mProgressValueStr = "0 %";
   _PopupText.MarkAllItemsModified();
   _PopupText.SendUpdate(true);
   return dataProvider;
}


#endif


//below code is to check status of _inMISUpdateMode on press of HK when in Stage One update progress and result screen
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
bool SWUpdate::getStageOneUpdateOnGoingStatus()
{
   ETG_TRACE_COMP(("SWUpdate::getStageOneUpdateOnGoingStatus _inMISUpdateMode= %d", _inMISUpdateMode));
   return _inMISUpdateMode;
}


#endif


/********************************************
* NAME    : SWUpdate
* SYSFL    : SWFL-2177
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
bool SWUpdate::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   bool msgProcessed = false;
   _currentRowId = oMsg.GetHdl();
   unsigned int listID = oMsg.GetListId();
   if (LIST_ID_SW_DOWNLOAD_HISTORY == listID)
   {
      ETG_TRACE_USR2(("SWUpdate::ButtonListItemUpdMsg:LIST_ID_SW_DOWNLOAD_HISTORY: row Id = %d, reaction = %d", _currentRowId, oMsg.GetReaction()));
      if (oMsg.GetReaction() == enRelease)
      {
         msgProcessed = true;
         updateSWUpdateHistoryDetailsText();
      }
   }
   return msgProcessed;
}


#endif


/********************************************
* NAME    : SWUpdate
* SYSFL    : SWFL-2177
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
void SWUpdate::updateSWUpdateHistoryDetailsText()
{
   _swHistoryDetailsVector =  SWUpdateClient::GetInstance()->getSWUpdateHistoryDetailsVector();
   ETG_TRACE_USR1(("SWUpdate::updateSWUpdateHistoryDetailsText: _swHistoryDetailsVector.size() = %d", _swHistoryDetailsVector.size()));
   if (_swHistoryDetailsVector.size() > _currentRowId)
   {
      (*_SWHistoryDetailsText).msubmoduleversion = _swHistoryDetailsVector[_currentRowId].c_str();
      _SWHistoryDetailsText.MarkAllItemsModified();
      _SWHistoryDetailsText.SendUpdate(true);
   }
}


#endif


/********************************************
* NAME    : SWUpdate - Handle Reboot scenarios trigger via Stat Machine Events
* SYSFL    : SWFL-2164
****************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
bool SWUpdate::onCourierMessage(const RebootOnSWDLCompleteMsg& /* oMsg */)
{
   // de-coupling courier msg and usecase handling to for efficinecy and optimization
   ETG_TRACE_COMP(("SWUpdate::onRebootOnSWDLCompleteMsg: EXT_bIs_USB_Connected = %d", EXT_bIs_USB_Connected));
   if (EXT_bIs_USB_Connected)
   {
      // Handline courier msgs only when USB is connected
      _isEstimatedTimeSet = false;
      handleSWDLRebootScenarios();
   }
   return true;
}


/********************************************
* NAME    : StartMISStageOneUpdateMsg - Triggered on expiration of the XML avialability Time Out
* SYSFL    : 2546,
****************************************************/
bool SWUpdate::onCourierMessage(const StartMISStageOneUpdateMsg& /* oMsg */)
{
   ETG_TRACE_COMP(("SWUpdate::StartMISStageOneUpdateMsg: EXT_bIs_USB_Connected -- %s", (EXT_bIs_USB_Connected ? "true" : "false")));
   if (true == EXT_bIs_USB_Connected)
   {
      // Read infrom from XML.
      _isXMLfileAvailable = RetrieveInformationFromXML();
      if (_isXMLfileAvailable)
      {
         _totalEstTimefromXML = XMLDocParser::GetInstance()->GetStageOneEstimatedTime();
         ETG_TRACE_USR2(("SWUpdate::StartMISStageOneUpdateMsg: Estimated Time for Stage 1 is %u,", _totalEstTimefromXML));
         _progressIndex = 0;
         (*_PopupText).mProgressValue = 0;
         (*_PopupText).mProgressValueStr = "0 %";
         _PopupText.MarkAllItemsModified();
         _PopupText.SendUpdate(true);
         // This Marks the Start of MIS Stage 1 update : Here on out , if USB stick is removed at anypoint,
         // The User will be notified of the USB Stick unavailabilty.
         // On user confirmation, this the system shall be rebooted as it was interrupted in in SW download process.
         // Settings this flag to true to Mark the entry into MIS Stage 1 update.
         _inMISUpdateMode = true;
         POST_MSG((COURIER_MESSAGE_NEW(OnReceivingStageOneEstTimeMsg)()));
      }
      else
      {
         POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Show, Courier::ViewId("AppHmi_System#SoftwareDownload#PopUp_three_line_single_button"))));
      }
   }
   return true;
}


void SWUpdate::CurrentActiveRegion(uint8 u8activeRegion)
{
   ETG_TRACE_COMP(("SWUpdate:CurrentActiveRegion is called with u8activeRegion = %d and _currentActiveRegion = %d", u8activeRegion, _currentActiveRegion));
   _currentActiveRegion = u8activeRegion;
   ETG_TRACE_USR1(("SWUpdate:CurrentActiveRegion _currentActiveRegion = %d", _currentActiveRegion));
}


void SWUpdate::SWUpdateviaDiagTool(bool status)
{
   ETG_TRACE_COMP(("SWUpdate:SWUpdateviaDiagTool is called with status=%d, _isSWupdateviaDiagTool=%d, _isContextSwitchRequestPlacedForSWUpdateviaDiag = %d", status, _isSWupdateviaDiagTool, _isContextSwitchRequestPlacedForSWUpdateviaDiag));
   ETG_TRACE_USR1(("SWUpdate:SWUpdateviaDiagTool _isSWUpdateTriggered= %d", _isSWUpdateTriggered));
   _isSWUpdateTriggered = status;
   _isSWupdateviaDiagTool = status;
   ETG_TRACE_USR2(("SWUpdate:SWUpdateviaDiagTool _isSWUpdateTriggered= %d", _isSWUpdateTriggered));

   if (_isSWupdateviaDiagTool == false)
   {
      ETG_TRACE_USR2(("SWUpdate:SWUpdateviaDiagTool _isSWupdateviaDiagTool is false, _isContextSwitchRequestPlacedForSWUpdateviaDiag = %d", _isContextSwitchRequestPlacedForSWUpdateviaDiag));
      _isContextSwitchRequestPlacedForSWUpdateviaDiag = false;
   }

   if ((_isSWupdateviaDiagTool == true) && (_isContextSwitchRequestPlacedForSWUpdateviaDiag == false))
   {
      ETG_TRACE_USR2(("SWUpdate:SWUpdateviaDiagTool send ContextSwitchApplication to Homescreen"));
      _isContextSwitchRequestPlacedForSWUpdateviaDiag = true;
      ApplicationSwitchClientComponent* _applicationSwitchClientComponent = ApplicationSwitchClientComponent::poGetInstance();
      _applicationSwitchClientComponent->requestContextSwitchApplication(_currentActiveRegion, (EN_ACTIVITY_IDS)0, (EN_ACTIVITY_IDS)0,
            APPID_APPHMI_MASTER, enActivityIDs__eActivityID_HOME);
   }
}


bool SWUpdate::getWaitAllowRecoveryModeStatus()
{
   ETG_TRACE_COMP(("SWUpdate:getWaitAllowRecoveryModeStatus is called and _isWaitAllowRecoveryModeReceived = %d", _isWaitAllowRecoveryModeReceived));
   return _isWaitAllowRecoveryModeReceived;
}


/********************************************
* NAME    : SWUpdate - ProgressBar information handler
* SYSFL    : SWFL-2547
****************************************************/
bool SWUpdate::onCourierMessage(const TimerWidgetExpiryMsg& oMsg)
{
   uint32 elapsedTime = oMsg.GetElapsedTime();
   ETG_TRACE_COMP(("SWUpdate::TimerWidgetExpiryMsg: elapsed time = %u, EXT_bIs_USB_Connected = %d, _isXMLfileAvailable = %d", elapsedTime, EXT_bIs_USB_Connected, _isXMLfileAvailable));
   if (true == EXT_bIs_USB_Connected)
   {
      uint8 _progressPercent = 0;
      if (_isXMLfileAvailable)
      {
         _progressPercent = static_cast<uint8>(((float)_progressIndex / (float)_totalEstTimefromXML) * 100);
         if (_progressPercent >= MAX_STEPCOUNT)
         {
            // read the XML again to get the UpdateResults
            RetrieveInformationFromXML();
            // on time out. Hid the MIS stage 1 progress pop up
            if (_isSWupdateviaDiagTool)
            {
               //disable Abort and Next buttons if SW Update happens via Diagnostics
               (*_MISStage1Results).mAbortButtonEnable = false;
               (*_MISStage1Results).mNextbuttonEnable = false;
               (*_MISStage1Results).mDetailsbuttonEnable = true; //currently Details menu is enabled in both updates [HMI trigger and Diagnosis]
               _MISStage1Results.MarkAllItemsModified();
               _MISStage1Results.SendUpdate(true);
            }
            else
            {
               //By Default Abort and Next Buttons will be enabled.
               //This else condition is fail safe condition, if SW Update via Diag gets interrpted in the middle.
               (*_MISStage1Results).mAbortButtonEnable = true;
               (*_MISStage1Results).mNextbuttonEnable = true;
               (*_MISStage1Results).mDetailsbuttonEnable = true;
               _MISStage1Results.MarkAllItemsModified();
               _MISStage1Results.SendUpdate(true);
            }
            // indicating LCM component that the SWUpdate is completed and results screen is shown.
            //ETG_TRACE_USR2(("SWUpdate::TimerWidgetExpiryMsg - Send SWUpdate completed to LCM"));
            //sending acknowledgement to LCM after SWUpdate completion not required as LCM is doing reboot and system state will be changed.
            //SpmSrvClient::GetInstance()->sendSWUpdateStatus(false);
            POST_MSG((COURIER_MESSAGE_NEW(SWUpdateStageOneCompleteMsg)()));
         }
         else // _progressIndex value is between 0 and MAX
         {
            _progressIndex++;
            ETG_TRACE_USR2(("SWUpdate::TimerWidgetExpiryMsg - Total est : %u, _progressIndex %u, _progressPercent : %d", _totalEstTimefromXML, _progressIndex, _progressPercent));
            SWUpdateUtility swUpdateUtility;
            std::string intStr = swUpdateUtility.itoa(_progressPercent);
            intStr.append(" %");
            // Update progressbar Text value
            (*_PopupText).mProgressValue = _progressPercent;
            (*_PopupText).mProgressValueStr = intStr.c_str();
            _PopupText.MarkAllItemsModified();
            _PopupText.SendUpdate(true);
         }
      }
   }
   return false;
}


/********************************************
* NAME    : SWUpdate - Handle Reboot scenario on USB Stick Removal on Software Update if needed
* SYSFL    : SWFL-2164
****************************************************/
bool SWUpdate::onCourierMessage(const HandleRebootOnUSBRemovalMsg& /* oMsg */)
{
   ETG_TRACE_COMP(("SWUpdate::HandleRebootOnUSBRemovalMsg is called"));
   // Handline courier msgs only when USB is connected
   handleSWDLRebootScenarios();
   return true;
}


/********************************************
 NAME    : SWUpdate
 SYSFL    : null
****************************************************/
bool SWUpdate::onCourierMessage(const HandlePendingSWDLMsg& /* oMsg */)
{
   ETG_TRACE_COMP(("SWUpdate::HandlePendingSWDLMsg: _isSoftwareDownloadPending = %d", _isSoftwareDownloadPending));
   if (true == _isSoftwareDownloadPending)
   {
      // this if should only be execute if marker file is found
      // Sending ApplyDoc request to middleware via client. to continue the pending software download
      SWUpdateClient::GetInstance()->handleStartDownloadRequest();
   }
   return true;
}


/********************************************
* NAME    : SWUpdate - internal function containing logic to find and set the flags for Rebooting
* SYSFL    : SWFL-2164
****************************************************/
void SWUpdate::handleSWDLRebootScenarios()
{
   /* bool performReboot = false; */
   ETG_TRACE_COMP(("SWUpdate::handleSWDLRebootScenarios: _inMISUpdateMode = %d, _isDownloadInterrupted = %d, EXT_bIs_USB_Connected = %d, _isCMCUpdateNeeded = %d", _inMISUpdateMode, _isDownloadInterrupted, EXT_bIs_USB_Connected, _isCMCUpdateNeeded));
   if (_inMISUpdateMode)
   {
      // This branch is used for normal flow as well as to handle negative scenario on USB removal on SWDL update
      // in Case of USB removal on update. This method shall be called Twice.
      // During First call:: Prepare the pop text, and set the download interrupt flag to reboot the system on second call
      /* performReboot = true; */
      ETG_TRACE_USR1(("SWUpdate::handleSWDLRebootScenarios: _isUpdateSuccessful = %d, _isCMCUpdateNeeded = %d", _isUpdateSuccessful, _isCMCUpdateNeeded));
      ETG_TRACE_USR1(("SWUpdate::handleSWDLRebootScenarios: _isSameVersion = %d, _isQuickUpdate = %d", _isSameVersion, _isQuickUpdate));
      if (_isUpdateSuccessful)
      {
         if (_isCMCUpdateNeeded)
         {
            // To reboot the Head unit in Recovery mode for CMC update
            ETG_TRACE_USR3(("SWUpdate::handleSWDLRebootScenarios: _inMISUpdateMode = %d, _isUpdateSuccessful = %d, _isCMCUpdateNeeded = %d", _inMISUpdateMode, _isUpdateSuccessful, _isCMCUpdateNeeded));
            SWUpdateClient::GetInstance()->setAllowRecoveryModeRequest(true);
         }
         else if ((_isSameVersion == true) && (_isQuickUpdate == true))
         {
            ETG_TRACE_USR3(("Same version Quick Update. Reboot the target")); //Next Reboot request similar to Abort Reboot
            SWUpdateClient::GetInstance()->sendAbortRequest();
         }
      }
      if (!EXT_bIs_USB_Connected)
      {
         // NORMAL FLOW : bugfix 715210
         // In successful scenario, Middleware will be reboot IMX .
         // #ifndef VARIANT_S_FTR_ENABLE_UNITTEST
         //	 #endif
         // ERROR USE CASE: USB stick removed during update. Preparing system for reboot on User confirmation on USB removal popup
         // this flag should not be set anywhere else, this ensure that, the system reboot on
         // user confirmation of USB removal popup. (as we are in MIS Stage 1 mode.)
         _isDownloadInterrupted = true;
         ETG_TRACE_USR4(("SWUpdate::handleSWDLRebootScenarios:_isDownloadInterrupted = %d", _isDownloadInterrupted));
      }
      _inMISUpdateMode = false;
      _isSWUpdateTriggered = false;
      _isQuickUpdate = false;
      ETG_TRACE_USR1(("SWUpdate::handleSWDLRebootScenarios: _inMISUpdateMode = %d", _inMISUpdateMode));
   }
   else
   {
      if (_isDownloadInterrupted)
      {
         // ERROR USE CASE: SECOND CALL :: WE have user confirmation, Reboot System.
         //Spl Case : USB stick removed while in MIS Stage 1 update.
         ETG_TRACE_ERR(("SWUpdate::handleSWDLRebootScenarios: Resetting _isDownloadInterrupted flag & Triggering IMX reboot"));
         // Perform Reboot only when USB is connected when the popup is closed.
         // else wait for the USB removed popup to close to perform the reboot.
         _isDownloadInterrupted = false;
         // sending system reboot request similar to abort for Download interrupt.
         SWUpdateClient::GetInstance()->sendAbortRequest();
      }
   }
}


void SWUpdate::PoolForXMLFile()
{
   ETG_TRACE_COMP(("SWUpdate::PoolForXMLFile"));
   std::string threadName("XMLFileobserverThread");
   pthread_attr_t tattr;
   int retValAttr = -1;
   retValAttr = pthread_attr_init(&tattr);
   retValAttr = pthread_attr_setdetachstate(&tattr, PTHREAD_CREATE_DETACHED);
   int retVal = -1;
   if (retValAttr == 0)
   {
      // Create detached child thread to pool for XML file availablity - dont neet to join
      retVal = pthread_create(&observerThread, &tattr, TestForXMLAvailability, NULL);
   }
   if (retVal == 0)
   {
      ETG_TRACE_USR1(("SWUpdate::PoolForXMLFile: CREATED THREAD_ID = %d", observerThread));
      /*if (0 == retValAttr)
       {
          // to be used if thread is modified to Joinable thread - join thread only if is created sucessfuly
          // pthread_join(observerThread,NULL);
       }*/
   }
   else
   {
      ETG_TRACE_ERR(("SWUpdate PoolForXMLFile: creation FAILED: ERROR_ID = %d", retVal));
      _isSWUpdateTriggered = false;
   }
}


void* TestForXMLAvailability(void* /*msgptr*/)
{
   ETG_TRACE_COMP_THR(("SWUpdate::TestForXMLAvailability is called"));
   // There will 20 iteration(20 seconds intervals) for 6.5 min wait time
   // Run forloop for 20 times (6.666 mins time)with sleep interval of 20 seconds
   //   for each 20 sec check for file availability
   //     ignore first three iteration (60 secs) for XML clearance and Python interpreter
   //      if found,
   //          update found flag and break
   // Post Stop timer msg,
   // close the thread
   bool isFileAvailable = false;
   for (int iteration = 0; iteration < 21; iteration++)
   {
      // ignore first three iteration (60 secs) for XML clearance and Python interpreter
      if (iteration > 2)
      {
         isFileAvailable = XMLDocParser::GetInstance()->FetchUpdateResults();
         ETG_TRACE_USR2_THR(("SWUpdate::TestForXMLAvailability: iteration : %d, isFileAvailable = %d", iteration, isFileAvailable));
         if (isFileAvailable)
         {
            break;
         }
      }
      // Sleep the child thread for 20secs
      sleep(20);
   }
   if (isFileAvailable)
   {
      POST_MSG_NOTRACE((COURIER_MESSAGE_NEW(OnXMLAvailabilityExitBusyWaitMsg)()));
   }
   return NULL;
}


/********************************************
* NAME    : Retrieve Information From XML
* SYSFL    : SWFL-2547
****************************************************/
bool SWUpdate::RetrieveInformationFromXML()
{
   bool retVal = false;
   retVal = XMLDocParser::GetInstance()->FetchUpdateResults();
   ETG_TRACE_USR1(("SWUpdate::RetrieveInformationFromXML: retVal = %d", retVal));
   return retVal;
}


/********************************************

* NAME    : Retrieve Information From DTCXML
* SYSFL    : SWFL-2547
<!--Task 1012776 and CRQ 952224  -->
****************************************************/
bool SWUpdate::RetrieveInformationFromDTCXML()
{
   bool retVal = false;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   retVal = XMLDocParser::GetInstance()->FetchDtcXmlUpdateResults();
   ETG_TRACE_USR1(("bool SWUpdate::RetrieveInformationFromDTCXML retVal =%d", retVal));
#endif
   return retVal;
}


void SWUpdate::CreateMapAttrbValuetoTextId()
{
   ETG_TRACE_COMP(("SWUpdate::CreateMapAttrbValuetoTextId function is called"));
   MappedValue["CM-P"]              =         	Candera::String(TextId_0x1791);
   MappedValue["CM-G_1"]            =         	Candera::String(TextId_0x1792);
   MappedValue["Amplifier CM-A 19"] =         	Candera::String(TextId_0x1793);
   MappedValue["Router"]            =         	Candera::String(TextId_0x1794);
   MappedValue["Camera"]            =         	Candera::String(TextId_0x1795);
   MappedValue["Tuner"]             =         	Candera::String(TextId_0x1796);
   MappedValue["Panel"]             =         	Candera::String(TextId_0x1797);
}


/********************************************
* NAME   : ExtractInfo function is called when either System installation status or SWUpdate info is true
****************************************************/
tSharedPtrDataProvider SWUpdate::ExtractInfo()
{
   ETG_TRACE_COMP(("SWUpdate::getListDataProvider is called ExtractInfo()entry"));
   ETG_TRACE_USR1(("SWUpdate::setdeviceinfo()"));
   VehicleSrvClient::poGetInstance()->setdeviceinfo(1);
   bool isFileAvailable = false;
#if defined VARIANT_S_FTR_ENABLE_NAVIGATION

   (*_oSwVersionNodeSwitchItem).mToggleNodeIndex = DisableLIST_EnableBUSYWAIT;
   _oSwVersionNodeSwitchItem.MarkAllItemsModified();
   _oSwVersionNodeSwitchItem.SendUpdate(true);
   ETG_TRACE_COMP(("SWUpdate::ExtractInfo sm_isEntryfromSystemSettings = %d", sm_isEntryfromSystemSettings));
   //script is run only on every entry from SYSTEM MAIN LIST to SW VERSION LIST
   if (sm_isEntryfromSystemSettings == true)
   {
      ETG_TRACE_COMP(("SWUpdate::ExtractInfo sm_isEntryfromSystemSettings is true. Entry from system settings menu and call the script"));
      ::std::string subSystemScript = "/var/opt/bosch/persistent/avdecc/cisinstallation/doipcmcerrmem.py";
      ::std::string cmd = "python ";
      cmd.append(subSystemScript);
      bool script_status = system(cmd.c_str());
      ETG_TRACE_USR1(("SWUpdate::ExtractInfo script_status = %d", script_status));
      //script generally returns the status as success which is zero.
      if (script_status == SCRIPT_RUN_SUCCESS)
      {
         isFileAvailable = loadingxmldata();
         ETG_TRACE_USR1(("SWUpdate::ExtractInfo isFileAvailable = %d", isFileAvailable));
         if (!isFileAvailable)//Script generated and XML file is not available
         {
            ETG_TRACE_USR1(("SWUpdate::ExtractInfo script generated and XML file is not available"));
            POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Show, Courier::ViewId("AppHmi_System#SoftwareDownload#Pfo_SoftwareVersionFetchingError"))));
         }
         (*_oSwVersionNodeSwitchItem).mToggleNodeIndex = EnableLIST_DisableBUSYWAIT;
         _oSwVersionNodeSwitchItem.MarkAllItemsModified();
         _oSwVersionNodeSwitchItem.SendUpdate(true);
      }
      else //Script generation failed or script_status returned non zero value.
      {
         ETG_TRACE_COMP(("SWUpdate::ExtractInfo script generation failed."));
         (*_oSwVersionNodeSwitchItem).mToggleNodeIndex = EnableLIST_DisableBUSYWAIT;
         _oSwVersionNodeSwitchItem.MarkAllItemsModified();
         _oSwVersionNodeSwitchItem.SendUpdate(true);
         POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Show, Courier::ViewId("AppHmi_System#SoftwareDownload#Pfo_SoftwareVersionFetchingError"))));
      }
   }
   else // Re-Entry to SW Version menu during back button press from DTC Code Screen.
   {
      ETG_TRACE_COMP(("SWUpdate::ExtractInfo sm_isEntryfromSystemSettings is false. Entry from DTC code menu"));
      isFileAvailable = loadingxmldata();
   }
#endif
   string _currentSoftwareVersion = SWUpdateClient::GetInstance()->getCurrentSytemVersion();			//get the Center CM-C 19
   string _overallSoftwareVersion = SWUpdateClient::GetInstance()->getOverallSoftwareVersion();		//get the Customer Software Version
   //_SWversionValue = VehicleSrvClient::poGetInstance()->getSoftwareversionvalue();		//get the  Software Version value
   std::string _SWversionValueString = boost::lexical_cast<string>(_SWversionValue);
   ETG_TRACE_USR4(("tSharedPtrDataProvider SWUpdate::ExtractInfo()  _currentSoftwareVersion loaded==>%s", _currentSoftwareVersion.c_str()));
   ETG_TRACE_USR4(("tSharedPtrDataProvider SWUpdate::ExtractInfo() _overallSoftwareVersion %s", _overallSoftwareVersion.c_str()));
   ETG_TRACE_USR4(("tSharedPtrDataProvider SWUpdate::ExtractInfo() _dSWversionValueString %s", _SWversionValueString.c_str()));
   _SoftwareversionTextValue.clear();
   _SoftwareversionText.clear();

   if (_SWversionValue != INVALID_SOFTWAREVERSIONVALUE)
   {
      _SoftwareversionTextValue += _overallSoftwareVersion.c_str(), _currentSoftwareVersion.c_str(), _SWversionValueString.c_str();
      _SoftwareversionText += Candera::String(TextId_0x19CF), Candera::String(TextId_0x1791), Candera::String(TextId_0x1797);
   }
   else
   {
      _SoftwareversionTextValue += _overallSoftwareVersion.c_str(), _currentSoftwareVersion.c_str();
      _SoftwareversionText += Candera::String(TextId_0x19CF), Candera::String(TextId_0x1791);
   }
   ListDataProviderBuilder listBuilder(LIST_ID_SYSTEM_SWVERSION_CIS_LIST);
   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();
   for (int index = 0; index < _SoftwareversionText.size(); index++)
   {
      ETG_TRACE_USR3(("SWUpdate::ExtractInfo obtained index %d", index));
      ETG_TRACE_USR3(("SWUpdate::ExtractInfo obtained size %d", _SoftwareversionText.size()));
      ETG_TRACE_USR3(("SWUpdate::ExtractInfo obtained  index str %s", _SoftwareversionText[index]));
      ETG_TRACE_USR3(("SWUpdate::ExtractInfo obtained string str %s", _SoftwareversionTextValue[index]));
      listBuilder.AddItem(index, 0UL, DATA_CONTEXT_TEXT_SW_VERSIN_LIST_ITEM).AddData(_SoftwareversionText[index]).AddData(_SoftwareversionTextValue[index]);
   }
#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
   if (isFileAvailable == true)
#endif
   {
      uint32 updateResultSize = _CISstatusReportVec.size();
      ETG_TRACE_USR2(("SWUpdate::ExtractInfo: updateResultSize==>%d", updateResultSize));
      for (uint8 logval = 0; logval < updateResultSize; logval++)
      {
         ETG_TRACE_USR3(("SWUpdate::ExtractInfo obtained NAME str %s", _CISstatusReportVec[logval].nameStr.c_str()));
         ETG_TRACE_USR3(("tSharedPtrDataProvider SWUpdate::ExtractInfo Result str %s", _CISstatusReportVec[logval].resultStr.c_str()));
         listBuilder.AddItem(logval + _SoftwareversionText.size(), 0UL, "Text_SWVersion_CIS").AddData(_CISstatusReportVec[logval].nameStr.c_str()).AddData(_CISstatusReportVec[logval].resultStr.c_str());
      }
   }
#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
   (*_oSwVersionNodeSwitchItem).mToggleNodeIndex = EnableLIST_DisableBUSYWAIT;
   _oSwVersionNodeSwitchItem.MarkAllItemsModified();
   _oSwVersionNodeSwitchItem.SendUpdate(true);
   stopTimer4softwareversion();
#endif
   listcreated = true;
   dataProvider = listBuilder.CreateDataProvider();
   return dataProvider;
}


tSharedPtrDataProvider SWUpdate::getSerialandMACAddress()
{
   ETG_TRACE_COMP(("SWUpdate::getSerialandMACAddress is called"));
   bool isXMLFileAvailable = false;
   isXMLFileAvailable = XMLDocParser::GetInstance()->FetchUpdateResults();
   ETG_TRACE_USR1(("SWUpdate::getSerialandMACAddress isXMLFileAvailable = %d", isXMLFileAvailable));

   ListDataProviderBuilder listBuilder(LIST_ID_SETTINGS_SWUPDATE_UPDATE_INFO);
   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();

   if (isXMLFileAvailable)
   {
      _SerialandMACAddressReportVec = XMLDocParser::GetInstance()->GetSerialandMACAddress();
      uint32 updateResultSize = _SerialandMACAddressReportVec.size();
      uint8 FirstListItem = 0;
      ETG_TRACE_USR2(("SWUpdate::getSerialandMACAddress: updateResultSize==>%d", updateResultSize));
      listBuilder.AddItem(FirstListItem, 0UL, "Layer_Title");  //First list item with Text - CiSSubsystem, Serial number, MAC Address
      for (uint8 logval = 0; logval < updateResultSize; logval++)
      {
         ETG_TRACE_USR3(("SWUpdate::getSerialandMACAddress Name = %s", _SerialandMACAddressReportVec[logval].nameStr.c_str()));
         ETG_TRACE_USR3(("SWUpdate::getSerialandMACAddress SerialNumber str %s", _SerialandMACAddressReportVec[logval].serialnumberStr.c_str()));
         ETG_TRACE_USR3(("SWUpdate::getSerialandMACAddress MAC Address str %s", _SerialandMACAddressReportVec[logval].macAddressStr.c_str()));
         if (_SerialandMACAddressReportVec[logval].nameStr != "KDS")
         {
            ETG_TRACE_USR3(("SWUpdate::getSerialandMACAddress name is not KDS"));
            listBuilder.AddItem(logval + 1, 0UL, "Layer_Details")
            .AddData(_SerialandMACAddressReportVec[logval].nameStr.c_str())
            .AddData(_SerialandMACAddressReportVec[logval].serialnumberStr.c_str())
            .AddData(_SerialandMACAddressReportVec[logval].macAddressStr.c_str());
         }
      }
   }

   dataProvider = listBuilder.CreateDataProvider();
   return dataProvider;
}


void SWUpdate::sendMCPVersionUpdatetoGUI(uint32 swVervalue)
{
   _SWversionValue = swVervalue;
   //get the  Software Version value
   ETG_TRACE_USR1(("SWUpdate::SetBluetoothStatus: _SWversionValue = %d ", _SWversionValue));
   if (listcreated == true)
   {
      ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_SWVERSION_CIS_LIST);
   }
}


bool SWUpdate::onCourierMessage(const ListRefreshMsg&  oMsg)
{
   ETG_TRACE_COMP(("SWUpdate::ListRefreshMsg: List Id = %d", oMsg.GetListId()));
   if (LIST_ID_SYSTEM_SWVERSION_CIS_LIST == oMsg.GetListId())
   {
      _CISstatusReportVec.clear();
   }
   // ListRegistry::s_getInstance().updateList(oMsg.GetListId());
   return false;
}


bool SWUpdate::loadingxmldata()
{
   _isXMLfileAvailable = RetrieveInformationFromDTCXML();//Task 1012776 and CRQ 952224e
   ETG_TRACE_COMP(("SWUpdate::loadingxmldata _isXMLfileAvailable=%d", _isXMLfileAvailable));
   //Task 1012776 and CRQ 952224
   if (_isXMLfileAvailable)
   {
      _CISstatusReportVec = XMLDocParser::GetInstance()->GetCISResultUpdates();
   }
   else
   {
      bool status = false;
      status = XMLDocParser::GetInstance()->FetchInstalledDTCResult(); //returns true if data is fetched
      ETG_TRACE_USR1(("SWVersion:loadingxmldata: doipcmcinstallresult.xml status = %d", status));
      if (status)
      {
         _CISstatusReportVec = XMLDocParser::GetInstance()->GetCISResultUpdates();
      }
      return status ;
   }
   return _isXMLfileAvailable;
}


/********************************************
 NAME    : SWUpdateAbortRebootMsg - Trigger System Reebot after SWUpdate Aborted.
****************************************************/
bool SWUpdate::onCourierMessage(const SWUpdateAbortRebootMsg& /* oMsg */)
{
   ETG_TRACE_COMP(("SWUpdate::SWUpdateAbortRebootMsg"));
   //Send Abort request to SW Update Component
   //After receiving Abort response trigger LCM reboot
   SWUpdateClient::GetInstance()->sendAbortRequest();
   return true;
}


bool SWUpdate::checkxmlavailable()
{
   bool _isXMLAvailable = RetrieveInformationFromDTCXML();
   ETG_TRACE_COMP(("SWUpdate::checkxmlavailable _isXMLAvailable=%d", _isXMLAvailable));

   return _isXMLAvailable;
}


/******************************End of Testing Purpose *********************************************/

#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
/**********************************************************************************************
*FUNCTION:          isTimerRunning4swver
*DESCRIPTION:       Starts inactivity timer
*PARAMETER:         None
*RETURNVALUE:       None
*
*HISTORY:
*05.05.2020:Prashant BG

*0.1 Initial Revision.
**********************************************************************************************/
void SWUpdate::startTimer4softwareversion(void)
{
   ETG_TRACE_COMP(("SWUpdate::startTimer4softwareversion: isTimerRunning4swver =%d", isTimerRunning4swver));
   if (!isTimerRunning4swver)		//default value of isTimerRunning4swver is false
   {
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
      _swvertimer.start(*this, 1000, 10); // SWIVEL_DELAY=10 Second
      isTimerRunning4swver = true;
      ETG_TRACE_USR1(("SWUpdate::startTimer4softwareversion: isTimerRunning4swver = true"));
#endif
   }
}


/**********************************************************************************************
*FUNCTION:          stopTimer4softwareversion
*DESCRIPTION:       Stops inactivity timer
*PARAMETER:         None
*RETURNVALUE:       None
*
*HISTORY:
*05.05.2020:Prashant BG

*0.1 Initial Revision.
**********************************************************************************************/
void SWUpdate::stopTimer4softwareversion(void)
{
   ETG_TRACE_COMP(("SWUpdate::stopTimer4softwareversion: isTimerRunning4swver =%d", isTimerRunning4swver));
   if (isTimerRunning4swver)
   {
      _swvertimer.stop();
      isTimerRunning4swver = false;
   }
}


void SWUpdate::onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data)
{
   ETG_TRACE_COMP(("SWUpdate::onExpired is Expired first ==>%d ", isTimerRunning4swver));
//unique timer comparsion
   if (&timer == &_swvertimer)
   {
      ETG_TRACE_USR1(("SWUpdate::onExpired is Expired second %d ", isTimerRunning4swver));
      // call swivel door after time out here
      //on expiry of 10 min and isTimerRunning4swver is made to false
      if (data->getReason() == asf::core::TimerPayload_Reason__Completed)
      {
         isTimerRunning4swver = false;
         ETG_TRACE_USR2(("SWUpdate::onExpired: SystemSettingsListHandler Time completed 20seconds ==>%d", isTimerRunning4swver));
         (*_oSwVersionNodeSwitchItem).mToggleNodeIndex = EnableLIST_DisableBUSYWAIT;
         _oSwVersionNodeSwitchItem.MarkAllItemsModified();
         _oSwVersionNodeSwitchItem.SendUpdate(true);
         ETG_TRACE_USR2(("SWUpdate::onExpired: TimerNDAnim-Dis - List-En"));

         POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Show, Courier::ViewId("AppHmi_System#SoftwareDownload#Pfo_SoftwareVersionFetchingError"))));
         ETG_TRACE_USR2(("SWUpdate::onExpired: SystemSettingsListHandler Time completed 10 min "));
      }
   }
}


#endif
#endif
