/**************************************************************************************
* @file         : DTCInfoCodeStatus4AllSubSM.h
* @author       : Prashant BG
* @Date		 	: 23.01.2021
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (C) 2016 Robert Bosch GmbH
*                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef DTCINFO_CODESTATUS_4ALL_SUBSM_H
#define DTCINFO_CODESTATUS_4ALL_SUBSM_H


#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
#include "AppHmi_SystemTypes.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/CourierMessageMapper.h"

#include "System_Types.h"
#include <vector>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea
#include <map>
#include <boost/tuple/tuple.hpp>

using namespace std;

typedef struct
{
   string dtcCode;
   string dtcStatus;
} DTC;

typedef struct
{
   string subSystemName;
   vector<DTC> dtc;
} DTCInfo;


namespace App {
namespace Core {


class DTCInfoCodeStatus4AllSubSM :  public ListImplementation
{
   public:
      virtual ~DTCInfoCodeStatus4AllSubSM();
      DTCInfoCodeStatus4AllSubSM(const DTCInfoCodeStatus4AllSubSM&);
      DTCInfoCodeStatus4AllSubSM& operator =(const DTCInfoCodeStatus4AllSubSM&);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(DTCSubSystemCMC19SwDetailsMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      //Singleton class implementation
      static DTCInfoCodeStatus4AllSubSM* poGetInstance()
      {
         if (NULL == m_poDTCInfoCodeStatus4AllSubSM)
         {
            m_poDTCInfoCodeStatus4AllSubSM = new DTCInfoCodeStatus4AllSubSM();
         }
         return m_poDTCInfoCodeStatus4AllSubSM;
      }
      virtual bool onCourierMessage(const DTCSubSystemCMC19SwDetailsMsg& oMsg);
   private:
      DTCInfoCodeStatus4AllSubSM();
      static DTCInfoCodeStatus4AllSubSM* m_poDTCInfoCodeStatus4AllSubSM;
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getDtcCodeStatusListDataProvider();
      bool listcreated;
      uint8 getcurrentsubsystemrow();
      uint8 currentsubsystemrow;
      std::vector<DTCInfo> _GetDTCInfoVec;
      DataBindingItem<DTCHeadingUpdateItemDataBindingSource> oDTCHeadingUpdateItem;
};


}
}


#endif
