/**************************************************************************************
* @file         : DTCInfoCodeStatus4AllSubSM.cpp
* @author       : Prashant BG
* @Date		 	: 23.01.2021
* @addtogroup   : AppHmi_System
* @brief        : Updated changes for displaying date format.
* @copyright    : (C) 2019 Robert Bosch GmbH
*                 (C) 2019 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "gui_std_if.h"
#include <string>
#include "App/Core/AppLogic/SoftwareUpdate/SWUpdate.h"

#include "App/Core/Utils/XMLParser/XMLParser.h"
#include "DTCInfoCodeStatus4AllSubSM.h"
#include <cstdlib>
#include "hmi_trace_if.h"
#include "AppHmi_SystemStateMachine.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::DTCInfoCodeStatus4AllSubSM::
#include "trcGenProj/Header/DTCInfoCodeStatus4AllSubSM.cpp.trc.h"
#endif


#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
namespace App {
namespace Core {

DTCInfoCodeStatus4AllSubSM* DTCInfoCodeStatus4AllSubSM::m_poDTCInfoCodeStatus4AllSubSM = NULL;
static const char* const DATA_DTC_Available_UnAvailable_TEXT_ITEM = "DTC_Available_UnAvailable";
static const char* const DATA_DTC_CODE_STATUS_TEXT_ITEM = "DTCCodeStatus";

Candera::String DTC_AvailOrUnAvail[2] = {"DTC information", "No DTCs have been generated for this subsystem"};//{Candera::String(TextId_0x199A),Candera::String(TextId_0x199F)}; ////
Candera::String DTC_CodeOrStatus[2] = {"DTC code", "DTC status"}; //{Candera::String(TextId_0x19B), Candera::String(TextId_0x199D)}; ////
Candera::String DTC_SubSMHeading[4] = {"Amplifier CM-A 19", "CM-G-AVB", "CM-G_1", "CM-P "}; //0x199B -DTC code: 0x199C  %1 0x199D  DTC status: 0x199E  %1


/************************************************************************
*FUNCTION: 		 DTCInfoCodeStatus4AllSubSM - Constructor
*DESCRIPTION: 	 default constructor of the System setting Listhadler will be created
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*23.01.2021 Prashant BG

*0.1 Initial Revision.
************************************************************************/

DTCInfoCodeStatus4AllSubSM::DTCInfoCodeStatus4AllSubSM()
{
   ETG_TRACE_COMP(("DTCInfoCodeStatus4AllSubSM:: Constructor is called"));
   currentsubsystemrow = 0;
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SYSTEM_DTC_CODE_STATUS_LIST, this);
   listcreated = false;
}


/************************************************************************
*FUNCTION: 		 DTCInfoCodeStatus4AllSubSM - Destructor
*DESCRIPTION: 	 Allocated resources such as memory will be released here
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*23.01.2021 Prashant BG

*0.1 Initial Revision.
************************************************************************/

DTCInfoCodeStatus4AllSubSM::~DTCInfoCodeStatus4AllSubSM()
{
   ETG_TRACE_COMP(("DTCInfoCodeStatus4AllSubSM:: Destructor is called"));
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SYSTEM_DTC_CODE_STATUS_LIST);
}


/**********************************************************************************************
*FUNCTION: 		 DTCInfoCodeStatus4AllSubSM - getListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 oMsg - Courier message received
*RETURNVALUE: 	 tSharedPtrDataProvider()
*
*HISTORY:
* Prashant BG
* 01012021

*0.1 Initial Revision.
**********************************************************************************************/

tSharedPtrDataProvider DTCInfoCodeStatus4AllSubSM::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_COMP(("DTCInfoCodeStatus4AllSubSM::getListDataProvider: List Id = %d", oMsg.GetListId()));
   tSharedPtrDataProvider dataProvider;
   switch (oMsg.GetListId())
   {
      case LIST_ID_SYSTEM_DTC_CODE_STATUS_LIST: //Settings Time Zone Clock List items are requested
      {
         dataProvider = getDtcCodeStatusListDataProvider();
         ETG_TRACE_COMP(("DTCInfoCodeStatus4AllSubSM::getListDataProvider: List Id ==>152"));
         break;
      }
      default:
      {
         break;
      }
   }
   return dataProvider;
}


/**********************************************************************************************
*FUNCTION: 		 DTCInfoCodeStatus4AllSubSM - getDtcCodeStatusListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 null
*RETURNVALUE: 	tSharedPtrDataProvider
*
*HISTORY:
* Prashant BG
* 01012021

*0.1 Initial Revision.
**********************************************************************************************/
tSharedPtrDataProvider DTCInfoCodeStatus4AllSubSM::getDtcCodeStatusListDataProvider()
{
   ListDataProviderBuilder listBuilder(LIST_ID_SYSTEM_DTC_CODE_STATUS_LIST);

   uint8 CtSubSystemRow = getcurrentsubsystemrow();						// Get the Current Row of the Subsystem
   _GetDTCInfoVec.clear();
   _GetDTCInfoVec = XMLDocParser::GetInstance()->GetDTCInfo();
   ETG_TRACE_USR1(("DTCInfoCodeStatus4AllSubSM::getDtcCodeStatusListDataProvider: LIST_ID_SYSTEM_DTC_CODE_STATUS_LIST: CtSubSystemRow = %d, Is _GetDTCInfoVec empty = %d", CtSubSystemRow, _GetDTCInfoVec.empty()));
   if (!_GetDTCInfoVec.empty())
   {
      for (int logval = 0; logval < _GetDTCInfoVec.size(); logval++)				// Iterating the Number of Subsystem
      {
         if (CtSubSystemRow == (logval + 2))				// Comparing the Current Subsystem
         {
            (*oDTCHeadingUpdateItem).mDTCHeadingData = _GetDTCInfoVec[logval].subSystemName.c_str();										// Assigning the Heading
            ETG_TRACE_USR4(("DTCInfoCodeStatus4AllSubSM::getDtcCodeStatusListDataProvider: logval = %d, subSystemName = %s\n", logval, _GetDTCInfoVec[logval].subSystemName.c_str()));
            ETG_TRACE_USR4(("DTCInfoCodeStatus4AllSubSM::getDtcCodeStatusListDataProvider: Is _GetDTCInfoVec[logval].dtc.empty() = %d", _GetDTCInfoVec[logval].dtc.empty()));
            if (!_GetDTCInfoVec[logval].dtc.empty())			// Checking the Current Subsystem is Empty or Not
            {
               listBuilder.AddItem(dtc_availNotAvail, 0UL, DATA_DTC_Available_UnAvailable_TEXT_ITEM).AddData(DTC_AvailOrUnAvail[0]);				// Showing "DTC INFORMATION"
               for (int i = 0; i < _GetDTCInfoVec[logval].dtc.size(); i++)		// Iterating for the particular SubSystem
               {
                  ETG_TRACE_USR4(("DTCInfoCodeStatus4AllSubSM::getDtcCodeStatusListDataProvider: obtained dtc code str %s",	_GetDTCInfoVec[logval].dtc[i].dtcCode.c_str()));
                  ETG_TRACE_USR4(("DTCInfoCodeStatus4AllSubSM::getDtcCodeStatusListDataProvider: dtc status str %s", _GetDTCInfoVec[logval].dtc[i].dtcStatus.c_str()));
                  listBuilder.AddItem(i + 1, 0UL, "DTCCodeStatus").AddData(_GetDTCInfoVec[logval].dtc[i].dtcCode.c_str()).AddData(_GetDTCInfoVec[logval].dtc[i].dtcStatus.c_str());			// showing DTC Code and DTC Status
               }
            }
            else
            {
               listBuilder.AddItem(dtc_availNotAvail, 0UL, DATA_DTC_Available_UnAvailable_TEXT_ITEM).AddData(DTC_AvailOrUnAvail[1]);			//Showing  "No DTCs have been generated for this subsystem"
            }
         }
      }
   }
   oDTCHeadingUpdateItem.MarkAllItemsModified();
   oDTCHeadingUpdateItem.SendUpdate(true);
   listcreated = true;

   return listBuilder.CreateDataProvider();
}


bool DTCInfoCodeStatus4AllSubSM::onCourierMessage(const DTCSubSystemCMC19SwDetailsMsg& oMsg)
{
   currentsubsystemrow = oMsg.GetCurrentSubSystemType();
   ETG_TRACE_USR1(("DTCInfoCodeStatus4AllSubSM::DTCSubSystemCMC19SwDetailsMsg: currentsubsystemrow==>%d ", currentsubsystemrow));
   return true;
}


uint8 DTCInfoCodeStatus4AllSubSM::getcurrentsubsystemrow()
{
   ETG_TRACE_COMP(("DTCInfoCodeStatus4AllSubSM::getcurrentsubsystemrow: currentsubsystemrow=%d ", currentsubsystemrow));
   return currentsubsystemrow;
}


bool DTCInfoCodeStatus4AllSubSM::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   bool liststatus = false ;
   return liststatus;
}


}
}


#endif
