/**************************************************************************************
* @file         : AudioSettingListHandler.h
* @author       : Sheena Mathew
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef RVC_SETTINGS_LIST_HANDLER_H
#define RVC_SETTINGS_LIST_HANDLER_H


#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
//#include "AppHmi_SystemTypes.h"z
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"

#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "App/Core/ClientHandler/RVC/RearViewCamera.h"
#include "System_Types.h"
#include <vector>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea
#include <map>

#define VARIANT_S_FTR_ENABLE_COACH_FEATURE
#define VARIANT_S_FTR_ENABLE_SPEED_LIMIT

#define PLUS_SIGN   1
#define MINUS_SIGN -1
using namespace std;
namespace App {
namespace Core {
class RVCSettingListHandler :  public ListImplementation
{
   public:

      virtual ~RVCSettingListHandler();
      RVCSettingListHandler(const RVCSettingListHandler&);
      RVCSettingListHandler& operator =(const RVCSettingListHandler&);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(rvcEntryView)
      ON_COURIER_MESSAGE(rvcExitView)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
      //Singleton class implementation

      static RVCSettingListHandler* poGetInstance()
      {
         if (NULL == m_poRVCSettingListHandler)
         {
            m_poRVCSettingListHandler = new RVCSettingListHandler();
         }
         return m_poRVCSettingListHandler;
      }
      bool getRVCActivestatus();
   private:
      RVCSettingListHandler();
      static RVCSettingListHandler* m_poRVCSettingListHandler;
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getMainViewListDataProvider();
      bool _toggleStatus;
      bool listcreated;
      bool _inRVCUpdateMode;
      int audiovalues[6];

      int32_t m_propertytype ;
      string m_brightness;

      bool onCourierMessage(const rvcExitView& oMsg);
      bool onCourierMessage(const rvcEntryView& oMsg);
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);

      unsigned long index, AudioIndex;
};


}
}


#endif // SYSTEM_SETTINGS_LIST_HANDLER_H
