/**************************************************************************************
* @file         : AudioSettingListHandler.cpp
* @author       : Sheena Mathew
* @addtogroup   : AppHmi_System
* @brief        :
* @copyright    : (c) 2019-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "gui_std_if.h"
#include <string>
//#include "util/StrUtf8.h"
#include "RVCSettingListHandler.h"
//#include "App/Core/ClientHandler/Audio/AudioServiceClient.h"
#include <cstdlib>
#include "hmi_trace_if.h"

#include <vector>
#include <iterator>
#include <algorithm>
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                  App::DataModel::RVCSettingListHandler
#include "trcGenProj/Header/RVCSettingListHandler.cpp.trc.h"
#endif
//#define VARIANT_S_FTR_ENABLE_COACH_AUDIO
//#define VARIANT_S_FTR_ENABLE_AUX
//#define VARIANT_S_FTR_ENABLE_SPEED_LIMIT
//#define VARIANT_S_FTR_ENABLE_NAVIGATION

using namespace ::rvc_cca_fi;
using namespace ::rvc_cca_fi_types;
using namespace ::App::Core;

namespace App {
namespace Core {

RVCSettingListHandler* RVCSettingListHandler::m_poRVCSettingListHandler = NULL;


static const char* const DATA_CONTEXT_TEXT_BUTTON_LIST_ITEM = "TextButton_ListItem";
static const char* const DATA_CONTEXT_TEXT_BUTTON_LIST_ITEM_1 = "TextButton_ListItem_1";
static const char* const DATA_CONTEXT_COMBOBOX_LIST_ITEM = "Combobox_ListItem";
static const char* const DATA_CONTEXT_TEXT_LIST_ITEM = "Layer_Sound";


static const char* const DATA_CONTEXT_TEXT_BUTTON_TOGGLE_LIST_ITEM = "Layer_Checkbox";
Candera::String   RVCSettingText[3] = {Candera::String(TextId_0x0596), Candera::String(TextId_0x0597), Candera::String(TextId_0x0A7B)}; //"Brightness", "Contrast", "Guide Lines"
#define COLUMN_BUTTON_MINUS 1
#define COLUMN_BUTTON_PLUS  2


/************************************************************************
*FUNCTION: 		 RVCSettingListHandler - Constructor
*DESCRIPTION: 	 default constructor of the System setting Listhadler will be created
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*27.3.2018:Sheena Mathew

*0.1 Initial Revision.
************************************************************************/

RVCSettingListHandler::RVCSettingListHandler()
{
   ETG_TRACE_USR4(("RVCSettingListHandler:: Constructor is called"));

   ListRegistry::s_getInstance().addListImplementation(LIST_ID_RVC_LIST, this);
   index = 0;
   AudioIndex = 0;
   m_propertytype = 0;
   _toggleStatus = false;
   listcreated = false;
   _inRVCUpdateMode = false;
// m_ListtypetoAudSpecVolUpd[0]=AudioServiceClient::poGetInstance()->getCurrentBassValueOnPowerRetain();
   //ETG_TRACE_USR4(("RVCSettingListHandler::m_ListtypetoAudSpecVolUpd[0]=%d",m_ListtypetoAudSpecVolUpd[0]));
}


/************************************************************************
*FUNCTION: 		 RVCSettingListHandler - Destructor
*DESCRIPTION: 	 Allocated resources such as memory will be released here
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*27.3.2018:Sheena Mathew

*0.1 Initial Revision.
************************************************************************/

RVCSettingListHandler::~RVCSettingListHandler()
{
   ETG_TRACE_USR4(("RVCSettingListHandler:: Destructor is called"));
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_RVC_LIST);
   listcreated = false;
}


/**********************************************************************************************
*FUNCTION: 		 RVCSettingListHandler - getListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 oMsg - Courier message received
*RETURNVALUE: 	 tSharedPtrDataProvider()
*
*HISTORY:
*27.3.2018:Sheena Mathew

*0.1 Initial Revision.
**********************************************************************************************/

tSharedPtrDataProvider RVCSettingListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_USR4(("RVCSettingListHandler:: getListDataProvider"));
   switch (oMsg.GetListId())
   {
      case LIST_ID_RVC_LIST:
         ETG_TRACE_USR4(("RVCSettingListHandler:: RVC setting Main view list id 508"));
         return getMainViewListDataProvider();
   }
   return tSharedPtrDataProvider();
}


tSharedPtrDataProvider RVCSettingListHandler::getMainViewListDataProvider()
{
   ListDataProviderBuilder listBuilder(LIST_ID_RVC_LIST);

   listBuilder.AddItem(
      BRIGHTNESS, 	//  - identifies the row
      0UL,   //  - column
      DATA_CONTEXT_TEXT_BUTTON_LIST_ITEM)  //  - overwrites the default data context
   .AddData(RVCSettingText[0]);//1 - Text of the button
   ETG_TRACE_USR4(("RVCSettingListHandler:: getMainViewListDataProvider AFTER is called=%s", RVCSettingText[0]));

   listBuilder.AddItem(
      CONTRAST, 	//  - identifies the row
      0UL,   //  - column
      DATA_CONTEXT_TEXT_BUTTON_LIST_ITEM_1)  //  - overwrites the default data context
   .AddData(RVCSettingText[1]);//1 - Text of the button, should be obtained from Candera.
   ETG_TRACE_USR4(("RVCSettingListHandler:: getMainViewListDataProvider AFTER is called=%s", RVCSettingText[1]));

   /*listBuilder.AddItem(
      GUIDELINES, 	//  - identifies the row
      0UL,   //  - column
      DATA_CONTEXT_TEXT_BUTTON_TOGGLE_LIST_ITEM)  //  - overwrites the default data context
   .AddData(RVCSettingText[2])//1 - Text of the button, should be obtained from Candera.
   .AddData(_toggleStatus);//2 - Toggle On/Off
   ETG_TRACE_USR4(("RVCSettingListHandler:: getMainViewListDataProvider AFTER is called=%s", RVCSettingText[2]));*/

   listcreated = true;
   return listBuilder.CreateDataProvider();
}


bool RVCSettingListHandler::onCourierMessage(const rvcExitView& oMsg)
{
   _inRVCUpdateMode = false;
   ETG_TRACE_USR4(("RVCSettingListHandler::in rvcExitView  _inRVCUpdateMode  =%d\n", _inRVCUpdateMode));
   return true;
}


bool RVCSettingListHandler::onCourierMessage(const rvcEntryView& oMsg)
{
   _inRVCUpdateMode = true;
   ETG_TRACE_USR4(("RVCSettingListHandler::in rvcEntryView _inRVCUpdateMode  =%d\n", _inRVCUpdateMode));
   return true;
}


bool RVCSettingListHandler::getRVCActivestatus()
{
   return _inRVCUpdateMode;
   ETG_TRACE_USR4(("RVCSettingListHandler::in getRVCActivestatus _inRVCUpdateMode  =%d\n", _inRVCUpdateMode));
}


bool RVCSettingListHandler::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   ETG_TRACE_USR4(("RVCSettingListHandler::in ButtonListItemUpdMsg\n"));
   ListDataProviderBuilder modifiedListItems(LIST_ID_RVC_LIST);
   ETG_TRACE_USR4(("RVCSettingListHandler::in ButtonListItemUpdMsg ROW VALUE =%d\n", oMsg.GetHdl()));
   ETG_TRACE_USR4(("RVCSettingListHandler::in ButtonListItemUpdMsg column VALUE =%d\n", oMsg.GetSubHdl()))

   bool msgProcessed = false;
   unsigned int rowIdx = (unsigned int)oMsg.GetHdl(); //Check For the Row Clicked

   if (oMsg.GetListId() == LIST_ID_RVC_LIST)
   {
      if (oMsg.GetReaction() == enRelease)
      {
         if (rowIdx == GUIDELINES)
         {
            ETG_TRACE_USR4(("RVCSettingListHandler::in ButtonListItemUpdMsg inside the case condition"));
            //m_propertytype = 21;
            _toggleStatus = !_toggleStatus;

            // AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(m_propertytype, _toggleStatus);    // Create a ListDataProviderUpdater using ListDataProviderBuilder and post it with a ListDataProviderUpdMsg.
         }
         msgProcessed = true;
         ETG_TRACE_USR4(("RVCSettingListHandler:: msgProcessed 111111=%d", msgProcessed));
      }
   }

   if (listcreated == true)
   {
      ListRegistry::s_getInstance().updateList(LIST_ID_RVC_LIST);
   }
   ETG_TRACE_USR4(("RVCSettingListHandler:: msgProcessed 22222=%d", msgProcessed));
   return msgProcessed;
}


}
}
