/***************************************************************************
* Copyright(c) 2019-2019 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/* ***************************************************************************************
* FILE:AudioPrivateModeRBtn.h
* SW-COMPONENT:  Audio Speed Dependent Volume Control Component
* DESCRIPTION:  AudioPrivateModeRBtn.h is part of Audio Setting reference/demo/test applications
* Author 	: PGA5COB (Prashant BG)
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef RVC_CONTRAST_HANDLER_H
#define RVC_CONTRAST_HANDLER_H
#include "AppHmi_SystemStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_SystemMessages.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"
#include "App/Core/ClientHandler/RVC/RearViewCamera.h"
#include <string>

namespace App {
namespace Core {

class RVCContrastHandler:  public ListImplementation
{
   private:
      RVCContrastHandler();

   public:

      static RVCContrastHandler* m_poRVCContrastHandler;
      int contrasttype;
      std::string m_contrast;
      bool listcreated;
      int contrasttypesign;
      uint8 m_ListtypetoRVCSpecConUpd;

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)

      //  ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()

      COURIER_MSG_MAP_ENDS()

      static RVCContrastHandler* poGetInstance()
      {
         if (NULL == m_poRVCContrastHandler)
         {
            m_poRVCContrastHandler = new RVCContrastHandler();
         }
         return m_poRVCContrastHandler;
      }

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getMainViewListDataProvider();
      virtual ~RVCContrastHandler();
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      void vRVCSettingContrastIncdecval(int type);
      void onUpdateMenu(int updatedval);

//	  bool onCourierMessage(const Courier::StartupMsg& oMsg);

      bool Init();
      int type;
      unsigned long index;
      DataBindingItem<RVCContrastUpdateItemDataBindingSource> _RVCContrastUpdateItem;
      void RVCCSetupVideoUpdateResult4mMW(bool BrightNdContSetupVideoUpdateresult);
};


}
}


#endif // _HMI_MODEL_COMPONENT_H*/
