/* ***************************************************************************************
* FILE:          AudioSpdDepdentVolCntrlRBtn.cpp
* SW-COMPONENT:  Audio Speed Dependent Volume Control Component
*  DESCRIPTION:  AudioSpdDepdentVolCntrlRBtn.cpp is part of Audio Setting reference/demo/test applications
* Author 	: PGA5COB (Prashant BG)
*    COPYRIGHT:  (c) 2019-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

//#include "AppUtils/StrUtf8.h"
#include "AppHmi_SystemStateMachine.h"
#include "App/Core/ClientHandler/Audio/AudioServiceClient.h"
#include "RVCContrastHandler.h"
#include "App/datapool/SystemDataPoolConfig.h"
#include "hmi_trace_if.h"
#include<iostream>
#include <string>
#include <cstdlib>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::DataModel::RVCContrastHandler
#include "trcGenProj/Header/RVCContrastHandler.cpp.trc.h"
#endif
using namespace std;

namespace App {
namespace Core {

#define COLUMN_BUTTON_MINUS 1
#define COLUMN_BUTTON_PLUS  2
const char* LISTITEMTEMPLATE_CON = "listTplate_BtnBassBar";

RVCContrastHandler* RVCContrastHandler::m_poRVCContrastHandler = NULL;
RVCContrastHandler::RVCContrastHandler()
{
   ETG_TRACE_USR4(("RVCContrastHandler"));
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_RVC_CONTRAST, this);
   contrasttype = COLUMN_BUTTON_PLUS;
   contrasttypesign = 0;
   m_ListtypetoRVCSpecConUpd = 5;
   listcreated = false;
   type = 0;
   index = 0;
   uint8 dp_rcvcontrast = 0;
   dp_rcvcontrast = SystemDataPoolConfig::getInstance()-> getRVCContrastValue() ;
   ETG_TRACE_USR4(("RVCContrastHandler datapool dp_rcvcontrast %d", dp_rcvcontrast));
   onUpdateMenu(dp_rcvcontrast);
}


RVCContrastHandler::~RVCContrastHandler()
{
   ETG_TRACE_USR4(("~RVCContrastHandler"));
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_RVC_CONTRAST);
   listcreated = false;
}


tSharedPtrDataProvider RVCContrastHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_USR4(("RVCContrastHandler:: getListDataProvider"));
   switch (oMsg.GetListId())
   {
      case LIST_ID_RVC_CONTRAST:
         ETG_TRACE_USR4(("RVCContrastHandler:: System setting Main view list id 108"));
         return getMainViewListDataProvider();
   }
   return tSharedPtrDataProvider();
}


tSharedPtrDataProvider RVCContrastHandler::getMainViewListDataProvider()
{
   ListDataProviderBuilder listBuilder(LIST_ID_RVC_CONTRAST);
   int updatedval;
   index = 0;
   updatedval = m_ListtypetoRVCSpecConUpd;
   stringstream bout;
   bout << updatedval ;
   m_contrast = bout.str();
   (*_RVCContrastUpdateItem).mRVCContrastIndex = m_contrast.c_str();

   _RVCContrastUpdateItem.MarkAllItemsModified();
   _RVCContrastUpdateItem.SendUpdate(true);

   listBuilder.AddItem(static_cast<int>(index), 0UL, LISTITEMTEMPLATE_CON)
   .AddId(index, COLUMN_BUTTON_MINUS)     // -
   .AddId(index, COLUMN_BUTTON_PLUS)// +
   .AddDataBindingUpdater<RVCContrastUpdateItemDataBindingSource>(_RVCContrastUpdateItem);

   listcreated = true;
   return listBuilder.CreateDataProvider();
}


bool RVCContrastHandler::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   ETG_TRACE_USR4(("RVCContrastHandler::in ButtonListItemUpdMsg\n"));
   ListDataProviderBuilder modifiedListItems(LIST_ID_RVC_CONTRAST);
   ETG_TRACE_USR4(("RVCContrastHandler::in ButtonListItemUpdMsg ROW VALUE =%d\n", oMsg.GetHdl()));
   ETG_TRACE_USR4(("RVCContrastHandler::in ButtonListItemUpdMsg column VALUE =%d\n", oMsg.GetSubHdl()))

   bool msgProcessed = false;

   if ((oMsg.GetListId() == LIST_ID_RVC_CONTRAST) && (oMsg.GetReaction() == enRelease)  && (0 == oMsg.GetHdl()))
   {
      type = oMsg.GetSubHdl();
      vRVCSettingContrastIncdecval(type);
      ETG_TRACE_USR4(("RVCContrastHandler::in ButtonListItemUpdMsg,_vBrightnessValue=%d", m_ListtypetoRVCSpecConUpd));
      msgProcessed = true;
   }

   return msgProcessed;
}


void RVCContrastHandler::vRVCSettingContrastIncdecval(int type)
{
   ETG_TRACE_USR4(("RVCContrastHandler::vRVCSettingContrastIncdecval is called"));
   ETG_TRACE_USR4(("RVCContrastHandler::vRVCSettingContrastIncdecval,val=%d", m_ListtypetoRVCSpecConUpd));
   if ((type == COLUMN_BUTTON_PLUS) && (m_ListtypetoRVCSpecConUpd < 20))
   {
      m_ListtypetoRVCSpecConUpd++;
      ETG_TRACE_USR4(("RVCContrastHandler::vDisplaySettingBrightnessIncdecval::COLUMN_BUTTON_PLUS,val=%d", m_ListtypetoRVCSpecConUpd));
   }
   else if ((type == COLUMN_BUTTON_MINUS) && (m_ListtypetoRVCSpecConUpd > 0))
   {
      m_ListtypetoRVCSpecConUpd--;
      ETG_TRACE_USR4(("RVCContrastHandler::vDisplaySettingBrightnessIncdecval::  COLUMN_BUTTON_MINUS,val=%d", m_ListtypetoRVCSpecConUpd));
   }

   RearViewCamera::poGetInstance()->sendSetupVideo((rvc_cca_fi_types::T_e8_RVC_VideoParameterType)1, m_ListtypetoRVCSpecConUpd);
}


void RVCContrastHandler::RVCCSetupVideoUpdateResult4mMW(bool BrightNdContSetupVideoUpdateresult)
{
   ETG_TRACE_USR4(("RVCContrastHandler::RVCCSetupVideoUpdateResult4mMW value and status =%d %d", m_ListtypetoRVCSpecConUpd, BrightNdContSetupVideoUpdateresult));

   if (BrightNdContSetupVideoUpdateresult == true)
   {
      ETG_TRACE_USR4(("RVCContrastHandler::RVCCSetupVideoUpdateResult4mMW value and status--IF=%d %d", m_ListtypetoRVCSpecConUpd, BrightNdContSetupVideoUpdateresult));
      ETG_TRACE_USR4(("RVCContrastHandler::RVCCSetupVideoUpdateResult4mMW Sending value to client handler--IF"));
      onUpdateMenu(m_ListtypetoRVCSpecConUpd);
      SystemDataPoolConfig::getInstance()->setRVCContrastValue(m_ListtypetoRVCSpecConUpd) ;

      /*verifying the datapool*/
      uint8 dp_contrast_check = SystemDataPoolConfig::getInstance()-> getRVCContrastValue() ;
      ETG_TRACE_USR4(("RVCContrastHandler::RVCCSetupVideoUpdateResult4mMW  Sending value to client handler--IF = %d %d", dp_contrast_check, m_ListtypetoRVCSpecConUpd));
   }
   else
   {
      ETG_TRACE_USR4(("RVCContrastHandler::RVCCSetupVideoUpdateResult4mMW Sending value to client handler--ELSE"));
   }
}


//Update the contrast value TO HMI GUI
void RVCContrastHandler::onUpdateMenu(int updatedval)
{
   int Contrastvalue = 0;
   if ((updatedval >= 0)  && (updatedval <= 19))
   {
      m_ListtypetoRVCSpecConUpd = static_cast<uint8>(updatedval);
      Contrastvalue = updatedval;
      ETG_TRACE_USR4(("RVCContrastHandler::in Contrastvalue=%d", Contrastvalue));
      ETG_TRACE_USR4(("RVCContrastHandler::in m_ListtypetoRVCSpecConUpd=%d", m_ListtypetoRVCSpecConUpd));
      ETG_TRACE_USR4(("RVCContrastHandler::in updatedval=%d", updatedval));
   }
   stringstream bout;
   bout << Contrastvalue ;
   m_contrast = bout.str();
   (*_RVCContrastUpdateItem).mRVCContrastIndex = m_contrast.c_str();

   _RVCContrastUpdateItem.MarkAllItemsModified();
   _RVCContrastUpdateItem.SendUpdate(true);
   ETG_TRACE_USR4(("RVCContrastHandler::in updatedval= %d ", updatedval));
   ETG_TRACE_USR4(("RVCContrastHandler::in onUpdateMenu=%d", Contrastvalue));
   ETG_TRACE_USR4(("RVCContrastHandler::in onUpdateMenu,(*_dispSettingvalueUpdateItem).mDispLevelIndex=%s", m_contrast.c_str()));
   if (listcreated == true)
   {
      ETG_TRACE_USR4(("RVCContrastHandler::listcreated %d", listcreated));
      ListRegistry::s_getInstance().updateList(LIST_ID_RVC_CONTRAST);
   }
}


/*-----------------------------------------------------------------------------------*/
}


}
