/* ***************************************************************************************
* FILE:          AudioSpdDepdentVolCntrlRBtn.cpp
* SW-COMPONENT:  Audio Speed Dependent Volume Control Component
*  DESCRIPTION:  AudioSpdDepdentVolCntrlRBtn.cpp is part of Audio Setting reference/demo/test applications
* Author 	: PGA5COB (Prashant BG)
*    COPYRIGHT:  (c) 2019-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

//#include "AppUtils/StrUtf8.h"
#include "AppHmi_SystemStateMachine.h"
#include "App/Core/ClientHandler/RVC/RearViewCamera.h"
#include "RVCBrightnessHandler.h"
#include "App/datapool/SystemDataPoolConfig.h"
#include "hmi_trace_if.h"
#include<iostream>
#include <string>
#include <cstdlib>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::DataModel::RVCBrightnessHandler
#include "trcGenProj/Header/RVCBrightnessHandler.cpp.trc.h"
#endif


using namespace std;
namespace App {
namespace Core {
#define COLUMN_BUTTON_MINUS 1
#define COLUMN_BUTTON_PLUS  2
const char* LISTITEMTEMPLATE_RVC = "listTplate_BtnBassBar";

RVCBrightnessHandler* RVCBrightnessHandler::m_poRVCBrightnessHandler = NULL;
RVCBrightnessHandler::RVCBrightnessHandler()
{
   ETG_TRACE_USR4(("RVCBrightnessHandler"));
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_RVC_BRIGHTNESS, this);
   brightnesstype = COLUMN_BUTTON_PLUS;
   brightnesstypesign = 0;
   m_ListtypetoRVCSpecBgtUpd = 5;
   index = 0;
   type = 0;
   listcreated = false;
   uint8 dp_rcvbrightness = 0;

   dp_rcvbrightness = SystemDataPoolConfig::getInstance()-> getRVCBrightnessValue() ;
   ETG_TRACE_USR4(("RVCBrightnessHandler datapool dp_rcvbrightness %d", dp_rcvbrightness));
   onUpdateMenu(dp_rcvbrightness);
}


RVCBrightnessHandler::~RVCBrightnessHandler()
{
   ETG_TRACE_USR4(("~RVCBrightnessHandler"));
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_RVC_BRIGHTNESS);
   listcreated = false;
}


tSharedPtrDataProvider RVCBrightnessHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_USR4(("RVCBrightnessHandler:: getListDataProvider"));
   switch (oMsg.GetListId())
   {
      case LIST_ID_RVC_BRIGHTNESS:
         ETG_TRACE_USR4(("RVCBrightnessHandler:: System setting Main view list id 108"));
         return getMainViewListDataProvider();
   }
   return tSharedPtrDataProvider();
}


tSharedPtrDataProvider RVCBrightnessHandler::getMainViewListDataProvider()
{
   ListDataProviderBuilder listBuilder(LIST_ID_RVC_BRIGHTNESS);
   /* int updatedval;
    index = 0;
   // updatedval = m_ListtypetoRVCSpecBgtUpd;
    stringstream bout;
    bout << updatedval ;
    m_brightness = bout.str();
    (*_RVCBrightnessUpdateItem).mRVCBrightnessIndex = m_brightness.c_str();

    _RVCBrightnessUpdateItem.MarkAllItemsModified();
    _RVCBrightnessUpdateItem.SendUpdate(true);*/

   listBuilder.AddItem(static_cast<int>(index), 0UL, LISTITEMTEMPLATE_RVC)
   .AddId(index, COLUMN_BUTTON_MINUS)     // -
   .AddId(index, COLUMN_BUTTON_PLUS)// +
   .AddDataBindingUpdater<RVCBrightnessUpdateItemDataBindingSource>(_RVCBrightnessUpdateItem);

   ETG_TRACE_USR4(("RVCBrightnessHandler:: getMainViewListDataProvider m_ListtypetoRVCSpecBgtUpd %d ", m_ListtypetoRVCSpecBgtUpd));

   listcreated = true;
   return listBuilder.CreateDataProvider();
}


bool RVCBrightnessHandler::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   ETG_TRACE_USR4(("RVCBrightnessHandler::in ButtonListItemUpdMsg\n"));
   ListDataProviderBuilder modifiedListItems(LIST_ID_RVC_BRIGHTNESS);
   ETG_TRACE_USR4(("RVCBrightnessHandler::in ButtonListItemUpdMsg ROW VALUE =%d\n", oMsg.GetHdl()));
   ETG_TRACE_USR4(("RVCBrightnessHandler::in ButtonListItemUpdMsg column VALUE =%d\n", oMsg.GetSubHdl()))

   bool msgProcessed = false;

   if ((oMsg.GetListId() == LIST_ID_RVC_BRIGHTNESS) && (oMsg.GetReaction() == enRelease)  && (0 == oMsg.GetHdl()))
   {
      type = oMsg.GetSubHdl();
      vRVCSettingBrightnessIncdecval(type);
      ETG_TRACE_USR4(("RVCBrightnessHandler::in ButtonListItemUpdMsg,_vBrightnessValue=%d", m_ListtypetoRVCSpecBgtUpd));
      msgProcessed = true;
   }

   /* if ((listUpdateNeeded) && (rowIdx <= 0))
   {
   	ETG_TRACE_USR4(("DisplaySettings::in ButtonListItemUpdMsg,rowIdx=%d", rowIdx));
     	ETG_TRACE_USR4(("DisplaySettings::in ButtonListItemUpdMsg----BEFORE =%s ",((*_dispSettingvalueUpdateItem).mDispLevelIndex)));

   	listUpdateNeeded = false;
   } */

   return msgProcessed;
}


void RVCBrightnessHandler::vRVCSettingBrightnessIncdecval(int type)
{
   ETG_TRACE_USR4(("RVCBrightnessHandler::vRVCSettingBrightnessIncdecval is called"));
   ETG_TRACE_USR4(("RVCBrightnessHandler::vRVCSettingBrightnessIncdecval,val=%d", m_ListtypetoRVCSpecBgtUpd));
   if ((type == COLUMN_BUTTON_PLUS) && (m_ListtypetoRVCSpecBgtUpd < 20))
   {
      m_ListtypetoRVCSpecBgtUpd++;
      ETG_TRACE_USR4(("RVCBrightnessHandler::vRVCSettingBrightnessIncdecval::COLUMN_BUTTON_PLUS,val=%d", m_ListtypetoRVCSpecBgtUpd));
   }
   else if ((type == COLUMN_BUTTON_MINUS) && (m_ListtypetoRVCSpecBgtUpd > 0))
   {
      m_ListtypetoRVCSpecBgtUpd--;
      ETG_TRACE_USR4(("RVCBrightnessHandler::vRVCSettingBrightnessIncdecval::  COLUMN_BUTTON_MINUS,val=%d", m_ListtypetoRVCSpecBgtUpd));
   }

   RearViewCamera::poGetInstance()->sendSetupVideo((rvc_cca_fi_types::T_e8_RVC_VideoParameterType)0, m_ListtypetoRVCSpecBgtUpd);
   /*testing purpose

   void RVCBrightnessHandler::RVCBSetupVideoUpdateResult4mMW(bool BrightNdContSetupVideoUpdateresult)
   {
   ETG_TRACE_USR4(("RVCBrightnessHandler::RVCBSetupVideoUpdateResult4mMW value and status =%d %d", m_ListtypetoRVCSpecBgtUpd, BrightNdContSetupVideoUpdateresult));

   if (BrightNdContSetupVideoUpdateresult)
   {
      ETG_TRACE_USR4(("RVCBrightnessHandler::RVCBSetupVideoUpdateResult4mMW  Sending value to client handler--IF=%d %d", m_ListtypetoRVCSpecBgtUpd, BrightNdContSetupVideoUpdateresult));
         onUpdateMenu(m_ListtypetoRVCSpecBgtUpd);
         SystemDataPoolConfig::getInstance()->setRVCBrightnessValue(m_ListtypetoRVCSpecBgtUpd) ;
   uint8  dp_rcvbrightness = SystemDataPoolConfig::getInstance()-> getRVCBrightnessValue() ;
      ETG_TRACE_USR4(("RVCBrightnessHandler datapool dp_rcvbrightness %d %d", dp_rcvbrightness,m_ListtypetoRVCSpecBgtUpd));*/
}


void RVCBrightnessHandler::RVCBSetupVideoUpdateResult4mMW(bool BrightNdContSetupVideoUpdateresult)
{
   ETG_TRACE_USR4(("RVCBrightnessHandler::RVCBSetupVideoUpdateResult4mMW value and status =%d %d", m_ListtypetoRVCSpecBgtUpd, BrightNdContSetupVideoUpdateresult));

   if (BrightNdContSetupVideoUpdateresult)
   {
      ETG_TRACE_USR4(("RVCBrightnessHandler::RVCBSetupVideoUpdateResult4mMW client handler--IF=%d %d", m_ListtypetoRVCSpecBgtUpd, BrightNdContSetupVideoUpdateresult));
      onUpdateMenu(m_ListtypetoRVCSpecBgtUpd);
      SystemDataPoolConfig::getInstance()->setRVCBrightnessValue(m_ListtypetoRVCSpecBgtUpd) ;

      /*verifying the datapool*/
      uint8 dp_rcvbrightness_check = SystemDataPoolConfig::getInstance()-> getRVCBrightnessValue() ;
      ETG_TRACE_USR4(("RVCBrightnessHandler::RVCBSetupVideoUpdateResult4mMW client handler--IF = %d %d", m_ListtypetoRVCSpecBgtUpd , dp_rcvbrightness_check));
   }
   else
   {
      ETG_TRACE_USR4(("RVCBrightnessHandler::RVCBSetupVideoUpdateResult4mMW  Sending value to client handler--ELSE"));
   }
}


//Update the BRIGHTNESS value TO HMI GUI
void RVCBrightnessHandler::onUpdateMenu(int updatedval)
{
   int Brightnessvalue = 0;
   if ((updatedval >= 0) && (updatedval <= 20))
   {
      m_ListtypetoRVCSpecBgtUpd = static_cast<uint8>(updatedval);
      Brightnessvalue = updatedval;
      ETG_TRACE_USR4(("RVCBrightnessHandler::in Brightnessvalue=%d", Brightnessvalue));
      ETG_TRACE_USR4(("RVCBrightnessHandler::in m_ListtypetoRVCSpecBgtUpd=%d", m_ListtypetoRVCSpecBgtUpd));
      ETG_TRACE_USR4(("RVCBrightnessHandler::in updatedval=%d", updatedval));
   }
   stringstream bout;
   bout << Brightnessvalue ;
   m_brightness = bout.str();
   (*_RVCBrightnessUpdateItem).mRVCBrightnessIndex = m_brightness.c_str();

   _RVCBrightnessUpdateItem.MarkAllItemsModified();
   _RVCBrightnessUpdateItem.SendUpdate(true);
   ETG_TRACE_USR4(("RVCBrightnessHandler::in updatedval=%d", updatedval));
   ETG_TRACE_USR4(("RVCBrightnessHandler::in onUpdateMenu=%d", Brightnessvalue));
   ETG_TRACE_USR4(("RVCBrightnessHandler::in onUpdateMenu,(*_dispSettingvalueUpdateItem).mDispLevelIndex=%s", m_brightness.c_str()));
   if (listcreated == true)
   {
      ETG_TRACE_USR4(("RVCBrightnessHandler::listcreated %d", listcreated));
      ListRegistry::s_getInstance().updateList(LIST_ID_RVC_BRIGHTNESS);
   }
}


}
}
