/**************************************************************************************
* @file         : OEMmenu.h
* @author       : Sriganesh
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef OEMMENU_H
#define OEMMENU_H


#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"
#include "App/Core/ClientHandler/Diagnosis/MIDWDiagnosis.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "OEMPinAuthentication.h"
#include "System_Types.h"
#include <vector>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea
#include <map>

using namespace std;

namespace App {
namespace Core {
class OEMmenu :  public ListImplementation
{
   public:
      virtual ~OEMmenu();
      OEMmenu(const OEMmenu&);
      OEMmenu& operator =(const OEMmenu&);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)

      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      ON_COURIER_MESSAGE(PopupStatusMsg)
      ON_COURIER_MESSAGE(SystemInstallationMsg)
      ON_COURIER_MESSAGE(OEMPinOkMsg)
      ON_COURIER_MESSAGE(Courier::UpdateModelMsg)
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
      COURIER_BINDING_MAP_BEGIN()
      COURIER_BINDING_ITEM_CHANGE(OEMPIN1TextInfoItem)
      COURIER_BINDING_ITEM_CHANGE(OEMPIN2TextInfoItem)
      COURIER_BINDING_ITEM_CHANGE(OEMPIN3TextInfoItem)
      COURIER_BINDING_ITEM_CHANGE(OEMPIN4TextInfoItem)
      COURIER_BINDING_ITEM_CHANGE(OEMPINKeyInfoItem)
      COURIER_BINDING_MAP_END()

      bool onCourierMessage(const PopupStatusMsg& oMsg);
      bool onCourierMessage(const SystemInstallationMsg& oMsg);
      bool onCourierMessage(const OEMPinOkMsg& oMsg);
      bool getSystemInstallationActiveStatus();
      static OEMmenu* poGetInstance()
      {
         if (NULL == m_poOEMmenu)
         {
            m_poOEMmenu = new OEMmenu();
         }
         return m_poOEMmenu;
      }

      DataBindingItem < OEMPINKeyInfoDataBindingSource > _oemPINKeyDataBinding;
      DataBindingItem < OEMPIN1TextInfoDataBindingSource > _oemPIN1TextDataBinding;
      DataBindingItem < OEMPIN2TextInfoDataBindingSource > _oemPIN2TextDataBinding;
      DataBindingItem < OEMPIN3TextInfoDataBindingSource > _oemPIN3TextDataBinding;
      DataBindingItem < OEMPIN4TextInfoDataBindingSource > _oemPIN4TextDataBinding;
      DataBindingItem < OEMPINCursorStateDataBindingSource > _oemPINCursorDataBinding;
      DataBindingItem < OEMPINEditableStateDataBindingSource > _oemPINEditableDataBinding;
      DataBindingItem < OEMAuthenticationInfoTextDataBindingSource > _oemAuthenticationText;
      DataBindingItem < OEMKey1InputDataBindingSource > _oemPINkey1Databinding;
      DataBindingItem < OEMKey2InputDataBindingSource > _oemPINkey2Databinding;
      DataBindingItem < OEMKey3InputDataBindingSource > _oemPINkey3Databinding;
      DataBindingItem < OEMKey4InputDataBindingSource > _oemPINkey4Databinding;
      DataBindingItem < OEMSpeedLockUpdateDataBindingSource > _speedlockOEMDatabinding;

      bool onCourierBindingItemChange_OEMPIN1TextInfoItem(const Courier::Request& request);
      bool onCourierBindingItemChange_OEMPIN2TextInfoItem(const Courier::Request& request);
      bool onCourierBindingItemChange_OEMPIN3TextInfoItem(const Courier::Request& request);
      bool onCourierBindingItemChange_OEMPIN4TextInfoItem(const Courier::Request& request);
      bool onCourierBindingItemChange_OEMPINKeyInfoItem(const Courier::Request& request);
      void UpdateResetToSupplierDefaultConfigStatus(bool status);
   private:
      OEMmenu();
      static OEMmenu* m_poOEMmenu;
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getMainViewListDataProvider();

      void resetSpellerEditableAndCursor();
      void setDefaultPINCursorAndEditableDatabinding();
      void performPINspellerEnable(bool status);
      void setSpellerEditableAndCursor(uint8 keyIndex, string key);
      void setSpellerText(uint8 keyIndex, string key);
      void performAuthenticationCheckScreenValidation();

      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);

      bool listcreated;
      bool SystemInstallationActiveStatus;
      int systemInstallationStatus;
      uint8 _pintrials;
      UserAuthentication _userAuthentication;
      std::string DisclaimerText;

      DataBindingItem<SystemInstallationDataBindingSource> _SystemInstallation;
      DataBindingItem<PopUpButtonVisibilityDataBindingSource> _PopupButton;
};


}
}


#endif
