/**************************************************************************************
* @file         : NaftaLanguageSettingListHandler.h
* @author       : Prashant BG
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef LANGUAGE_SETTINGS_LIST_HANDLER_H
#define LANUAGE_SETTINGS_LIST_HANDLER_H

#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
//#include "AppHmi_SystemTypes.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"
#include "Common/DataModel/ListModel.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "System_Types.h"
#include <vector>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea
#include <map>
#include <boost/tuple/tuple.hpp>


using namespace std;

/* structure for language list */
/* struct Language_List
{
	Candera::String LangList;
}; */

namespace App {
namespace Core {
class NaftaLanguageSettingListHandler :  public ListImplementation
{
   public:

      virtual ~NaftaLanguageSettingListHandler();
      NaftaLanguageSettingListHandler(const NaftaLanguageSettingListHandler&);
      NaftaLanguageSettingListHandler& operator =(const NaftaLanguageSettingListHandler&);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)

      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
//	ON_COURIER_MESSAGE(Courier::StartupMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      //Singleton class implementation

      static NaftaLanguageSettingListHandler* poGetInstance()
      {
         if (NULL == m_polanguageSettingNaftaListHandler)
         {
            m_polanguageSettingNaftaListHandler = new NaftaLanguageSettingListHandler();
         }
         return m_polanguageSettingNaftaListHandler;
      }

      void sendNaftaLanguageUpdateToGUI(uint32 Naftalanguagecode);
      bool onCourierMessage(const Courier::StartupMsg& oMsg);
      bool listcreated;

   private:
      NaftaLanguageSettingListHandler();
      static NaftaLanguageSettingListHandler* m_polanguageSettingNaftaListHandler;

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getMainViewListDataProvider();

      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);

      //typedef ::boost::tuple<int,std::string,int,Candera::String,std::string,bool>tp_naftalang;
      typedef ::boost::tuple<int, Candera::String, int, Candera::String, std::string, bool>tp_naftalang;
      vector<tp_naftalang>vec_naftalang;

      void vCreateMapCultureindextoNaftaLangString();
      uint32 NaftaLangCodeStatus;
      DataBindingItem<NaftaLang_SettingMenuDataBindingSource> oNaftaLang_SettingMenu;

      NaftaLang_SettingMenuData _NaftaLanguageListItem[5];
      unsigned int prevIndex;
      unsigned int prevIndex2Gui;
      unsigned int index;
};


}
}


#endif // SYSTEM_SETTINGS_LIST_HANDLER_H
