/**************************************************************************************
* @file         : NaftaLanguageSettingListHandler.cpp
* @author       : Prashant BG
* @addtogroup   : AppHmi_System
* @brief        :
* @copyright    : (c) 2019-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "gui_std_if.h"
#include <string>
//#include "util/StrUtf8.h"
#include "NaftaLanguageSettingListHandler.h"
#include "App/Core/ClientHandler/VehicleSrvClient/VehicleSrvClient.h"
#include "App/Core/ClientHandler/RVC/RearViewCamera.h"
#include "App/Core/AppLogic/ClockSettings/ClockDateFormat/ClockDateFormatRbtn.h"
#include "App/Core/AppLogic/SystemSettingListhandler/SystemSettingsListHandler.h"

#include <cstdlib>
#include "hmi_trace_if.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::NaftaLanguageSettingListHandler::
#include "trcGenProj/Header/NaftaLanguageSettingListHandler.cpp.trc.h"
#endif

namespace App {
namespace Core {

NaftaLanguageSettingListHandler* NaftaLanguageSettingListHandler::m_polanguageSettingNaftaListHandler = NULL;
static const char* const DATA_CONTEXT_TEXT_BUTTON_TOGGLE_NAFTA_LIST_ITEM = "Layer_NaftaLSCheckbox";


/************************************************************************
*FUNCTION: 		 AudioSettingListHandler - Constructor
*DESCRIPTION: 	 default constructor of the System setting Listhadler will be created
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*27.3.2018:Prashant BG

*0.1 Initial Revision.
************************************************************************/

NaftaLanguageSettingListHandler::NaftaLanguageSettingListHandler()
{
   ETG_TRACE_COMP(("NaftaLanguageSettingListHandler:: Constructor is called"));
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SYSTEM_LANGUAGE_NAFTA_LIST, this);
   //listUpdateNeeded=false;
   NaftaLangCodeStatus = 0;
   prevIndex = 0;
   prevIndex2Gui = 0;
   index = 0;
   listcreated = false;
   vCreateMapCultureindextoNaftaLangString();
   //	 boost::get<NaftaLang_Toggle>(vec_naftalang[0]) = true;	// Toggle Button
   //_NaftaLanguageListItem[0].mnaftalang_ActiveColor = true;	//Text Color Update
   //m_checklang=false;
}


/************************************************************************
*FUNCTION: 		 NaftaLanguageSettingListHandler - Destructor
*DESCRIPTION: 	 Allocated resources such as memory will be released here
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*27.3.2018:Prashant BG

*0.1 Initial Revision.
************************************************************************/
NaftaLanguageSettingListHandler::~NaftaLanguageSettingListHandler()
{
   ETG_TRACE_COMP(("NaftaLanguageSettingListHandler:: Destructor is called"));
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SYSTEM_LANGUAGE_NAFTA_LIST);
   listcreated = false;
}


void NaftaLanguageSettingListHandler::vCreateMapCultureindextoNaftaLangString()
{
   ETG_TRACE_COMP(("NaftaLanguageSettingListHandler:: vCreateMapCultureindextoNaftaLangString"));
   Candera::String vmLanguageStr[4] = {Candera::String(TextId_0x1396), Candera::String(TextId_0x0256), Candera::String(TextId_0x0259), Candera::String(TextId_0x1397)};
   int vmServiceCode[4] = {13, 12, 47, 22};
   Candera::String vmTranStr[4] = {Candera::String(TextId_0x1396), Candera::String(TextId_0x0256), Candera::String(TextId_0x0259), Candera::String(TextId_0x1397)};
   std::string vmCultureReqCodeStr[4] = {"en_US", "en_GB", "es_MX", "fr_CA"};
   for (int index = 0; index < 4; index++)
   {
      vec_naftalang.push_back(boost::make_tuple(index, vmLanguageStr[index], vmServiceCode[index], vmTranStr[index], vmCultureReqCodeStr[index], false));
   }
}


/**********************************************************************************************
*FUNCTION: 		 NaftaLanguageSettingListHandler - getListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 oMsg - Courier message received
*RETURNVALUE: 	 tSharedPtrDataProvider()
*
*HISTORY:
*27.3.2018:Prashant BG

*0.1 Initial Revision.
**********************************************************************************************/

tSharedPtrDataProvider NaftaLanguageSettingListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_COMP(("NaftaLanguageSettingListHandler:: getListDataProvider: List Id = %d", oMsg.GetListId()));
   switch (oMsg.GetListId())
   {
      case LIST_ID_SYSTEM_LANGUAGE_NAFTA_LIST:
         return getMainViewListDataProvider();
   }
   return tSharedPtrDataProvider();
}


tSharedPtrDataProvider NaftaLanguageSettingListHandler::getMainViewListDataProvider()
{
   Candera::String dummyMenuDataBinding;
   Candera::String dummylangtoggle;
   ListDataProviderBuilder listBuilder(LIST_ID_SYSTEM_LANGUAGE_NAFTA_LIST, DATA_CONTEXT_TEXT_BUTTON_TOGGLE_NAFTA_LIST_ITEM);
   for (int itemIdx = 0 ; itemIdx < 4  ; itemIdx++)
   {
      _NaftaLanguageListItem[itemIdx].mnaftalang_val = boost::get<NaftaLang_LanguageStr>(vec_naftalang[itemIdx]);
      listBuilder.AddItem(
         itemIdx, 	//  - identifies the row
         0UL,   //  - column
         DATA_CONTEXT_TEXT_BUTTON_TOGGLE_NAFTA_LIST_ITEM)  //  - overwrites the default data context
      .AddDataBindingUpdater<NaftaLang_SettingMenuDataBindingSource>(_NaftaLanguageListItem[itemIdx])//1 - Text of the button, should be obtained from Candera.
      .AddData(boost::get<NaftaLang_Toggle>(vec_naftalang[itemIdx]));//2 - TimeZoneToggle On/Off */
      //Checking the dummy toggle value- Just for Testing;
      dummylangtoggle = (boost::get<NaftaLang_Toggle>(vec_naftalang[itemIdx]));
   }
   listcreated = true;
   return listBuilder.CreateDataProvider();
}


bool NaftaLanguageSettingListHandler::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   bool msgProcessed = false;
   unsigned int rowIdx = (unsigned int)oMsg.GetHdl();
   if (oMsg.GetListId() == LIST_ID_SYSTEM_LANGUAGE_NAFTA_LIST)
   {
      ETG_TRACE_USR1(("NaftaLanguageSettingListHandler::ButtonListItemUpdMsg:: Reaction = %d, rowIdx [%d], prevIdx [%d]", oMsg.GetReaction(), rowIdx, prevIndex));
      if ((rowIdx < 4) && (rowIdx != prevIndex) && (oMsg.GetReaction() == enRelease))
      {
         uint32  NaftaLangCodeStatus = boost::get<NaftaLang_ServiceCode>(vec_naftalang[rowIdx]);
         VehicleSrvClient::poGetInstance()->setHMILanguage(NaftaLangCodeStatus);
         ETG_TRACE_USR3(("NaftaLanguageSettingListHandler::ButtonListItemUpdMsg:LIST_ID_SYSTEM_LANGUAGE_NAFTA_LIST: NaftaLangCodeStatus [%d]", NaftaLangCodeStatus));
         prevIndex = rowIdx;
      }
      //This below Condition on Power(kl30) off and on --1st Row Selection won't work
      if ((prevIndex == rowIdx) && (index == 0))
      {
         uint32  NaftaLangCodeStatus = boost::get<NaftaLang_ServiceCode>(vec_naftalang[rowIdx]);
         VehicleSrvClient::poGetInstance()->setHMILanguage(NaftaLangCodeStatus);
         index = 1;
         ETG_TRACE_USR3(("NaftaLanguageSettingListHandler::ButtonListItemUpdMsg:LIST_ID_SYSTEM_LANGUAGE_NAFTA_LIST: NaftaLangCodeStatus [%d]", NaftaLangCodeStatus));
         prevIndex = rowIdx;
      }
      msgProcessed = true;
   }
   return msgProcessed;
}


void NaftaLanguageSettingListHandler::sendNaftaLanguageUpdateToGUI(uint32  Naftalanguagecode)
{
   unsigned int rowIdx2Gui = 0 ;
   if (Naftalanguagecode == 13)
   {
      rowIdx2Gui = 0;
   }
   else if (Naftalanguagecode == 12)
   {
      rowIdx2Gui = 1;
   }
   else if (Naftalanguagecode == 47)
   {
      rowIdx2Gui = 2;
   }
   else if (Naftalanguagecode == 22)
   {
      rowIdx2Gui = 3;
   }
   else
   {
      rowIdx2Gui = 255;
   }
   ETG_TRACE_USR1(("NaftaLanguageSettingListHandler::Naftalanguagecode [%d], Current Row Index [%d] Prev Row Index [%d]", Naftalanguagecode, rowIdx2Gui, prevIndex2Gui));
   if (rowIdx2Gui != 255)
   {
      if (rowIdx2Gui != prevIndex2Gui)
      {
         boost::get<NaftaLang_Toggle>(vec_naftalang[rowIdx2Gui]) = true;	// Toggle Button
         _NaftaLanguageListItem[rowIdx2Gui].mnaftalang_ActiveColor = true;	//Text Color Update

         boost::get<NaftaLang_Toggle>(vec_naftalang[prevIndex2Gui]) = false;
         _NaftaLanguageListItem[prevIndex2Gui].mnaftalang_ActiveColor = false;
      }
      else //At start up if both prev and current are same ..
      {
         boost::get<NaftaLang_Toggle>(vec_naftalang[rowIdx2Gui]) = true;	// Toggle Button
         _NaftaLanguageListItem[rowIdx2Gui].mnaftalang_ActiveColor = true;	//Text Color Update
      }
      prevIndex2Gui = rowIdx2Gui;
      if (listcreated == true)
      {
         ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_LANGUAGE_NAFTA_LIST);
      }
      SystemSettingsListHandler::poGetInstance()->SetLanguageStatus(Naftalanguagecode);
      RearViewCamera::poGetInstance()->SetLanguage_RVC(Naftalanguagecode);
   }
}


/*
bool NaftaLanguageSettingListHandler::onCourierMessage(const Courier::StartupMsg& oMsg)
{
	ETG_TRACE_USR4(("AudioEquilizerPresetRBtn:StartupMsg"));
				 boost::get<NaftaLang_Toggle>(vec_naftalang[0]) = true;	// Toggle Button
			_NaftaLanguageListItem[0].mnaftalang_ActiveColor = true;	//Text Color Update
	return true;
} */
}


}
