/**************************************************************************************
* @file         : AudioSettingListHandler.h
* @author       : Sheena Mathew
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/


#ifndef DISPLAY_SETTINGS_H
#define DISPLAY_SETTINGS_H

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "AppHmi_SystemStateMachine.h"

#include "CgiExtensions/DataBindingItem.hpp"

#include "AppHmi_SystemMessages.h"

#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "AppHmi_SystemStateMachineData.h"
#endif
#include "App/Core/ClientHandler/Display/DisplaySrvClient.h"
#include "System_Types.h"
#include <vector>
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea
#include <map>
#include <string>

#define M_BRIGHTLOWEST	0
#define M_Zero          0
#define M_BRIGHTONE 	1
#define M_BRIGHTHIGHEST 	20
#define M_DIMMINGDAY 	1
#define M_DIMMINGNIGHT 	2
#define COLUMN_BUTTON_MINUS 1
#define COLUMN_BUTTON_PLUS  2

using namespace std;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
namespace App {
namespace Core {
class DisplaySettings :  public ListImplementation
{
   public:
      virtual ~DisplaySettings();
      DisplaySettings(const DisplaySettings&);
      DisplaySettings& operator =(const DisplaySettings&);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)

      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(ChangeDisplaySettingModevalueReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
      //Singleton class implementation
      static DisplaySettings* poGetInstance()
      {
         if (NULL == m_poDisplaySettings)
         {
            m_poDisplaySettings = new DisplaySettings();
         }
         return m_poDisplaySettings;
      }
      bool listcreated;
      void onUpdateMenu(int& updatedval);
      void DisplayModeUpdate2HMI(const int& DisplayModeStatus);
      void SetDimmingModeInGui(const uint32& mvalue);
      void DisplayCompUpdate2GUI(int DispModeRx, int DispBrightRx);
   private:
      DisplaySettings();
      static DisplaySettings* m_poDisplaySettings;
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getMainViewListDataProvider();
      tSharedPtrDataProvider GetCombo1ListDataProvider(::Courier::UInt32);

      virtual bool onCourierMessage(const ChangeDisplaySettingModevalueReqMsg& oMsg);
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);

      enDisplaySettingModeOption _currentDispBrightnessValOption;
      Candera::String _currentDispModeOptionStr;
      Candera::String _currentDispModeOptionStr2HMI;

      DataBindingItem<DispSettingValueUpdateItemDataBindingSource> _dispSettingvalueUpdateItem;

      string s_BrightValue;
      int32_t  updatedBrightval;
      int type;
      bool _toggleStatus;
      unsigned int _vBrightnessValue;
      unsigned int _vBrightnessValue2ch;
      int32_t  listUpdateNeeded;

      void onCreateMaplistUpdate();
      void vDisplaySettingBrightnessIncdecval(int type, unsigned int brightvalue);
      void DisplayDisableBrightness();
};


}
}


#endif
#endif // SYSTEM_SETTINGS_LIST_HANDLER_H
