/**************************************************************************************
* @file         : DisplaySettings.cpp
* @author       : Sheena Mathew
* @addtogroup   : AppHmi_System
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "gui_std_if.h"

#include "util/StrUtf8.h"
#include "AppHmi_SystemStateMachine.h"
#include "hmi_trace_if.h"
#endif

#include "DisplaySettings.h"
#include "App/Core/Utils/DisplayUtility.h"

#include<iostream>
#include <string>
#include <cstdlib>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::DataModel::DisplaySettings
#include "trcGenProj/Header/DisplaySettings.cpp.trc.h"
#endif

namespace App {
namespace Core {

DisplaySettings* DisplaySettings::m_poDisplaySettings = NULL;


//static const char* const DATA_CONTEXT_TEXT_LIST_ITEM="Layer_Sound";
static const char* const DATA_CONTEXT_COMBOBOX_LIST_ITEM = "Combobox_ListItem";

//Automatic, Day Night-Drop Down List
/* 0x0F90 Automatic
0x0F91 DAY
0x0F92 Night */
Candera::String DisplayModeStrings[4]  = {Candera::String(TextId_0x0F91), Candera::String(TextId_0x0F92), Candera::String(TextId_0x0F90), Candera::String(TextId_0x0F90)};
//Candera::String DisplayModeStrings[3]  = {Candera::String(TextId_0x0F92), Candera::String(TextId_0x0F91), Candera::String(TextId_0x0F90)};

//std::String DisplayModeStrings[3]  = {Candera::String(TextId_0x0F90), Candera::String(TextId_0x0F91), Candera::String(TextId_0x0F92)};
Candera::String  DisplaySettingText[2] = {Candera::String(TextId_0x0A8A), Candera::String(TextId_0x0A8B)}; //Brightness ,  Mode


const char* LISTITEMTEMPLATE4DS[1] = {"listTplate_BtnBrightnessBar"}; //,"listTplate_BtnBassBar","listTplate_BtnBalanceBar"};

/************************************************************************
*FUNCTION: 		 DisplaySettings - Constructor
*DESCRIPTION: 	 default constructor of the System setting Listhadler will be created
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*27.3.2018:Sheena Mathew

*0.1 Initial Revision.
************************************************************************/

DisplaySettings::DisplaySettings()
{
   ETG_TRACE_COMP(("DisplaySettings:: Constructor is called"));
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SYSTEM_DISPLAYSETTING_LIST, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SYSTEM_DISPLAYSETTING_DAYNIGHTAUTOMODE_LIST, this);
   type = COLUMN_BUTTON_PLUS;
   listUpdateNeeded = false;
   _vBrightnessValue = 7;
   _toggleStatus = 0;
   _vBrightnessValue2ch = 0;
   updatedBrightval = 7;
   listcreated = false;
   _currentDispBrightnessValOption = Auto;
   if (_currentDispModeOptionStr == Candera::String(TextId_0x0F90))
   {
      ETG_TRACE_USR1(("DisplaySettings:: Automatic greying image"));
      DisplayDisableBrightness();
   }
}


/************************************************************************
*FUNCTION: 		 DisplaySettings - Destructor
*DESCRIPTION: 	 Allocated resources such as memory will be released here
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*27.3.2018:Sheena Mathew

*0.1 Initial Revision.
************************************************************************/
DisplaySettings::~DisplaySettings()
{
   ETG_TRACE_COMP(("DisplaySettings:: Destructor is called"));
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SYSTEM_DISPLAYSETTING_LIST);
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SYSTEM_DISPLAYSETTING_DAYNIGHTAUTOMODE_LIST);
   listcreated = false;
}


/**********************************************************************************************
*FUNCTION: 		 DisplaySettings - getListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 oMsg - Courier message received
*RETURNVALUE: 	 tSharedPtrDataProvider()
*
*HISTORY:
*27.3.2018:Sheena Mathew

*0.1 Initial Revision.
**********************************************************************************************/

tSharedPtrDataProvider DisplaySettings::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_COMP(("DisplaySettings:: getListDataProvider: List Id = %d", oMsg.GetListId()));
   switch (oMsg.GetListId())
   {
      case LIST_ID_SYSTEM_DISPLAYSETTING_LIST:
         return getMainViewListDataProvider();

      case LIST_ID_SYSTEM_DISPLAYSETTING_DAYNIGHTAUTOMODE_LIST:
         return GetCombo1ListDataProvider(oMsg.GetListId());
   }
   return tSharedPtrDataProvider();
}


tSharedPtrDataProvider DisplaySettings::getMainViewListDataProvider()
{
   ListDataProviderBuilder listBuilder(LIST_ID_SYSTEM_DISPLAYSETTING_LIST);
   /*Button Inc and Dec*/
   ETG_TRACE_USR1(("DisplaySettings::getMainViewListDataProvider ---BEFORE *_dispSettingvalueUpdateItem).mDispLevelIndex=%s ", ((*_dispSettingvalueUpdateItem).mDispLevelIndex).GetCString()));

   listBuilder.AddItem(static_cast<int>(e_BRIGHTNESS), 0UL, "listTplate_BtnBrightnessBar")
   .AddData(DisplaySettingText[e_BRIGHTNESS])
   .AddId(e_BRIGHTNESS, COLUMN_BUTTON_MINUS)     // -
   .AddId(e_BRIGHTNESS, COLUMN_BUTTON_PLUS)// +
   .AddDataBindingUpdater<DispSettingValueUpdateItemDataBindingSource>(_dispSettingvalueUpdateItem);

   ETG_TRACE_USR1(("DisplaySettings::getMainViewListDataProvider ----AFTER *_dispSettingvalueUpdateItem).mDispLevelIndex=%s ", ((*_dispSettingvalueUpdateItem).mDispLevelIndex).GetCString()));
   /*Drop Down List*/
   listBuilder.AddExpandableItem(static_cast<int>(e_MODE),            //   - identifies the row
                                 LIST_ID_SYSTEM_DISPLAYSETTING_DAYNIGHTAUTOMODE_LIST,                          //   - used to automatically toggle the visibility of the combobox dropdown list when the combox button is clicked
                                 "Combobox_ListItem")         //   - overwrites the default data context
   .AddData(DisplaySettingText[1])  //1 - Text of the combobox button.
   .AddData(LIST_ID_SYSTEM_DISPLAYSETTING_DAYNIGHTAUTOMODE_LIST)				 //2 - ListId of the combobox dropdown list.
   .AddData(_currentDispModeOptionStr);					 //3 - Text of the label displayed in front of the combobox button, should be obtained from Candera.

   listcreated = true;
   return listBuilder.CreateDataProvider();
}


tSharedPtrDataProvider DisplaySettings::GetCombo1ListDataProvider(::Courier::UInt32  listID)
{
   const char* DATA_CONTEXT_DROPDOWN_LIST_ITEM = "DropdownListButton";

   ListDataProviderBuilder listBuilder(LIST_ID_SYSTEM_DISPLAYSETTING_DAYNIGHTAUTOMODE_LIST, DATA_CONTEXT_DROPDOWN_LIST_ITEM);

   listBuilder.AddItem(1UL).AddData(DisplayModeStrings[0]);
   listBuilder.AddItem(2UL).AddData(DisplayModeStrings[1]);
   listBuilder.AddItem(3UL).AddData(DisplayModeStrings[2]);

   return listBuilder.CreateDataProvider();
}


bool DisplaySettings::onCourierMessage(const ChangeDisplaySettingModevalueReqMsg& oMsg)
{
   unsigned int DispModeSelect = oMsg.GetDisplaySettingModeOptions();
   ListDataProviderBuilder modifiedListItems(LIST_ID_SYSTEM_DISPLAYSETTING_LIST);
   ETG_TRACE_COMP(("DisplaySettings::ChangeDisplaySettingModevalueReqMsg: DispModeSelect = %d", DispModeSelect));
   // Subtract 1 to match the selection and enumeration index,
   // handle for first option in dropdown is 1. However, the enumeration value for same is 0
   if (DispModeSelect <= 3)
   {
      _currentDispBrightnessValOption = static_cast<enDisplaySettingModeOption>(DispModeSelect);
   }
   SetDimmingModeInGui(_currentDispBrightnessValOption);
   return true;
}


//Update to Mode Value to CLIENT HANDLER
void DisplaySettings::SetDimmingModeInGui(const uint32& mvalue)
{
   ETG_TRACE_COMP(("DisplaySettings::SetDimmingModeInGui mvalue:%d", mvalue));
   if (DisplaySrvClient::poGetInstance())
   {
      DisplaySrvClient::poGetInstance()->SetDimmingMode(mvalue);
   }
}


//Update to Mode Value to HMI GUI
void DisplaySettings::DisplayModeUpdate2HMI(const int& DisplayModeStatus)
{
   ETG_TRACE_COMP(("DisplaySettings::DisplayModeUpdate2HMI:  DisplayModeStatus = %d", DisplayModeStatus));
   if (DisplayModeStatus == 1)
   {
      _currentDispModeOptionStr = Candera::String(TextId_0x0F91);
      (*_dispSettingvalueUpdateItem).mGreyBrightnessTextCumImage = 1;
   }
   else if (DisplayModeStatus == 2)
   {
      _currentDispModeOptionStr = Candera::String(TextId_0x0F92);
      (*_dispSettingvalueUpdateItem).mGreyBrightnessTextCumImage = 1;
   }
   else if (DisplayModeStatus == 3)
   {
      _currentDispModeOptionStr = Candera::String(TextId_0x0F90);
      ETG_TRACE_USR2(("DisplaySettings::DisplayModeUpdate2HMI:: OUTSIDE Greying"));
      DisplayDisableBrightness();
   }
   else
   {
      _currentDispModeOptionStr = Candera::String(TextId_0x0F90);
      DisplayDisableBrightness();
   }
   if (listcreated == true)
   {
      ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_DISPLAYSETTING_DAYNIGHTAUTOMODE_LIST);
      ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_DISPLAYSETTING_LIST);
   }
}


void DisplaySettings::DisplayDisableBrightness()
{
   ETG_TRACE_COMP(("DisplaySettings::DisplayDisableBrightness"));
   (*_dispSettingvalueUpdateItem).mGreyBrightnessTextCumImage = 0;
   ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_DISPLAYSETTING_DAYNIGHTAUTOMODE_LIST);
   ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_DISPLAYSETTING_LIST);
}


bool DisplaySettings::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   ListDataProviderBuilder modifiedListItems(LIST_ID_SYSTEM_DISPLAYSETTING_LIST);
   bool msgProcessed = false;
   unsigned int rowIdx = (unsigned int)oMsg.GetHdl();
   Candera::DropdownChangeType clkmanddChange;
   if (rowIdx == 0)
   {
      clkmanddChange = Candera::DropdownChangeClose;
      DropdownChangeMsg* ddToggleMsg_ManualClockFormat = COURIER_MESSAGE_NEW(DropdownChangeMsg)(clkmanddChange, LIST_ID_SYSTEM_DISPLAYSETTING_DAYNIGHTAUTOMODE_LIST);
      ETG_TRACE_USR2(("DisplaySettings::ButtonListItemUpdMsg:LIST_ID_SYSTEM_DISPLAYSETTING_LIST: rowIdx =%d, clkmanddChange = %d, ddToggleMsg_ManualClockFormat = %d", rowIdx, clkmanddChange, ddToggleMsg_ManualClockFormat));
      if (ddToggleMsg_ManualClockFormat != NULL)
      {
         ddToggleMsg_ManualClockFormat->Post();
      }
   }
   if ((oMsg.GetListId() == LIST_ID_SYSTEM_DISPLAYSETTING_LIST) && (oMsg.GetReaction() == enRelease)  && (0 == oMsg.GetHdl()))
   {
      type = oMsg.GetSubHdl();
      vDisplaySettingBrightnessIncdecval(type, _vBrightnessValue);
      ETG_TRACE_USR2(("DisplaySettings::ButtonListItemUpdMsg:LIST_ID_SYSTEM_DISPLAYSETTING_LIST: Reaction = %d,rowIdx =%d, _vBrightnessValue=%d", oMsg.GetReaction(), rowIdx, _vBrightnessValue));
      msgProcessed = true;
   }
   return msgProcessed;
}


//Update the BRIGHTNESS value TO Client Handler
void DisplaySettings::vDisplaySettingBrightnessIncdecval(int type, unsigned int brightvalue)
{
   ETG_TRACE_COMP(("DisplaySettings::vDisplaySettingBrightnessIncdecval: type = %d, brightvalue =%d", type, brightvalue));
   DisplayUtility displayUtility;
   _vBrightnessValue = displayUtility.getCurrentBrightnesValue(type, brightvalue);
   _vBrightnessValue2ch = _vBrightnessValue;
   ETG_TRACE_USR1(("DisplaySettings::vDisplaySettingBrightnessIncdecval: _vBrightnessValue2ch =%d", _vBrightnessValue2ch));
   DisplaySrvClient::poGetInstance()->Inc_Dec_Brightness_Service(_vBrightnessValue2ch);
}


//Update the BRIGHTNESS value TO HMI GUI
void DisplaySettings::onUpdateMenu(int& updatedval)
{
   int Brightnessvalue = 0;
   _vBrightnessValue = updatedval;
   Brightnessvalue = updatedval;
   string mbrightstringvalinc;//string which will contain the result
   stringstream convert; // stringstream used for the conversion
   convert << Brightnessvalue;//add the value of Number to the characters in the stream
   mbrightstringvalinc = convert.str();//set Result to the content of the stream
   ETG_TRACE_USR1(("DisplaySettings::onUpdateMenu: updatedval = %d, (*_dispSettingvalueUpdateItem).mDispLevelIndex = %s", updatedval, mbrightstringvalinc.c_str()));
   (*_dispSettingvalueUpdateItem).mDispLevelIndex = mbrightstringvalinc.c_str(); //mbrightstringval.c_str();
   _dispSettingvalueUpdateItem.MarkAllItemsModified();
   _dispSettingvalueUpdateItem.SendUpdate(true);
   if (listcreated == true)
   {
      ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_DISPLAYSETTING_LIST);
   }
}


/* void DisplaySettings::DisplayCompUpdate2GUI(int DispModeRx,int DispBrightRx)
{ */
/*int BrightnesUpdateByModevalue =DispBrightRx;

_currentDispModeOptionStr = (DisplayModeStrings[DispModeRx - 1]);//.c_str();
ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_DISPLAYSETTING_DAYNIGHTAUTOMODE_LIST);
//ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_DISPLAYSETTING_LIST);


string mbrightstringvalinc;//string which will contain the result
stringstream convert; // stringstream used for the conversion
convert << BrightnesUpdateByModevalue;//add the value of Number to the characters in the stream
mbrightstringvalinc = convert.str();//set Result to the content of the stream


(*_dispSettingvalueUpdateItem).mDispLevelIndex = mbrightstringvalinc.c_str(); //mbrightstringval.c_str();


ETG_TRACE_USR4(("DisplaySrvClient::DisplayCompRxUpdate DispMode:%s", _currentDispModeOptionStr));
ETG_TRACE_USR4(("DisplaySrvClient::DisplayCompRxUpdate DispBright :%s", mbrightstringvalinc.c_str()));


_dispSettingvalueUpdateItem.MarkAllItemsModified();
_dispSettingvalueUpdateItem.SendUpdate(true);*/


/* } */
}


}
