/**************************************************************************************
* @file         : ConfigurationVersion.h
* @author       : Prashant BG
* @Date		 	: 23.01.2021
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (C) 2016 Robert Bosch GmbH
*                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef CONFIGURATION_VERSION_H
#define CONFIGURATION_VERSION_H
#define CIS_NETWORK_LIST_SIZE 2
#define DO_IPC_INSTALL_LIST_SIZE 1
#define CIS_NETWORK_ROW_ZERO 0
#define CIS_NETWORK_ROW_ONE 1
#define CIS_NETWORK_ROW_TWO 2

#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
#include "AppHmi_SystemTypes.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"
#include "Common/DataModel/ListModel.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "System_Types.h"
#include <vector>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea

using namespace std;

namespace App {
namespace Core {

class ConfigurationVersion :  public ListImplementation
{
   public:
      virtual ~ConfigurationVersion();
      ConfigurationVersion(const ConfigurationVersion&);
      ConfigurationVersion& operator =(const ConfigurationVersion&);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      //Singleton class implementation
#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
      static ConfigurationVersion* poGetInstance()
      {
         if (NULL == m_poConfigurationVersion)
         {
            m_poConfigurationVersion = new ConfigurationVersion();
         }
         return m_poConfigurationVersion;
      }
#endif

   private:
      ConfigurationVersion();
#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
      static ConfigurationVersion* m_poConfigurationVersion;
#endif
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getMainViewListDataProvider();
};


}
}


#endif
