/**************************************************************************************
* @file         : ClockSettings.h
* @author       : Sheena Mathew
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef CLOCK_SETTINGS_H
#define CLOCK_SETTINGS_H

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "App/Core/ClientHandler/VehicleSrvClient/VehicleSrvClient.h"
#endif
//#include "AppHmi_SystemTypes.h"
//#include "App/Core/ClientHandler/Audio/AudioServiceClient.h"
#include "System_Types.h"
#include <vector>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea
#include <map>
#include <boost/tuple/tuple.hpp>

#define COLUMN_BUTTON_MINUS 2
#define COLUMN_BUTTON_PLUS  3

using namespace std;

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
const Candera::String sTimeZoneListId [] =
{
   Candera::String(TextId_0x1812), //Eniwetok, Kwajalein
   Candera::String(TextId_0x1813), //Midway Island Samoa
   Candera::String(TextId_0x1814), //Hawaii
   Candera::String(TextId_0x1815), //Alaska
   Candera::String(TextId_0x1816), //Pacific
   Candera::String(TextId_0x1817), //Arizona
   Candera::String(TextId_0x1818), //Mountain
   Candera::String(TextId_0x1819), //Central America
   Candera::String(TextId_0x181A), //Central
   Candera::String(TextId_0x181B), //Mexico City
   Candera::String(TextId_0x181C), //Saskatchewan
   Candera::String(TextId_0x181D), //Bogota, Lima
   Candera::String(TextId_0x181E), //Eastern
   Candera::String(TextId_0x181F), //Indiana
   Candera::String(TextId_0x1820), //Atlantic
   Candera::String(TextId_0x1821), //Caracas, La Paz
   Candera::String(TextId_0x1822), //San Diego
   Candera::String(TextId_0x1823), //Newfoundland
   Candera::String(TextId_0x1824), //Brasilia
   Candera::String(TextId_0x1825), //Buenos Aires, Georgetown
   Candera::String(TextId_0x1826), //Greenland
   Candera::String(TextId_0x1827), //Mid-Atlantic
   Candera::String(TextId_0x1828), //Azores
   Candera::String(TextId_0x1829), //Cape Verde Isl
   Candera::String(TextId_0x182A), //Casablanca, Monrovia
   Candera::String(TextId_0x182B), //London
   Candera::String(TextId_0x182C), //Amsterdam
   Candera::String(TextId_0x182D), //Belgrade
   Candera::String(TextId_0x182E), //Paris
   Candera::String(TextId_0x182F), //Sarajevo
   Candera::String(TextId_0x1830), //West Central Africa
   Candera::String(TextId_0x1831), // Athens
   Candera::String(TextId_0x1832), //Istanbul
   Candera::String(TextId_0x1833), //Bucharest
   Candera::String(TextId_0x1834), //Cairo
   Candera::String(TextId_0x1835), //Harare
   Candera::String(TextId_0x1836), //Helsinki
   Candera::String(TextId_0x1837), //Jerusalem
   Candera::String(TextId_0x1838), //Baghdad
   Candera::String(TextId_0x1839), //Kuwait
   Candera::String(TextId_0x183A), //Moscow
   Candera::String(TextId_0x183B), //Nairobi
   Candera::String(TextId_0x183C), //Tehran
   Candera::String(TextId_0x183D), //Abu Dhabi
   Candera::String(TextId_0x183E), //Baku
   Candera::String(TextId_0x183F), //Kabul
   Candera::String(TextId_0x1840), //Ekaterinburg
   Candera::String(TextId_0x1841), //Islamabad
   Candera::String(TextId_0x1842), //Calcutta
   Candera::String(TextId_0x1843), //Kathmandu
   Candera::String(TextId_0x1844), //Almaty
   Candera::String(TextId_0x1845), //Astana
   Candera::String(TextId_0x1846), //Sri Jayawardenepura Kotte
   Candera::String(TextId_0x1847), //Novosibirsk
   Candera::String(TextId_0x1848), //Yangon
   Candera::String(TextId_0x1849), //Bangkok
   Candera::String(TextId_0x184A), //Krasnoyarsk
   Candera::String(TextId_0x184B), //Beijing
   Candera::String(TextId_0x184C), //Irkutsk
   Candera::String(TextId_0x184D), //Kuala Lumpur
   Candera::String(TextId_0x184E), //Perth
   Candera::String(TextId_0x184F), //Taipei
   Candera::String(TextId_0x1850), //
   Candera::String(TextId_0x1851), //
   Candera::String(TextId_0x1852), //
   Candera::String(TextId_0x1853), //
   Candera::String(TextId_0x1854), //
   Candera::String(TextId_0x1855), //
   Candera::String(TextId_0x1856), //
   Candera::String(TextId_0x1857), //
   Candera::String(TextId_0x1858), //
   Candera::String(TextId_0x1859), //
   Candera::String(TextId_0x185A), //
   Candera::String(TextId_0x185B), //
   Candera::String(TextId_0x185C), //
   Candera::String(TextId_0x185D), //
   Candera::String(TextId_0x185E), //
   Candera::String(TextId_0x185F), //
   Candera::String(TextId_0x1860), //
   Candera::String(TextId_0x1861), //
   Candera::String(TextId_0x1862), //
   Candera::String(TextId_0x1863), //
   Candera::String(TextId_0x1864), //
   Candera::String(TextId_0x1865), //
   Candera::String(TextId_0x1866), //
   Candera::String(TextId_0x1867), //
   Candera::String(TextId_0x1868), //
   Candera::String(TextId_0x1869), //
};


namespace App {
namespace Core {
class ClockSettings :  public ListImplementation
{
   public:

      virtual ~ClockSettings();
      ClockSettings(const ClockSettings&);
      ClockSettings& operator =(const ClockSettings&);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)

      ON_COURIER_MESSAGE(ChangeClockTimeformatReqMsg)
      ON_COURIER_MESSAGE(ChangeClockTimeZoneReqMsg)
      ON_COURIER_MESSAGE(ChangeClockformatReqMsg)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)

      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      virtual bool onCourierMessage(const ChangeClockTimeformatReqMsg& oMsg);
      virtual bool onCourierMessage(const ChangeClockTimeZoneReqMsg& oMsg);
      virtual bool onCourierMessage(const ChangeClockformatReqMsg& oMsg);

      //Singleton class implementation
      static ClockSettings* poGetInstance()
      {
         if (NULL == m_poClockSettings)
         {
            m_poClockSettings = new ClockSettings();
         }
         return m_poClockSettings;
      }

      void bonsetformatpropertyUpdateHMI(const int& timeFormat);
      void bonsetsynmodetoPL(const int& gpsenablestatus, const int& positionstatus);
      void vUpdateMin_Hr_Value(const int Hr_INC_DEC, const int Min_INC_DEC);
      void calculateforminus();
      void calculateforplus();
      void callGps();
      void callManual();
      int clocksettingmode;
      void ManualDateUpdateStatus(int dateformat);
      bool isNaviVariant();

      //Timezone functions
      void handleAvailableTimezonePropertyUpdate(std::vector< TimeZoneList > availableTimeZoneList);
      void updateRegionTimeZoneResponse(const uint8 status);
      void updateTimezoneOnStartup(uint16 index);
   private:
      ClockSettings();
      uint16 getVariantType();
      int m_clockmode;
      int u8RequestedHourValue;
      static ClockSettings* m_poClockSettings;
      enTimeformatOption _currentTimeformatOption;
      Candera::String _currentTimeformatOptionStr;
      enClockformatOption _currentClockformatOption;
      Candera::String _currentClockformatOptionStr;
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      int32_t updatedval;
      map<int, int> m_ListClockHourandMinuteVal;
      string m_hourmin;
      std::map <uint16, TimeZoneListItemInfo > _timeZoneListItemInfoMap;

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getDropdownListDataProvider();
      tSharedPtrDataProvider getDropdownTimeFormatListDataProvider();
      tSharedPtrDataProvider getDropdownClockSettingModeListDataProvider();
      tSharedPtrDataProvider getDropdownClockListDataProvider();
      tSharedPtrDataProvider getTimeZoneClockListDataProvider();

      void vClockSpecHourincrementdecrementvalue(int type, int Hourval);
      void vClockSpecMinuteincrementdecrementvalue(int type, int Hourval);
      void onUpdateMenu(int rowid, int* HourMinval);

      //TimeZone
      void prepareTimeZoneList();

      // void onUpdateMenu(int rowid, int HourMinval);
      void updateClockHrMinValue(int* address);

      DataBindingItem<HourValueUpdateItemDataBindingSource> _HourValueUpdateItem;
      typedef ::boost::tuple<string, int, int, int>tp_clocksettings;
      vector<tp_clocksettings>vec_clocksettings;
      void vCreateMapCultureindextoClockString();
      int type;
      unsigned int rowIdx;
      void bonrefreshissue();
      void UpdateManualClkDropDownMsg();
      bool listUpdateNeeded;
      bool listcreated;
      Candera::String _dateformat;
      std::vector<uint16> _availableTimeZoneList;
      uint16 _selectedTimeZone;

      //bool onCourierMessage(const ButtonListItemUpdMsg &oMsg);
};


}
}


#endif
#endif // SYSTEM_SETTINGS_LIST_HANDLER_H
