/**************************************************************************************
* @file         : CabinBSettingListhandler.cpp
* @author       : Prashant BG
* @addtogroup   : AppHmi_System
* @brief        :
* @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "gui_std_if.h"
#include <string>
//#include "util/StrUtf8.h"
#include "CabinBSettingListhandler.h"
/* #include "App/Core/ClientHandler/VehicleSrvClient/VehicleSrvClient.h"
#include "App/Core/ClientHandler/DownloadSrvClient/SWUpdateClient.h" */
#include "hmi_trace_if.h"
#include "CgiExtensions/ImageLoader.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::CabinBSettingListhandler::
#include "trcGenProj/Header/CabinBSettingListhandler.cpp.trc.h"
#endif

namespace App {
namespace Core {
#ifdef VARIANT_S_FTR_ENABLE_CABIN_B_SUPPORT
CabinBSettingListhandler* CabinBSettingListhandler::m_poCabinBSettingListhandler = NULL;
static const char* const DATA_CONTEXT_TEXT_LIST_ITEM = "Layer_Sound";


std::string IconNormalCB[4] = {"Icon_SoundSettings_normalBmp", "Icon_Display_normalBmp",
                               "Icon_OpenSrcSw_normalBmp", "Icon_RstToFactSettings_normalBmp"
                              };

std::string IconPressedCB[4] = {"Icon_SoundSettings_touchedBmp", "Icon_Display_touchedBmp",
                                "Icon_OpenSrcSw_touchedBmp", "Icon_RstToFactSettings_touchedBmp"
                               };

Candera::String CabinBSettingMainText[4] =
{
   Candera::String(TextId_0x1585), Candera::String(TextId_0x1586),
   Candera::String(TextId_0x1587), Candera::String(TextId_0x1588)
};


std::string basePath_CB = "AppHmi_System#Images#SO_CabinBSysSettings#";
/************************************************************************
*FUNCTION: 		 CabinBSettingListhandler - Constructor
*DESCRIPTION: 	 default constructor of the System setting Listhadler will be created
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*15.07.2019:Prashant BG

*0.1 Initial Revision.
************************************************************************/

CabinBSettingListhandler::CabinBSettingListhandler()
{
   ETG_TRACE_COMP(("CabinBSettingListhandler:: Constructor is called"));
   CABIN_B_MAIN_TEXT = Candera::String(TextId_0x1585);
   listcreated = false;
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_CABIN_B_MAIN_LIST, this);
   vCreateCabinBListUpdate();
}


/************************************************************************
*FUNCTION: 		 CabinBSettingListhandler - Destructor
*DESCRIPTION: 	 Allocated resources such as memory will be released here
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*15.07.2019:Prashant BG

*0.1 Initial Revision.
************************************************************************/

CabinBSettingListhandler::~CabinBSettingListhandler()
{
   ETG_TRACE_COMP(("CabinBSettingListhandler:: Destructor is called"));
   my_cabinB_vec.clear();
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_CABIN_B_MAIN_LIST);
   listcreated = false;
   // delete _hmidatasrvhandler;
}


bool CabinBSettingListhandler::onCourierMessage(const Courier::StartupMsg&)
{
   ETG_TRACE_COMP(("CabinBSettingListhandler:: StartupMsg is called"));
   return true;
}


/**********************************************************************************************
*FUNCTION: 		 CabinBSettingListhandler - vCreateCabinBListUpdate
*DESCRIPTION: 	 Create maping between list id and and the value
*PARAMETER:		 None
*RETURNVALUE: 	 NONE
*
*HISTORY:
*15.07.2019:Prashant BG

*0.1 Initial Revision.
**********************************************************************************************/
void CabinBSettingListhandler::vCreateCabinBListUpdate()
{
   my_cabinB_vec.clear();
   for (int index = 0; index <= 3; index++)
   {
      IMG_ICON_NORMAL_CB = basePath_CB + IconNormalCB[index];
      IconNormalCB[index] = "";
      ETG_TRACE_USR2(("CabinBSettingListhandler:: vCreateCabinBListUpdate: IMG_ICON_NORMAL_CB =%s\n", IMG_ICON_NORMAL_CB.c_str()));
      IMG_ICON_PRESS_CB = basePath_CB + IconPressedCB[index];
      IconPressedCB[index] = "";
      ETG_TRACE_USR2(("CabinBSettingListhandler:: vCreateCabinBListUpdate: IMG_ICON_PRESS_CB =%s\n", IMG_ICON_PRESS_CB.c_str()));
      my_cabinB_vec.push_back(boost::make_tuple(IMG_ICON_NORMAL_CB, IMG_ICON_PRESS_CB, CabinBSettingMainText[index]));
   }
   ETG_TRACE_USR1(("CabinBSettingListhandler:: vCreateCabinBListUpdate: my_cabinB_vec.size() =%d\n", my_cabinB_vec.size()));
}


/**********************************************************************************************
*FUNCTION: 		 CabinBSettingListhandler - getListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 oMsg - Courier message received
*RETURNVALUE: 	 tSharedPtrDataProvider()
*
*HISTORY:
*15.07.2019:Prashant BG

*0.1 Initial Revision.
**********************************************************************************************/

tSharedPtrDataProvider CabinBSettingListhandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_COMP(("CabinBSettingListhandler:: getListDataProvider: List Id = %d", oMsg.GetListId()));
   switch (oMsg.GetListId())
   {
      case LIST_ID_CABIN_B_MAIN_LIST:
         return getMainViewListDataProvider();

      default:
      {
         break;
      }
   }
   return tSharedPtrDataProvider();
}


tSharedPtrDataProvider CabinBSettingListhandler::getMainViewListDataProvider()
{
   ListDataProviderBuilder listBuilder(LIST_ID_CABIN_B_MAIN_LIST);
   for (int index = 0; index <= 3; index++)
   {
      CabinBsettingMainIconData CabinBitem;

      IMG_CABIN_B_ICON_NORMAL = boost::get<Icon_normal_cb>(my_cabinB_vec[index]);
      IMG_CABIN_B_ICON_TOUCHED = boost::get<Icon_pressed_cb>(my_cabinB_vec[index]);
      CABIN_B_MAIN_TEXT = boost::get<CabinBMain_text>(my_cabinB_vec[index]);

      CabinBitem.mCabinBMainIconNormalBitmap = ImageLoader::getAssetBitmapImage(IMG_CABIN_B_ICON_NORMAL.c_str());
      CabinBitem.mCabinBMainIconPressedBitmap = ImageLoader::getAssetBitmapImage(IMG_CABIN_B_ICON_TOUCHED.c_str());
      CabinBitem.mCabinBMainNameInfo = CABIN_B_MAIN_TEXT;

      listBuilder.AddItem(
         index, 	//  - identifies the row
         0UL,   //  - column
         DATA_CONTEXT_TEXT_LIST_ITEM)  //  - overwrites the default data context
      .AddDataBindingUpdater<CabinBsettingMainIconDataBindingSource>(CabinBitem);//1 - Text of the button, should be obtained from Candera.

      ETG_TRACE_USR1(("CabinBSettingListhandler::getMainViewListDataProvider: index =%d, CabinBitem.mCabinBMainIconNormalBitmap= %s ", index, CabinBitem.mCabinBMainIconNormalBitmap));
      ETG_TRACE_USR1(("CabinBSettingListhandler::getMainViewListDataProvider: CabinBitem.mCabinBMainIconPressedBitmap= %s \n", CabinBitem.mCabinBMainIconPressedBitmap));
      ETG_TRACE_USR1(("CabinBSettingListhandler::getMainViewListDataProvider: CabinBitem.mCabinBMainNameInfo= %s \n", CabinBitem.mCabinBMainNameInfo.GetCString()));
   }
   return listBuilder.CreateDataProvider();
}


#endif
}


}
