/**************************************************************************************
* @file         : CabinAVideoMixSourceListHandler.h
* @author       : Prashant BG
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef CABINA_VIDEOMIXSOURCE_LISTHANDLER_H
#define CABINA_VIDEOMIXSOURCE_LISTHANDLER_H

#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
#include "AppHmi_SystemTypes.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"
#include "Common/DataModel/ListModel.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "App/Core/ClientHandler/CabinInfoSrvClient/CabinInfoSrvClient.h"

#include "System_Types.h"
#include <vector>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea
#include <map>
#include <boost/tuple/tuple.hpp>


using namespace std;

namespace App {
namespace Core {


typedef struct
{
   int vmsSourceId;				//0 none //1 mapout //2 cmp1 //3 cmp2 //4 cmp3
   int vmsConnectionStatus;  	// 0 diconnected //1 connected //2 removed
   uint32 vmstextId;
   uint8 vmsRbtnStatus;			//0 disabled //1 enabled //2 greyed
} vmsStructData;


class CabinAVideoMixSourceListHandler :  public ListImplementation
{
   public:

      virtual ~CabinAVideoMixSourceListHandler();
      CabinAVideoMixSourceListHandler(const CabinAVideoMixSourceListHandler&);
      CabinAVideoMixSourceListHandler& operator =(const CabinAVideoMixSourceListHandler&);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)

      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      //Singleton class implementation
      static CabinAVideoMixSourceListHandler* poGetInstance()
      {
         if (NULL == m_poCabinAVideoMixSourceListHandler)
         {
            m_poCabinAVideoMixSourceListHandler = new CabinAVideoMixSourceListHandler();
         }
         return m_poCabinAVideoMixSourceListHandler;
      }

      bool listcreated;
      void UpdateVideoMixSource(std::map<int, map<int, uint32> >&  cabinSysteminfo);
      void UpdateVmsGuiOnUserSelection(unsigned int vmsSourceSelectedInfo);
   private:
      CabinAVideoMixSourceListHandler();
      static CabinAVideoMixSourceListHandler* m_poCabinAVideoMixSourceListHandler;
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getMainViewListDataProvider();
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);

      DataBindingItem<vmsCabinMenuDataBindingSource> _vmsCabinMenuObj;
      vmsCabinMenuData  _vmsCabinMenuDataObj;
      map<int, map<int, uint32> >::const_iterator itr;
      map<int, uint32>::const_iterator ptr;

      // source id //connectionstatus //userid/textid
      std::map<int, map<int, uint32> > vmsListMapData;
      vmsStructData _vmsStructObj[5];
      unsigned int mapsize;
      unsigned int prevIndex;
      unsigned int prevIndex2Gui;
      unsigned int index;
      unsigned int lastIndexb4PowerCycle;
      bool Variant_Type;
};


}//end of core
}//end of app
#endif // SYSTEM_SETTINGS_LIST_HANDLER_H
