/**************************************************************************************
* @file         : CabinASettingListhandler.h
* @author       : Sheena Mathew
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef CABIN_A_SETTINGS_LIST_HANDLER_H
#define CABIN_A_SETTINGS_LIST_HANDLER_H


#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
//#include "AppHmi_SystemTypes.h"
#include "App/Core/ClientHandler/CabinInfoSrvClient/CabinInfoSrvClient.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"
#include "ProjectPluginMsgs.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "System_Types.h"
#include <vector>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea
#include<map>
#include <boost/tuple/tuple.hpp>
using namespace std;
namespace App {
namespace Core {
#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
class CabinASettingListhandler :  public ListImplementation
{
   public:

      virtual ~CabinASettingListhandler();
      CabinASettingListhandler(const CabinASettingListhandler&);
      CabinASettingListhandler& operator =(const CabinASettingListhandler&);
      bool listcreated;

      // Incomming events ...
      bool onCourierMessage(const Courier::StartupMsg& oMsg);
      bool onCourierMessage(const ApplicationStateUpdMsg& oMsg);

      //bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(PluginEndStationListUpdateMsg)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(ApplicationStateUpdMsg)
      //ON_COURIER_MESSAGE(ButtonListItemUpdMsg)

      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
      virtual bool onCourierMessage(const PluginEndStationListUpdateMsg& oMsg);
      // virtual bool onCourierMessage(const ApplicationStateUpdMsg& oMsg);

      static CabinASettingListhandler* poGetInstance()
      {
         if (NULL == m_poCabinASettingListhandler)
         {
            m_poCabinASettingListhandler = new CabinASettingListhandler();
         }
         return m_poCabinASettingListhandler;
      }
      bool getglassconnectedstatus();

      bool _currentglassavalStatus;
      uint8 _HMIState;
      void setCurrentGlassAvailablityStatusData(bool flag);

      bool applicationState;
      void getActiveView(Candera::String ActiveView);
      void UpdateHMIState2HMI(const uint8 HMIState);
      void enableDisableGlass(bool rxdCurrentglassavalStatus);
      void UpdateVideoMixVisibilitystatus(uint32 systemCategory, uint8 systemStatus);
      void UpdateVideoMixSource(std::map<int, map<int, int> >&  cabinSysteminfo);
      void vCreateCabinAListUpdate();
      void UpdateCabinASettingListOnCmgChange();
      void UpdateTextColorStatus(bool* CabinAEnDisbTextOldStatus, bool* CabinAEnDisbTextNewStatus);
      void UpdateBmpIconStringStatus(std::string*  CabinIconOldBmpImage, std::string*  CabinIconNewBmpImage);
   private:

      static CabinASettingListhandler* m_poCabinASettingListhandler;
      CabinASettingListhandler();
      // void checkglassenablestatus(int);
      bool getCurrentGlassAvailablityStatusData();
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getMainViewListDataProvider();

      typedef ::boost::tuple<string, string, string, Candera::String, bool>mycabinA;
      vector<mycabinA>my_cabinA_vec;
      std::string IMG_ICON_NORMAL_CA;
      std::string IMG_ICON_PRESS_CA;
      std::string IMG_ICON_DISBNORMAL_CA;
      std::string IMG_ICON_CMG_CMGA2_DISBABLENORMAL_CA;

      std::string IMG_CABIN_A_ICON_NORMAL;
      std::string IMG_CABIN_A_ICON_TOUCHED;
      std::string IMG_CABIN_A_ICON_DISABLE;

      Candera::String CABIN_A_MAIN_TEXT;
      bool CABIN_A_ENDISB_TEXTIMAGE_FLAG;

      Candera::String _ActiveView;
};


#endif
}


}
#endif // SYSTEM_SETTINGS_LIST_HANDLER_H
