/**************************************************************************************
* @file         : CabinASettingListhandler.cpp
* @author       : Prashant BG
* @addtogroup   : AppHmi_System
* @brief        :
* @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "gui_std_if.h"
#include <string>
//#include "util/StrUtf8.h"
#include "CabinASettingListhandler.h"
#include "CabinAGlassSettingListhandler.h"
/* #include "App/Core/ClientHandler/VehicleSrvClient/VehicleSrvClient.h"
#include "App/Core/ClientHandler/DownloadSrvClient/SWUpdateClient.h" */
#include "hmi_trace_if.h"
#include "CgiExtensions/ImageLoader.h"
#include "spm_core_fi_typesConst.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::CabinASettingListhandler::
#include "trcGenProj/Header/CabinASettingListhandler.cpp.trc.h"
#endif

#define CABINASETTINGLISTCOUNTWITHVIDEOMIXSOURCE 3
#define CABINASETTINGLISTCOUNTWITHOUTVIDEOMIXSOURCE 2

using namespace ::spm_core_fi_types;

namespace App {
namespace Core {
#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
CabinASettingListhandler* CabinASettingListhandler::m_poCabinASettingListhandler = NULL;
static const char* const DATA_CONTEXT_TEXT_LIST_ITEM = "Layer_Sound";


std::string basePath_CA = "AppHmi_System#Images#SO_CabinASysSettings#";
/************************************************************************
*FUNCTION: 		 CabinASettingListhandler - Constructor
*DESCRIPTION: 	 default constructor of the System setting Listhadler will be created
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*15.07.2019:Prashant BG

*0.1 Initial Revision.
************************************************************************/

CabinASettingListhandler::CabinASettingListhandler()
{
   ETG_TRACE_COMP(("CabinASettingListhandler:: Constructor is called"));
   CABIN_A_MAIN_TEXT = Candera::String(TextId_0x1585);
   listcreated = false;
   _currentglassavalStatus = false;
   _HMIState = 0;
   _ActiveView = "";
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_CABIN_A_MAIN_LIST, this);
   vCreateCabinAListUpdate();
}


/************************************************************************
*FUNCTION: 		 CabinASettingListhandler - Destructor
*DESCRIPTION: 	 Allocated resources such as memory will be released here
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*15.07.2019:Prashant BG

*0.1 Initial Revision.
************************************************************************/

CabinASettingListhandler::~CabinASettingListhandler()
{
   ETG_TRACE_COMP(("CabinASettingListhandler:: Destructor is called"));
   my_cabinA_vec.clear();
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_CABIN_A_MAIN_LIST);
   listcreated = false;
   applicationState = false;
}


bool CabinASettingListhandler::onCourierMessage(const Courier::StartupMsg&)
{
   ETG_TRACE_COMP(("CabinASettingListhandler:: StartupMsg is called"));
   return true;
}


/**********************************************************************************************
*FUNCTION: 		 CabinASettingListhandler - vCreateCabinAListUpdate
*DESCRIPTION: 	 Create maping between list id and and the value
*PARAMETER:		 None
*RETURNVALUE: 	 NONE
*
*HISTORY:
*15.07.2019:Prashant BG

*0.1 Initial Revision.
**********************************************************************************************/
void CabinASettingListhandler::vCreateCabinAListUpdate()
{
   ETG_TRACE_USR2(("CabinASettingListhandler:: vCreateCabinAListUpdate "));
   //@PGA5COB - Reset To Factory Setting is Removed in Cabin as per Bug 1773578
   std::string IconNormalCA[4] = {"Icon_SoundSettings_normalBmp", "Icon_Glasssetting_normalBmp", "Icon_OpenSrcSw_normalBmp", /*"Icon_RstToFactSettings_normalBmp",*/ "Icon_Displaymixedsource_normalBmp"};
   std::string IconPressedCA[4] = {"Icon_SoundSettings_touchedBmp", "Icon_Glasssetting_touchedBmp", "Icon_OpenSrcSw_touchedBmp", /*"Icon_RstToFactSettings_touchedBmp", */"Icon_Displaymixedsource_activeBmp"};
   std::string IconNormalGlassDisbCA[4] = {"Icon_SoundSettings_normalBmp", "Icon_Glasssetting_disabledBmp", "Icon_OpenSrcSw_touchedBmp",/* "Icon_RstToFactSettings_touchedBmp", */ "Icon_Displaymixedsource_disableBmp"}; //for  T_SPM_e32_HMI_STATE__SPM_U32_HMISTATE_SHOW_HMI_HOUR_MODE
   Candera::String CabinASettingMainText[4] =
   {
      Candera::String(TextId_0x1585), Candera::String(TextId_0x1586), Candera::String(TextId_0x1587),/* Candera::String(TextId_0x1588), */ Candera::String(TextId_0x1A39)
   };
   bool CabinAEnDisb_CMG_CMGA2_LatestUpdate_CA[4] = {true, false, true,/* true,*/ false}; // Main Container
   bool CabinAEnDisb_CMG_CMGA2_Def_CA[4] = {true, false, true, /*true,*/ false};	// Default value
   bool CabinAEnDisb_CMGenB_CMGA2disB_CA[4] = {true, true, true,/* true,*/ false};	// CMGenB_CMGA2disB
   bool CabinAEnDisb_CMGenB_CMGA2enB_CA[4] = {true, true, true, /*true,*/ true};	// CMGenB_CMGA2enB
   std::string IconNormal_CMG_CMGA2_LatestUpdate_CA[4]  = {"Icon_SoundSettings_normalBmp", "Icon_Glasssetting_disabledBmp", "Icon_OpenSrcSw_touchedBmp",/* "Icon_RstToFactSettings_touchedBmp",*/ "Icon_Displaymixedsource_disableBmp"};	// mychange
   std::string IconNormal_CMG_CMGA2_Def_CA[4]    		 = {"Icon_SoundSettings_normalBmp", "Icon_Glasssetting_disabledBmp", "Icon_OpenSrcSw_touchedBmp",/* "Icon_RstToFactSettings_touchedBmp",*/ "Icon_Displaymixedsource_disableBmp"};	// mychange
   std::string IconNormal_CMGenB_CMGA2disB_CA[4] 		 = {"Icon_SoundSettings_normalBmp", "Icon_Glasssetting_normalBmp", "Icon_OpenSrcSw_touchedBmp",/* "Icon_RstToFactSettings_touchedBmp",*/ "Icon_Displaymixedsource_disableBmp"};
   std::string IconNormal_CMGenB_CMGA2enB_CA[4]  		 = {"Icon_SoundSettings_normalBmp", "Icon_Glasssetting_normalBmp", "Icon_OpenSrcSw_touchedBmp",/* "Icon_RstToFactSettings_touchedBmp",*/ "Icon_Displaymixedsource_normalBmp"};

   bool ctRxdGlassAvailablityStatusCA = CabinInfoSrvClient::poGetInstance()->getglassAvailablityInfoStatusCA();
   bool ctRxdCmgA2AvailablityStatusCA = CabinInfoSrvClient::poGetInstance()->getcmgA2AvailablityInfoStatusCA();
   ETG_TRACE_USR2(("CabinASettingListhandler:: vCreateCabinAListUpdate	 ctRxdGlassAvailablityStatusCA ctRxdCmgA2AvailablityStatusCA==>%d %d ", ctRxdGlassAvailablityStatusCA, ctRxdCmgA2AvailablityStatusCA));

   if (ctRxdGlassAvailablityStatusCA == true)
   {
      UpdateTextColorStatus(&CabinAEnDisb_CMG_CMGA2_LatestUpdate_CA[0], &CabinAEnDisb_CMGenB_CMGA2disB_CA[0]);
      UpdateBmpIconStringStatus(&IconNormal_CMG_CMGA2_LatestUpdate_CA[0], &IconNormal_CMGenB_CMGA2disB_CA[0]);
      if (ctRxdCmgA2AvailablityStatusCA == true)
      {
         UpdateTextColorStatus(&CabinAEnDisb_CMG_CMGA2_LatestUpdate_CA[0], &CabinAEnDisb_CMGenB_CMGA2enB_CA[0]);
         UpdateBmpIconStringStatus(&IconNormal_CMG_CMGA2_LatestUpdate_CA[0], &IconNormal_CMGenB_CMGA2enB_CA[0]);
      }
   }
   else
   {
      UpdateTextColorStatus(&CabinAEnDisb_CMG_CMGA2_LatestUpdate_CA[0], &CabinAEnDisb_CMG_CMGA2_Def_CA[0]);
      UpdateBmpIconStringStatus(&IconNormal_CMG_CMGA2_LatestUpdate_CA[0], &IconNormal_CMG_CMGA2_Def_CA[0]);
   }

   my_cabinA_vec.clear();
   for (int index = 0; index <= 3; index++)
   {
      IMG_ICON_NORMAL_CA = basePath_CA + IconNormalCA[index];
      IconNormalCA[index] = "";
      IMG_ICON_PRESS_CA = basePath_CA + IconPressedCA[index];
      IconPressedCA[index] = "";
      IMG_ICON_DISBNORMAL_CA = basePath_CA + IconNormalGlassDisbCA[index];
      IconNormalGlassDisbCA[index] = "";
      IMG_ICON_CMG_CMGA2_DISBABLENORMAL_CA = basePath_CA + IconNormal_CMG_CMGA2_LatestUpdate_CA[index];
      IconNormal_CMG_CMGA2_LatestUpdate_CA[index] = " ";
      if (_HMIState == T_SPM_e32_HMI_STATE__SPM_U32_HMISTATE_SHOW_HMI_HOUR_MODE)
      {
         ETG_TRACE_USR3(("CabinASettingListhandler:: vCreateCabinAListUpdate HOUR MODE is true DISABLED CabinAEnDisb_CMG_CMGA2_Def_CA[%d]=%d", index, CabinAEnDisb_CMG_CMGA2_Def_CA[index]));
         my_cabinA_vec.push_back(boost::make_tuple(IMG_ICON_NORMAL_CA, IMG_ICON_PRESS_CA, IMG_ICON_DISBNORMAL_CA, CabinASettingMainText[index], CabinAEnDisb_CMG_CMGA2_Def_CA[index]));
      }
      else
      {
         ETG_TRACE_USR4(("CabinASettingListhandler:: vCreateCabinAListUpdate HOUR MODE is false DISABLED CabinAEnDisb_CMG_CMGA2_LatestUpdate_CA[%d]=%d", index, CabinAEnDisb_CMG_CMGA2_LatestUpdate_CA[index]));
         my_cabinA_vec.push_back(boost::make_tuple(IMG_ICON_NORMAL_CA, IMG_ICON_PRESS_CA, IMG_ICON_CMG_CMGA2_DISBABLENORMAL_CA, CabinASettingMainText[index], CabinAEnDisb_CMG_CMGA2_LatestUpdate_CA[index]));
      }
   }
}


/**********************************************************************************************
*FUNCTION: 		 CabinASettingListhandler - UpdateTextColorStatus
*DESCRIPTION: 	 Update of Item Text
*PARAMETER:		 bool *CabinAEnDisbTextOldStatus,bool *CabinAEnDisbTextNewStatus
*RETURNVALUE: 	 void
*
*HISTORY:
*22.04.2022:Prashant BG
*0.1 Initial Revision.
**********************************************************************************************/
void CabinASettingListhandler::UpdateTextColorStatus(bool* CabinAEnDisbTextOldStatus, bool* CabinAEnDisbTextNewStatus)
{
   for (int i = 0; i <= 3; i++)
   {
      CabinAEnDisbTextOldStatus[i] = CabinAEnDisbTextNewStatus[i];
      ETG_TRACE_USR1(("CabinASettingListhandler:: UpdateTextColorStatus CabinAEnDisbTextOldStatus[%d]   %d CabinAEnDisbTextNewStatus[%d] %d", i, CabinAEnDisbTextOldStatus[i], i, CabinAEnDisbTextNewStatus[i]));
   }
}


/**********************************************************************************************
*FUNCTION: 		 CabinASettingListhandler - UpdateBmpIconStringStatus
*DESCRIPTION: 	 Update of Icon
*PARAMETER:		 std::string  *CabinIconOldBmpImage,std::string  *CabinIconNewBmpImage
*RETURNVALUE: 	 void
*
*HISTORY:
*22.04.2022:Prashant BG
*0.1 Initial Revision.
**********************************************************************************************/

void CabinASettingListhandler::UpdateBmpIconStringStatus(std::string*  CabinIconOldBmpImage, std::string*  CabinIconNewBmpImage)
{
   for (int i = 0; i <= 3; i++)
   {
      CabinIconOldBmpImage[i] = CabinIconNewBmpImage[i];
      ETG_TRACE_USR1(("CabinASettingListhandler:: vCreateCabinAListUpdate CabinIconOldBmpImage  =%s ", CabinIconOldBmpImage[i]));
      ETG_TRACE_USR1(("CabinASettingListhandler:: vCreateCabinAListUpdate CabinIconNewBmpImage  =%s ", CabinIconNewBmpImage[i]));
   }
}


/**********************************************************************************************
*FUNCTION: 		 CabinASettingListhandler - getListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 oMsg - Courier message received
*RETURNVALUE: 	 tSharedPtrDataProvider()
*
*HISTORY:
*15.07.2019:Prashant BG

*0.1 Initial Revision.
**********************************************************************************************/
tSharedPtrDataProvider CabinASettingListhandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_COMP(("CabinASettingListhandler:: getListDataProvider: list Id = %d", oMsg.GetListId()));
   switch (oMsg.GetListId())
   {
      case LIST_ID_CABIN_A_MAIN_LIST:
         return getMainViewListDataProvider();
      default:
      {
         break;
      }
   }
   return tSharedPtrDataProvider();
}


/**********************************************************************************************
*FUNCTION: 		 CabinASettingListhandler - getListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 oMsg - Courier message received
*RETURNVALUE: 	 tSharedPtrDataProvider()
*
*HISTORY:
*22.04.2022:Prashant BG
*0.1 Initial Revision.
**********************************************************************************************/
tSharedPtrDataProvider CabinASettingListhandler::getMainViewListDataProvider()
{
   ListDataProviderBuilder listBuilder(LIST_ID_CABIN_A_MAIN_LIST);
   /*Bug-1455486- condition check to find if A2 Glasses are configured or not. Based on that VideoMix Source Option will be shown/hidden*/
   bool b_CmgA2GlassConfiguredStatus_CA = CabinInfoSrvClient::poGetInstance()->getcmgA2GlassConfiguredInfoStatusCA();
   int listcount = 0;
   if (b_CmgA2GlassConfiguredStatus_CA == true)
   {
      listcount = CABINASETTINGLISTCOUNTWITHVIDEOMIXSOURCE;
   }
   else
   {
      listcount = CABINASETTINGLISTCOUNTWITHOUTVIDEOMIXSOURCE;
   }

   for (int index = 0; index <= listcount; index++)
   {
      CabinAsettingMainIconData CabinAitem;

      IMG_CABIN_A_ICON_NORMAL = boost::get<Icon_normal_ca>(my_cabinA_vec[index]);
      IMG_CABIN_A_ICON_TOUCHED = boost::get<Icon_pressed_ca>(my_cabinA_vec[index]);
      IMG_CABIN_A_ICON_DISABLE = boost::get<Icon_disbale_ca>(my_cabinA_vec[index]);  //assign to variable- new

      CABIN_A_MAIN_TEXT = boost::get<CabinAMain_text>(my_cabinA_vec[index]);
      CABIN_A_ENDISB_TEXTIMAGE_FLAG = boost::get<CabinAEnDisb_textimageflag>(my_cabinA_vec[index]);	//assign to variable- new
      ETG_TRACE_USR1(("CabinASettingListhandler:: getMainViewListDataProvider: INDEX =%d, my_cabinA_vec.size() =%d\n", index, my_cabinA_vec.size()));
      CabinAitem.mCabinAMainIconNormalBitmap = ImageLoader::getAssetBitmapImage(IMG_CABIN_A_ICON_NORMAL.c_str());
      CabinAitem.mCabinAMainIconPressedBitmap = ImageLoader::getAssetBitmapImage(IMG_CABIN_A_ICON_TOUCHED.c_str());
      CabinAitem.mCabinAMainIconFocusedBitmap = ImageLoader::getAssetBitmapImage(IMG_CABIN_A_ICON_TOUCHED.c_str());
      CabinAitem.mCabinAMainIconDisbaledBitmap = ImageLoader::getAssetBitmapImage(IMG_CABIN_A_ICON_DISABLE.c_str());//assign to binding- new
      CabinAitem.mCabinAMainNameInfo = CABIN_A_MAIN_TEXT;
      CabinAitem.mCabinAMainActiveTextInfo = CABIN_A_ENDISB_TEXTIMAGE_FLAG; //assign to binding- new

      listBuilder.AddItem(
         index, 	//  - identifies the row
         0UL,   //  - column
         DATA_CONTEXT_TEXT_LIST_ITEM)  //  - overwrites the default data context
      .AddDataBindingUpdater<CabinAsettingMainIconDataBindingSource>(CabinAitem);//1 - Text of the button, should be obtained from Candera.

      ETG_TRACE_USR1(("CabinASettingListhandler::getMainViewListDataProvider CabinAitem.mCabinAMainIconNormalBitmap1= %s \n", CabinAitem.mCabinAMainIconNormalBitmap));
      ETG_TRACE_USR1(("CabinASettingListhandler::getMainViewListDataProvider CabinAitem.mCabinAMainIconPressedBitmap1= %s \n", CabinAitem.mCabinAMainIconPressedBitmap));
      ETG_TRACE_USR1(("CabinASettingListhandler::getMainViewListDataProvider CabinAitem.mCabinAMainIconFocusedBitmap1= %s \n", CabinAitem.mCabinAMainIconFocusedBitmap));
      ETG_TRACE_USR1(("CabinASettingListhandler::getMainViewListDataProvider CabinAitem.mCabinAMainNameInfo1= %s \n", (CabinAitem.mCabinAMainNameInfo).GetCString()));
      ETG_TRACE_USR1(("CabinASettingListhandler::getMainViewListDataProvider CabinAitem.mCabinAMainIconDisbaledBitmap= %s \n", CabinAitem.mCabinAMainIconDisbaledBitmap));
   }
   listcreated = true;
   return listBuilder.CreateDataProvider();
}


bool CabinASettingListhandler::onCourierMessage(const PluginEndStationListUpdateMsg& oMsg)
{
   ETG_TRACE_COMP(("CabinASettingListhandler::PluginUpdateRespMsg Entered"));
   const boost::shared_ptr<EventDataUtility>& dataUtility = oMsg.GetEndStationListData();
   if (NULL != dataUtility.get())
   {
      const std::vector<EventDataItem*>& dataItems = dataUtility->getData();
      ETG_TRACE_USR1(("CabinASettingListhandler:onCourierMessage:PluginEndStationListUpdateMsg dataItems.size() %d", dataItems.size()));
      if (dataItems.size() > 0)
      {
         _currentglassavalStatus = false;
         for (int index = 0; index < dataItems.size(); index++)
         {
            EventDataItem* eventDataItem = dataItems.at(index);
            if (NULL != eventDataItem)
            {
               EventDataItem::Data eventDataVal = eventDataItem->getData();
               std::string strVal = eventDataVal._value._stringValue->c_str();
               ETG_TRACE_USR4(("CabinASettingListhandler::PluginEndStationListUpdateMsg: strVal:  %s", strVal.c_str()));
               if (strVal == "CMG")
               {
                  // _currentglassavalStatus = true;
                  //App::Core::CabinAGlassSettingListhandler::poGetInstance()->startInactivityTimerONStartup(CABIN_A_MEDIAGLASS1_SINK_ID);
                  //App::Core::CabinAGlassSettingListhandler::poGetInstance()->startInactivityTimerONStartup(CABIN_A_MEDIAGLASS2_SINK_ID);
               }
            }
         }
         // vCreateCabinAListUpdate();
      }
   }

   if ((applicationState == true) && (_ActiveView == "AppHmi_System#SysSettingsScenes#SO_SysSettings_CA"))
   {
      ETG_TRACE_USR1(("CabinASettingListhandler::PluginEndStationListUpdateMsg: LIST_ID_CABIN_A_MAIN_LIST list is Available"));
      ListRegistry::s_getInstance().updateList(LIST_ID_CABIN_A_MAIN_LIST);
   }
   return true;
}


void CabinASettingListhandler::enableDisableGlass(bool rxdCurrentglassavalStatus)
{
   /*	_currentglassavalStatus = rxdCurrentglassavalStatus;

    	ETG_TRACE_USR1(("CabinASettingListhandler::enableDisableGlass: _currentglassavalStatus =%d",_currentglassavalStatus));
    	if(rxdCurrentglassavalStatus==true)
    	{
    		App::Core::CabinAGlassSettingListhandler::poGetInstance()->startInactivityTimerONStartup(CABIN_A_MEDIAGLASS1_SINK_ID);
   	App::Core::CabinAGlassSettingListhandler::poGetInstance()->startInactivityTimerONStartup(CABIN_A_MEDIAGLASS2_SINK_ID);
   	//App::Core::CabinAGlassSettingListhandler::poGetInstance()->startInactivityTimerONStartup(CABIN_B_MEDIAGLASS1_SINK_ID);
   	//App::Core::CabinAGlassSettingListhandler::poGetInstance()->startInactivityTimerONStartup(CABIN_B_MEDIAGLASS2_SINK_ID);
    	}
    	vCreateCabinAListUpdate();

    if ((applicationState == true) && (_ActiveView == "AppHmi_System#SysSettingsScenes#SO_SysSettings_CA"))
    {
       ETG_TRACE_USR1(("CabinASettingListhandler::enableDisableGlass: LIST_ID_CABIN_A_MAIN_LIST list AppHmi_System#SysSettingsScenes#SO_SysSettings_CA"));
       ListRegistry::s_getInstance().updateList(LIST_ID_CABIN_A_MAIN_LIST);
    } */
}


bool CabinASettingListhandler::onCourierMessage(const ApplicationStateUpdMsg& oMsg)
{
   ETG_TRACE_COMP(("CabinASettingListhandler::ApplicationStateUpdMsg: applicationState=%d", oMsg.GetState()));
   if (oMsg.GetState() == hmibase::IN_FOREGROUND)
   {
      applicationState = true;
   }
   else
   {
      applicationState = false;
   }
   return false;
}


void CabinASettingListhandler::getActiveView(Candera::String ActiveView)
{
   _ActiveView = ActiveView;
   ETG_TRACE_USR1(("CabinASettingListhandler::getActiveView: _ActiveView=%s", _ActiveView.GetCString()));
}


void CabinASettingListhandler::UpdateVideoMixVisibilitystatus(uint32 systemCategory, uint8 systemStatus)
{
   ETG_TRACE_USR1(("CabinASettingListhandler::UpdateVideoMixVisibilitystatus:systemCategory =%d, systemStatus =%d", systemCategory, systemStatus));
}


//below code is to get the status
bool CabinASettingListhandler::getglassconnectedstatus()
{
   ETG_TRACE_COMP(("CabinASettingListhandler::getglassconnectedstatus _currentglassavalStatus= %d", _currentglassavalStatus));
   return _currentglassavalStatus;
}


void CabinASettingListhandler::UpdateHMIState2HMI(const uint8 HMIState)
{
   _HMIState = HMIState;
   ETG_TRACE_USR1(("CabinASettingListhandler::UpdateHMIState2HMI _HMIState= %d", _HMIState));
   vCreateCabinAListUpdate();
   if ((applicationState == true) && (_ActiveView == "AppHmi_System#SysSettingsScenes#SO_SysSettings_CA"))
   {
      ETG_TRACE_USR1(("CabinASettingListhandler::UpdateCabinASettingListOnCmgChange: LIST_ID_CABIN_A_MAIN_LIST list is Available"));
      ListRegistry::s_getInstance().updateList(LIST_ID_CABIN_A_MAIN_LIST);
   }
}


void CabinASettingListhandler::UpdateCabinASettingListOnCmgChange()
{
   ETG_TRACE_USR1(("CabinASettingListhandler::UpdateCabinASettingListOnCmgChange vCreateCabinAListUpdate()"));
   vCreateCabinAListUpdate();
   if ((applicationState == true) && (_ActiveView == "AppHmi_System#SysSettingsScenes#SO_SysSettings_CA"))
   {
      ListRegistry::s_getInstance().updateList(LIST_ID_CABIN_A_MAIN_LIST);
   }
}


#endif
};


};
