/**************************************************************************************
* @file         : CabinASwivelCalibration.h
* @author       : Sheena Mathew
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (C) 2016 Robert Bosch GmbH
*                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef CABIN_A_SWIVEL_CALIBRATION_H
#define CABIN_A_SWIVEL_CALIBRATION_H


#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
//#include "AppHmi_SystemTypes.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/CourierMessageMapper.h"
//#include "App/Core/ClientHandler/Audio/AudioServiceClient.h"
#include "ProjectPluginMsgs.h"
#include "PluginConstants.h"
#include "Common/PluginClientHandler/PluginClientHandler.h"
#include "System_Types.h"
#include <vector>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea
#include <map>
#include <boost/tuple/tuple.hpp>

using namespace std;


namespace App {
namespace Core {
class CabinASwivelCalibration :  public ListImplementation
{
   public:
      virtual ~CabinASwivelCalibration();
      CabinASwivelCalibration(const CabinASwivelCalibration&);
      CabinASwivelCalibration& operator =(const CabinASwivelCalibration&);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(SendPluginReq)
      ON_COURIER_MESSAGE(PluginUpdateRespMsg)

      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      //Singleton class implementation
      static CabinASwivelCalibration* poGetInstance()
      {
         if (NULL == m_poSwivelCalibration)
         {
            m_poSwivelCalibration = new CabinASwivelCalibration();
         }
         return m_poSwivelCalibration;
      }
   private:
      CabinASwivelCalibration();
      static CabinASwivelCalibration* m_poSwivelCalibration;
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      virtual bool onCourierMessage(const SendPluginReq& oMsg);
      virtual bool onCourierMessage(const PluginUpdateRespMsg& oMsg);

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getSwivelCalibListDataProvider();

      //TimeZone
      bool listcreated;
      unsigned int CurrentrowIdx;
      unsigned int PreviousrowIdx;
      uint16 Glasssize;
      std::vector<std::string> IPAddressVec;
};


}
}


#endif // SYSTEM_SETTINGS_LIST_HANDLER_H
