/**************************************************************************************
* @file         : CabinAGlassSettingListhandler.h
* @author       : Prashant BG
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef CABIN_A_GLASS_SETTINGS_LIST_HANDLER_H
#define CABIN_A_GLASS_SETTINGS_LIST_HANDLER_H

#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
#include "App/Core/ClientHandler/HmiState/HmiStateHandler.h"
//#include "AppHmi_SystemTypes.h"
#include "AudioDefines.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"
#include "PluginConstants.h"  //glass lcd plugin 01.11.2019 *****
#include "Common/PluginClientHandler/PluginClientHandler.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "ProjectPluginMsgs.h"
#include "System_Types.h"
#include "asf/core/Timer.h"


#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea

#define MCPLCDON 0
#define MCPLCDOFF 1

#define SWIVELPOPUPID 3840974510

#define MEDIA_STATE_UNKNOWN 0
#define MEDIA_STATE_CONNECTING 1
#define MEDIA_STATE_CONNECTED 2
#define MEDIA_STATE_DISCONNECTING 3
#define MEDIA_STATE_DISCONNECTED 4
#define MEDIA_STATE_SUSPENDED 5


using namespace std;
namespace App {
namespace Core {
class CabinAGlassSettingListhandler :
   public ListImplementation,
   public ::asf::core::TimerCallbackIF
{
   public:

      virtual ~CabinAGlassSettingListhandler();
      CabinAGlassSettingListhandler(const CabinAGlassSettingListhandler&);
      CabinAGlassSettingListhandler& operator =(const CabinAGlassSettingListhandler&);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)
// "LCD ON AND OFF" Feature based on MCP LONG PRESS and HMI IS Removed
      //   ON_COURIER_MESSAGE(ChangeLCDOnOff4GammaCASettingModevalReqMsg)
      ON_COURIER_MESSAGE(ChangeMonitorUpDown4GammaCASettingModevalReqMsg)
      ON_COURIER_MESSAGE(SwivelModeMsg)
      ON_COURIER_MESSAGE(CockpitModeMsg)
      ON_COURIER_MESSAGE(PopupStatusMsg)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)

      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_DELEGATE_TO_OBJ(_pluginClientHandler)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
      //Singleton class implementation

      // "LCD ON AND OFF" Feature based on MCP LONG PRESS and HMI IS Removed
      virtual bool onCourierMessage(const ChangeMonitorUpDown4GammaCASettingModevalReqMsg& oMsg);
      virtual bool onCourierMessage(const SwivelModeMsg& oMsg);
      virtual bool onCourierMessage(const CockpitModeMsg& oMsg);
      virtual bool onCourierMessage(const PopupStatusMsg& oMsg);

      static CabinAGlassSettingListhandler* poGetInstance()
      {
         if (NULL == m_poCabinAGlassSettingListhandler)
         {
            m_poCabinAGlassSettingListhandler = new CabinAGlassSettingListhandler();
         }
         return m_poCabinAGlassSettingListhandler;
      }
      virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);
      void DropdownClose();

      void CheckPopupActive(int hardkeyState);
      void sendMcpStatusRequestToPlugin(int hardkeyState);
      void sendPassengerDoorStatusRequestToPlugin(uint8 doorStatus);
      void sendDriverDoorStatusRequestToPlugin(uint8 doorStatus);
      void sendContentStatusRequestToPlugin(int status, int sinkid, bool isSourceIgnored);
      void sendMapoutStatusRequestToPlugin(int status, int glasssinkid);
      void UpdateCockpitModeStatus(const uint8 HMIState);
      void startInactivityTimer(int sinkid);
      void startInactivityTimerONStartup(int sinkid);
      void stopInactivityTimer(int sinkid);
   private:
      CabinAGlassSettingListhandler();
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      static CabinAGlassSettingListhandler* m_poCabinAGlassSettingListhandler;
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getMainViewListDataProvider();

      bool isSinkSupported(int sinkid);
      void evaluateAndSendSwivelCommandToAllZones(uint8 status, uint8 key);
      void evaluateAndSendSwivelCommand(int sinkid, uint8 status, uint8 key);
      bool sendSwivelCommandToPlugin(uint8 sinkID, uint8 swivelSelected, uint8 swivelRequest, uint8 lcdOnOffRequest);
      void inactivityTimerCallback(void);

      tSharedPtrDataProvider GetComboGammaMonitorFlipListDataProvider(::Courier::UInt32);

      enLCDOnOffGammaCASettingModeOption _currentlcdpanel4caOption;
      enMonitorUpDownGammaCASettingModeOption _currentmonitorflip4caOption;
      Candera::String _currentmonitorflip4caOptionStr;

      unsigned int rowIdx;

      // Below are common for all zones
      uint8 currentHMISwivelMode ;
      uint8 updatedHMISwivelMode ;
      bool ignoreSourceUpdate;
      bool isPassengerDoorOpen;
      bool isDriverDoorOpen;

      // Below are separate for each zones
      unsigned int currentSwivelStatus[SINK_INVALID];
      unsigned int currentLCDStatus[SINK_INVALID];
      bool isContentActiveInGlass[SINK_INVALID];
      bool isSourceActiveInGlass[SINK_INVALID];
      bool isMapoutActiveInGlass[SINK_INVALID];
      asf::core::Timer _swiveltimer[SINK_INVALID];
      uint8 isInactivityTimerRunning[SINK_INVALID];

      uint8 PopupState;
      PluginClientHandler* _pluginClientHandler;

      void CabinAGammaSingleDropDownUpdateMsg();

      DataBindingItem<SwivelPopupDataBindingSource> oSwivelPopup;
      uint8 lcmUserState;
};


}
}


#endif // SYSTEM_SETTINGS_LIST_HANDLER_H
