/**************************************************************************************
* @file         : CABIN_A_AudioSettingListHandler.h
* @author       : Prashant BG
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (C) 2016 Robert Bosch GmbH
*                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef CABIN_A_AUDIO_SETTINGS_LIST_HANDLER_H
#define CABIN_A_AUDIO_SETTINGS_LIST_HANDLER_H

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
//#include "AppHmi_SystemTypes.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"

#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "Common/PluginClientHandler/PluginClientHandler.h"
#include "PluginConstants.h"
#endif

//#include "App/Core/ClientHandler/Audio/AudioServiceClient.h"
#include "System_Types.h"
#include <vector>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea
#include <map>

#define VARIANT_S_FTR_ENABLE_COACH_FEATURE
//#define VARIANT_S_FTR_ENABLE_AUX
#define VARIANT_S_FTR_ENABLE_SPEED_LIMIT

#define MIN_MIC_BEEP_VOLUME 0
#define MAX_MIC_BEEP_VOLUME 39
#define PLUS_SIGN   1
#define MINUS_SIGN -1
#define COLUMN_BUTTON_MINUS 1
#define COLUMN_BUTTON_PLUS  2
#define CABINA_SINKID 3
#define AUDIO_LIST_SIZE  7
using namespace std;
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
namespace App {
namespace Core {
class CabinAAudioSettingListHandler :  public ListImplementation
{
   public:

      virtual ~CabinAAudioSettingListHandler();
      CabinAAudioSettingListHandler(const CabinAAudioSettingListHandler&);
      CabinAAudioSettingListHandler& operator =(const CabinAAudioSettingListHandler&);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)
#ifndef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)

      ON_COURIER_MESSAGE(FactoryResetSMBeep)
#endif
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
      //Singleton class implementation

      static CabinAAudioSettingListHandler* poGetInstance()
      {
         if (NULL == m_pocabinAaudioSettingListHandler)
         {
            m_pocabinAaudioSettingListHandler = new CabinAAudioSettingListHandler();
         }
         return m_pocabinAaudioSettingListHandler;
      }
      void setMainSinkSoundProperty(const uint16& mtypeproperty, const uint32& mvalue);

      void vPerformCabinASinkSoundPropertyBassUpdate(const uint16& sinkId, const uint16& soundproperty, const uint16& value);
      void printVector(const std::vector<int>& n);
      std::vector<int> vecOfValues;
      /*Fix for Bug 1354816- Function to send Beep Volume to Plugin*/
      void NotifyMicBeepVolumeAfterGuiStartUp();
#ifndef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
      virtual bool onCourierMessage(const	 FactoryResetSMBeep& oMsg);
#endif
   private:
      CabinAAudioSettingListHandler();
      static CabinAAudioSettingListHandler* m_pocabinAaudioSettingListHandler;
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getMainViewListDataProvider();

      //int32_t updatedval;
#ifndef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
      int _audiotypesign;
      int32_t listUpdateNeeded;
      uint16 m_caaudiopropertytype, m_capvtmodmixpropertytype ;
      uint8 cabinAmodmixvoltype;
      int _audiobtntype;
#endif

      map<int, uint16> m_ListCASndSpectoServAudSpec;
      map<int, int16> m_ListtypetoCAAudSpecVolUpd;

      uint16 micBeepValue;
      unsigned long index;
      bool listcreated;
      void vCabinASpecPriModMixVolincrementdecrementvalue(int rxprimodmixvoltype, int16* PriModMix_vol_val, int feature);
      string m_bass;
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      uint32 CheckAudioButtonType(unsigned int RxdAudioColumnBtn, signed int RxdAudioType);
      DataBindingItem<CAAudiolevelUpdateItemDataBindingSource> _audio4calevelUpdateItem;
      DataBindingItem<CAMICBeepAudiolevelUpdateItemDataBindingSource> _audio4micbeepcalevelUpdateItem;
      uint16 InitMicBeepVolume();
      bool CheckMicBeepVolButtonTypeNdValueUpdate(uint8 RxdMICBeepColumnBtn);
      bool performMICBeepVolButtonUpdate(signed int RxdMicBtntype);
      void UpdateMicValue2Gui(uint16 RxddpCtMicBeepVal);
      void UpdateMicBeepValue2Plugin(uint16 RxddpGuiCtMicBeepVal);
      uint32 CheckCabinModMixVolButtonType(unsigned int RxdCabinModMixVolColumnBtn);
      void onCreateCAMaplistUpdate();
      void vUpdateDatatoMasterPlugin(uint16 value);
};


}
}


#endif
#endif // SYSTEM_SETTINGS_LIST_HANDLER_H
