/**************************************************************************************
* @file         : CabinAAudioSettingListHandler.cpp
* @author       : Prashant BG
* @addtogroup   : AppHmi_System
* @brief        :
* @copyright    : (C) 2016 Robert Bosch GmbH
*                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "gui_std_if.h"
#include "hmi_trace_if.h"
#endif

#include <string>
//#include "util/StrUtf8.h"
#include "CabinAAudioSettingListHandler.h"
#include "App/Core/ClientHandler/Audio/AudioServiceClient.h"
#include "App/datapool/SystemDataPoolConfig.h"
#include <cstdlib>
#include <vector>
#include <iterator>
#include <algorithm>
#define CTRLBLOCK_NAME_SETTINGS_FADERSETTINGS "FaderSetting"

#include "App/Core/Utils/CabinAUtility.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::CabinAAudioSettingListHandler::
#include "trcGenProj/Header/CabinAAudioSettingListHandler.cpp.trc.h"
#endif

namespace App {
namespace Core {

CabinAAudioSettingListHandler* CabinAAudioSettingListHandler::m_pocabinAaudioSettingListHandler = NULL;


//const char* LISTITEMTEMPLATE4AUDCA[6] = {"listTplate_BtnIncDecBar", "listTplate_BtnIncDecBar", "listTplate_BtnLftRgtBar", "listTplate_BtnIncDecBar", "listTplate_BtnIncDecBar", "listTplate_BtnIncDecBar"};

const char* LISTITEMTEMPLATE4AUDCA[AUDIO_LIST_SIZE] = {"listTplate_BtnIncDecBar", "listTplate_BtnIncDecBar", "listTplate_BtnIncDecBar", "listTplate_BtnIncDecBar", "listTplate_BtnIncDecBar", "listTplate_BtnIncDecBar", "listTplate_BtnIncDecBarMicBeep"};

//Candera::String  CASoundSettingText[6] = {Candera::String(TextId_0x159D), Candera::String(TextId_0x159F), Candera::String(TextId_0x15A1), Candera::String(TextId_0x15A3), Candera::String(TextId_0x15A5), Candera::String(TextId_0x15A7)};

Candera::String  CASoundSettingText[AUDIO_LIST_SIZE] = {Candera::String(TextId_0x159D), Candera::String(TextId_0x159F), Candera::String(TextId_0x1978), Candera::String(TextId_0x15A3), Candera::String(TextId_0x15A5), Candera::String(TextId_0x15A7), Candera::String(TextId_0x1A06)};

#define COLUMN_BUTTON_MINUS 1
#define COLUMN_BUTTON_PLUS  2


/************************************************************************
*FUNCTION: 		 CabinAAudioSettingListHandler - Constructor
*DESCRIPTION: 	 default constructor of the System setting Listhadler will be created
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*27.3.2018:Prashant BG

*0.1 Initial Revision.
************************************************************************/

CabinAAudioSettingListHandler::CabinAAudioSettingListHandler()
{
   ETG_TRACE_COMP(("CabinAAudioSettingListHandler:: Constructor is called"));
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_CABIN_A_AUDIO_LIST, this);
#ifndef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
   _audiobtntype = COLUMN_BUTTON_PLUS;
   cabinAmodmixvoltype = COLUMN_BUTTON_PLUS;
   _audiotypesign = 0;
   listUpdateNeeded = false;
   onCreateCAMaplistUpdate();
   m_caaudiopropertytype = 0;
   m_capvtmodmixpropertytype = 0;
   AudioServiceClient::poGetInstance()->OnStartupRequestSinkId4CAaudio();
   listcreated = false;

#endif
   listcreated = false;
   index = 0;
   m_bass = "";
   m_ListtypetoCAAudSpecVolUpd.clear();
#ifndef VARIANT_S_FTR_ENABLE_AUX_SUPPORT

   UpdateMicValue2Gui(InitMicBeepVolume());
#endif
}


uint16 CabinAAudioSettingListHandler::InitMicBeepVolume()
{
   micBeepValue = 0;
   uint16 _DpCtMicBeepVal ;
   micBeepValue = SystemDataPoolConfig::getInstance()-> getMICBeepVol() ;
   ETG_TRACE_USR4(("CabinAAudioSettingListHandler:: InitMicBeepVolume: micBeepValue read from datapool = %d ", micBeepValue));
   // Below Condition Confirms if _DpCtMicBeepVal is out of range -> will reset micBeepValue _DpCtMicBeepVal to default value
   // coverity fix- Second condition removed as this has no effect. micBeepvolume is unsigned int which wont hold negative value
   if ((micBeepValue > (MAX_MIC_BEEP_VOLUME + 2)))// || (micBeepValue < (uint16) MIN_MIC_BEEP_VOLUME))
   {
      micBeepValue = 16;
      SystemDataPoolConfig::getInstance()->setMICBeepVol(micBeepValue) ;
      _DpCtMicBeepVal = SystemDataPoolConfig::getInstance()-> getMICBeepVol() ;
      micBeepValue = _DpCtMicBeepVal;
      ETG_TRACE_USR4(("CabinAAudioSettingListHandler:: InitMicBeepVolume: After settings Default value micBeepValue = %d ", micBeepValue));
   }
   return micBeepValue;
}


/************************************************************************
*FUNCTION: 		 CabinAAudioSettingListHandler - Destructor
*DESCRIPTION: 	 Allocated resources such as memory will be released here
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*27.3.2018:Prashant BG

*0.1 Initial Revision.
************************************************************************/

CabinAAudioSettingListHandler::~CabinAAudioSettingListHandler()
{
   ETG_TRACE_COMP(("CabinAAudioSettingListHandler:: Destructor is called"));
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_CABIN_A_AUDIO_LIST);
}


#ifndef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
void CabinAAudioSettingListHandler::onCreateCAMaplistUpdate()
{
   ETG_TRACE_COMP(("CabinAAudioSettingListHandler:: onCreateMaplistUpdate is called"));
   m_ListCASndSpectoServAudSpec[BASS_CA] = MSP_SOUND_BASS_RELATIVE;
   m_ListCASndSpectoServAudSpec[TREBBLE_CA] = MSP_SOUND_TREBBLE_RELATIVE;
   m_ListCASndSpectoServAudSpec[FADER_CA] = MSP_SOUND_FADER_RELATIVE;
   m_ListCASndSpectoServAudSpec[MINVOL_CA] =  MSP_ENTSTARTUPMINVOLUME_RELATIVE ;
   m_ListCASndSpectoServAudSpec[MAXVOL_CA] = MSP_ENTSTARTUPMAXVOLUME_RELATIVE;
   m_ListCASndSpectoServAudSpec[CABINMODMIXVOL_CA] = MSP_PRIVATE_MODE_MIX_VOLUME;
}


#endif
/**********************************************************************************************
*FUNCTION: 		 CabinAAudioSettingListHandler - getListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 oMsg - Courier message received
*RETURNVALUE: 	 tSharedPtrDataProvider()
*
*HISTORY:
*27.3.2018:Prashant BG

*0.1 Initial Revision.
**********************************************************************************************/

tSharedPtrDataProvider CabinAAudioSettingListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_COMP(("CabinAAudioSettingListHandler:: getListDataProvider: List Id = %d", oMsg.GetListId()));
   switch (oMsg.GetListId())
   {
      case LIST_ID_CABIN_A_AUDIO_LIST:
         return getMainViewListDataProvider();
   }
   return tSharedPtrDataProvider();
}


tSharedPtrDataProvider CabinAAudioSettingListHandler::getMainViewListDataProvider()
{
   ListDataProviderBuilder listBuilder(LIST_ID_CABIN_A_AUDIO_LIST);
   int updatedval;
   for (index = 0; index < AUDIO_LIST_SIZE ; ++index)
   {
      ETG_TRACE_USR4(("CabinAAudioSettingListHandler:: getMainViewListDataProvider:index = %d ", index));
      updatedval = m_ListtypetoCAAudSpecVolUpd.find(index)->second;
      stringstream bout;
      bout << updatedval ;
      m_bass = bout.str();

      if (index != (AUDIO_LIST_SIZE - 1))
      {
         (*_audio4calevelUpdateItem).mCAAudiolevelIndex = m_bass.c_str();
         _audio4calevelUpdateItem.MarkAllItemsModified();
         _audio4calevelUpdateItem.SendUpdate(true);

         listBuilder.AddItem(static_cast<int>(index), 0UL, LISTITEMTEMPLATE4AUDCA[index])
         .AddData(CASoundSettingText[index])
         .AddId(index, COLUMN_BUTTON_MINUS)     // -
         .AddId(index, COLUMN_BUTTON_PLUS)// +
         .AddDataBindingUpdater<CAAudiolevelUpdateItemDataBindingSource>(_audio4calevelUpdateItem);
      }
      else if (index == ((AUDIO_LIST_SIZE - 1)))
      {
         (*_audio4micbeepcalevelUpdateItem).mCAMicBeepAudiolevelIndex = m_bass.c_str();
         _audio4micbeepcalevelUpdateItem.MarkAllItemsModified();
         _audio4micbeepcalevelUpdateItem.SendUpdate(true);

         listBuilder.AddItem(static_cast<int>(index), 0UL, LISTITEMTEMPLATE4AUDCA[index])
         .AddData(CASoundSettingText[index])
         .AddId(index, COLUMN_BUTTON_MINUS)     // -
         .AddId(index, COLUMN_BUTTON_PLUS)// +
         .AddDataBindingUpdater<CAMICBeepAudiolevelUpdateItemDataBindingSource>(_audio4micbeepcalevelUpdateItem);
      }

      ETG_TRACE_COMP(("CabinAAudioSettingListHandler:: getMainViewListDataProvider FIRST After is called Index  Value =%d %d %d", index, m_ListtypetoCAAudSpecVolUpd.find(index)->second, m_ListtypetoCAAudSpecVolUpd[index]));
   }
   listcreated = true;
   return listBuilder.CreateDataProvider();
}


#ifndef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
bool CabinAAudioSettingListHandler::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   bool msgProcessed = false;

   unsigned int rowIdx = (unsigned int)oMsg.GetHdl(); //Check For the Row Clicked

   if (oMsg.GetListId() == LIST_ID_CABIN_A_AUDIO_LIST)
   {
      ETG_TRACE_USR1(("CabinAAudioSettingListHandler::ButtonListItemUpdMsg:LIST_ID_CABIN_A_AUDIO_LIST: Reaction = %d, rowIdx = %d, column VALUE =%d\n", oMsg.GetReaction(), oMsg.GetHdl(), oMsg.GetSubHdl()))
      if (oMsg.GetReaction() == enRelease)
      {
         switch (rowIdx)
         {
            case BASS_CA:
            {
               if (oMsg.GetSubHdl() != 0)
               {
                  listUpdateNeeded = CheckAudioButtonType(oMsg.GetSubHdl(), BASS_CA) ; // Function to check the Btn Click "+" OR "-"
               }
            }
            break;
            case TREBBLE_CA:
            {
               if (oMsg.GetSubHdl() != 0)
               {
                  listUpdateNeeded = CheckAudioButtonType(oMsg.GetSubHdl(), TREBBLE_CA) ; // Function to check the Btn Click "+" OR "-"
               }
            }
            break;
            case FADER_CA:
            {
               if (oMsg.GetSubHdl() != 0)
               {
                  listUpdateNeeded = CheckAudioButtonType(oMsg.GetSubHdl(), FADER_CA) ; // Function to check the Btn Click "+" OR "-"
               }
            }
            break;
            case MINVOL_CA:
            {
               if (oMsg.GetSubHdl() != 0)
               {
                  listUpdateNeeded = CheckAudioButtonType(oMsg.GetSubHdl(), MINVOL_CA) ; // Function to check the Btn Click "+" OR "-"
               }
            }
            break;
            case MAXVOL_CA:
            {
               if (oMsg.GetSubHdl() != 0)
               {
                  listUpdateNeeded = CheckAudioButtonType(oMsg.GetSubHdl(), MAXVOL_CA) ; // Function to check the Btn Click "+" OR "-"
               }
            }
            break;

            case CABINMODMIXVOL_CA:
            {
               if (oMsg.GetSubHdl() != 0)
               {
                  listUpdateNeeded = CheckCabinModMixVolButtonType(oMsg.GetSubHdl()) ; // Function to check the Btn Click "+" OR "-"
               }
            }
            break;
            case MICBEEPVOL_CA:
            {
               ETG_TRACE_COMP(("CabinAAudioSettingListHandler::in ButtonListItemUpdMsg MICBEEPVOL_CA Column VALUE =%d\n", oMsg.GetSubHdl()));
               if (oMsg.GetSubHdl() != 0)
               {
                  listUpdateNeeded = CheckMicBeepVolButtonTypeNdValueUpdate(oMsg.GetSubHdl()) ; // Function to check the Btn Click "+" OR "-"
               }
            }
            break;
            default:
            {
               ETG_TRACE_USR4(("CabinAAudioSettingListHandler::DEFAULT "));// Do Nothing
            }
            break;
         }
         msgProcessed = true;
      }
   }
   return msgProcessed;
}


bool CabinAAudioSettingListHandler::CheckMicBeepVolButtonTypeNdValueUpdate(uint8 RxdMICBeepColumnBtn)
{
   if ((RxdMICBeepColumnBtn == COLUMN_BUTTON_MINUS) && (micBeepValue > MIN_MIC_BEEP_VOLUME))
   {
      micBeepValue--;
   }
   else if ((RxdMICBeepColumnBtn == COLUMN_BUTTON_PLUS) && (micBeepValue < (MAX_MIC_BEEP_VOLUME + 1))) // change added
   {
      micBeepValue++;
   }
   SystemDataPoolConfig::getInstance()->setMICBeepVol(micBeepValue) ;
   uint16 _DpCtMicBeepVal = SystemDataPoolConfig::getInstance()-> getMICBeepVol() ;
   ETG_TRACE_COMP(("CabinAAudioSettingListHandler::CheckMicBeepVolButtonTypeNdValueUpdate ON EXIT _DpCtMicBeepVal micBeepValue RxdMICBeepColumnBtn= %d %d %d\n", _DpCtMicBeepVal, micBeepValue, RxdMICBeepColumnBtn));
   UpdateMicValue2Gui(_DpCtMicBeepVal);
   return true;
}


void CabinAAudioSettingListHandler::UpdateMicValue2Gui(uint16 RxddpCtMicBeepVal)
{
   ListDataProviderBuilder listBuilder(LIST_ID_CABIN_A_AUDIO_LIST);
   m_ListtypetoCAAudSpecVolUpd[6] = RxddpCtMicBeepVal;
   ETG_TRACE_COMP(("void CabinAAudioSettingListHandler::UpdateMicValue2Gui RxddpCtMicBeepVal m_ListtypetoCAAudSpecVolUpd[6],listcreated %d %d %d\n", RxddpCtMicBeepVal, m_ListtypetoCAAudSpecVolUpd[6], listcreated));
   UpdateMicBeepValue2Plugin(m_ListtypetoCAAudSpecVolUpd[6]);
   if (listcreated == true)
   {
      ListRegistry::s_getInstance().updateList(LIST_ID_CABIN_A_AUDIO_LIST);
   }
}


/*Fix for Bug 1354816- Function to send Beep Volume to Master Plugin*/
void CabinAAudioSettingListHandler::NotifyMicBeepVolumeAfterGuiStartUp()
{
   uint16 DpMicBeepVolume;
   DpMicBeepVolume = SystemDataPoolConfig::getInstance()-> getMICBeepVol() ;
   ETG_TRACE_USR4(("GuiStartupFinishedUpdMsg DpMicBeepVolume Received from Datapool: %d", DpMicBeepVolume));
   UpdateMicBeepValue2Plugin(DpMicBeepVolume);
}


void  CabinAAudioSettingListHandler::UpdateMicBeepValue2Plugin(uint16 RxddpGuiCtMicBeepVal)
{
   boost::shared_ptr<EventDataUtility> pluginData(EventDataUtility::newEventDataUtility());
   if (NULL != pluginData.get())
   {
      ETG_TRACE_COMP(("CabinAAudioSettingListHandler::UpdateMicBeepValue2Plugin PLUGIN_NAME_MASTER, CTRBLOCK_NAME_BEEP_VOLUME,CABINA_SINKID,RxddpGuiCtMicBeepVal = %d %d %d %d", PLUGIN_NAME_MASTER, CTRBLOCK_NAME_BEEP_VOLUME, CABINA_SINKID, RxddpGuiCtMicBeepVal));
      pluginData->addEventData(static_cast<uint8>(CABINA_SINKID));//cabin-A sink-id
      pluginData->addEventData(static_cast<uint8>(RxddpGuiCtMicBeepVal));//fader step value
      POST_MSG((COURIER_MESSAGE_NEW(PluginCommandReqMsg)(PLUGIN_NAME_MASTER, CTRBLOCK_NAME_BEEP_VOLUME, pluginData)));
   }
}


uint32 CabinAAudioSettingListHandler::CheckAudioButtonType(unsigned int RxdAudioColumnBtn, signed int RxdAudioType)
{
//Function to Identify the Column Click (ie BTN + OR BTN -)
   if (RxdAudioColumnBtn == COLUMN_BUTTON_MINUS)
   {
      _audiobtntype = COLUMN_BUTTON_MINUS;
      _audiotypesign = MINUS_SIGN;
   }
   else if (RxdAudioColumnBtn == COLUMN_BUTTON_PLUS)
   {
      _audiobtntype = COLUMN_BUTTON_PLUS;
      _audiotypesign = PLUS_SIGN;
   }
   m_caaudiopropertytype = m_ListCASndSpectoServAudSpec.find(RxdAudioType)->second; //Find the Sound Property    //MSP_SOUND_BASS=1;

   // _audiotypesign =-1 or + 1 and Rsound property
   ETG_TRACE_USR4(("CabinAAudioSettingListHandler::vAudSpecBassincrementdecrementvalue <_audiotypesign> <m_caaudiopropertytype>=%d nd %d and %d", _audiotypesign, m_caaudiopropertytype, CABINA_SINKID));

   /*---------------------------------Commented During Testing---------------------------------*/
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(CABINA_SINKID, m_caaudiopropertytype, _audiotypesign);
   return true;
}


/************************************************************************
*FUNCTION: 		 AudioSettingListHandler - vPerformCabinASinkSoundPropertyBassUpdate
*DESCRIPTION: 	 Update the chnaged values to HMI from the service

*PARAMETER:
*RETURNVALUE: 	 None
*
*
************************************************************************/
//void AudioSettingListHandler::vPerformCabinASinkSoundPropertyBassUpdate(uint16 sinkId,  uint16 soundproperty,  int value)

void CabinAAudioSettingListHandler::vPerformCabinASinkSoundPropertyBassUpdate(const uint16& sinkId, const uint16& soundproperty, const uint16& value)
{
   ETG_TRACE_COMP(("CabinAAudioSettingListHandler::vPerformCabinASinkSoundPropertyBassUpdate:soundproperty:%d::Value:%d", soundproperty, value));
   ListDataProviderBuilder listBuilder(LIST_ID_CABIN_A_AUDIO_LIST);

   if (soundproperty == MSP_SOUND_BASS)
   {
      m_ListtypetoCAAudSpecVolUpd[0] = value;
   }
   else if (soundproperty == MSP_SOUND_TREBBLE)
   {
      m_ListtypetoCAAudSpecVolUpd[1] = value;
   }
   else if (soundproperty == MSP_SOUND_FADER)
   {
      m_ListtypetoCAAudSpecVolUpd[2] = value;
      vUpdateDatatoMasterPlugin(value);
   }
   else if (soundproperty == MSP_SOUND_MIN_VOLUME)
   {
      m_ListtypetoCAAudSpecVolUpd[3] = value;
   }
   else if (soundproperty == MSP_SOUND_MAX_VOLUME)
   {
      m_ListtypetoCAAudSpecVolUpd[4] = value;
   }
   else if (soundproperty == MSP_PRIVATE_MODE_MIX_VOLUME)
   {
      m_ListtypetoCAAudSpecVolUpd[5] = value;
   }
   else
   {
   }
   if (listcreated == true)
   {
      ListRegistry::s_getInstance().updateList(LIST_ID_CABIN_A_AUDIO_LIST);
   }
}


uint32 CabinAAudioSettingListHandler::CheckCabinModMixVolButtonType(unsigned int RxdCabinModMixVolColumnBtn)
{
   ETG_TRACE_COMP(("CabinAAudioSettingListHandler::CheckCabinModMixVolButtonType: RxdCabinModMixVolColumnBtn = %d, Before m_ListtypetoCAAudSpecVolUpd[5]=%d", RxdCabinModMixVolColumnBtn, m_ListtypetoCAAudSpecVolUpd[5]));
   //Function to Identify the Column Click (ie BTN + OR BTN -)
   if (RxdCabinModMixVolColumnBtn == COLUMN_BUTTON_MINUS)
   {
      cabinAmodmixvoltype = COLUMN_BUTTON_MINUS;
   }
   else if (RxdCabinModMixVolColumnBtn == COLUMN_BUTTON_PLUS)
   {
      cabinAmodmixvoltype = COLUMN_BUTTON_PLUS;
   }
   vCabinASpecPriModMixVolincrementdecrementvalue(cabinAmodmixvoltype, &m_ListtypetoCAAudSpecVolUpd[5], CABINMODMIXVOL_CA);
   ETG_TRACE_USR1(("CabinAAudioSettingListHandler::CheckCabinModMixVolButtonType: After m_ListtypetoCAAudSpecVolUpd[5]=%d", m_ListtypetoCAAudSpecVolUpd[5]));
   return true;
}


void CabinAAudioSettingListHandler::vCabinASpecPriModMixVolincrementdecrementvalue(int rxprimodmixvoltype, int16* PriModMix_vol_val, int feature)
{
   ETG_TRACE_COMP(("CabinAAudioSettingListHandler::vCabinASpecPriModMixVolincrementdecrementvalue: feature =%d, rxprimodmixvoltype = %d, PriModMix_vol_val = %d", feature, rxprimodmixvoltype, *PriModMix_vol_val));
   int16 value = *PriModMix_vol_val;
   int UpdatedPriModMixVolval = 0;
   if ((feature == CABINMODMIXVOL_CA))
   {
      CabinAUtility cabinAUtility;
      UpdatedPriModMixVolval = cabinAUtility.updateVolumeValue(rxprimodmixvoltype, value);
   }
   else
   {
      //Do Nothing
   }
   m_capvtmodmixpropertytype = m_ListCASndSpectoServAudSpec.find(CABINMODMIXVOL_CA)->second; //Find the Sound Property    //MSP_SOUND_BASS=1;
   ETG_TRACE_USR1(("AudioSettingListHandler::vAudSpecPriModMixVolincrementdecrementvalue: UpdatedPriModMixVolval = %d, m_capvtmodmixpropertytype =%d", UpdatedPriModMixVolval, m_capvtmodmixpropertytype));
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(CABINA_SINKID, m_capvtmodmixpropertytype, UpdatedPriModMixVolval);
}


bool CabinAAudioSettingListHandler::onCourierMessage(const	 FactoryResetSMBeep& /* oMsg */)
{
   ETG_TRACE_USR1(("CabinAAudioSettingListHandler::FactoryResetSMBeep"));
   uint8 micBeepValue = 16;
   SystemDataPoolConfig::getInstance()->setMICBeepVol(micBeepValue) ;
   uint16 _DpCtMicBeepVal = SystemDataPoolConfig::getInstance()-> getMICBeepVol() ;
   ETG_TRACE_COMP(("CabinAAudioSettingListHandler::FactoryResetSMBeep ON EXIT _DpCtMicBeepVal micBeepValue = %d %d\n", _DpCtMicBeepVal, micBeepValue));
   UpdateMicValue2Gui(_DpCtMicBeepVal);
   return true;
}


void CabinAAudioSettingListHandler::vUpdateDatatoMasterPlugin(uint16 value)
{
   ETG_TRACE_COMP(("CabinAAudioSettingListHandler::vUpdateDatatoMasterPlugin: value = %d", value));
   boost::shared_ptr<EventDataUtility> pluginData(EventDataUtility::newEventDataUtility());
   int8 int_value = static_cast<int8>(value);
   uint8 factor = 0;
   uint8 StepValue = 0;
   if (int_value < 0)
   {
      factor = 1;
      StepValue = (int_value * (-1));
   }
   else
   {
      factor = 2;
      StepValue = int_value;
   }
   if (NULL != pluginData.get())
   {
      pluginData->addEventData(static_cast<uint8>(CABINA_SINKID));//cabin-A sink-id
      pluginData->addEventData(StepValue);//fader step value
      pluginData->addEventData(factor);//factor = 1 -> if stepvalue is less than zero ; factor = 2 -> if stepvalue greater than zero

      POST_MSG((COURIER_MESSAGE_NEW(PluginCommandReqMsg)(PLUGIN_NAME_SETTINGS, CTRLBLOCK_NAME_SETTINGS_FADERSETTINGS, pluginData)));
   }
}


#endif
}


}
