/***************************************************************************
* Copyright(c) 2018-2018 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/* ***************************************************************************************
* FILE:AudioSpdDepdentVolCntrlRBtn.h
* SW-COMPONENT:  Audio Speed Dependent Volume Control Component
* DESCRIPTION:  AudioSpdDepdentVolCntrlRBtn.h is part of Audio Setting reference/demo/test applications
* Author 	: PGA5COB (Prashant BG)
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef AUDIOSPDDEPDENTVOLCNTRLRBTN_H
#define AUDIOSPDDEPDENTVOLCNTRLRBTN_H
#include "AppHmi_SystemStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_SystemMessages.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include <string>

#define mSpdProperty 15
#define mOffSpdValue  0
#define mLvl1SpdValue 1
#define mLvl2SpdValue 2
#define mLvl3SpdValue 3

namespace App {
namespace Core {

class AudioSpdDepdentVolCntrlRBtn
{
   private:
      AudioSpdDepdentVolCntrlRBtn();
   public:
      static AudioSpdDepdentVolCntrlRBtn* m_poAudioSpdDepdentVolCntrlRBtn;
      static AudioSpdDepdentVolCntrlRBtn* poGetInstance();

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)

      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(LevelOff)
      ON_COURIER_MESSAGE(LevelOne)
      ON_COURIER_MESSAGE(LevelTwo)
      ON_COURIER_MESSAGE(LevelThree)

      COURIER_MSG_MAP_END()
      void UpdateSpdDepVolCntrlTglStatus(int UpdateSpdLvlVal);
      virtual ~AudioSpdDepdentVolCntrlRBtn();
      virtual bool onCourierMessage(const LevelOff& oMsg);
      virtual bool onCourierMessage(const LevelOne& oMsg);
      virtual bool onCourierMessage(const LevelTwo& oMsg);
      virtual bool onCourierMessage(const LevelThree& oMsg);
      bool onCourierMessage(const Courier::StartupMsg& oMsg);

      bool Init();
      DataBindingItem<SpeedDependentVolumeControlDataBindingSource> oSpeedDependentVolumeControl;
};


}
}


#endif // _HMI_MODEL_COMPONENT_H
