/* ***************************************************************************************
* FILE:          AudioSpdDepdentVolCntrlRBtn.cpp
* SW-COMPONENT:  Audio Speed Dependent Volume Control Component
*  DESCRIPTION:  AudioSpdDepdentVolCntrlRBtn.cpp is part of Audio Setting reference/demo/test applications
* Author 	: PGA5COB (Prashant BG)
*    COPYRIGHT:  (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

//#include "AppUtils/StrUtf8.h"
#include "AppHmi_SystemStateMachine.h"
#include "App/Core/ClientHandler/Audio/AudioServiceClient.h"
#include "AudioSpdDepdentVolCntrlRBtn.h"
#include "hmi_trace_if.h"
#include<iostream>
#include <string>
#include <cstdlib>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::DataModel::AudioSpdDepdentVolCntrlRBtn
#include "trcGenProj/Header/AudioSpdDepdentVolCntrlRBtn.cpp.trc.h"
#endif

using namespace App::Core;
using namespace std;


AudioSpdDepdentVolCntrlRBtn* AudioSpdDepdentVolCntrlRBtn::m_poAudioSpdDepdentVolCntrlRBtn = NULL;
AudioSpdDepdentVolCntrlRBtn::AudioSpdDepdentVolCntrlRBtn()
{
   ETG_TRACE_COMP(("AudioSpdDepdentVolCntrlRBtn::Constructor"));
}


AudioSpdDepdentVolCntrlRBtn* AudioSpdDepdentVolCntrlRBtn::poGetInstance()
{
   ETG_TRACE_COMP(("AudioSpdDepdentVolCntrlRBtn::poGetInstance"));
   if (NULL == m_poAudioSpdDepdentVolCntrlRBtn)
   {
      m_poAudioSpdDepdentVolCntrlRBtn = new AudioSpdDepdentVolCntrlRBtn();
   }
   return m_poAudioSpdDepdentVolCntrlRBtn;
}


AudioSpdDepdentVolCntrlRBtn::~AudioSpdDepdentVolCntrlRBtn()
{
   ETG_TRACE_COMP(("AudioSpdDepdentVolCntrlRBtn::Destructor"));
}


bool AudioSpdDepdentVolCntrlRBtn::onCourierMessage(const LevelOff& /* oMsg */)
{
   ETG_TRACE_COMP(("AudioSpdDepdentVolCntrlRBtn::LevelOff: mSpdProperty = %d, mOffSpdValue = %d", mSpdProperty, mOffSpdValue));
   UpdateSpdDepVolCntrlTglStatus(mOffSpdValue);
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, mSpdProperty, mOffSpdValue);
   return true;
}


bool AudioSpdDepdentVolCntrlRBtn::onCourierMessage(const LevelTwo& /* oMsg */)
{
   ETG_TRACE_COMP(("AudioSpdDepdentVolCntrlRBtn::LevelTwo: mSpdProperty = %d, mLvl2SpdValue = %d", mSpdProperty, mLvl2SpdValue));
   UpdateSpdDepVolCntrlTglStatus(mLvl2SpdValue);
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, mSpdProperty, mLvl2SpdValue);
   return true;
}


bool AudioSpdDepdentVolCntrlRBtn::onCourierMessage(const LevelOne& /* oMsg */)
{
   ETG_TRACE_COMP(("AudioSpdDepdentVolCntrlRBtn::LevelOne: mSpdProperty = %d, mLvl1SpdValue = %d", mSpdProperty, mLvl1SpdValue));
   UpdateSpdDepVolCntrlTglStatus(mLvl1SpdValue);
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, mSpdProperty, mLvl1SpdValue);
   return true;
}


bool AudioSpdDepdentVolCntrlRBtn::onCourierMessage(const LevelThree& /* oMsg */)
{
   ETG_TRACE_COMP(("AudioSpdDepdentVolCntrlRBtn::LevelThree: mSpdProperty = %d, mLvl3SpdValue = %d", mSpdProperty, mLvl3SpdValue));
   UpdateSpdDepVolCntrlTglStatus(mLvl3SpdValue);
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, mSpdProperty, mLvl3SpdValue);
   return true;
}


void AudioSpdDepdentVolCntrlRBtn :: UpdateSpdDepVolCntrlTglStatus(int UpdateSpdLvlVal)
{
   ETG_TRACE_COMP(("AudioSpdDepdentVolCntrlRBtn :: UpdateSpdDepVolCntrlTglStatus: UpdateSpdLvlVal=%d", UpdateSpdLvlVal));
   (*oSpeedDependentVolumeControl).mToggleOFF = false;
   (*oSpeedDependentVolumeControl).mToggleLVL1 = false;
   (*oSpeedDependentVolumeControl).mToggleLVL2 = false;
   (*oSpeedDependentVolumeControl).mToggleLVL3 = false;

   (*oSpeedDependentVolumeControl).mColorOFF = false;
   (*oSpeedDependentVolumeControl).mColorLVL1 = false;
   (*oSpeedDependentVolumeControl).mColorLVL2 = false;
   (*oSpeedDependentVolumeControl).mColorLVL3 = false;

   if (UpdateSpdLvlVal == mOffSpdValue)
   {
      (*oSpeedDependentVolumeControl).mToggleOFF = true;
      (*oSpeedDependentVolumeControl).mColorOFF = true;
   }
   else if (UpdateSpdLvlVal == mLvl1SpdValue)
   {
      (*oSpeedDependentVolumeControl).mToggleLVL1 = true;
      (*oSpeedDependentVolumeControl).mColorLVL1 = true;
   }
   else if (UpdateSpdLvlVal == mLvl2SpdValue)
   {
      (*oSpeedDependentVolumeControl).mToggleLVL2 = true;
      (*oSpeedDependentVolumeControl).mColorLVL2 = true;
   }
   else if (UpdateSpdLvlVal == mLvl3SpdValue)
   {
      (*oSpeedDependentVolumeControl).mToggleLVL3 = true;
      (*oSpeedDependentVolumeControl).mColorLVL3 = true;
   }
   else
   {
      /*Do Nothing*/
   }
   oSpeedDependentVolumeControl.MarkAllItemsModified();
   oSpeedDependentVolumeControl.SendUpdate(true);
}


bool AudioSpdDepdentVolCntrlRBtn::onCourierMessage(const Courier::StartupMsg& /* oMsg */)
{
   ETG_TRACE_COMP(("AudioSpdDepdentVolCntrlRBtn::StartupMsg"));
   return true;
}
