/**************************************************************************************
* @file         : AudioSettingListHandler.cpp
* @author       : Sheena Mathew
* @addtogroup   : AppHmi_System
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "gui_std_if.h"
#include <string>
//#include "util/StrUtf8.h"
#include "AudioSettingListHandler.h"
#include "App/Core/ClientHandler/Audio/AudioServiceClient.h"
#include <cstdlib>
#include "hmi_trace_if.h"
#include <vector>
#include <iterator>
#include <algorithm>
#ifndef VARIANT_S_FTR_ENABLE_NAVIGATION
#include "dp_generic_if.h"
#define DP_S_IMPORT_INTERFACE_KDS_FI
#include "dp_kds_if.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::AudioSettingListHandler::
#include "trcGenProj/Header/AudioSettingListHandler.cpp.trc.h"
#endif
//#define VARIANT_S_FTR_ENABLE_COACH_AUDIO
//#define VARIANT_S_FTR_ENABLE_AUX
//#define VARIANT_S_FTR_ENABLE_SPEED_LIMIT
//#define VARIANT_S_FTR_ENABLE_NAVIGATION
namespace App {
namespace Core {

AudioSettingListHandler* AudioSettingListHandler::m_poaudioSettingListHandler = NULL;


static const char* const DATA_CONTEXT_TEXT_BUTTON_LIST_ITEM = "TextButton_ListItem";
static const char* const DATA_CONTEXT_COMBOBOX_LIST_ITEM = "Combobox_ListItem";
static const char* const DATA_CONTEXT_TEXT_LIST_ITEM = "Layer_Sound";


Candera::String AuxLevelStrings[3]  = {Candera::String(TextId_0x057E), Candera::String(TextId_0x057D), Candera::String(TextId_0x057C)};

const char* LISTITEMTEMPLATE[9] = {"listTplate_BtnBassBar_1", "listTplate_BtnBassBar", "listTplate_BtnBalanceBar", "listTplate_BtnFaderBar", "NULL", "NULL", "listTplate_BtnBassBar", "listTplate_BtnBassBar", "listTplate_BtnBassBar"};
#if defined VARIANT_S_FTR_ENABLE_COACH_AUDIO
Candera::String  SystemSettingText[12] = {Candera::String(TextId_0x0572), Candera::String(TextId_0x0579), Candera::String(TextId_0x0571), Candera::String(TextId_0x0578), Candera::String(TextId_0x0577), Candera::String(TextId_0x0582), Candera::String(TextId_0x14A3), Candera::String(TextId_0x14A5), Candera::String(TextId_0x14A7), Candera::String(TextId_0x14A9), Candera::String(TextId_0x057B)}; 	//SystemBeef- Candera::String(TextId_0x057F)};
#endif
#if !defined VARIANT_S_FTR_ENABLE_COACH_AUDIO
Candera::String  SystemSettingText[10] = {Candera::String(TextId_0x0572), Candera::String(TextId_0x0579), Candera::String(TextId_0x0571), Candera::String(TextId_0x0578), Candera::String(TextId_0x0577), Candera::String(TextId_0x0582), Candera::String(TextId_0x14A3), Candera::String(TextId_0x14A5), Candera::String(TextId_0x057B), Candera::String(TextId_0x057F)};
#endif
//Candera::String  SystemSettingText[12] = {Candera::String(TextId_0x0572), Candera::String(TextId_0x0579), Candera::String(TextId_0x0571), Candera::String(TextId_0x0578), Candera::String(TextId_0x0577), Candera::String(TextId_0x0582), Candera::String(TextId_0x14A3), Candera::String(TextId_0x14A5), Candera::String(TextId_0x14A7), Candera::String(TextId_0x14A9)/*"Private mode"*/, Candera::String(TextId_0x057B), Candera::String(TextId_0x057F)};
#define COLUMN_BUTTON_MINUS 1
#define COLUMN_BUTTON_PLUS  2


/************************************************************************
*FUNCTION: 		 AudioSettingListHandler - Constructor
*DESCRIPTION: 	 default constructor of the System setting Listhadler will be created
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*27.3.2018:Sheena Mathew

*0.1 Initial Revision.
************************************************************************/

AudioSettingListHandler::AudioSettingListHandler()
{
   ETG_TRACE_COMP(("AudioSettingListHandler:: Constructor is called"));
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SYSTEM_AUDIO_LIST, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SYSTEM_AUDIO_AUXLEVEL_LIST, this);
   rowIdx = 0;
   basstype = COLUMN_BUTTON_PLUS;
   trebbletype = COLUMN_BUTTON_PLUS;
   primodmixvoltype = COLUMN_BUTTON_PLUS;
   maxvoltype = COLUMN_BUTTON_PLUS;
   minvoltype = COLUMN_BUTTON_PLUS;
   fadertype = COLUMN_BUTTON_PLUS;
   balancetype = COLUMN_BUTTON_PLUS;
   u8ExtAmpConfig = 0;
   u8CarModelType = 0;
   basstypesign = 0;
   listUpdateNeeded = false;
   updatedval = 0;
   MinvalueDef = 5;
   MaxvalueDef = 20;
   index = 0;
   AudioIndex = 0;
   m_propertytype = 0;
   _currentAuxlevelOption = Quiet;
   m_ListtypetoAudSpecVolUpd[7] = 16;

   listcreated = false;

   onCreateMaplistUpdate();
}


/************************************************************************
*FUNCTION: 		 AudioSettingListHandler - Destructor
*DESCRIPTION: 	 Allocated resources such as memory will be released here
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*27.3.2018:Sheena Mathew

*0.1 Initial Revision.
************************************************************************/

AudioSettingListHandler::~AudioSettingListHandler()
{
   ETG_TRACE_COMP(("AudioSettingListHandler:: Destructor is called"));
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SYSTEM_AUDIO_LIST);
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SYSTEM_AUDIO_AUXLEVEL_LIST);
   listcreated = false;
}


void AudioSettingListHandler::onCreateMaplistUpdate()
{
   ETG_TRACE_COMP(("AudioSettingListHandler:: onCreateMaplistUpdate is called"));
   m_ListAudSpectoServAudSpec[BASS] = MSP_SOUND_BASS_RELATIVE;
   m_ListAudSpectoServAudSpec[TREBBLE] = MSP_SOUND_TREBBLE_RELATIVE;
   m_ListAudSpectoServAudSpec[BALANCE] = MSP_SOUND_BALANCE_RELATIVE;
   m_ListAudSpectoServAudSpec[FADER] =  MSP_SOUND_FADER_RELATIVE ;
   m_ListAudSpectoServAudSpec[MINVOL] = MSP_ENTSTARTUPMINVOLUME_RELATIVE;
   m_ListAudSpectoServAudSpec[MAXVOL] = MSP_ENTSTARTUPMAXVOLUME_RELATIVE;
#ifdef VARIANT_S_FTR_ENABLE_COACH_AUDIO
   m_ListAudSpectoServAudSpec[PRIVATEMODMIXVOL] = MSP_PRIVATE_MODE_MIX_VOLUME;
#endif
}


/**********************************************************************************************
*FUNCTION: 		 AudioSettingListHandler - getListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 oMsg - Courier message received
*RETURNVALUE: 	 tSharedPtrDataProvider()
*
*HISTORY:
*27.3.2018:Sheena Mathew

*0.1 Initial Revision.
**********************************************************************************************/

tSharedPtrDataProvider AudioSettingListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_COMP(("AudioSettingListHandler:: getListDataProvider: List Id = %d", oMsg.GetListId()));
   switch (oMsg.GetListId())
   {
      case LIST_ID_SYSTEM_AUDIO_LIST:
         return getMainViewListDataProvider();
#ifdef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
      case LIST_ID_SYSTEM_AUDIO_AUXLEVEL_LIST:
         return GetCombo1ListDataProvider(oMsg.GetListId());
#endif
   }
   return tSharedPtrDataProvider();
}


////Function to get the ExtAmplifier(Function name to be checked if its genereted or not)
#ifdef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
unsigned int AudioSettingListHandler::getDpExtAmp()
{
   ETG_TRACE_COMP(("AudioSettingListHandler:: getDpExtAmp"));
   return u8ExtAmpConfig;
}


unsigned int AudioSettingListHandler::getDpCarModel()
{
   ETG_TRACE_COMP(("AudioSettingListHandler:: getDpCarModel"));
   return 0;
}


#endif


tSharedPtrDataProvider AudioSettingListHandler::getMainViewListDataProvider()
{
   ListDataProviderBuilder listBuilder(LIST_ID_SYSTEM_AUDIO_LIST);
   int updatedval;
   for (index = 0; index < 3; ++index)
   {
      updatedval = m_ListtypetoAudSpecVolUpd.find(index)->second;
      stringstream bout;
      bout << updatedval ;
      m_bass = bout.str();
      (*_basslevelUpdateItem).mBasslevelIndex = m_bass.c_str();
      _basslevelUpdateItem.MarkAllItemsModified();
      _basslevelUpdateItem.SendUpdate(true);

      listBuilder.AddItem(static_cast<int>(index), 0UL, LISTITEMTEMPLATE[index])
      .AddData(SystemSettingText[index])
      .AddId(index, COLUMN_BUTTON_MINUS)     // -
      .AddId(index, COLUMN_BUTTON_PLUS)// +
      .AddDataBindingUpdater<BasslevelUpdateItemDataBindingSource>(_basslevelUpdateItem);

      ETG_TRACE_USR2(("AudioSettingListHandler::getMainViewListDataProvider: index = %d, (*_basslevelUpdateItem).mBasslevelIndex = %s", index, ((*_basslevelUpdateItem).mBasslevelIndex).GetCString()));
   }
   /*FADER ListBuilder*/
#ifdef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
   uint16 u16VehicleType = static_cast<uint16>(getDpCarModel());
   ETG_TRACE_USR1(("AudioSettingListHandler::getMainViewListDataProvider: u16VehicleType = %d", u16VehicleType));
   if (u16VehicleType == 1)
   {
      updatedval = m_ListtypetoAudSpecVolUpd.find(3)->second;
      stringstream bout;
      bout << updatedval ;
      m_bass = bout.str();
      (*_basslevelUpdateItem).mBasslevelIndex = m_bass.c_str();
      _basslevelUpdateItem.MarkAllItemsModified();
      _basslevelUpdateItem.SendUpdate(true);
      listBuilder.AddItem(
         FADER, 	//  - identifies the row
         0UL,   //  - column
         LISTITEMTEMPLATE[3])  //  - overwrites the default data context
      .AddData(SystemSettingText[3])
      .AddId(3, COLUMN_BUTTON_MINUS)     // -
      .AddId(3, COLUMN_BUTTON_PLUS)// +
      .AddDataBindingUpdater<BasslevelUpdateItemDataBindingSource>(_basslevelUpdateItem);
   }
   u8ExtAmpConfig = static_cast<uint8>(getDpExtAmp());
   ETG_TRACE_USR1(("AudioSettingListHandler:: getMainViewListDataProvider: u8ExtAmpConfig = %d", u8ExtAmpConfig));
   if (u8ExtAmpConfig == 0)
   {
      listBuilder.AddItem(
         EQUILISERPRESET, 	//  - identifies the row
         0UL,   //  - column
         DATA_CONTEXT_TEXT_BUTTON_LIST_ITEM)  //  - overwrites the default data context
      .AddData(SystemSettingText[4]);//1 - Text of the button

      listBuilder.AddItem(
         SPDVOL, 	//  - identifies the row
         0UL,   //  - column
         DATA_CONTEXT_TEXT_BUTTON_LIST_ITEM)  //  - overwrites the default data context
      .AddData(SystemSettingText[5]);//1 - Text of the button, should be obtained from Candera.
   }
#endif
#ifdef VARIANT_S_FTR_ENABLE_COACH_AUDIO
   listBuilder.AddItem(
      EQUILISERPRESET, 	//  - identifies the row
      0UL,   //  - column
      DATA_CONTEXT_TEXT_BUTTON_LIST_ITEM)  //  - overwrites the default data context
   .AddData(SystemSettingText[4]);//1 - Text of the button
   listBuilder.AddItem(
      SPDVOL, 	//  - identifies the row
      0UL,   //  - column
      DATA_CONTEXT_TEXT_BUTTON_LIST_ITEM)  //  - overwrites the default data context
   .AddData(SystemSettingText[5]);//1 - Text of the button, should be obtained from Candera.
#endif
#ifdef VARIANT_S_FTR_ENABLE_COACH_AUDIO
   for (index = 6; index < 9; ++index)
   {
      updatedval = m_ListtypetoAudSpecVolUpd.find(index)->second;
      stringstream bout;
      bout << updatedval ;
      m_bass = bout.str();
      (*_basslevelUpdateItem).mBasslevelIndex = m_bass.c_str();

      _basslevelUpdateItem.MarkAllItemsModified();
      _basslevelUpdateItem.SendUpdate(true);

      listBuilder.AddItem(static_cast<int>(index), 0UL, LISTITEMTEMPLATE[index])
      .AddData(SystemSettingText[index])
      .AddId(index, COLUMN_BUTTON_MINUS)     // -
      .AddId(index, COLUMN_BUTTON_PLUS)// +
      .AddDataBindingUpdater<BasslevelUpdateItemDataBindingSource>(_basslevelUpdateItem);

      ETG_TRACE_USR2(("AudioSettingListHandler:: getMainViewListDataProvider: Index = %d, updatedval = %d", index, updatedval));
   }

   listBuilder.AddItem(
      PRIVATEMODE, 	//  - identifies the row
      0UL,   //  - column
      DATA_CONTEXT_TEXT_BUTTON_LIST_ITEM)  //  - overwrites the default data context
   .AddData(SystemSettingText[9]);//1 - Text of the button, should be obtained from Candera.
   ETG_TRACE_USR1(("AudioSettingListHandler:: getMainViewListDataProvider AFTER is called=%s", SystemSettingText[10]));


#endif
#ifndef VARIANT_S_FTR_ENABLE_COACH_AUDIO
   for (index = 6; index < 8; ++index)
   {
      updatedval = m_ListtypetoAudSpecVolUpd.find(index)->second;
      stringstream bout;
      bout << updatedval ;
      m_bass = bout.str();
      (*_basslevelUpdateItem).mBasslevelIndex = m_bass.c_str();

      _basslevelUpdateItem.MarkAllItemsModified();
      _basslevelUpdateItem.SendUpdate(true);

      listBuilder.AddItem(static_cast<int>(index), 0UL, LISTITEMTEMPLATE[index])
      .AddData(SystemSettingText[index])
      .AddId(index, COLUMN_BUTTON_MINUS)     // -
      .AddId(index, COLUMN_BUTTON_PLUS)// +
      .AddDataBindingUpdater<BasslevelUpdateItemDataBindingSource>(_basslevelUpdateItem);

      ETG_TRACE_USR2(("AudioSettingListHandler:: getMainViewListDataProvider: Index = %d, updatedval = %d", index, updatedval));
   }
#endif
#ifdef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
   listBuilder.AddExpandableItem(static_cast<int>(AUXLEVEL),            //   - identifies the row
                                 LIST_ID_SYSTEM_AUDIO_AUXLEVEL_LIST,                          //   - used to automatically toggle the visibility of the combobox dropdown list when the combox button is clicked
                                 "Combobox_ListItem")         //   - overwrites the default data context
   .AddData(SystemSettingText[8]) //1 - Text of the combobox button.
   .AddData(LIST_ID_SYSTEM_AUDIO_AUXLEVEL_LIST)				 //2 - ListId of the combobox dropdown list.
   .AddData(_currentAuxlevelOptionStr);
#endif
   listcreated = true;
   return listBuilder.CreateDataProvider();
}


bool AudioSettingListHandler::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   ListDataProviderBuilder modifiedListItems(LIST_ID_SYSTEM_AUDIO_LIST);
   bool msgProcessed = false;
   rowIdx = (unsigned int)oMsg.GetHdl(); //Check For the Row Clicked
   if (oMsg.GetListId() == LIST_ID_SYSTEM_AUDIO_LIST)
   {
      ETG_TRACE_USR1(("AudioSettingListHandler::ButtonListItemUpdMsg:LIST_ID_SYSTEM_AUDIO_LIST: Reaction = %d,rowIdx = %d, column index = %d", oMsg.GetReaction(), rowIdx, oMsg.GetSubHdl()));
      CloseAuxdropdown();
      if (oMsg.GetReaction() == enRelease)
      {
         switch (rowIdx)
         {
            case BASS:
            {
               if (oMsg.GetSubHdl() != 0)
               {
                  listUpdateNeeded = CheckBassButtonType(oMsg.GetSubHdl()) ; // Function to check the Btn Click "+" OR "-"
               }
            }
            break;
            case TREBBLE:
            {
               if (oMsg.GetSubHdl() != 0)
               {
                  listUpdateNeeded = CheckTrebbleButtonType(oMsg.GetSubHdl()) ; // Function to check the Btn Click "+" OR "-"
               }
            }
            break;
            case BALANCE:
            {
               if (oMsg.GetSubHdl() != 0)
               {
                  listUpdateNeeded = CheckBalanceButtonType(oMsg.GetSubHdl()) ; // Function to check the Btn Click "+" OR "-"
               }
            }
            break;
#ifndef VARIANT_S_FTR_ENABLE_NAVIGATION
            case FADER:
            {
               if (oMsg.GetSubHdl() != 0)
               {
                  listUpdateNeeded = CheckFaderButtonType(oMsg.GetSubHdl()) ; // Function to check the Btn Click "+" OR "-"
               }
            }
            break;
#endif
            case MINVOL:
            {
               if (oMsg.GetSubHdl() != 0)
               {
                  listUpdateNeeded = CheckMinVolButtonType(oMsg.GetSubHdl()) ; // Function to check the Btn Click "+" OR "-"
               }
            }
            break;
            case MAXVOL:
            {
               if (oMsg.GetSubHdl() != 0)
               {
                  listUpdateNeeded = CheckMaxVolButtonType(oMsg.GetSubHdl()) ; // Function to check the Btn Click "+" OR "-"
               }
            }
            break;
#ifdef VARIANT_S_FTR_ENABLE_COACH_AUDIO
            case PRIVATEMODMIXVOL:
            {
               if (oMsg.GetSubHdl() != 0)
               {
                  listUpdateNeeded = CheckPriModMixVolButtonType(oMsg.GetSubHdl()) ; // Function to check the Btn Click "+" OR "-"
               }
            }
            break;
#endif


            default:
            {
               // Do Nothing
            }
            break;
         }
         msgProcessed = true;
      }
   }
   return msgProcessed;
}


void AudioSettingListHandler::CloseAuxdropdown()
{
   ETG_TRACE_COMP(("AudioSettingListHandler::CloseAuxdropdown"));
   Candera::DropdownChangeType clkmanddChange;
   if (rowIdx != 8)
   {
      clkmanddChange = Candera::DropdownChangeClose;
      DropdownChangeMsg* ddToggleMsg_AuxFormat = COURIER_MESSAGE_NEW(DropdownChangeMsg)(clkmanddChange, 109);
      ETG_TRACE_USR1(("AudioSettingListHandler::CloseAuxdropdown: clkmanddChange = %d, ddToggleMsg_AuxFormat = %d", clkmanddChange, ddToggleMsg_AuxFormat));
      if (ddToggleMsg_AuxFormat != NULL)
      {
         ddToggleMsg_AuxFormat->Post();
      }
   }
}


uint32 AudioSettingListHandler::CheckBassButtonType(unsigned int RxdBassColumnBtn)
{
   ETG_TRACE_COMP(("AudioSettingListHandler::CheckBassButtonType: RxdBassColumnBtn = %d, Before m_ListtypetoAudSpecVolUpd[0]=%d", RxdBassColumnBtn, m_ListtypetoAudSpecVolUpd[0]));
//Function to Identify the Column Click (ie BTN + OR BTN -)
   if (RxdBassColumnBtn == COLUMN_BUTTON_MINUS)
   {
      basstype = COLUMN_BUTTON_MINUS;
      basstypesign = MINUS_SIGN;
   }
   else if (RxdBassColumnBtn == COLUMN_BUTTON_PLUS)
   {
      basstype = COLUMN_BUTTON_PLUS;
      basstypesign = PLUS_SIGN;
   }
   m_propertytype = m_ListAudSpectoServAudSpec.find(BASS)->second; //Find the Sound Property    //MSP_SOUND_BASS=1;
   ETG_TRACE_USR1(("AudioSettingListHandler::CheckBassButtonType: m_propertytype = %d ", m_propertytype));
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, m_propertytype, basstypesign);
   return true;
}


uint32 AudioSettingListHandler::CheckTrebbleButtonType(unsigned int RxdTrebbleColumnBtn)
{
   ETG_TRACE_COMP(("AudioSettingListHandler::CheckTrebbleButtonType: RxdTrebbleColumnBtn = %d, Before m_ListtypetoAudSpecVolUpd[1]=%d", RxdTrebbleColumnBtn, m_ListtypetoAudSpecVolUpd[1]));
//Function to Identify the Column Click (ie BTN + OR BTN -)
   if (RxdTrebbleColumnBtn == COLUMN_BUTTON_MINUS)
   {
      trebbletype = COLUMN_BUTTON_MINUS;
      basstypesign = MINUS_SIGN;
   }
   else if (RxdTrebbleColumnBtn == COLUMN_BUTTON_PLUS)
   {
      trebbletype = COLUMN_BUTTON_PLUS;
      basstypesign = PLUS_SIGN;
   }
   m_propertytype = m_ListAudSpectoServAudSpec.find(TREBBLE)->second; //Find the Sound Property    //MSP_SOUND_BASS=1;
   ETG_TRACE_USR1(("AudioSettingListHandler::CheckTrebbleButtonType: m_propertytype=%d",  m_propertytype));
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, m_propertytype, basstypesign);
   return true;
}


uint32 AudioSettingListHandler::CheckBalanceButtonType(unsigned int RxdBalanceColumnBtn)
{
   ETG_TRACE_COMP(("AudioSettingListHandler::CheckBalanceButtonType: RxdBalanceColumnBtn = %d, Before m_ListtypetoAudSpecVolUpd[2]=%d", RxdBalanceColumnBtn, m_ListtypetoAudSpecVolUpd[2]));
   //Function to Identify the Column Click (ie BTN + OR BTN -)
   if (RxdBalanceColumnBtn == COLUMN_BUTTON_MINUS)
   {
      balancetype = COLUMN_BUTTON_MINUS;
      basstypesign = MINUS_SIGN;
   }
   else if (RxdBalanceColumnBtn == COLUMN_BUTTON_PLUS)
   {
      balancetype = COLUMN_BUTTON_PLUS;
      basstypesign = PLUS_SIGN;
   }
   m_propertytype = m_ListAudSpectoServAudSpec.find(BALANCE)->second; //Find the Sound Property    //MSP_SOUND_BASS=1;
   ETG_TRACE_USR1(("AudioSettingListHandler::CheckBalanceButtonType: m_propertytype =%d",  m_propertytype));
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, m_propertytype, basstypesign);
   return true;
}


uint32 AudioSettingListHandler::CheckFaderButtonType(unsigned int RxdFaderColumnBtn)
{
   ETG_TRACE_COMP(("AudioSettingListHandler::CheckFaderButtonType: RxdFaderColumnBtn = %d, Before m_ListtypetoAudSpecVolUpd[3]=%d", RxdFaderColumnBtn, m_ListtypetoAudSpecVolUpd[3]));
   //Function to Identify the Column Click (ie BTN + OR BTN -)
   if (RxdFaderColumnBtn == COLUMN_BUTTON_MINUS)
   {
      fadertype = COLUMN_BUTTON_MINUS;
      basstypesign = MINUS_SIGN;
   }
   else if (RxdFaderColumnBtn == COLUMN_BUTTON_PLUS)
   {
      fadertype = COLUMN_BUTTON_PLUS;
      basstypesign = PLUS_SIGN;
   }
   m_propertytype = m_ListAudSpectoServAudSpec.find(FADER)->second; //Find the Sound Property    //MSP_SOUND_BASS=1;
   ETG_TRACE_USR1(("AudioSettingListHandler::CheckFaderButtonType: m_propertytype = %d", m_propertytype));
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, m_propertytype, basstypesign);
   return true;
}


uint32 AudioSettingListHandler::CheckMinVolButtonType(unsigned int RxdMinVolColumnBtn)
{
   ETG_TRACE_COMP(("AudioSettingListHandler::CheckMinVolButtonType: RxdMinVolColumnBtn = %d, Before m_ListtypetoAudSpecVolUpd[6]=%d", RxdMinVolColumnBtn, m_ListtypetoAudSpecVolUpd[6]));
   //Function to Identify the Column Click (ie BTN + OR BTN -)
   if (RxdMinVolColumnBtn == COLUMN_BUTTON_MINUS)
   {
      minvoltype = COLUMN_BUTTON_MINUS;
      basstypesign = MINUS_SIGN;
   }
   else if (RxdMinVolColumnBtn == COLUMN_BUTTON_PLUS)
   {
      minvoltype = COLUMN_BUTTON_PLUS;
      basstypesign = PLUS_SIGN;
   }
   m_propertytype = m_ListAudSpectoServAudSpec.find(MINVOL)->second; //Find the Sound Property    //MSP_SOUND_BASS=1;
   ETG_TRACE_USR1(("AudioSettingListHandler::CheckMinVolButtonType: m_propertytype = %d ", m_propertytype));
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, m_propertytype, basstypesign);
   return true;
}


uint32 AudioSettingListHandler::CheckMaxVolButtonType(unsigned int RxdMaxVolColumnBtn)
{
   ETG_TRACE_COMP(("AudioSettingListHandler::CheckMaxVolButtonType: RxdMaxVolColumnBtn = %d, Before m_ListtypetoAudSpecVolUpd[7]=%d", RxdMaxVolColumnBtn, m_ListtypetoAudSpecVolUpd[7]));
   //Function to Identify the Column Click (ie BTN + OR BTN -)
   if (RxdMaxVolColumnBtn == COLUMN_BUTTON_MINUS)
   {
      maxvoltype = COLUMN_BUTTON_MINUS;
      basstypesign = MINUS_SIGN;
   }
   else if (RxdMaxVolColumnBtn == COLUMN_BUTTON_PLUS)
   {
      maxvoltype = COLUMN_BUTTON_PLUS;
      basstypesign = PLUS_SIGN;
   }
   m_propertytype = m_ListAudSpectoServAudSpec.find(MAXVOL)->second; //Find the Sound Property    //MSP_SOUND_BASS=1;
   ETG_TRACE_USR1(("AudioSettingListHandler::CheckMaxVolButtonType: m_propertytype = %d ", m_propertytype));
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, m_propertytype, basstypesign);
   return true;
}


uint32 AudioSettingListHandler::CheckPriModMixVolButtonType(unsigned int RxdPriModMixVolColumnBtn)
{
   ETG_TRACE_COMP(("AudioSettingListHandler::CheckPriModMixVolButtonType: RxdPriModMixVolColumnBtn = %d, Before Btn Click m_ListtypetoAudSpecVolUpd[8]=%d", RxdPriModMixVolColumnBtn, m_ListtypetoAudSpecVolUpd[8]));
   //Function to Identify the Column Click (ie BTN + OR BTN -)
   if (RxdPriModMixVolColumnBtn == COLUMN_BUTTON_MINUS)
   {
      primodmixvoltype = COLUMN_BUTTON_MINUS;
   }
   else if (RxdPriModMixVolColumnBtn == COLUMN_BUTTON_PLUS)
   {
      primodmixvoltype = COLUMN_BUTTON_PLUS;
   }
#ifdef VARIANT_S_FTR_ENABLE_COACH_AUDIO
   vAudSpecPriModMixVolincrementdecrementvalue(primodmixvoltype, &m_ListtypetoAudSpecVolUpd[8], PRIVATEMODMIXVOL);
   ETG_TRACE_USR1(("AudioSettingListHandler::CheckPriModMixVolButtonType: m_ListtypetoAudSpecVolUpd[8]=%d", m_ListtypetoAudSpecVolUpd[8]));
#endif
   return true;
}


void AudioSettingListHandler::vAudSpecBassincrementdecrementvalue(int rxbasstype, int* Bass_vol_val, int feature)
{
   ETG_TRACE_COMP(("AudioSettingListHandler::vAudSpecBassincrementdecrementvalue: rxbasstype = %d, feature=%d, Bass_vol_val =%d", rxbasstype, feature, *Bass_vol_val));
   int UpdatedBassval ;
   if ((feature == BASS))
   {
      if ((rxbasstype == COLUMN_BUTTON_PLUS) && (*Bass_vol_val < 9))
      {
         ++*Bass_vol_val;
      }
      else if ((rxbasstype == COLUMN_BUTTON_MINUS) && (*Bass_vol_val > -9))
      {
         --*Bass_vol_val;
      }
   }
   else
   {
      /*Do Nothing*/
   }
   UpdatedBassval = *Bass_vol_val;
   m_propertytype = m_ListAudSpectoServAudSpec.find(BASS)->second; //Find the Sound Property    //MSP_SOUND_BASS=1;
   ETG_TRACE_USR1(("AudioSettingListHandler::vAudSpecBassincrementdecrementvalue: m_propertytype=%d", m_propertytype));
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, m_propertytype, UpdatedBassval);
}


void AudioSettingListHandler::vAudSpecTrebbleincrementdecrementvalue(int rxtrebbletype, int* Trebble_vol_val, int feature)
{
   ETG_TRACE_COMP(("AudioSettingListHandler::vAudSpecTrebbleincrementdecrementvalue: rxtrebbletype = %d, feature=%d, Trebble_vol_val =%d", rxtrebbletype, feature, *Trebble_vol_val));
   int UpdatedTrebbleval ;
   if ((feature == TREBBLE))
   {
      if ((rxtrebbletype == COLUMN_BUTTON_PLUS) && (*Trebble_vol_val < 9))
      {
         ++*Trebble_vol_val;
      }
      else if ((rxtrebbletype == COLUMN_BUTTON_MINUS) && (*Trebble_vol_val > -9))
      {
         --*Trebble_vol_val;
      }
   }
   else
   {
      //Do Nothing
   }
   UpdatedTrebbleval = *Trebble_vol_val;
   m_propertytype = m_ListAudSpectoServAudSpec.find(TREBBLE)->second; //Find the Sound Property    //MSP_SOUND_BASS=1;
   ETG_TRACE_USR1(("AudioSettingListHandler::vAudSpecTrebbleincrementdecrementvalue: Trebble_vol_val=%d, m_propertytype=%d", *Trebble_vol_val, m_propertytype));
}


void AudioSettingListHandler::vAudSpecBalanceincrementdecrementvalue(int rxbalancetype, int* Balance_vol_val, int feature)
{
   ETG_TRACE_COMP(("AudioSettingListHandler::vAudSpecBalanceincrementdecrementvalue: rxbalancetype = %d, feature=%d, Balance_vol_val =%d", rxbalancetype, feature, *Balance_vol_val));
   int UpdatedBalanceval ;
   if ((feature == BALANCE))
   {
      if ((rxbalancetype == COLUMN_BUTTON_PLUS) && (*Balance_vol_val < 9))
      {
         ++*Balance_vol_val;
      }
      else if ((rxbalancetype == COLUMN_BUTTON_MINUS) && (*Balance_vol_val > -9))
      {
         --*Balance_vol_val;
      }
   }
   UpdatedBalanceval = *Balance_vol_val;
   m_propertytype = m_ListAudSpectoServAudSpec.find(BALANCE)->second; //Find the Sound Property    //MSP_SOUND_BASS=1;
   ETG_TRACE_USR1(("AudioSettingListHandler::vAudSpecBalanceincrementdecrementvalue: Balance_vol_val=%d, m_propertytype=%d", *Balance_vol_val, m_propertytype));
}


void AudioSettingListHandler::vAudSpecFaderincrementdecrementvalue(int rxfadertype, int* Fader_vol_val, int feature)
{
   ETG_TRACE_COMP(("AudioSettingListHandler::vAudSpecFaderincrementdecrementvalue: rxfadertype = %d, feature=%d, Fader_vol_val =%d", rxfadertype, feature, *Fader_vol_val));
   int UpdatedFaderval ;
   if ((feature == FADER))
   {
      if ((rxfadertype == COLUMN_BUTTON_PLUS) && (*Fader_vol_val < 9))
      {
         ++*Fader_vol_val;
      }
      else if ((rxfadertype == COLUMN_BUTTON_MINUS) && (*Fader_vol_val > -9))
      {
         --*Fader_vol_val;
      }
   }
   UpdatedFaderval = *Fader_vol_val;
   m_propertytype = m_ListAudSpectoServAudSpec.find(FADER)->second; //Find the Sound Property    //MSP_SOUND_BASS=1;
   ETG_TRACE_USR1(("AudioSettingListHandler::vAudSpecFaderincrementdecrementvalue: Fader_vol_val=%d, m_propertytype =%d", *Fader_vol_val, m_propertytype));
}


void AudioSettingListHandler::vAudSpecMinVolincrementdecrementvalue(int rxminvoltype, int* Min_vol_val, int feature)
{
   ETG_TRACE_COMP(("AudioSettingListHandler::vAudSpecMinVolincrementdecrementvalue: rxminvoltype = %d, feature=%d, Min_vol_val =%d", rxminvoltype, feature, *Min_vol_val));
   int UpdatedMinVolval ;
   if ((feature == MINVOL))
   {
      if ((rxminvoltype == COLUMN_BUTTON_PLUS) && (*Min_vol_val < 15))
      {
         ++*Min_vol_val;
      }
      else if ((rxminvoltype == COLUMN_BUTTON_MINUS) && (*Min_vol_val > 0))
      {
         --*Min_vol_val;
      }
   }
   else
   {
      //Do Nothing
   }
   UpdatedMinVolval = *Min_vol_val;
   m_propertytype = m_ListAudSpectoServAudSpec.find(MINVOL)->second; //Find the Sound Property    //MSP_SOUND_BASS=1;
   ETG_TRACE_USR1(("AudioSettingListHandler::vAudSpecMinVolincrementdecrementvalue: Min_vol_val=%d, m_propertytype =%d", *Min_vol_val, m_propertytype));
}


void AudioSettingListHandler::vAudSpecMaxVolincrementdecrementvalue(int rxmaxvoltype, int* Max_vol_val, int feature)
{
   ETG_TRACE_COMP(("AudioSettingListHandler::vAudSpecMaxVolincrementdecrementvalue: rxmaxvoltype = %d, feature=%d, Max_vol_val =%d", rxmaxvoltype, feature, *Max_vol_val));
   int UpdatedMaxVolval = 0 ;
   if ((feature == MAXVOL))
   {
      if ((rxmaxvoltype == COLUMN_BUTTON_PLUS) && (*Max_vol_val < 30))
      {
         ++*Max_vol_val;
      }
      else if ((rxmaxvoltype == COLUMN_BUTTON_MINUS) && (*Max_vol_val > 15))
      {
         --*Max_vol_val;
      }
   }
   else
   {
      //Do Nothing
   }
   UpdatedMaxVolval = *Max_vol_val;
   m_propertytype = m_ListAudSpectoServAudSpec.find(MAXVOL)->second; //Find the Sound Property    //MSP_SOUND_BASS=1;
   ETG_TRACE_USR1(("AudioSettingListHandler::vAudSpecMaxVolincrementdecrementvalue: Max_vol_val=%d, m_propertytype = %d", *Max_vol_val, m_propertytype));
}


void AudioSettingListHandler::vAudSpecPriModMixVolincrementdecrementvalue(int rxprimodmixvoltype, int16* PriModMix_vol_val, int feature)
{
   ETG_TRACE_COMP(("AudioSettingListHandler::ivAudSpecPriModMixVolincrementdecrementvalue: rxprimodmixvoltype = %d, feature = %d, PriModMix_vol_val = %d", rxprimodmixvoltype, feature, *PriModMix_vol_val));
#ifdef VARIANT_S_FTR_ENABLE_COACH_AUDIO
   uint UpdatedPriModMixVolval = 0;
   if ((feature == PRIVATEMODMIXVOL))
   {
      if ((rxprimodmixvoltype == COLUMN_BUTTON_PLUS) && (*PriModMix_vol_val < 10))
      {
         ++*PriModMix_vol_val;
      }
      else if ((rxprimodmixvoltype == COLUMN_BUTTON_MINUS) && (*PriModMix_vol_val > 0))
      {
         --*PriModMix_vol_val;
      }
   }
   else
   {
      //Do Nothing
   }
   UpdatedPriModMixVolval = *PriModMix_vol_val;
   m_propertytype = m_ListAudSpectoServAudSpec.find(PRIVATEMODMIXVOL)->second; //Find the Sound Property    //MSP_SOUND_BASS=1;
   ETG_TRACE_USR1(("AudioSettingListHandler::vAudSpecPriModMixVolincrementdecrementvalue: PriModMix_vol_val=%d, m_propertytype = %d ", *PriModMix_vol_val, m_propertytype));
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, m_propertytype, UpdatedPriModMixVolval);
#endif
}


/************************************************************************
*FUNCTION: 		 AudioSettingListHandler - vPerformMainSinkSoundPropertyBassUpdate
*DESCRIPTION: 	 Update the chnaged values to HMI from the service

*PARAMETER:
*RETURNVALUE: 	 None
*
*
************************************************************************/
//void AudioSettingListHandler::vPerformMainSinkSoundPropertyBassUpdate(uint16 sinkId,  uint16 soundproperty,  int value)
void AudioSettingListHandler::vPerformMainSinkSoundPropertyBassUpdate(const uint16& sinkId, const uint16& soundproperty, const uint16& value)
{
   ETG_TRACE_COMP(("AudioSettingListHandler::vPerformMainSinkSoundPropertyBassUpdate: soundproperty = %d, value = %d", soundproperty, value));
   ListDataProviderBuilder listBuilder(LIST_ID_SYSTEM_AUDIO_LIST);
   if (soundproperty == MSP_SOUND_BASS)
   {
      m_ListtypetoAudSpecVolUpd[0] = value;
   }
   else if (soundproperty == MSP_SOUND_TREBBLE)
   {
      m_ListtypetoAudSpecVolUpd[1] = value;
   }
   else if (soundproperty == MSP_SOUND_BALANCE)
   {
      m_ListtypetoAudSpecVolUpd[2] = value;
   }
#ifndef VARIANT_S_FTR_ENABLE_NAVIGATION
   else if (soundproperty == MSP_SOUND_FADER)
   {
      m_ListtypetoAudSpecVolUpd[3] = value;
   }
#endif
   else if (soundproperty == MSP_SOUND_MIN_VOLUME)
   {
      m_ListtypetoAudSpecVolUpd[6] = value;
   }

   else if (soundproperty == MSP_SOUND_MAX_VOLUME)
   {
      m_ListtypetoAudSpecVolUpd[7] = value;
   }
   else if (soundproperty == MSP_PRIVATE_MODE_MIX_VOLUME)
   {
      m_ListtypetoAudSpecVolUpd[8] = value;

      ETG_TRACE_USR1(("AudioSettingListHandler::vPerformMainSinkSoundPropertyBassUpdate:soundproperty nd m_ListtypetoAudSpecVolUpd[8] nd value = %d %d %d", soundproperty, m_ListtypetoAudSpecVolUpd[8], value));
   }

#ifdef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
   else if (soundproperty == MSP_SOUND_AUX)
   {
      _currentAuxlevelOptionStr = (AuxLevelStrings[value - 1]);
   }
#endif
   else
   {
   }
   if (listcreated == true)
   {
#ifndef VARIANT_S_FTR_ENABLE_NAVIGATION
      ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_AUDIO_AUXLEVEL_LIST);
#endif
      ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_AUDIO_LIST);
   }
}


#ifdef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
bool AudioSettingListHandler::onCourierMessage(const ChangeAuxlevelvalueReqMsg& oMsg)
{
   unsigned int selectedOption = oMsg.GetAuxLevelOptions();
   ListDataProviderBuilder modifiedListItems(LIST_ID_SYSTEM_AUDIO_LIST);
   m_propertytype = 20;
   if (selectedOption <= 3)
   {
      // Subtract 1 to match the selection and enumeration index,
      // handle for first option in dropdown is 1. However, the enumeration value for same is 0
      _currentAuxlevelOption = static_cast<enAuxlevelOption>(selectedOption);
      _currentAuxlevelOptionStr = (AuxLevelStrings[selectedOption - 1U]);
   }
   ETG_TRACE_USR1(("AudioSettingListHandler::ChangeAuxlevelvalueReqMsg: selectedOption = %d, _currentAuxlevelOption=%d, _currentAuxlevelOptionStr=%s", selectedOption, _currentAuxlevelOption, _currentAuxlevelOptionStr.GetCString()));
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, m_propertytype, _currentAuxlevelOption);
   return true;
}


tSharedPtrDataProvider AudioSettingListHandler::GetCombo1ListDataProvider(::Courier::UInt32 listID)
{
   const char* DATA_CONTEXT_DROPDOWN_LIST_ITEM = "DropdownListButton";

   ListDataProviderBuilder listBuilder(LIST_ID_SYSTEM_AUDIO_AUXLEVEL_LIST, DATA_CONTEXT_DROPDOWN_LIST_ITEM);

   listBuilder.AddItem(1UL).AddData(AuxLevelStrings[0]);
   listBuilder.AddItem(2UL).AddData(AuxLevelStrings[1]);
   listBuilder.AddItem(3UL).AddData(AuxLevelStrings[2]);

   return listBuilder.CreateDataProvider();
}


#endif
}


}
