/***************************************************************************
* Copyright(c) 2019-2019 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/* ***************************************************************************************
* FILE:AudioPrivateModeRBtn.h
* SW-COMPONENT:  Audio Speed Dependent Volume Control Component
* DESCRIPTION:  AudioPrivateModeRBtn.h is part of Audio Setting reference/demo/test applications
* Author 	: PGA5COB (Prashant BG)
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef AUDIOPRIVATEMODERBTN_H
#define AUDIOPRIVATEMODERBTN_H
#include "AppHmi_SystemStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_SystemMessages.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include <string>

#define mPvtModeProperty 13
#define mLvl1PrivateMode 1
#define mLvl2PrivateMode 2
#define mLvl3PrivateMode 3

namespace App {
namespace Core {

class AudioPrivateModeRBtn
{
   private:
      AudioPrivateModeRBtn();

   public:

      static AudioPrivateModeRBtn* m_poAudioPrivateModeRBtn;
      static AudioPrivateModeRBtn* poGetInstance();

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)

      //  ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(PrivateModeLevelOne)
      ON_COURIER_MESSAGE(PrivateModeLevelTwo)
      ON_COURIER_MESSAGE(PrivateModeLevelThree)

      COURIER_MSG_MAP_END()
      void UpdatePrivateModeCntrlStatus(int UpdatePrivateModeVal);
      virtual ~AudioPrivateModeRBtn();
      virtual bool onCourierMessage(const PrivateModeLevelOne& oMsg);
      virtual bool onCourierMessage(const PrivateModeLevelTwo& oMsg);
      virtual bool onCourierMessage(const PrivateModeLevelThree& oMsg);
      void performPrivatemodeChange(const uint16& mPvtmode, const  uint16& value);

//	  bool onCourierMessage(const Courier::StartupMsg& oMsg);

      bool Init();
      DataBindingItem<PrivateModeSettingDataBindingSource> oPrivateModeControl;
};


}
}


#endif // _HMI_MODEL_COMPONENT_H
