/* ***************************************************************************************
* FILE:          AudioSpdDepdentVolCntrlRBtn.cpp
* SW-COMPONENT:  Audio Speed Dependent Volume Control Component
*  DESCRIPTION:  AudioSpdDepdentVolCntrlRBtn.cpp is part of Audio Setting reference/demo/test applications
* Author 	: PGA5COB (Prashant BG)
*    COPYRIGHT:  (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

//#include "AppUtils/StrUtf8.h"
#include "AppHmi_SystemStateMachine.h"
#include "App/Core/ClientHandler/Audio/AudioServiceClient.h"
#include "AudioPrivateModeRBtn.h"
#include "hmi_trace_if.h"
#include<iostream>
#include <string>
#include <cstdlib>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::DataModel::AudioPrivateModeRBtn
#include "trcGenProj/Header/AudioPrivateModeRBtn.cpp.trc.h"
#endif

using namespace App::Core;
using namespace std;


AudioPrivateModeRBtn* AudioPrivateModeRBtn::m_poAudioPrivateModeRBtn = NULL;
AudioPrivateModeRBtn::AudioPrivateModeRBtn()
{
   ETG_TRACE_COMP(("AudioPrivateModeRBtn::Constructor"));
}


AudioPrivateModeRBtn* AudioPrivateModeRBtn::poGetInstance()
{
   ETG_TRACE_COMP(("AudioPrivateModeRBtn::poGetInstance"));
   if (NULL == m_poAudioPrivateModeRBtn)
   {
      m_poAudioPrivateModeRBtn = new AudioPrivateModeRBtn();
   }
   return m_poAudioPrivateModeRBtn;
}


AudioPrivateModeRBtn::~AudioPrivateModeRBtn()
{
   ETG_TRACE_COMP(("AudioPrivateModeRBtn::Destructor"));
}


bool AudioPrivateModeRBtn::onCourierMessage(const PrivateModeLevelOne& /* oMsg */)
{
   ETG_TRACE_COMP(("AudioPrivateModeRBtn::PrivateModeLevelOne:: mPvtModeProperty = %d, mLvl1PrivateMode = %d", mPvtModeProperty, mLvl1PrivateMode));
   AudioServiceClient::poGetInstance()->performSystemPropertyChange(mPvtModeProperty, mLvl1PrivateMode);
   return true;
}


bool AudioPrivateModeRBtn::onCourierMessage(const PrivateModeLevelTwo& /* oMsg */)
{
   ETG_TRACE_COMP(("AudioPrivateModeRBtn::PrivateModeLevelOTwo: mPvtModeProperty = %d, mLvl2PrivateMode=%d", mPvtModeProperty, mLvl2PrivateMode));
   AudioServiceClient::poGetInstance()->performSystemPropertyChange(mPvtModeProperty, mLvl2PrivateMode);
   return true;
}


bool AudioPrivateModeRBtn::onCourierMessage(const PrivateModeLevelThree& /* oMsg */)
{
   ETG_TRACE_COMP(("AudioPrivateModeRBtn::PrivateModeLevelThree: mPvtModeProperty = %d, mLvl3PrivateMode=%d", mPvtModeProperty, mLvl3PrivateMode));
   AudioServiceClient::poGetInstance()->performSystemPropertyChange(mPvtModeProperty, mLvl3PrivateMode);
   return true;
}


void AudioPrivateModeRBtn ::UpdatePrivateModeCntrlStatus(int UpdatePrivateModeVal)
{
   ETG_TRACE_COMP(("AudioPrivateModeRBtn::UpdatePrivateModeCntrlStatus:UpdatePrivateModeVal=%d ", UpdatePrivateModeVal));
   (*oPrivateModeControl).mPrivate_1_Toggle = false;
   (*oPrivateModeControl).mPrivate_2_Toggle = false;
   (*oPrivateModeControl).mPrivate_3_Toggle = false;

   (*oPrivateModeControl).mPrivate_1_ColorChg = false;
   (*oPrivateModeControl).mPrivate_2_ColorChg = false;
   (*oPrivateModeControl).mPrivate_3_ColorChg = false;
   if (UpdatePrivateModeVal == mLvl1PrivateMode)
   {
      (*oPrivateModeControl).mPrivate_1_Toggle = true;
      (*oPrivateModeControl).mPrivate_1_ColorChg = true;
   }
   else if (UpdatePrivateModeVal == mLvl2PrivateMode)
   {
      (*oPrivateModeControl).mPrivate_2_Toggle = true;
      (*oPrivateModeControl).mPrivate_2_ColorChg = true;
   }
   else if (UpdatePrivateModeVal == mLvl3PrivateMode)
   {
      (*oPrivateModeControl).mPrivate_3_Toggle = true;
      (*oPrivateModeControl).mPrivate_3_ColorChg = true;
   }
   else
   {
      /*Do Nothing*/
   }

   POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Show, Courier::ViewId("AppHmi_System#SettingsPopUp#Pfo_PrivateModeAudioSetting"))));

   oPrivateModeControl.MarkAllItemsModified();
   oPrivateModeControl.SendUpdate(true);
}


void AudioPrivateModeRBtn::performPrivatemodeChange(const uint16& mPvtmode, const  uint16& value)
{
   ETG_TRACE_COMP(("AudioPrivateModeRBtn::performPrivatemodeChange: mPvtmode=%d, value = %d,", mPvtmode, value));
   AudioServiceClient::poGetInstance()->performSystemPropertyChange(mPvtmode, value);
}


/* bool AudioPrivateModeRBtn::onCourierMessage(const Courier::StartupMsg& oMsg)
{
	ETG_TRACE_USR4(("DisplaySettings:StartupMsg"));
	return true;
} */
