/**
 * @file        :  CGIAppPopupTable.cpp
 * @addtogroup  :  AppHmi_Sxm
 * @brief       :  SXM HALL class which contains all the necessary business logic required for CGI App popup table
 * @copyright   :  (c) 2018-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#include "gui_std_if.h"
#include "CgiExtensions/PopupConfig.h"
#include "CGIAppViewController_Sxm.h"
#include "ProjectBaseTypes.h"

POPUP_TABLE_BEGIN()
//          popup ID, modality,                       prio, presentation time, min. presentation time, validity period, close on superseded, close on app leave, Surface Id, path in asset
POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System,  12, 4000, 4000, 0, true, true, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioPopupChannelSkipped, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::Application,  14, 4000, 4000, 0, true, true, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioPopupSportsflashTeamSelected, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::Application,  14, 4000, 4000, 0, true, true, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioPopupDeleteFavoriteTeam, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::Application,  14, 4000, 4000, 0, true, true, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioTPopUpAlertAll, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::Application,  14, 4000, 4000, 0, true, true, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioTPopUpTWNNoInfo, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::Application,  14, 4000, 4000, 0, true, true, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioTPopUpMonitoring, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System,  12, 4000, 4000, 0, true, false, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioChannelNotAvailable, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System,  12, 4000, 4000, 0, true, false, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioChannelNotSubsribed, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System,  13, 5000, 5000, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioPopupFavContentAlert, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::System,  13, 10000, 0, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioTPopUpSportsFlashActive, true),
                  POPUP_TABLE_ENTRY_EXT(ScreenBroker::Modality::Application,  14, 4000, 4000, 0, true, true, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioPopUpDeleteFav, true),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System,  13, 0, 0, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioTPopUpSportsFlashReturn),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application,  14, 4000, 4000, 0, true, true, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmDTMPopupSxmSetting),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application,  14, 0, 0, 0, true, true, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmDTMPopupResetSxmModule),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application,  14, 0, 0, 0, true, true, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmTWNPopUpFavoriteCity),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application,  14, 0, 0, 0, true, true, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioPopupSportsFlashMaxFav),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application,  14, 0, 0, 0, false, true, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioPopupMaxFavContentReached),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application,  14, 0, 0, 0, true, true, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioPopupSportsMonitorTeam),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application,  14, 0, 0, 0, true, true, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioPopupSportsGameAvail),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application,  14, 0, 0, 0, true, true, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioPopupSFNoGameAvail),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application,  14, 0, 0, 0, true, true, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioPopupSFReplay),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::Application,  14, 0, 0, 0, true, true, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmAudioPopUpDeleteAllFav),
                  POPUP_TABLE_ENTRY(ScreenBroker::Modality::System,  11, 0, 0, 0, false, false, SURFACEID_TOP_POPUP_SURFACE_SXM, CGIAppViewController_SxmPopupSubscriptionUpdated),
                  POPUP_TABLE_END()
