/* ***************************************************************************************
* FILE:          CGIAppController.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppController.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "gui_std_if.h"
#include "AppHmi_SxmStateMachine.h"
#include "CGIAppController.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SXM_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SXM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SXM_"
#define ETG_I_FILE_PREFIX                 CGIAppController::
#include "trcGenProj/Header/CGIAppController.cpp.trc.h"
#endif

/**
 * CGIAppController Class destructor
 */
CGIAppController::~CGIAppController()
{
}


/**
* onCourierMessage - Courier message handler for RenderingCompleteMsg
* @param[in] : Message
* @return : TRUE if consumed
*/
bool CGIAppController::onCourierMessage(const RenderingCompleteMsg& omsg)
{
   ETG_TRACE_USR4(("CGIAppController: RenderingCompleteMsg ViewName:%s", omsg.GetViewName().GetCString()));
   if ((omsg.GetSurfaceId() == Enum_SURFACEID_MAIN_SURFACE_SXM) || (omsg.GetSurfaceId() == Enum_SURFACEID_TOP_POPUP_SURFACE_SXM))
   {
      POST_MSG((COURIER_MESSAGE_NEW(SxmActiveRenderedViewMsg)
                (omsg.GetSurfaceId(),
                 Courier::ViewId(omsg.GetViewName().GetCString()).GetHashId().HashValue(),
                 omsg.GetViewName())));
   }
   CGIAppControllerProject::onCourierMessage(omsg);

   return false;
}


/**
* onCourierMessage - Courier message handler for ButtonReactionMsg
* @param[in] : Message
* @return : TRUE if consumed
*/
bool CGIAppController::onCourierMessage(const ButtonReactionMsg& oMsg)
{
   bool status = false;
   const ButtonReactionMsg* l_pButtonReationMsg = ::Courier::message_cast<const ButtonReactionMsg*>(&oMsg);
   if (NULL != l_pButtonReationMsg)
   {
      ETG_TRACE_USR1(("CGIAppController: ButtonReactionMsg"));
      ::Courier::ViewId const l_oViewId = l_pButtonReationMsg->GetView();
      ::Courier::Identifier const l_oIdentifier =	l_pButtonReationMsg->GetSender();
      enReaction const l_enReaction = l_pButtonReationMsg->GetEnReaction();
      if ((l_oViewId == (::Courier::ViewId("Sxm#Scenes#SXM_RADIO__MAIN"))))
      {
         ETG_TRACE_USR1(("CGIAppController: ButtonReactionMsg, SXM_RADIO__MAIN"));
         if ((l_oIdentifier.operator == (::Courier::Identifier("Btn_SxmSource/ButtonWidget"))) ||
               (l_oIdentifier.operator == (::Courier::Identifier("Btn_SxmAudioMenu/ButtonWidget"))) ||
               (l_oIdentifier.operator == (::Courier::Identifier("Btn_SxmPreset/ButtonWidget"))) ||
               (l_oIdentifier.operator == (::Courier::Identifier("Btn_TwnGray/ButtonWidget"))) ||
               (l_oIdentifier.operator == (::Courier::Identifier("Btn_TwnRed/ButtonWidget"))) ||
               (l_oIdentifier.operator == (::Courier::Identifier("Btn_SFGrey/ButtonWidget"))) ||
               (l_oIdentifier.operator == (::Courier::Identifier("Btn_SFWhite/ButtonWidget"))) ||
               (l_oIdentifier.operator == (::Courier::Identifier("Btn_SFGreen/ButtonWidget"))) ||
               (l_oIdentifier.operator == (::Courier::Identifier("Btn_SaveArtist/ButtonWidget"))) ||
               (l_oIdentifier.operator == (::Courier::Identifier("Btn_SaveSong/ButtonWidget"))) ||
               (l_oIdentifier.operator == (::Courier::Identifier("Btn_SFRed/ButtonWidget"))))
         {
            sendTuneScanControlReq(SCAN_ABORT);
            status = true;
         }
         else if ((l_oIdentifier.operator == (::Courier::Identifier("Btn_TwnGreen/ButtonWidget"))) ||
                  (l_oIdentifier.operator == (::Courier::Identifier("Btn_TwnWhite/ButtonWidget"))))
         {
            sendTuneScanControlReq(SCAN_STOP);
            status = true;
         }
         else if (((l_oIdentifier.operator == (::Courier::Identifier("Btn_Forward/ButtonWidget"))) &&
                   (l_enReaction == enLongPressRelease || l_enReaction == enShortPressRelease || l_enReaction == enAbortPress)) ||
                  ((l_oIdentifier.operator == (::Courier::Identifier("Btn_Rewind/ButtonWidget"))) &&
                   (l_enReaction == enLongPressRelease || l_enReaction == enShortPressRelease || l_enReaction == enAbortPress)))
         {
            POST_MSG((COURIER_MESSAGE_NEW(SXMAudioReplayControlReqMsg)(SXM_AUDIO_REPLAY_PLAY)));
         }
      }
      else if ((l_oViewId == (::Courier::ViewId("SxmPopups#Popups#SXM_RADIO__ITPOP_SPORTSFLASH_ACTIVE"))))
      {
         if ((l_oIdentifier.operator == (::Courier::Identifier("Btn_SFTune/ButtonWidget"))))
         {
            sendTuneScanControlReq(SCAN_STOP);
            status = true;
         }
      }
   }
   CGIAppControllerProject::onCourierMessage(oMsg);

   return status;
}


/**
 * Helper function to send Tune scan control request to model
 * @param[in] : mode
 */
void CGIAppController::sendTuneScanControlReq(uint8 mode)
{
   const bool* dataItem = ::Courier::Internal::AsyncGenericModelBindingSource::GetDataItemValue< const bool>(
                             ::Courier::ComponentId(::Courier::ComponentType::Controller),
                             ItemKey::SxmAudioScan::ScanOnItem);

   bool status = (dataItem == 0) ? bool() : (bool) * dataItem;

   if (status) //only if scan is active.
   {
      POST_MSG((COURIER_MESSAGE_NEW(SXMAudioScanOpertationReqMsg)(mode)));
   }
}
