/**************************************************************************************
 * @file        : apphmi_sxm_datapool_if.h
 * @addtogroup  : AppHmi_Sxm
 * @brief       : constants and classes used for datapool
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#ifndef _PERSMEMVARSSXM_H
#define _PERSMEMVARSSXM_H

namespace HmiAppSxm {

#define DEFAULT_SF_DP_INVALID 0xFFFF
#define MAX_ALERTSETTINGS_ENTRIES 6
#define MAX_SPORTSFLASH_FAVORITES 5

//SportsflashMonitor - LeagueId, TeamId, Status
#define DEFAULT_SF_FAVORITE_INFO  \
		DEFAULT_SF_DP_INVALID,    \
		DEFAULT_SF_DP_INVALID,    \
		DEFAULT_SF_DP_INVALID

//5 - SF favorites
#define DEFAULT_SF_FAVORITE_INFO_LIST  \
		DEFAULT_SF_FAVORITE_INFO,      \
		DEFAULT_SF_FAVORITE_INFO,      \
		DEFAULT_SF_FAVORITE_INFO,      \
		DEFAULT_SF_FAVORITE_INFO,      \
		DEFAULT_SF_FAVORITE_INFO

class AlertSetting
{
   public:
      bool OnOrOff[MAX_ALERTSETTINGS_ENTRIES];
};


struct SportsflashMonitor
{
   int LeagueId;
   int TeamId;
   int Status;
};


class SXMSportsFlashFavTeams
{
   public:
      struct SportsflashMonitor SFMonitorList[MAX_SPORTSFLASH_FAVORITES];
};


};

#endif  // _PERSMEMVARSSXM_H
