/**
 * @file        :  SxmCommonTypes.h
 * @addtogroup  :  AppHmi_Sxm
 * @brief       :  Contains user defined types.
 * @copyright   :  (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */

#ifndef _SXMCOMMONTYPES_H_
#define _SXMCOMMONTYPES_H_

//SXM Info for Vechicle Interface
#define SXM_ADVISORY 7
#define SXM_CHANNEL_NUMBER 12
#define SXM_CATEGORY 13

//For Navi Interface
struct VehicleLocationType
{
   int s32Latitude;
   int s32Longitude;
   std::string sCountryCode;
   VehicleLocationType(): s32Latitude(0), s32Longitude(0), sCountryCode("") {}
};


enum enCountryCode
{
   EN_USA,
   EN_CAN,
   EN_INVALID
};


enum enHeadingType
{
   EN_HEADING_INDEX_UNKNOWN         = -1,
   EN_HEADING_INDEX_NORTH           = 0,
   EN_HEADING_INDEX_NORTH_EAST      = 1,
   EN_HEADING_INDEX_EAST            = 2,
   EN_HEADING_INDEX_SOUTH_EAST      = 3,
   EN_HEADING_INDEX_SOUTH           = 4,
   EN_HEADING_INDEX_SOUTH_WEST      = 5,
   EN_HEADING_INDEX_WEST            = 6,
   EN_HEADING_INDEX_NORTH_WEST      = 7
};


enum enDateFormat
{
   EN_SHORT_DATE_MDY = 0,
   EN_LONG_DATE
};


//For Clock Interface
struct LocalDateTimeType
{
   short int s16Year;
   unsigned short int u8Month;
   unsigned short int u8Day;
   unsigned short int u8Hours;
   unsigned short int u8Minutes;
   unsigned short int u8Seconds;
   unsigned short int u8Weekday;

   LocalDateTimeType(): s16Year(0), u8Month(0), u8Day(0), u8Hours(0), u8Minutes(0), u8Seconds(0), u8Weekday(0) {}
};


//For Navi interface for WEather.
struct FavoriteCityInformation
{
   int cityLocationLatitude;
   int cityLocationLongitude;
   std::string cityName;
   std::string stateName;
   bool isValidAddress;
   FavoriteCityInformation(): cityLocationLatitude(0), cityLocationLongitude(0)
      , cityName(""), stateName(""), isValidAddress(false) {}
};


struct CityInformation
{
   std::string cityName;
   std::string stateName;
   CityInformation(): cityName(""), stateName("") {}
};


enum enDestOrFavCity
{
   EN_UNKNOWN = 0,
   EN_DEST_CITY,
   EN_FAV_CITY,
   EN_NEAR_CITY
};


struct ScrollBarStruc
{
   std::string buttonName;
   unsigned int listId;
   unsigned short int isUp;
};


//For temperature units.
enum T_e8_SXMNissanTemperatureUnitType
{
   EN_SXM_TEMP_UNKNOWN = 0,
   EN_SXM_FAHREHEIT,
   EN_SXM_CENTIGRADE
};


enum enConnectionState
{
   unknown = 0,
   connecting  = 1,
   connected,
   disconnecting,
   disconnected,
   suspended
};


struct TChannelInformation
{
   unsigned int channelID;
   std::string channelName;
};


struct regionText
{
   std::string region1;
   std::string region2;
   regionText(std::string lRegion1 = "", std::string lRegion2 = ""): region1(lRegion1), region2(lRegion2) {}
};


#endif
