/**
 * @file        :  SxmHall.h
 * @addtogroup  :  AppHmi_Sxm
 * @brief       :  SXM HALL class which contains all the necessary business logic required for SXM HMI
 * @copyright   :  (c) 2019-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#ifndef SxmHall_h
#define SxmHall_h

#include "AppBase/HallComponentBase.h"
#include "Common/DefSetServiceBase/DefSetServiceBase.h"
#include <Adapter/LanguageHandlerAdapter.h>
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
//#include "ApplicationSwitch.h"
//#include "ApplicationSwitchProxy.h"
#include "App/Core/ClientHandler/ApplicationSwitchClientHandler/ApplicationSwitchClientHandler.h"

namespace Courier {
class Message;
}


namespace App {
namespace Core {

// Forward declarations
class SxmAudioHall;
class SxmUtilsListHandler;
class SxmAdvisories;
class SxmHMIServiceStateHandler;
class SXMSourceSwitch;
class SXMClockService;
class SxmHmiInfoService;

/**
 * SxmHall class, main HALL class for SXM HMI
 * @class : SxmHall
 */
class SxmHall
   : public HallComponentBase
   , public iDefSetServiceBase
   , public ::languageHandler::LanguageHandlerAdapter
{
   public:
      /**
      * SxmHall() class constructor
      */
      SxmHall();
      /**
       * SxmHall() class destructor
       */
      virtual ~SxmHall();
      /**
       * Timer expiry handler function
       */
      virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);
      void vonGuiStartupFinished();

      /**
       *virtual methods from iDefSetServiceBase to handle restore factory settings
       */
      void reqPrepareResponse(const PrepareResDiagMsgData&);
      void reqExecuteResponse(const ExecuteResDiagMsgData&);
      void reqFinalizeResponse(const FinalizeResDiagMsgData&);

   protected:
      /**
       * Method to retrieve TraceClass reference. This is unused.
       */
      inline uint32_t getTraceClass() const
      {
         return TR_CLASS_APPHMI_SXM_COURIER_PAYLOAD_MODEL_COMP;
      }

      /*
       * Courier message handler
       */
      virtual bool OnMessage(const Courier::Message& Msg);

   private:
      SxmAudioHall* _mPtrSxmAudioHall;   // SxmAudioHall class pointer
      SXMSourceSwitch* _mPtrSXMSourceSwitch;
      SxmUtilsListHandler* _mPtrSxmUtilsListHandler;
      SxmAdvisories* _mPtrSxmAdvisories;
      DefSetServiceBase* _defSetServiceBase;
      ApplicationSwitchClientComponent* _applicationSwitchClientComponent;//applicationSwitch
      SXMClockService* _mPtrSXMClockService;
      ApplicationSwitchClientHandler* _applicationSwitchClientHandler;
      SxmHMIServiceStateHandler* _ptrSxmHMIServiceStateHandler;
      SxmHmiInfoService* _pSxmHmiInfoService;

      /**
      * Helper function to do restore factory settings
      */
      bool bSxmRestoreFactorySetting();

      DECLARE_CLASS_LOGGER();
}; // SxmHall
} // namespace Core
} // namespace App

#endif
