/**
 * @file        :  SxmGui.cpp
 * @addtogroup  :  AppHmi_Sxm
 * @brief       :  Class which contains all the necessary business logic required to handle gui instance and gadgets
 * @copyright   :  (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#include "gui_std_if.h"
#include "SxmGui.h"
#include "HMI/CGIComponents/AppViewSettings.h"
#include "HMI/CGIComponents/CGIApp.h"
#include "AppBase/IApplicationSettings.h"
#include "Common/AppBaseSettings/KeyMapping.h"
//#include "Common/AssetShaperUtils/AssetShaperUtil.h"

//////// TRACE IF ///////////////////////////////////////////////////
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SXM_MAIN
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SXM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SXM_"
#define ETG_I_FILE_PREFIX                 App::Core::SxmGui::
#include "trcGenProj/Header/SxmGui.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN
//////// TRACE IF ///////////////////////////////////////////////////

//DEFAULT_APPSETTINGS(SURFACEID_MAIN_SURFACE_SXM, SURFACEID_NONE, SURFACEID_TOP_POPUP_SURFACE_SXM, SURFACEID_CENTER_POPUP_SURFACE_SXM)

APPSETTINGS_BEGIN()
APPSETTINGS_ADD_MAINSURFACE(SURFACEID_MAIN_SURFACE_SXM),
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_TOP_POPUP_SURFACE_SXM),
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_CENTER_POPUP_SURFACE_SXM)
                            APPSETTINGS_END()

                            using namespace ::hmi;
namespace App {
namespace Core {

SxmGui::SxmGui() : GuiComponentBase(hmi::apps::reference::appHmi_Sxm, appSettings)//, _pThreadBridge(0)
{
   ETG_I_REGISTER_FILE();
   ETG_I_REGISTER_CHN(TraceCmd_NotProcessedMsg);
   _hmiAppCtrlProxyHandler.setTraceId(TR_CLASS_APPHMI_SXM_APPCTRL_PROXY);
   // configure sync block connection for unique producer id on unique 'channel' 765
   SYNC_BLOCK_CONNECTION(765, SXM_GADGET);
   // SYNC_BLOCK_CONNECTION(765, SXM_GADGET_CURRENT_AUDIO);
   // SYNC_BLOCK_CONNECTION(765, SXM_GADGET_CURRENT_AUDIO_SMALL);
   // SYNC_BLOCK_CONNECTION(765, SXM_GADGET_SPORTS);
   // SYNC_BLOCK_CONNECTION(765, SXM_GADGET_CURRENT_WEATHER);
   // SYNC_BLOCK_CONNECTION(765, SXM_GADGET_WEATHER_5DAY);
   // SYNC_BLOCK_CONNECTION(765, SXM_GADGET_WEATHER_HOURLY)

   uint32 DisplayID_D1 = 1;// DisplayConfiguration::getInstance()->getPhysicalDisplayIdOfDisplayIndex(0);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_MAIN_SURFACE_SXM, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_TOP_POPUP_SURFACE_SXM, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_CENTER_POPUP_SURFACE_SXM, DisplayID_D1);
}


SxmGui::~SxmGui()
{
   ETG_I_UNREGISTER_FILE();
   /*  if (_pThreadBridge)
    {
       delete _pThreadBridge;
       _pThreadBridge = NULL;
    } */
}


/*void SxmGui::getInitializationParameters(SurfaceParameter& p)
{
   p.mainSurfaceId = SURFACEID_MAIN_SURFACE_SXM;
   p.applicationPopupSurfaceId = SURFACEID_CENTER_POPUP_SURFACE_SXM;
   p.globalPopupSurfaceId = SURFACEID_CENTER_POPUP_SURFACE_SXM;
   p.videoSurfaceId = SURFACEID_NONE;

   p.appViewSettings = AppViewSettings::GetInstance();
}


*/

unsigned int SxmGui::getDefaultTraceClass()
{
   return TR_CLASS_APPHMI_SXM_MAIN;
}


void SxmGui::setupCgiInstance()
{
   std::string assetFileName = hmibase::app::base::SystemConfiguration::getAssetFileName();

   ETG_TRACE_USR4(("SxmGui() setupCgiInstance %s", assetFileName.c_str()));

   setCgiApp(new CGIApp(assetFileName.c_str(), _hmiAppCtrlProxyHandler));
   /*  std::string assetFileName = Rnaivi::AssetShaperUtil::getDefaultAssetFileName();
    std::vector<std::string> assetFileNames = Rnaivi::AssetShaperUtil::getAssetFiles(assetFileName);
    setCgiApp(new CGIApp(assetFileNames, _hmiAppCtrlProxyHandler)); */
   //setCgiApp(new CGIApp(assetFileName.c_str(), _hmiAppCtrlProxyHandler));

   //For solving custodial pointer lint error - Start
   //cgiApp is deleted in GuiComponentBase destructor
   //CGIApp* dummycgiApp = cgiApp;
   //(void)dummycgiApp;
   //For solving custodial pointer lint error - End
}


/*bool SxmGui::onCourierMessage(const GuiStartupFinishedUpdMsg& msg)
{
   bool isGuiComponentBaseMsg = GuiComponentBase::OnMessage(msg);
   //_hmiAppCtrlProxyHandler.setStartupFinished(true);
   return isGuiComponentBaseMsg;
}


*/

void SxmGui::preRun()
{
//	DP_vCreateDatapool();
   // _pThreadBridge = new asf::core::ThreadBridge("sxmGui");
   PersistentValuesRead();
}


void SxmGui::postRun()
{
   PersistentValuesWrite();
   /*  if (_pThreadBridge)
    {
       delete _pThreadBridge;
       _pThreadBridge = NULL;
    } */
}


void SxmGui::PersistentValuesRead()
{
//   dp_tclhmiAppSxmPersMemVarsSxm dp;
//   _mvar = dp.tGetData();
}


void SxmGui::PersistentValuesWrite()
{
//   dp_tclhmiAppSxmPersMemVarsSxm dp;
//   dp.s32SetData(_mvar);
}


/**
 *sink for not processed ttfis input messages
 */
void SxmGui::TraceCmd_NotProcessedMsg(const unsigned char* data)
{
   if (data)
   {
      ETG_TRACE_FATAL(("TraceCmd_NotProcessedMsg() : 0x%*x", ETG_LIST_LEN(data[0]), ETG_LIST_PTR_T8(data)));
   }
}


} // namespace Core
} // namespace App
