/**************************************************************************************
 * @file        : SXMCommonInterface.cpp
 * @addtogroup  : AppHmi_Sxm
 * @brief       : SXM Common Interface.
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#include "hmi_trace_if.h"
#include "CgiExtensions/CourierMessageMapper.h"
//#include "hall_std_if.h"  //when other headers also needed, include hall_std_if and remove above two
#include "SXMCommonInterface.h"
#include "SxmAdvisories.h"
#include "SxmHMIServiceStateHandler.h"

namespace App {
namespace Core {

/**
 * Register call back function to receive updates.
 * @param [in] : _obsptr - object reference of observer.
 * @param [in] : enSXMServiceType - data Service type
 */
void SXMCommonInterface::vRegisterNotification(ISxmCommon* _obsptr, enSXMServiceType enServiceType, enSXMEventNotificationType enEventType)
{
   switch (enEventType)
   {
      case SXMDataServiceAntennaStatus:
      case SXMDataServiceStatus:
      {
         SxmAdvisories::instance()->vRegisterNotification(_obsptr, enServiceType, enEventType);
         break;
      }
      default:
      {
         break;
      }
   }
}


/**
 * De-Register call back function to receive updates.
 * @param [in] : _obsptr - object reference of observer.
 * @param [in] : enSXMServiceType - data Service type
 */
void SXMCommonInterface::vDeregisterNotification(ISxmCommon* _obsptr, enSXMServiceType enServiceType, enSXMEventNotificationType enEventType)
{
   switch (enEventType)
   {
      case SXMDataServiceAntennaStatus:
      case SXMDataServiceStatus:
      {
         SxmAdvisories::instance()->vDeregisterNotification(_obsptr, enServiceType, enEventType);
         break;
      }
      default:
      {
         break;
      }
   }
}


/**
 * Register call back function to receive updates.
 * @param [in] : _obsptr - object reference of observer.
 * @param [in] : enSXMServiceType - data Service type
 */
void SXMCommonInterface::registerServiceEntryExitNotification(ISxmHMIServiceStateHandler* _obsptr, enSXMServiceType enServiceType)
{
   SxmHMIServiceStateHandler::instance()->registerServiceEntryExitNotification(_obsptr, enServiceType);
}


/**
 *Register call back function to receive updates.
 * @param [in] : _obsptr - object reference of observer.
 * @param [in] : enSXMServiceType - data Service type
 */
void SXMCommonInterface::registerApplicationModeChangeNotication(ISxmHMIServiceStateHandler* _obsptr, enSXMServiceType enServiceType)
{
   SxmHMIServiceStateHandler::instance()->registerApplicationModeChangeNotication(_obsptr, enServiceType);
}


/**
 * DeRegister call back function to stop receiving updates.
 * @param [in] : _obsptr - object reference of observer.
 * @param [in] : enSXMServiceType - data Service type
 */
void SXMCommonInterface::deregisterServiceEntryExitNotification(ISxmHMIServiceStateHandler* _obsptr, enSXMServiceType enServiceType)
{
   SxmHMIServiceStateHandler::instance()->deregisterServiceEntryExitNotification(_obsptr, enServiceType);
}


/**
 * DeRegister call back function to stop receiving updates.
 * @param [in] : _obsptr - object reference of observer.
 * @param [in] : enSXMServiceType - data Service type
 */
void SXMCommonInterface::deregisterApplicationModeChangeNotication(ISxmHMIServiceStateHandler* _obsptr, enSXMServiceType enServiceType)
{
   SxmHMIServiceStateHandler::instance()->deregisterApplicationModeChangeNotication(_obsptr, enServiceType);
}


/**
 *Register call back function to receive updates.
 * @param [in] : _obsptr - object reference of observer.
 * @param [in] : enSXMServiceType - data Service type
 */
void SXMCommonInterface::registerApplicationStateNotication(ISxmHMIServiceStateHandler* _obsptr, enSXMServiceType enServiceType)
{
   SxmHMIServiceStateHandler::instance()->registerApplicationStateNotication(_obsptr, enServiceType);
}


/**
 * DeRegister call back function to stop receiving updates.
 * @param [in] : _obsptr - object reference of observer.
 * @param [in] : enSXMServiceType - data Service type
 */
void SXMCommonInterface::deregisterApplicationStateNotication(ISxmHMIServiceStateHandler* _obsptr, enSXMServiceType enServiceType)
{
   SxmHMIServiceStateHandler::instance()->deregisterApplicationStateNotication(_obsptr, enServiceType);
}


/**
 * Helper Function to get current view or Popup name.
 * @param [in] :uSurfaceId - surface id of the view.
 */
unsigned int SXMCommonInterface::getActiveViewName(unsigned int uSurfaceId)
{
   return SxmHMIServiceStateHandler::instance()->getVisibleView(uSurfaceId);
}


/**
 * Helper Function to get active service state.
 */
unsigned int SXMCommonInterface::getActiveServiceState()
{
   return SxmHMIServiceStateHandler::instance()->getActiveState();
}


/**
 * Helper Function to get service state of current data service.
 */
unsigned int SXMCommonInterface::getCurrentDataServiceState()
{
   return SxmHMIServiceStateHandler::instance()->getDataServiceState();
}


/**
 * Helper Function to get appmode
 */
unsigned int SXMCommonInterface::getActiveAppMode()
{
   return SxmHMIServiceStateHandler::instance()->getActiveAppMode();
}


/**
 * Helper Function to get status of view visibility.
 * @param [in] : viewid
 */
bool SXMCommonInterface::isViewVisible(unsigned int viewid)
{
   return SxmHMIServiceStateHandler::instance()->isViewVisible(viewid);
}


/**
 * Helper Function to get status of application state.
 */
bool SXMCommonInterface::isSxmInForeground()
{
   return  SxmHMIServiceStateHandler::instance()->getApplicationState();
}


void SXMCommonInterface::updateMapStatusBar(TChannelInformation chnInfo)
{
   SxmHMIServiceStateHandler::instance()->updateMapStatusBar(chnInfo);
}


/**
 * Helper Function to set cache setting of dataProvider.
 * @param [in] : dataProvider - reference of dataProvider
 * @param [in] : enableCache - flag for enable/disable cache
 */
void SXMCommonInterface::dataproviderCacheSetting(const tSharedPtrDataProvider& dataProvider, bool enableCache)
{
   if (!dataProvider.PointsToNull())
   {
      dataProvider->setCacheOnOff(enableCache);
   }
}


/**
 * Helper Function to get Data service status.
 * @param [in] : enServiceType - Data service type
 */
enSXMDataServiceAdvisory SXMCommonInterface::getDataServiceStatus(const enSXMServiceType enServiceType)
{
   return SxmAdvisories::instance()->getDataServiceStatus(enServiceType);
}


/**
 * Helper Function to get TargetContextId.
 */
unsigned int SXMCommonInterface::getTargetContextId()
{
   return SxmHMIServiceStateHandler::instance()->getTargetContextId();
}


/**
 * Helper Function to set TargetContextId.
 * @param [in] : tcontextId - targetcontextid from vOnNewActiveContext
*/
void SXMCommonInterface::setTargetContextId(unsigned int tcontextId)
{
   SxmHMIServiceStateHandler::instance()->setTargetContextId(tcontextId);
}


/**
 * Helper Function to get gadget visibility
 */
bool SXMCommonInterface::getGadgetVisibility(enSXMServiceType serviceType)
{
   return SxmHMIServiceStateHandler::instance()->getGadgetVisibility(serviceType);
}


/**
 * Helper Function to get gadget visibility
 */
bool SXMCommonInterface::getLockoutKdsStatus(lockoutKDSConfig lockoutkdsConfig)
{
   return SxmHMIServiceStateHandler::instance()->getLockoutKdsStatus(lockoutkdsConfig);
}


}  // namespace Core
}  // namespace App
