/**************************************************************************************
 * @file        : ISxmTabListHandler.h
 * @addtogroup  : AppHmi_Sxm
 * @brief       :
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#ifndef ISxmTabListHandler_H_
#define ISxmTabListHandler_H_

namespace App {
namespace Core {

/**
   @brief :
   @class : ISxmTabListHandler
*/
class ISxmTabListHandler
{
   public:
      virtual ~ISxmTabListHandler() { } ;
      virtual void addItem(uint8 index, const char* viewname, const char* buttonname, bool isEnable, uint32 tabButtonTextId) = 0;
      virtual void enableSelectedItemIndex(uint8 index, bool enable) = 0;
      virtual void setCurrentTabIndex(uint8 index, bool update) = 0;
      virtual uint8 getActiveTabIndex() = 0;
      virtual void updateSxmTabControlBindingData(uint8 serviceHeaderIndex) = 0;
      virtual void setHeaderText(unsigned int textId) = 0;
};


} //end of namespace Core
} //end of namespace App


#endif /* ILISTHANDLER_H_ */
