/**************************************************************************************
 * @file         : SxmAudioPreset.h
 * @addtogroup   : AppHmi_Sxm
 * @brief        : Functional class to handle business logic for Presets.
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/
#ifndef _SxmAudioPreset_H_
#define _SxmAudioPreset_H_

#include "sxm_audio_main_fiProxy.h"
#include "ISxmAudioChannelArtResponse.h"
#include "ISxmAudioChannelArtRequest.h"
#include "Common/DataModel/ListRegistry.h"
#include "AppHmi_SxmMessages.h"

namespace App {
namespace Core {

/**
 * Utility class which contains all the necessary business logic required to handle Presets.
 * @class : SxmAudioPreset
 */
class SxmAudioPreset
   : public ::sxm_audio_main_fi::GetPresetListCallbackIF
   , public ::sxm_audio_main_fi::PresetChannelUpdateCallbackIF
   , public ::sxm_audio_main_fi::AutoCompareCallbackIF
   , public ::sxm_audio_main_fi::SetAutoCompareParametersCallbackIF
   , public ::sxm_audio_main_fi::StorePresetCallbackIF
   , public ::sxm_audio_main_fi::RecallPresetCallbackIF
   , public ::sxm_audio_main_fi::SystemMessageCallbackIF
   , public ISxmAudioChannelArtResponse
{
   public:
      /**
       * SxmAudioPreset Class constructor
       */
      SxmAudioPreset(::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy > pSxmAudioFiProxy, ISxmAudioChannelArtRequest* pSxmChannelart);
      /**
       * SxmAudioPreset Class destructor
       */
      virtual ~SxmAudioPreset();
      /**
       * Utility function that registers for notifications updates from SXM Audio MIDW layer
       */
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      /**
       * Utility function that deregisters for notifications updates from SXM Audio MIDW layer
       */
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      /**
      * Error handling function for get PresetList Method
      */
      void onGetPresetListError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                const ::boost::shared_ptr< ::sxm_audio_main_fi::GetPresetListError >& error);
      /**
       * Result handling function for get PresetList Method
       */
      void onGetPresetListResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                 const ::boost::shared_ptr< ::sxm_audio_main_fi::GetPresetListResult >& result);
      /**
       * Error handling function for get PresetChannelUpdate Property
       */
      void onPresetChannelUpdateError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                      const ::boost::shared_ptr< ::sxm_audio_main_fi::PresetChannelUpdateError >& error);
      /**
       * Status handling function for get PresetChannelUpdate Property
       */
      void onPresetChannelUpdateStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                       const ::boost::shared_ptr< ::sxm_audio_main_fi::PresetChannelUpdateStatus >& status);
      /**
       * Error handling function for auto compare property
       */
      void onAutoCompareError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                              const boost::shared_ptr< ::sxm_audio_main_fi::AutoCompareError >& /*error*/);
      /**
       * Status handling function for auto compare property
       */
      void onAutoCompareStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                               const boost::shared_ptr< ::sxm_audio_main_fi::AutoCompareStatus >& /*status*/);
      /**
       * Error handling function for set auto compare parameters method
       */
      void onSetAutoCompareParametersError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                           const boost::shared_ptr< ::sxm_audio_main_fi::SetAutoCompareParametersError >& /*error*/);
      /**
       * Result handling function for set auto compare parameters method
       */
      void onSetAutoCompareParametersResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                            const boost::shared_ptr< ::sxm_audio_main_fi::SetAutoCompareParametersResult >& /*result*/);
      /**
       * Error handling function for recall preset method
       */
      void onRecallPresetError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                               const boost::shared_ptr< ::sxm_audio_main_fi::RecallPresetError >& /*error*/);
      /**
       * Result handling function for recall preset method
       */
      void onRecallPresetResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                const boost::shared_ptr< ::sxm_audio_main_fi::RecallPresetResult >& result);
      /**
       * Error handling function for store preset method
       */
      void onStorePresetError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                              const boost::shared_ptr< ::sxm_audio_main_fi::StorePresetError >& /*error*/);
      /**
       * Result handling function for store preset method
       */
      void onStorePresetResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                               const boost::shared_ptr< ::sxm_audio_main_fi::StorePresetResult >& /*result*/);
      /**
       * Error handling function for system messages property
       */
      void onSystemMessageError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                const boost::shared_ptr< ::sxm_audio_main_fi::SystemMessageError >& /*error*/);
      /**
       * Status handling function for system messages property
       */
      void onSystemMessageStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                 const boost::shared_ptr< ::sxm_audio_main_fi::SystemMessageStatus >& status);
      /**
       * Result handling function for GetChannelArt method.
       */
      virtual void onGetChannelLogoResult(const uint16& sid, const uint8& /*ChannelGraphicsType*/, const std::vector<uint8>& /*u8ImageData*/,
                                          const std::vector<uint8>& /*albumImageData*/);
      /**
       * Result handling function for GetChannelArt method.
       */
      virtual void onGetChannelArtListResult(const ::std::vector< ChannelGraphicsType >& channelArtList);
      /**
       * Error handling function for GetChannelArtList method.
       */
      virtual void onGetChannelArtListError();
      /**
       * Error handling function for GetChannelArt method.
       */
      virtual void onGetChannelLogoError(const uint16& sid);
      /**
       * Helper function to get preset list on startup.
       */
      void getPresetList();
      /**
       * Restore Dp value for Audio Preset.
      */
      void restoreAudioPreset(void);
      /**
       * Function to set default value on service availability from suspended
       */
      void onServiceResumed(const ::boost::shared_ptr< asf::core::Proxy >& proxy);

   private:

      /**
      * Callback to handle Courier Message SxmAudioChangePresetBankReqMsg Request
      */
      bool onCourierMessage(const SxmAudioChangePresetBankReqMsg& oMsg);
      /**
      * Callback to handle Courier Message SXMAudioRecallorStoreReqMsg Request
      */
      bool onCourierMessage(const SXMAudioRecallorStoreReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SXMTuneToChannelReqMsg Request
       */
      bool onCourierMessage(const SXMTuneToChannelReqMsg& oMsg);
      /**
      * Callback to handle Courier Message ListChangedUpdMsg Request
      */
      bool onCourierMessage(const ListChangedUpdMsg& oMsg);
      /**
      * Callback to handle Courier Message SxmAudioUpdatePresetListReqMsg Request
      */
      bool onCourierMessage(const SxmAudioUpdatePresetListReqMsg& oMsg);
      /**
       * Helper function for get Channel logos for PresetList
       */
      void getPresetChannlLogo(bool allSid, uint8 presetIndex, uint16 serviceId);

      void synchronizeAllChannelInfo();
      /**
       * Courier Message Handler
       */
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SXM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(SxmAudioChangePresetBankReqMsg)
      ON_COURIER_MESSAGE(SXMAudioRecallorStoreReqMsg)
      ON_COURIER_MESSAGE(SXMTuneToChannelReqMsg)
      ON_COURIER_MESSAGE(SxmAudioUpdatePresetListReqMsg)
      ON_COURIER_MESSAGE(ListChangedUpdMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_MAP_DELEGATE_END()

      //Member Variable
      ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy > _sxmAudioFiProxy;
      ISxmAudioChannelArtRequest* _sxmChannelart;
      std::vector<uint8> _requestedPresetIndexs;
      uint8 _presetBand;
      uint8 _activePresetIndex;
      const uint8 _cMAXPRESETSINONEBAND;
      bool _isPresetListAvailable;
      bool _noSystemMessageError;
      bool _isPresetUpdateRegistered;
      bool _isPresetSwipeOrScrollProgress;
};


}  // namespace Core
}  // namespace App

#endif
