/**************************************************************************************
 * @file         : SxmAudioPlayback.h
 * @addtogroup   : AppHmi_Sxm
 * @brief        : Functional class to handle business logic for Instant Replay,Tune Scan.
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/
#ifndef _SXMAUDIOPLAYBACK_H_
#define _SXMAUDIOPLAYBACK_H_

#include "sxm_audio_main_fiProxy.h"
#include "AppHmi_SxmMessages.h"

namespace App {
namespace Core {

/**
 * Utility class which contains all the necessary business logic required to handle Instant Replay and Presets.
 * @class : SxmAudioPlayback
 */
class SxmAudioPlayback
   : public ::sxm_audio_main_fi::InstantReplayControlCallbackIF
   , public ::sxm_audio_main_fi::InstantReplayModeCallbackIF
   , public ::sxm_audio_main_fi::InstantReplayStatusCallbackIF
   , public ::sxm_audio_main_fi::TuneScanContentStatusCallbackIF
   , public ::sxm_audio_main_fi::TuneScanControlCallbackIF
   , public ::sxm_audio_main_fi::EnableTuneStartCallbackIF
{
   public:
      /**
       * SxmAudioPlayback Class constructor
       */
      SxmAudioPlayback(::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy > pSxmAudioFiProxy);
      /**
       * SxmAudioPlayback Class destructor
       */
      virtual ~SxmAudioPlayback();
      /**
       * Utility function that registers for notifications updates from SXM Audio MIDW layer
       */
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      /**
       * Utility function that deregisters for notifications updates from SXM Audio MIDW layer
       */
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      /**
       * Error handling function for instant replay control method
       */
      void onInstantReplayControlError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                       const boost::shared_ptr< ::sxm_audio_main_fi::InstantReplayControlError >& /*error*/);
      /**
       * Result handling function for instant replay control method
       */
      void onInstantReplayControlResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                        const boost::shared_ptr< ::sxm_audio_main_fi::InstantReplayControlResult >& /*result*/);
      /**
       * Error handling function for instant replay mode property
       */
      void onInstantReplayModeError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                    const boost::shared_ptr< ::sxm_audio_main_fi::InstantReplayModeError >& /*error*/);
      /**
       * Status handling function for instant replay mode property
       */
      void onInstantReplayModeStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                     const boost::shared_ptr< ::sxm_audio_main_fi::InstantReplayModeStatus >& /*status*/);
      /**
       * Error handling function for instant replay status property
       */
      void onInstantReplayStatusError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                      const boost::shared_ptr< ::sxm_audio_main_fi::InstantReplayStatusError >& /*error*/);
      /**
       * Status handling function for instant replay status property
       */
      void onInstantReplayStatusStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                       const boost::shared_ptr< ::sxm_audio_main_fi::InstantReplayStatusStatus >& /*status*/);
      /**
       * Error handling function for Tune Scan Content property
       */
      void onTuneScanContentStatusError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                        const boost::shared_ptr< ::sxm_audio_main_fi::TuneScanContentStatusError >& /*error*/);
      /**
       * Status handling function for Tune Scan Content property
       */
      void onTuneScanContentStatusStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                         const boost::shared_ptr< ::sxm_audio_main_fi::TuneScanContentStatusStatus >& status);
      /**
       * Error handling function for Tune Scan Control method
       */
      void onTuneScanControlError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                  const boost::shared_ptr< ::sxm_audio_main_fi::TuneScanControlError >& /*error*/);
      /**
       * Result handling function for Tune Scan Control method
       */
      void onTuneScanControlResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                   const boost::shared_ptr< ::sxm_audio_main_fi::TuneScanControlResult >& /*result*/);
      /**
      * Error handling function for enable tune start method
      */
      void onEnableTuneStartError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                  const boost::shared_ptr< ::sxm_audio_main_fi::EnableTuneStartError >& /*error*/);
      /**
       * Result handling function for enable tune start method
       */
      void onEnableTuneStartResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                   const boost::shared_ptr< ::sxm_audio_main_fi::EnableTuneStartResult >& /*result*/);
      /**
       * Restore Dp value for Audio Playback
       */
      void restoreAudioPlayback(void) const;
      /**
       * Send Midw Tune Start Status.
       */
      void sendTuneStartStatus();
      /**
       * Function to set default value on service availability from suspended
       */
      void onServiceResumed(const ::boost::shared_ptr< asf::core::Proxy >& proxy);

   private:
      /**
      * Callback to handle Courier Message SXMAudioReplayControlReqMsg Request
      */
      bool onCourierMessage(const SXMAudioReplayControlReqMsg& oMsg);
      /**
      * Callback to handle Courier Message SxmAudioPresetControlReqMsg Request
      */
      bool onCourierMessage(const SxmAudioPresetControlReqMsg& oMsg);
      /**
      * Callback to handle Courier Message SXMAudioScanOpertationReqMsg Request
      */
      bool onCourierMessage(const SXMAudioScanOpertationReqMsg& oMsg);
      /**
      * Callback to handle Courier Message SXMAudioTuneStartReqMsg Request
      */
      bool onCourierMessage(const SXMAudioTuneStartReqMsg& /*oMsg*/);
      /**
       * Courier Message Handler
       */
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SXM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(SXMAudioReplayControlReqMsg)
      ON_COURIER_MESSAGE(SxmAudioPresetControlReqMsg)
      ON_COURIER_MESSAGE(SXMAudioScanOpertationReqMsg)
      ON_COURIER_MESSAGE(SXMAudioTuneStartReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEF_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()

      //Member Variable
      ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy > _sxmAudioFiProxy;
      ::sxm_audio_main_fi_types::T_e8_TuneScanMode _scanMode;
      enSxmIRPlaybackMode _previousPlaybackMode;

   protected:
};


}  // namespace Core
}  // namespace App

#endif
