/**************************************************************************************
 * @file         : SxmAudioHall.h
 * @addtogroup   : AppHmi_Sxm
 * @brief        : SXM Audio HALL utility class which contains all the necessary business logic required for SXM Audio HMI.
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/
#ifndef _SXMAUDIOHALL_H_
#define _SXMAUDIOHALL_H_

#include "AppBase/ServiceAvailableIF.h"

namespace sxm_audio_main_fi {
class Sxm_audio_main_fiProxy;
}


namespace sxm_channelart_main_fi {
class Sxm_channelart_main_fiProxy;
}


namespace App {
namespace Core {
// Forward Declarations
class SxmAudioPlayback;
class SxmAudioDiagnosis;
class SxmAudioChannelInformation;
class SxmAudioList;
class SxmAudioContentAlert;
class SxmAudioSportsFlash;
class SxmAudioTWNow;
class SxmAudioPreset;
class SxmAudioChannelArt;
/**
 * SXM Audio HALL utility class required to handle actions, responses and notifications from FC SXM Audio MIDW.
 * @class : SxmAudioHall
 */
class SxmAudioHall
   : public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
{
   public:
      /**
       * SxmAudioHall Class constructor
       */
      SxmAudioHall();
      /**
       * SxmAudioHall Class destructor
       */
      virtual ~SxmAudioHall();
      /**
       * Utility function that registers for notifications updates from SXM Audio MIDW layer
       */
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/,
                              const asf::core::ServiceStateChange& /*stateChange*/);
      /**
       * Utility function that deregisters for notifications updates from SXM Audio MIDW layer
       */
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/,
                                const asf::core::ServiceStateChange& /*stateChange*/);
      /**
       * Utility function that registers for notifications updates from SXM Audio MIDW layer
       */
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                       const asf::core::ServiceStateChange& stateChange);
      /**
       * Utility function that deregisters for notifications updates from SXM Audio MIDW layer
       */
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy,
                         const asf::core::ServiceStateChange& stateChange);
      /**
        * Method to retrieve TraceClass reference. This is unused.
        */
      inline uint32_t getTraceClass() const
      {
         return TR_CLASS_APPHMI_SXM_COURIER_PAYLOAD_MODEL_COMP;
      }
      /*
       * Courier message handler
       */
      virtual bool OnMessage(const Courier::Message& Msg);
      /*
       * Function to perform restore factory setting for sxm audio
       */
      bool bSxmAudioRestoreFactorySetting();
      /*
      * Function to trigger handling for TTFis Command SxmAudio_GetChannelArt
      */
      void vGetChannelArt(uint8) const;
      void vonGuiStartupFinished();

   private:
      SxmAudioPlayback* _sxmAudioPlayback;
      SxmAudioDiagnosis* _sxmAudioDiagnosis;
      SxmAudioChannelInformation* _sxmAudioChannelInformation;
      SxmAudioList* _sxmAudioList;
      SxmAudioSportsFlash* _sxmAudioSportsFlash;
      SxmAudioContentAlert* _sxmAudioContentAlert;
      SxmAudioTWNow* _sxmAudioTWNow;
      SxmAudioPreset* _sXMAudioPreset;
      SxmAudioChannelArt* _sXMAudioChannelArt;
      ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy > _sxmAudioFiProxy;
      ::boost::shared_ptr< ::sxm_channelart_main_fi::Sxm_channelart_main_fiProxy > _sxmChannelartFiProxy;
      bool _onAvlStartup;
      bool _onAvlAudio;
      bool _onAvlChnArt;

   protected:
};


}  // namespace Core
}  // namespace App

#endif
