/**************************************************************************************
 * @file         : SxmAudioDiagnosis.h
 * @addtogroup   : AppHmi_Sxm
 * @brief        : Functional class to handle business logic for Sxm Diagnosis application.
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/
#ifndef _SXMAUDIODIAGNOSIS_H_
#define _SXMAUDIODIAGNOSIS_H_

#include "sxm_audio_main_fiProxy.h"
#include "AppHmi_SxmMessages.h"

namespace App {
namespace Core {
/**
 * Utility class which contains all the necessary business logic required to handle Diagnosis.
 * @class : SxmAudioDiagnosis
 */
class SxmAudioDiagnosis
   : public ::sxm_audio_main_fi::SxmRadioIdCallbackIF
   , public ::sxm_audio_main_fi::SxmDiagAntennaStateCallbackIF
   , public ::sxm_audio_main_fi::SxmDiagSignalQualityCallbackIF
   , public ::sxm_audio_main_fi::SxmAudioSubInfoCallbackIF
   , public ::sxm_audio_main_fi::SxmDataServiceStatusCallbackIF
   , public ::sxm_audio_main_fi::DiagSxmResetCallbackIF
   , public ::sxm_audio_main_fi::DiagTestModeDataCallbackIF
   , public ::sxm_audio_main_fi::SxmSmsDbVersionsCallbackIF
   , public ::sxm_audio_main_fi::DiagTestModeEnableCallbackIF
   , public ::sxm_audio_main_fi::ExternalDiagnosisModeCallbackIF
   , public ::sxm_audio_main_fi::SxmModuleSubInfoCallbackIF
   , public ::sxm_audio_main_fi::SystemMessageCallbackIF
   , public ::sxm_audio_main_fi::ResetSXMModuleCallbackIF

{
   public:
      /**
       * SxmAudioDiagnosis Class constructor
       */
      SxmAudioDiagnosis(::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy > pSxmAudioFiProxy);
      /**
       * SxmAudioDiagnosis Class destructor
       */
      virtual ~SxmAudioDiagnosis();
      /**
       * Utility function that registers for notifications updates from SXM Audio MIDW layer
       */
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      /**
       * Utility function that deregisters for notifications updates from SXM Audio MIDW layer
       */
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/) const;
      /**********************************************************Middleware Callbacks*****************************************************/
      /**
       * Error handling function for sxm Radio Id property
       */
      void onSxmRadioIdError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                             const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmRadioIdError >& error);
      /**
       * Result handling function for sxm Radio Id property
       */
      void onSxmRadioIdStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                              const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmRadioIdStatus >& status);
      /**
        * Error handling function for sxm diag antenna state property
       */
      void onSxmDiagAntennaStateError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                      const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmDiagAntennaStateError >& error);
      /**
      * Result handling function for sxm diag antenna state property
      */
      void onSxmDiagAntennaStateStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                       const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmDiagAntennaStateStatus >& status);
      /**
       * Error handling function for sxm diag signal quality property
       */
      void onSxmDiagSignalQualityError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                       const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmDiagSignalQualityError >& error);
      /**
       * Result handling function for sxm diag signal quality property
       */
      void onSxmDiagSignalQualityStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                        const ::boost::shared_ptr< ::sxm_audio_main_fi:: SxmDiagSignalQualityStatus >& status);

      /**
       * Error handling function for sxm audio sub info property
       */
      void onSxmAudioSubInfoError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                  const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmAudioSubInfoError >& error);
      /**
       * Result handling function for sxm audio sub info property
       */
      void onSxmAudioSubInfoStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                   const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmAudioSubInfoStatus >& status);
      /**
       * Error handling function for Sxm Data Service Status property
       */
      void onSxmDataServiceStatusError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                       const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmDataServiceStatusError >& error);
      /**
       * Result handling function for Sxm Data Service Status property
       */
      void onSxmDataServiceStatusStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                        const ::boost::shared_ptr< ::sxm_audio_main_fi:: SxmDataServiceStatusStatus >& status);
      /**
       * Error handling function for diag sxm reset method
       */
      void onDiagSxmResetError(const ::boost::shared_ptr< ::sxm_audio_main_fi:: Sxm_audio_main_fiProxy >& proxy,
                               const ::boost::shared_ptr< ::sxm_audio_main_fi::  DiagSxmResetError >& error);
      /**
       * Result handling function for diag sxm reset method
       */
      void onDiagSxmResetResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::  Sxm_audio_main_fiProxy >& proxy,
                                const ::boost::shared_ptr< ::sxm_audio_main_fi:: DiagSxmResetResult >& result);
      /**
      * Error handling function for diag test mode data property
      */
      void onDiagTestModeDataError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                   const ::boost::shared_ptr< ::sxm_audio_main_fi::DiagTestModeDataError >& error);
      /**
      * Result handling function for diag test mode data property
      */
      void onDiagTestModeDataStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                    const ::boost::shared_ptr< ::sxm_audio_main_fi::DiagTestModeDataStatus >& status);
      /**
       * Error handling function for sxm sms db version property
       */
      void onSxmSmsDbVersionsError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                   const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmSmsDbVersionsError >& error);
      /**
       * Status handling function for sxm sms db version property
       */
      void onSxmSmsDbVersionsStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                    const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmSmsDbVersionsStatus >& status);
      /**
      * Error handling function for diag test mode enable method
      */
      void onDiagTestModeEnableError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                     const ::boost::shared_ptr< ::sxm_audio_main_fi::DiagTestModeEnableError >& error);
      /**
       * Result handling function for diag test mode enable method
       */
      void onDiagTestModeEnableResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                      const ::boost::shared_ptr< ::sxm_audio_main_fi::DiagTestModeEnableResult >& result);
      /**
      * Error handling function for ExternalDiagnosisMode method
      */
      void onExternalDiagnosisModeError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                        const ::boost::shared_ptr< ::sxm_audio_main_fi::ExternalDiagnosisModeError >& error);
      /**
      * Result handling function for ExternalDiagnosisMode method
      */
      void onExternalDiagnosisModeResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                         const ::boost::shared_ptr< ::sxm_audio_main_fi::ExternalDiagnosisModeResult >& result);
      /**
       * Error handling function for SxmModuleSubInfo method
       */
      void onSxmModuleSubInfoError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                   const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmModuleSubInfoError >& error);
      /**
        * Result handling function for SxmModuleSubInfo method
        */
      void onSxmModuleSubInfoStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                    const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmModuleSubInfoStatus >& status);
      /**
       * Error handling function for system messages property
       */
      void onSystemMessageError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                const boost::shared_ptr< ::sxm_audio_main_fi::SystemMessageError >& /*error*/);
      /**
       * Status handling function for system messages property
       */
      void onSystemMessageStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                 const boost::shared_ptr< ::sxm_audio_main_fi::SystemMessageStatus >& status);
      /**
       * Error handling function for ResetSXMModule method
       */
      void onResetSXMModuleError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                 const ::boost::shared_ptr< ::sxm_audio_main_fi::ResetSXMModuleError >& /*error*/);
      /**
       * Result handling function for ResetSXMModule method
       */
      void onResetSXMModuleResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                  const ::boost::shared_ptr< ::sxm_audio_main_fi::ResetSXMModuleResult >& result);
      /**
       * Function to set default value on service availability from suspended
       */
      void onServiceResumed(const ::boost::shared_ptr< asf::core::Proxy >& proxy);

   private:
      /**********************************************************Courier Message callbacks*****************************************************/
      /**
      * Callback to handle Courier Message SxmDTMTestModeMonitorSelReqMsg Request
      */
      bool onCourierMessage(const SxmDTMTestModeMonitorSelReqMsg& oMsg);
      /**
      * Callback to handle Courier Message SXMSettingsTestModeListReqMsg Request
      */
      bool onCourierMessage(const SXMSettingsTestModeListReqMsg& oMsg);
      /**
      * Helper function to start External Diagnosis Mode.
      */
      void externalDiagSwitch(unsigned int, unsigned int);
      /**
       * Helper function to update the subscribe button.
       */
      void setSubscribeButton() const;
      /**
       * Courier Message Handler
       */
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SXM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(SxmDTMTestModeMonitorSelReqMsg)
      ON_COURIER_MESSAGE(SXMSettingsTestModeListReqMsg)
      // ON_COURIER_MESSAGE(SXMInfoUpdatedatabindingReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEF_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()

      //Member Variable
      ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy > _ptrSxmAudioFiProxy;
      bool _isExternalDiagmodeOn;
      bool _isDataServiceInfoSubscribeOn;
      bool _isAudioSubInfoSubscribeOn;
      bool _isClearAllDBandData;

   protected:
};


}  // namespace Core
}  // namespace App

#endif
