/**************************************************************************************
 * @file         : SxmAudioConetAlert.h
 * @addtogroup   : AppHmi_Sxm
 * @brief        : Functional class to handle business logic for Content Alerts.
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/
#ifndef SXMAUDIOCONTENTALERT_H_
#define SXMAUDIOCONTENTALERT_H_

#include "sxm_audio_main_fiProxy.h"
#include "AppHmi_SxmMessages.h"
#include "Common/DataModel/ListRegistry.h"
#include "SxmAudioTypes.h"
#include "ISxmAudioChannelArtResponse.h"
#include "ISxmAudioChannelArtRequest.h"
#include "App/datapool/apphmi_sxm_datapool_if.h"
#include "App/Core/SxmCommon/ISxmHMIServiceStateHandler.h"


namespace App {
namespace Core {
/**
 * Utility class which which contains all the necessary business logic required to handle all Audio Content Alerts
 * @class : SxmAudioContentAlert
 */
class SxmAudioContentAlert
   : public ::sxm_audio_main_fi::AlertNoticeListUpdateCallbackIF
   , public ::sxm_audio_main_fi::GetAlertNoticeListCallbackIF
   , public ::sxm_audio_main_fi::GetFavoriteListCallbackIF
   , public ::sxm_audio_main_fi::ModifyFavoriteCallbackIF
   , public ::sxm_audio_main_fi::SaveFavoriteCallbackIF
   , public ::sxm_audio_main_fi::FavoriteContentAlertInfoCallbackIF
   , public ListImplementation
   , public ISxmAudioChannelArtResponse
   , public ISxmHMIServiceStateHandler
{
   public:
      /**
       * SxmAudioContentAlert Class constructor
       */
      SxmAudioContentAlert(::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy > pSxmAudioFiProxy, ISxmAudioChannelArtRequest* pSxmChannelart);
      /*
       * SxmAudioContentAlert destructor
        */
      virtual ~SxmAudioContentAlert();

      //****************************Middleware Callbacks******************************//

      /**
       * Utility function that registers for notifications updates from SXM Audio MIDW layer
       */
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      /**
       * Utility function that deregisters for notifications updates from SXM Audio MIDW layer
       */
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      /**
       *Error handling function for Alert Notice ListUpdate
       */
      void onAlertNoticeListUpdateError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                        const ::boost::shared_ptr< ::sxm_audio_main_fi::AlertNoticeListUpdateError >& error);
      /**
       *Status handling function for Alert Notice ListUpdate
       */
      void onAlertNoticeListUpdateStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                         const ::boost::shared_ptr< ::sxm_audio_main_fi::AlertNoticeListUpdateStatus >& status);
      /**
       *Error handling function for Get Alert Notice List
       */
      void onGetAlertNoticeListError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                     const ::boost::shared_ptr< ::sxm_audio_main_fi::GetAlertNoticeListError >& error);
      /**
       * Result handling function for Get Alert Notice List
       */
      void onGetAlertNoticeListResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                      const ::boost::shared_ptr< ::sxm_audio_main_fi::GetAlertNoticeListResult >& result);
      /**
       * Error handling function for Get Favorite List
       */
      void onGetFavoriteListError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                  const ::boost::shared_ptr< ::sxm_audio_main_fi::GetFavoriteListError >& error);
      /**
       *Result handling function for Get Favorite List
       */
      void onGetFavoriteListResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                   const ::boost::shared_ptr< ::sxm_audio_main_fi::GetFavoriteListResult >& result);
      /**
       *Error handling function for Modify Favorite
       */
      void onModifyFavoriteError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                 const ::boost::shared_ptr< ::sxm_audio_main_fi::ModifyFavoriteError >& error);
      /**
       *Result handling function for Modify Favorite
       */
      void onModifyFavoriteResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                  const ::boost::shared_ptr< ::sxm_audio_main_fi::ModifyFavoriteResult >& result);
      /**
       *Error handling function for Save Favorite
       */
      void onSaveFavoriteError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                               const ::boost::shared_ptr< ::sxm_audio_main_fi::SaveFavoriteError >& error);
      /**
       *Result handling function for Save Favorite
       */
      void onSaveFavoriteResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                const ::boost::shared_ptr< ::sxm_audio_main_fi::SaveFavoriteResult >& result);
      /**
       *Error handling function for Favorite Content Alert Info
       */
      void onFavoriteContentAlertInfoError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                           const ::boost::shared_ptr< ::sxm_audio_main_fi::FavoriteContentAlertInfoError >& error);
      /**
       *Result handling function for Favorite Content Alert Info
       */
      void onFavoriteContentAlertInfoStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                            const ::boost::shared_ptr< ::sxm_audio_main_fi::FavoriteContentAlertInfoStatus >& status);
      /**
       * Result handling function for GetChannelArt method.
       */
      virtual void onGetChannelLogoResult(const uint16& /*sid*/, const uint8& /*ChannelGraphicsType*/, const std::vector<uint8>& /*u8ImageData*/,
                                          const std::vector<uint8>& /*albumImageData*/) {}
      /**
        * Result handling function for GetChannelArt method.
        */
      virtual void onGetChannelArtListResult(const ::std::vector< ChannelGraphicsType >& channelArtList);
      /**
      * Result handling function for GetChannelArtList method.
      */
      virtual void onGetChannelArtListError();
      /**
       * Result handling function for GetChannelArt method.
       */
      virtual void onGetChannelLogoError(const uint16& sid);
      /**
       * getListDataProvider : Gets the ListDataProvider from the corresponding list data provider functions
       */
      //tSharedPtrDataProvider getListDataProvider(const ListDataInfo& listDataInfo);
      virtual tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& listDataInfo);
      /**
       *Restore Data Pool value to initial value
       */
      void restoreAudioAlertDP(void);
      /**
       *  Call Back function for system appmode status.
       */
      void vNotifyAppModeChange(unsigned short int lactiveAppMode);
      /**
       *  Call Back function for service status.
       */
      void vNotifyServiceStatus(unsigned short int lEntryExitStatus, unsigned int serviceType);
      void vNotifyAppState(unsigned short int /*appState*/) {};

   private:
      //*****************Helper Functions*************//
      /**
       * Handle Modify FavoriteList
       */
      void handleModifyFavoriteList(uint8 action);
      /**
       * Helper Function to Update Favorite List
       */
      void updateFavoriteList();
      /**
       * Helper Function to get Favorite List
       */
      void getFavList();
      /**
       * Helper Function to Get Save Fav Artist Result
       */
      void setSaveResult(uint8 status, uint8 favcount, std::string contentName);
      /**
       * Helper Function to Send Modify Fav Method Start
       */
      void sendModifyFavoriteStart(uint32 fav_type, uint8 action, std::string contentname);
      /**
       * Helper Function to update Alert Info and Notify.
       */
      void setSxmAudioContentAlertinfo();
      /**
       * Helper Function to get advisory text.
       */
      const std::string getAdvisoryText() const;
      /**
      * Helper Function to get advisory text.
      */
      const std::string getAdvisoryTextForFavorites() const;
      /**
       * Helper Function to store favorite availability.
       */
      void storeFavoriteStatus(bool status) const;
      /**
       * Helper Function to queue all alerts notified by middleware.
       */
      void enQueueContentAlerts(const ::sxm_audio_main_fi_types::T_AlertInfo& lAlertInfo);
      /**
       * Helper Function to Dequeue all alerts when alert settings are changed.
       */
      void deQueueContentAlerts(const ::sxm_audio_main_fi_types::T_e8_FavoriteType& lfavtype);
      //************************Courier Message callbacks**********//
      /**
       * Callback to hanlde Courier Message SxmAudioAlertSettingOnorOffReqMsg
       */
      bool onCourierMessage(const SxmAudioAlertSettingOnOffReqMsg& oMsg);
      /**
       * Callback to hanlde Courier Message SxmAudioContentAlertListReqMsg
       */
      bool onCourierMessage(const SxmAudioContentAlertListReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SxmAudioSaveFavReqMsg Request
       */
      bool onCourierMessage(const SxmAudioSaveFavReqMsg& oMsg);
      /**
       *Callback to handle Courier Message SxmAduioDeleteAllFavReqMsg Request
       */
      bool onCourierMessage(const SxmAudioDeleteAllFavReqMsg& oMsg);
      /**
       *Callback to handle Courier Message SXMAudioEnableDeleteFavReqMsg
       */
      bool onCourierMessage(const SXMAudioEnableDeleteFavReqMsg& oMsg);
      /**
       *Callback to handle Courier Message SXMAudioAlertsTurnOnOffReqMsg
       */
      bool onCourierMessage(const SXMAudioAlertsTurnOnOffReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SxmAudioCloseFavMaxReachedPopupReqMsg
       */
      bool onCourierMessage(const SxmAudioCloseFavMaxReachedPopupReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SxmAudioReplaceSelectedFavReqMsg Request
       */
      bool onCourierMessage(const SxmAudioReplaceSelectedFavReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SxmAudioCloseContentAlertPopupReqMsg Request
       */
      bool onCourierMessage(const SxmAudioCloseContentAlertPopupReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SxmAudioTunetoContentAlertReqMsg Request
       */
      bool onCourierMessage(const SxmAudioTunetoContentAlertReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SxmAudioDeleteAllConfirmReqMsg Request
       */
      bool onCourierMessage(const SxmAudioDeleteAllConfirmReqMsg& oMsg);
      /**
      * Helper Function to update Alert popup
      */
      void updateAlertPopup();
      /**
      * Function to get Popup text based on Region status
      */
      std::string getRegionText();
      bool isPopupAllowed();
      /**
       * Courier Message Handler
       */
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SXM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(SxmAudioAlertSettingOnOffReqMsg)
      ON_COURIER_MESSAGE(SxmAudioSaveFavReqMsg)
      ON_COURIER_MESSAGE(SxmAudioContentAlertListReqMsg)
      ON_COURIER_MESSAGE(SxmAudioDeleteAllFavReqMsg)
      ON_COURIER_MESSAGE(SXMAudioEnableDeleteFavReqMsg)
      ON_COURIER_MESSAGE(SXMAudioAlertsTurnOnOffReqMsg)
      ON_COURIER_MESSAGE(SxmAudioCloseFavMaxReachedPopupReqMsg)
      ON_COURIER_MESSAGE(SxmAudioReplaceSelectedFavReqMsg)
      ON_COURIER_MESSAGE(SxmAudioCloseContentAlertPopupReqMsg)
      ON_COURIER_MESSAGE(SxmAudioTunetoContentAlertReqMsg)
      ON_COURIER_MESSAGE(SxmAudioDeleteAllConfirmReqMsg)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_END()

      //Member Variable Declarations
      ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy > _sxmAudioFiProxy;
      ISxmAudioChannelArtRequest* _sxmChannelart;
      sxm_audio_main_fi_types::T_e8_FavoriteType _favtype;
      std::vector< ::sxm_audio_main_fi_types::T_AlertInfo> _contentAlertList;
      bool _maxFavReached;
      bool _isReplaceFav;
      bool _isFavoriteAlertActive;
      uint32 _transtionId;
      uint32 _deleteAllFavType;
      HmiAppSxm::AlertSetting _alertSettingsStatus;
      const uint8 _cMaxfavCount;
      bool _allowContentAlert;
      bool _popupCloseOnAppmodeChange;
      uint8 _artistFavCount;
      uint8 _songFavCount;
      bool _isAlertAllowed;
      bool _isRegisterProperties;
};


}// namespace Core
}// namespace App

#endif /* SXMAUDIOCONTENTALERT_H_ */
