/**************************************************************************************
 * @file         : SxmAudioChannelInformation.h
 * @addtogroup   : AppHmi_Sxm
 * @brief        : Functional class to handle business logic for Channel browsing.
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/
#ifndef _SXMAUDIOCHANNELINFORMATION_H_
#define _SXMAUDIOCHANNELINFORMATION_H_

#include "sxm_audio_main_fiProxy.h"
#include "AppHmi_SxmStateMachine.h"
#include "SxmAudioTypes.h"
#include "ISxmAudioChannelArtResponse.h"
#include "ISxmAudioChannelArtRequest.h"
#include "Courier/Visualization/VisualizationMsgs.h"
#include "App/Core/SxmCommon/SXMCommonInterface.h"


//forward declaration
class UserInterfaceControl;

namespace App {
namespace Core {
/**
 * Utility class which contains all the necessary business logic required to handle Channel Information updates.
 * @class : SxmAudioChannelInformation
 */
class SxmAudioChannelInformation
   : public ::sxm_audio_main_fi::ChannelInformationCallbackIF
   , public ::sxm_audio_main_fi::SelectChannelCallbackIF
   , public ::sxm_audio_main_fi::SelectChannelWithDwellTimeCallbackIF
   , public ::sxm_audio_main_fi::SystemMessageCallbackIF
   , public ::sxm_audio_main_fi::SetClockParamsCallbackIF
   , public ::sxm_audio_main_fi::RapidChannelBrowseInfoCallbackIF
   , public ::sxm_audio_main_fi::RapidChannelBrowseStartCallbackIF
   , public ::sxm_audio_main_fi::RapidChannelBrowseStopCallbackIF
   , public ISxmAudioChannelArtResponse
   , public ISxmHMIServiceStateHandler
{
   public:
      /**
       * SxmAudioChannelInformation Class constructor
       */
      SxmAudioChannelInformation(::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy > pSxmAudioFiProxy,
                                 ISxmAudioChannelArtRequest* pSxmChannelart);
      /**
       * SxmAudioChannelInformation Class destructor
       */
      virtual ~SxmAudioChannelInformation();
      /**
       * Utility function that registers for notifications updates from SXM Audio MIDW layer
       */
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      /**
       * Utility function that deregisters for notifications updates from SXM Audio MIDW layer
       */
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      /**********************************************************Middleware Callbacks*****************************************************/
      /**
       * Error handling function for channel information property
       */
      void onChannelInformationError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                     const boost::shared_ptr< ::sxm_audio_main_fi::ChannelInformationError >& /*error*/);
      /**
       * Status handling function for channel information property
       */
      void onChannelInformationStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                      const boost::shared_ptr< ::sxm_audio_main_fi::ChannelInformationStatus >& status);
      /**
       * Error handling function for select channel method
       */
      void onSelectChannelError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                const boost::shared_ptr< ::sxm_audio_main_fi::SelectChannelError >& /*error*/);
      /**
       * Result handling function for select channel method
       */
      void onSelectChannelResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                 const boost::shared_ptr< ::sxm_audio_main_fi::SelectChannelResult >& /*result*/);
      /**
       * Error handling function for select channel with dwell time method
       */
      void onSelectChannelWithDwellTimeError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                             const boost::shared_ptr< ::sxm_audio_main_fi::SelectChannelWithDwellTimeError >& /*error*/);
      /**
       * Result handling function for select channel with dwell time method
       */
      void onSelectChannelWithDwellTimeResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                              const boost::shared_ptr< ::sxm_audio_main_fi::SelectChannelWithDwellTimeResult >& /*result*/);
      /**
       * Error handling function for system messages property
       */
      void onSystemMessageError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                const boost::shared_ptr< ::sxm_audio_main_fi::SystemMessageError >& /*error*/);
      /**
       * Status handling function for system messages property
       */
      void onSystemMessageStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                 const boost::shared_ptr< ::sxm_audio_main_fi::SystemMessageStatus >& status);
      /**
       * Error handling function for ClockParams property
       */
      void onSetClockParamsError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                 const ::boost::shared_ptr< ::sxm_audio_main_fi::SetClockParamsError >& error);
      /**
       * Status handling function for ClockParams property
       */
      void onSetClockParamsStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                  const ::boost::shared_ptr< ::sxm_audio_main_fi::SetClockParamsStatus >& status);
      /**
       * Error handling function for ClockParams property
       */
      void onRapidChannelBrowseInfoError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                         const ::boost::shared_ptr< ::sxm_audio_main_fi::RapidChannelBrowseInfoError >& error);
      /**
       * Status handling function for RapidChannelBrowseInfo property
       */
      void onRapidChannelBrowseInfoStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                          const ::boost::shared_ptr< ::sxm_audio_main_fi::RapidChannelBrowseInfoStatus >& status);
      /**
       * Error handling function for RapidChannelBrowseStart Method
       */
      void onRapidChannelBrowseStartError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                          const ::boost::shared_ptr< ::sxm_audio_main_fi::RapidChannelBrowseStartError >& error);
      /**
       * Result handling function for RapidChannelBrowseStart Method
       */
      void onRapidChannelBrowseStartResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                           const ::boost::shared_ptr< ::sxm_audio_main_fi::RapidChannelBrowseStartResult >& result);
      /**
       * Error handling function for RapidChannelBrowseStop Method
       */
      void onRapidChannelBrowseStopError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                         const ::boost::shared_ptr< ::sxm_audio_main_fi::RapidChannelBrowseStopError >& error);
      /**
       * Result handling function for RapidChannelBrowseStop Method
       */
      void onRapidChannelBrowseStopResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                          const ::boost::shared_ptr< ::sxm_audio_main_fi::RapidChannelBrowseStopResult >& result);
      /**
       * Result handling function for GetChannelArt method.
       */
      virtual void onGetChannelLogoResult(const uint16& sid, const uint8& graphicsType, const std::vector<uint8>& u8ImageData,
                                          const std::vector<uint8>& albumImageData);
      /**
        * Result handling function for GetChannelArt method.
        */
      virtual void onGetChannelArtListResult(const ::std::vector< ChannelGraphicsType >& /*channelArtList*/) {}
      /**
       * Result handling function for GetChannelArtList method.
       */
      virtual void onGetChannelArtListError();
      /**
       * Result handling function for GetChannelArt method.
       */
      virtual void onGetChannelLogoError(const uint16& sid);
      /**
       * Function to handle Gui startup
       */
      void onGuiStartupFinished();
      /**
       * Restore Dp value for Audio Preset
       */
      void restoreChannelInfo();
      /**
       * Function to set default value on service availability from suspended
       */
      void onServiceResumed(const ::boost::shared_ptr< asf::core::Proxy >& proxy);
      /**
      *  Call Back function for service status.
      */
      void vNotifyServiceStatus(unsigned short int lEntryExitStatus, unsigned int serviceType);
      /**
       *  Call Back function for appmode status.
       */
      void vNotifyAppModeChange(unsigned short int lactiveAppMode);
      void vNotifyAppState(unsigned short int /*appState*/) {};

   private:
      /**********************************************************Courier Message callbacks*****************************************************/
      /**
       * Callback to handle Courier Message SXMAudioDirectTuneOkReqMsg Request
       */
      bool onCourierMessage(const SXMAudioDirectTuneOkReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SXMAudioDirectTuneClearSpellerReqMsg Request
       */
      bool onCourierMessage(const SXMAudioDirectTuneClearSpellerReqMsg& oMsg) const;
      /**
       * Callback to handle Courier Message SXMAudioPostTimeZoneChangeReqMsg Request
       */
      bool onCourierMessage(const SXMAudioPostTimeZoneChangeReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SXMTuneToChannelReqMsg Request
       */
      bool onCourierMessage(const SXMTuneToChannelReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SXMTuneSelectedChannelItemReqMsg Request
       */
      bool onCourierMessage(const SXMTuneSelectedChannelItemReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SXMPopUpStateUpdMsg Request
       */
      bool onCourierMessage(const SXMPopUpStateUpdMsg& oMsg) const;
      /**
       * Callback to handle Courier Message SxmUpdatePresetlistReqMsg Request
       */
      bool onCourierMessage(const SxmUpdatePresetlistReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SXMAudioPostLocalTimeChangeReqMsg Request
       */
      bool onCourierMessage(const SXMAudioPostLocalTimeChangeReqMsg& oMsg);
      /**
       * Callback to handle Courier Message TimerExpiredMsg Request
       */
      bool onCourierMessage(const TimerExpiredMsg& oMsg);
      /**
       * Callback to handle binding update of data item SxmAudioDirectTuneTextInfo.
       */
      bool onCourierBindingItemChange_SxmAudioDirectTuneTextInfoItem(Courier::Request& request);
      /**
       * Callback to handle binding update of data item SxmAudioDirectTuneKeyPressInfo.
       */
      bool onCourierBindingItemChange_SxmAudioDirectTuneKeyPressInfoItem(Courier::Request& request);
      /**
       * Callback to handle Courier Message SXMAudioDirectTuneDeletePosReqMsg Request
       */
      bool onCourierMessage(const SXMAudioDirectTuneDeletePosReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SxmKeyRegisterStatusMsg Request
       */
      bool onCourierMessage(const SxmKeyRegisterStatusMsg& oMsg);
      /**
       * Callback to handle Courier Message SxmAudioFocusResetReqMsg Request
       */
      bool onCourierMessage(const SxmAudioFocusResetReqMsg& oMsg);
      /**
       * Courier Message Handler
       */
      COURIER_BINDING_MAP_BEGIN()
      COURIER_BINDING_ITEM_CHANGE(SxmAudioDirectTuneTextInfoItem)
      COURIER_BINDING_ITEM_CHANGE(SxmAudioDirectTuneKeyPressInfoItem)
      COURIER_BINDING_MAP_END()

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SXM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(Courier::UpdateModelMsg)
      ON_COURIER_MESSAGE(SXMAudioDirectTuneOkReqMsg)
      ON_COURIER_MESSAGE(SXMAudioDirectTuneClearSpellerReqMsg)
      ON_COURIER_MESSAGE(SXMAudioPostTimeZoneChangeReqMsg)
      ON_COURIER_MESSAGE(SXMTuneToChannelReqMsg)
      ON_COURIER_MESSAGE(SXMTuneSelectedChannelItemReqMsg)
      ON_COURIER_MESSAGE(SXMPopUpStateUpdMsg)
      ON_COURIER_MESSAGE(SxmUpdatePresetlistReqMsg)
      ON_COURIER_MESSAGE(SXMAudioPostLocalTimeChangeReqMsg)
      ON_COURIER_MESSAGE(SXMAudioDirectTuneDeletePosReqMsg)
      ON_COURIER_MESSAGE(TimerExpiredMsg)
      ON_COURIER_MESSAGE(SxmKeyRegisterStatusMsg)
      ON_COURIER_MESSAGE(SxmAudioFocusResetReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEF_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()

      /**********************************************************Helper Functions*****************************************************/
      /**
       * Helper function to post message to controller for Audio service.
       */
      void postPopupMessageForAudio(uint8 errorType, uint16 cid);
      /**
       * Helper function post PopUp Message on channel selection failure
       */
      void postPopupMessageForNonAudioMain(::sxm_audio_main_fi_types::T_e8_SystemMessage errorType, uint16 cid);
      /**
       * Helper function to Posts Toast Pop up Audio,if context is not in Main Screen.
       */
      void postTpopAudioMessage(void);
      /**
       * Helper function to send tune request to middleware
       */
      void sendSelectChannel(::sxm_audio_main_fi_types::T_e8_SelectChannelMode selectionMode,
                             uint16 cidOrSid, uint16 categoryType, uint8 steps);
      /**
       * Request Middleware to get channel or album art for selected service id.
       */
      void sendChannelArtReq(uint16 u16ServiceId, uint8 eGraphicsType);
      /**
       * Helper Function to Request for Channel Logo or Album art.
       */
      void requestSxmGraphics(::sxm_audio_main_fi_types::T_e8_Graphics chnArtAvail ,
                              ::sxm_audio_main_fi_types::T_e8_Graphics albumArtAvail, uint16 sid);
      /**
       * Helper Function to Request for Channel Logo.
       */
      void handleRequestChannelLogo(::sxm_audio_main_fi_types::T_e8_Graphics chnArtAvail);
      /**
       * Helper Function to Request for Album art.
       */
      void handleRequestAlbumart(::sxm_audio_main_fi_types::T_e8_Graphics albumArtAvail);
      /**
       * Helper Function to handler dwell timer for channel browse.
       */
      void startDwellTimer();
      /**
       * Helper Function to start rapid channel browse.
       */
      void startRapidChannelBrowse(uint8 lmode);
      /**
       * Helper Function to stop rapid channel browse.
       */
      void stopRapidChannelBrowse();
      /**
       * Helper Function to start channel browse.
       */
      void channelBrowseWithDwellTime(const SXMTuneToChannelReqMsg& oMsg);
      /**
       * Helper Function to set clock parameters to midw.
       */
      void setClockParams();
      /**
       * Helper function to synchronize display of all channel information.
       */
      void synchronizeAllChannelInfo();
      /**
       * initialize channel information
       */
      void initializeChannelInfo();
      /**
       * update channel information
       */
      void updateChannelInfo();
      /**
       * update lists on channel information status
       */
      void updateListOnChannelInfo(uint16 activeChannel, uint16 newChannel);

      //Member Variable Declarations
      ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy > _sxmAudioFiProxy;
      ISxmAudioChannelArtRequest* _sxmChannelart;
      ::sxm_audio_main_fi_types::T_ChannelInformation _channelInfoStatus;
      bool _goToSXMMainScreen;
      bool _noSystemMessageError;
      bool _isRapidChannelModeActive;
      bool _displayTpopAudio;
      bool _isDstOn;
      int _dwellsteps;
      uint32 _activeAdvisoryId;
      std::string _currentTimeZone;
      const uint8 _cStepSizeOne;
      const uint16 _cDefaultCategoryType;
      ::Util::Timer* _dwellTimer;
      bool _isAudioUtility;
      bool _isEncodertuned;

   protected:
};


}  // namespace Core
}  // namespace App

#endif
