/**************************************************************************************
 * @file         : SxmAudioChannelArt.h
 * @addtogroup   : AppHmi_Sxm
 * @brief        : Utility class which contains all the necessary business logic required to handle channel art.
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/
#ifndef _SXMAudioChannelArt_H_
#define _SXMAudioChannelArt_H_

#include "sxm_channelart_main_fiProxy.h"
#include "ISxmAudioChannelArtRequest.h"
#include "App/Core/SxmCommon/ISxmCommon.h"

namespace App {
namespace Core {

/**
 * Utility class which contains all the necessary business logic required to handle channel art.
 * @class : SxmAudioChannelArt
 */
class SxmAudioChannelArt
   : public ::sxm_channelart_main_fi::GetChannelArtListCallbackIF
   , public ::sxm_channelart_main_fi::GetChannelArtCallbackIF
   , public ISxmAudioChannelArtRequest
   , public ISxmCommon
{
   public:
      /**
       * SxmAudioChannelArt Class constructor
       */
      SxmAudioChannelArt(::boost::shared_ptr< ::sxm_channelart_main_fi::Sxm_channelart_main_fiProxy> pSxmChannelartFiProxy);
      /**
       * SxmAudioChannelArt Class destructor
       */
      virtual ~SxmAudioChannelArt();
      /**
       * Utility function that registers for notifications updates from SXM Audio MIDW layer
       */
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      /**
       * Utility function that deregisters for notifications updates from SXM Audio MIDW layer
       */
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      /**
       * Error handling function for get ChannelArt Method
       */
      void onGetChannelArtError(const ::boost::shared_ptr< ::sxm_channelart_main_fi::Sxm_channelart_main_fiProxy >& proxy,
                                const boost::shared_ptr< ::sxm_channelart_main_fi::GetChannelArtError >& error);
      /**
       * Result handling function for get ChannelArt Method
       */
      void onGetChannelArtResult(const ::boost::shared_ptr< ::sxm_channelart_main_fi::Sxm_channelart_main_fiProxy >& proxy,
                                 const boost::shared_ptr< ::sxm_channelart_main_fi::GetChannelArtResult >& result);
      /**
       * Error handling function for get ChannelArtList Method
       */
      void onGetChannelArtListError(const ::boost::shared_ptr< ::sxm_channelart_main_fi::Sxm_channelart_main_fiProxy >& proxy,
                                    const ::boost::shared_ptr<  ::sxm_channelart_main_fi::GetChannelArtListError >& error);
      /**
       * Result handling function for get ChannelArtList Method
       */
      void onGetChannelArtListResult(const ::boost::shared_ptr< ::sxm_channelart_main_fi::Sxm_channelart_main_fiProxy >& proxy,
                                     const ::boost::shared_ptr<  ::sxm_channelart_main_fi::GetChannelArtListResult >& result);
      /**
       * Function handles method request for channel art list.
       */
      virtual void sendChannelArtListMethodRequest(ISxmAudioChannelArtResponse* client,
            const ::std::vector< uint16 >& listOfSid, const uint16& channelGraphicsType);
      /**
       * Function handles method request for channel logo.
       */
      virtual void sendChannelLogoMethodRequest(ISxmAudioChannelArtResponse* client, const uint16& sid, const uint16& channelGraphicsType);
      /**
       *  Call Back function for advisory status.
      */
      virtual void vNotifyAdvisoryStatus(enSXMServiceType enServiceType, enSXMDataServiceAdvisory enServiceState , enSXMEventNotificationType enEventType);
      /**
       * Helper function to know service state.
       */
      virtual bool isChannelArtServiceAvailable();
      /**
       * Helper function to get subscription state.
       */
      virtual uint8 getChannelArtSubscriptionState();
      /**
       * Helper function to start loading timer.
       */
      virtual void startLoadingTimer();
      /**
       * Helper function to stop loading timer.
       */
      virtual void stopLoadingTimer();
      /**
       * Helper function to clear all channel art request
       */
      virtual void clearAllChannelArtReq();
      /**
       * Helper function to get  channel art timer status
       */
      virtual uint8 getChannelArtTimerStatus();
      /*
       * restore channel art info on restore factory settings
       */
      void restoreChannelArtInfo();
      /**
       * Function to set default value on service availability from suspended
       */
      void onServiceResumed(const ::boost::shared_ptr< asf::core::Proxy >& proxy);

   private:

      struct ChannelArtCallback
      {
         uint8 fID;
         ISxmAudioChannelArtResponse* client;
         ::std::vector< uint16 >  listOfSid;
         uint16 channelGraphicsType;
         ChannelArtCallback(uint8 lfID, ISxmAudioChannelArtResponse* lclient, ::std::vector< uint16 > llistOfSid, uint16 lchannelGraphicsType):
            fID(lfID), client(lclient), listOfSid(llistOfSid), channelGraphicsType(lchannelGraphicsType) {}
         virtual ~ChannelArtCallback()
         {
            client = NULL;
            listOfSid.clear();
         }
      };

      //Member Variable
      ::boost::shared_ptr< ::sxm_channelart_main_fi::Sxm_channelart_main_fiProxy > _sxmChannelartFiProxy;
      std::vector<ChannelArtCallback> _clientCb;
      bool _isPreviousRequestProcessed;
      uintptr_t _actIdForChannelArt;
      enSXMDataServiceAdvisory _channelartSubStatus;
      ::Util::Timer* _loadingTimer;

      /**
       * Callback to handle Courier Message TimerExpiredMsg Request
       */
      bool onCourierMessage(const TimerExpiredMsg& oMsg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SXM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(TimerExpiredMsg)
      COURIER_MSG_MAP_DELEGATE_DEF_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()

      //Member Functions
      void getChannelart();
      void sendDefaultChannelart();
      void startTimer();

   protected:
};


}  // namespace Core
}  // namespace App

#endif
