/**************************************************************************************
 * @file         : ISxmAudioChannelArtResponse.h
 * @addtogroup   : AppHmi_Sxm
 * @brief        : Interface adapter to handle channel art response.
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/
#ifndef ISXMAUDIOCHANNELARTRESPONSE_H_
#define ISXMAUDIOCHANNELARTRESPONSE_H_

#include "SxmAudioTypes.h"

namespace App {
namespace Core {
/**
   @brief : Interface adapter to handle channel art response
   @class : ISxmAudioChannelArtResponse
*/

class ISxmAudioChannelArtResponse
{
   public:
      virtual ~ISxmAudioChannelArtResponse() { } ;
      virtual void onGetChannelLogoResult(const uint16& sid, const uint8& graphicsType, const std::vector<uint8>& u8ImageData, const std::vector<uint8>& albumImageData) = 0;
      virtual void onGetChannelLogoError(const uint16& sid) = 0;
      virtual void onGetChannelArtListResult(const ::std::vector< ChannelGraphicsType >& channelArtList) = 0;
      virtual void onGetChannelArtListError() = 0;
};


} //end of namespace Core
} //end of namespace App


#endif /* ISXMAUDIOCHANNELARTRESPONSE_H_ */
